/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app.tools;

import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.nlogo.agent.Agent;
import org.nlogo.agent.DummyLink;
import org.nlogo.agent.Link;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.api.Perspective;
import org.nlogo.api.PerspectiveJ;
import org.nlogo.swing.WrappingPopupMenu;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.View;

public class AgentMonitorView
extends View {
    private Perspective perspective = PerspectiveJ.create(0);
    private Agent agent;
    private double radius;
    private double fontSizeRatio;
    private final MouseListener popupListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                AgentMonitorView.this.doPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                AgentMonitorView.this.doPopup(e);
            }
        }
    };

    public AgentMonitorView(GUIWorkspace workspace) {
        super(workspace);
        this.radius = (workspace.world().worldWidth() - 1) / 2;
        this.addMouseListener(this.popupListener);
    }

    @Override
    public boolean isDead() {
        return this.agent != null && this.agent.id() == -1L;
    }

    public Agent agent() {
        return this.agent;
    }

    public void agent(Agent agent) {
        this.agent = agent;
        this.perspective = PerspectiveJ.create(2, agent);
    }

    public double radius() {
        return this.radius;
    }

    public void radius(double radius) {
        this.radius = radius;
        this.patchSize(this.viewWidth * this.patchSize / (radius * 2.0 + 1.0));
        this.viewWidth = radius * 2.0 + 1.0;
        this.viewHeight = radius * 2.0 + 1.0;
        this.incrementalUpdateFromEventThread();
    }

    public void patchSize(double patchSize) {
        Font font = this.getFont();
        int newFontSize = StrictMath.max(1, (int)(patchSize * this.fontSizeRatio));
        this.setFont(new Font(font.getName(), font.getStyle(), newFontSize));
        this.patchSize = patchSize;
    }

    @Override
    public Perspective perspective() {
        return this.perspective;
    }

    @Override
    public double viewOffsetX() {
        if (this.perspective.kind() == 0 || this.agent instanceof DummyLink) {
            return 0.0;
        }
        double x = 0.0;
        x = this.agent instanceof Turtle ? ((Turtle)this.agent).xcor() : (this.agent instanceof Patch ? (double)((Patch)this.agent).pxcor : ((Link)this.agent).midpointX());
        return x - this.radius - (double)this.workspace.world().minPxcor();
    }

    @Override
    public double viewOffsetY() {
        if (this.perspective.kind() == 0 || this.agent instanceof DummyLink) {
            return 0.0;
        }
        double y = 0.0;
        y = this.agent instanceof Turtle ? ((Turtle)this.agent).ycor() : (this.agent instanceof Patch ? (double)((Patch)this.agent).pycor : ((Link)this.agent).midpointY());
        return y + (this.viewHeight - 1.0) / 2.0 - (double)this.workspace.world().maxPycor();
    }

    @Override
    public double patchSize() {
        return this.patchSize;
    }

    @Override
    public void applyNewFontSize(int newFontSize, int zoom) {
        this.fontSizeRatio = (double)newFontSize / this.workspace.world().patchSize();
        super.applyNewFontSize(newFontSize, zoom);
    }

    @Override
    public void setSize(int worldWidth, int worldHeight, double patchSize) {
        this.patchSize(patchSize);
        this.viewWidth = worldWidth;
        this.viewHeight = worldHeight;
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.patchSize((double)width / (this.radius * 2.0 + 1.0));
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.patchSize((double)width / (this.radius * 2.0 + 1.0));
    }

    @Override
    public boolean drawSpotlight() {
        return false;
    }

    public void close() {
        this.workspace.viewManager().remove(this);
    }

    private void doPopup(MouseEvent e) {
        WrappingPopupMenu menu = new WrappingPopupMenu();
        Point p = e.getPoint();
        this.populateContextMenu(menu, p);
        if (menu.getSubElements().length > 0) {
            menu.show((Component)e.getSource(), p.x, p.y);
        }
        e.consume();
    }
}

