/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.LineBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.nlogo.api.LibraryInfoDownloader$;
import org.nlogo.api.LibraryManager;
import org.nlogo.api.Version$;
import org.nlogo.app.tools.LibrariesTab$;
import org.nlogo.app.tools.LibrariesTab$Worker$;
import org.nlogo.awt.EventQueue$;
import org.nlogo.core.I18N;
import org.nlogo.core.I18N$;
import org.nlogo.core.I18N$Prefix$;
import org.nlogo.core.LibraryInfo;
import org.nlogo.core.LibraryStatus;
import org.nlogo.core.LibraryStatus$CanInstall$;
import org.nlogo.core.LibraryStatus$CanUpdate$;
import org.nlogo.core.LibraryStatus$UpToDate$;
import org.nlogo.core.Token;
import org.nlogo.swing.BrowserLauncher$;
import org.nlogo.swing.Button;
import org.nlogo.swing.EmptyIcon;
import org.nlogo.swing.FilterableListModel;
import org.nlogo.swing.Implicits$;
import org.nlogo.swing.OptionPane;
import org.nlogo.swing.OptionPane$Icons$;
import org.nlogo.swing.OptionPane$Options$;
import org.nlogo.swing.RichAction$;
import org.nlogo.swing.ScalableIcon;
import org.nlogo.swing.ScrollPane;
import org.nlogo.swing.ScrollPane$;
import org.nlogo.swing.SwingWorker;
import org.nlogo.swing.TextArea;
import org.nlogo.swing.TextArea$;
import org.nlogo.swing.TextField;
import org.nlogo.swing.TextField$;
import org.nlogo.swing.Transparent;
import org.nlogo.swing.Utils$;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.theme.ThemeSync;
import org.nlogo.workspace.ModelsLibrary;
import org.nlogo.workspace.ModelsLibrary$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public class LibrariesTab
extends JPanel
implements ThemeSync {
    private final String category;
    private final LibraryManager manager;
    public final Function1<String, BoxedUnit> org$nlogo$app$tools$LibrariesTab$$updateStatus;
    private final Function0<BoxedUnit> recompile;
    private final Function1<String, Iterator<Token>> tokenizeSource;
    private final Function1<Function1<String, String>, BoxedUnit> updateSource;
    public final Map<String, Path> org$nlogo$app$tools$LibrariesTab$$extPathMappings;
    private final Seq<LibraryInfo> libraries;
    private final Function1<LibraryInfo, BoxedUnit> install;
    private final Function1<LibraryInfo, BoxedUnit> uninstall;
    public final Function0<BoxedUnit> org$nlogo$app$tools$LibrariesTab$$updateLists;
    private final I18N.Prefix i18nPrefix;
    private final DefaultListModel<LibraryInfo> baseListModel;
    public final FilterableListModel<LibraryInfo> org$nlogo$app$tools$LibrariesTab$$listModel;
    public final JList<LibraryInfo> org$nlogo$app$tools$LibrariesTab$$libraryList;
    private boolean actionIsInProgress;
    private final Action updateAllAction;
    private final JPanel topPanel;
    private final JLabel magIcon;
    public final TextField org$nlogo$app$tools$LibrariesTab$$filterField;
    private final ScrollPane libraryScroll;
    private final JPanel installationPanel;
    private final Button installButton;
    private final Button addToCodeTabButton;
    private final Button homepageButton;
    private final Button uninstallButton;
    private final TextArea info;
    private final ScrollPane infoScroll;
    private final JLabel installedVersionLabel;
    private final JLabel latestVersionLabel;
    private final JLabel minNetLogoVersionLabel;
    private final JLabel installedVersion;
    private final JLabel latestVersion;
    private final JLabel minNetLogoVersion;
    private final JPanel nlvPanel;
    public int org$nlogo$app$tools$LibrariesTab$$numOperatedLibs;
    public final LibrariesTab$Worker$ Worker$lzy1;

    public static Option<String> addExtsToSource(String string, Set<String> set, Function1<String, Iterator<Token>> function1) {
        return LibrariesTab$.MODULE$.addExtsToSource(string, set, function1);
    }

    public LibrariesTab(String category, LibraryManager manager, Function1<String, BoxedUnit> updateStatus, Function0<BoxedUnit> recompile, Function1<String, Iterator<Token>> tokenizeSource, Function1<Function1<String, String>, BoxedUnit> updateSource, Map<String, Path> extPathMappings) {
        this.category = category;
        this.manager = manager;
        this.org$nlogo$app$tools$LibrariesTab$$updateStatus = updateStatus;
        this.recompile = recompile;
        this.tokenizeSource = tokenizeSource;
        this.updateSource = updateSource;
        this.org$nlogo$app$tools$LibrariesTab$$extPathMappings = extPathMappings;
        super(new BorderLayout());
        this.Worker$lzy1 = new LibrariesTab$Worker$();
        this.libraries = manager.getExtensionInfos();
        this.install = ext -> manager.installExtension((LibraryInfo)ext);
        this.uninstall = ext -> manager.uninstallExtension((LibraryInfo)ext);
        this.org$nlogo$app$tools$LibrariesTab$$updateLists = (JFunction0.mcV.sp & Serializable)() -> manager.reloadMetadata();
        this.i18nPrefix = I18N$Prefix$.MODULE$.apply("tools.libraries");
        this.baseListModel = new DefaultListModel();
        EventQueue$.MODULE$.invokeLater(() -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.libraries.toArray(ClassTag$.MODULE$.apply(LibraryInfo.class)));
            ArrayOps$.MODULE$.foreach$extension(object, elem -> this.baseListModel.addElement((LibraryInfo)elem));
        });
        manager.onLibInfoChange(libs -> EventQueue$.MODULE$.invokeLater(() -> {
            this.baseListModel.clear();
            libs.foreach(elem -> this.baseListModel.addElement((LibraryInfo)elem));
            this.org$nlogo$app$tools$LibrariesTab$$updateSidebar();
        }));
        this.org$nlogo$app$tools$LibrariesTab$$listModel = new FilterableListModel<LibraryInfo>(this.baseListModel, (Function2 & Serializable)(info, text) -> this.containsLib((LibraryInfo)info, (String)text));
        this.org$nlogo$app$tools$LibrariesTab$$libraryList = new JList<LibraryInfo>(this.org$nlogo$app$tools$LibrariesTab$$listModel);
        this.actionIsInProgress = false;
        this.updateAllAction = RichAction$.MODULE$.apply(I18N$.MODULE$.gui().apply("updateAll", this.i18nPrefix()), _$10 -> {
            this.updateAllAction().setEnabled(false);
            IndexedSeq libsToUpdate = (IndexedSeq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.org$nlogo$app$tools$LibrariesTab$$listModel.getSize()).map((Function1 & Serializable)i -> this.$anonfun$1(BoxesRunTime.unboxToInt((Object)i))).filter((Function1 & Serializable)_$11 -> {
                LibraryStatus libraryStatus = _$11.status();
                LibraryStatus$CanUpdate$ libraryStatus$CanUpdate$ = LibraryStatus$CanUpdate$.MODULE$;
                return !(libraryStatus != null ? !libraryStatus.equals(libraryStatus$CanUpdate$) : libraryStatus$CanUpdate$ != null);
            });
            this.org$nlogo$app$tools$LibrariesTab$$numOperatedLibs = libsToUpdate.length();
            this.org$nlogo$app$tools$LibrariesTab$$updateMultipleOperationStatus("installing");
            this.runAllWorkersAndThen("installing", this.install, (Seq<LibraryInfo>)libsToUpdate, true, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.finishManagement());
        });
        this.topPanel = new JPanel(new GridBagLayout());
        this.magIcon = new JLabel();
        this.org$nlogo$app$tools$LibrariesTab$$filterField = new TextField(TextField$.MODULE$.$lessinit$greater$default$1(), TextField$.MODULE$.$lessinit$greater$default$2(), TextField$.MODULE$.$lessinit$greater$default$3());
        this.libraryScroll = new ScrollPane(this.org$nlogo$app$tools$LibrariesTab$$libraryList, ScrollPane$.MODULE$.$lessinit$greater$default$2(), ScrollPane$.MODULE$.$lessinit$greater$default$3());
        Box sidebar = Box.createVerticalBox();
        Transparent libraryButtonsPanel = new Transparent(){
            {
                Transparent.$init$(this);
            }
        };
        this.installationPanel = new Transparent(){
            {
                Transparent.$init$(this);
            }
        };
        this.installButton = new Button(I18N$.MODULE$.gui().apply("install", this.i18nPrefix()), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Function1 & Serializable installCheck = (Function1 & Serializable)lib -> {
                if (!lib.isVersionRequirementMet(Version$.MODULE$.version())) return false;
                LibraryStatus libraryStatus = lib.status();
                LibraryStatus$UpToDate$ libraryStatus$UpToDate$ = LibraryStatus$UpToDate$.MODULE$;
                if (libraryStatus == null) {
                    if (libraryStatus$UpToDate$ == null) return false;
                    return true;
                } else if (libraryStatus.equals(libraryStatus$UpToDate$)) return false;
                return true;
            };
            Function1 & Serializable uninstallCheck = (Function1 & Serializable)lib -> BoxesRunTime.unboxToBoolean((Object)installCheck.apply(lib)) && lib.canUninstall();
            this.perform("uninstalling", this.uninstall, (Function1<LibraryInfo, Object>)uninstallCheck, true);
            this.perform("installing", lib -> this.wrappedInstall((LibraryInfo)lib), (Function1<LibraryInfo, Object>)installCheck, false);
        });
        this.addToCodeTabButton = new Button(I18N$.MODULE$.gui().apply("addToCodeTab", this.i18nPrefix()), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            updateSource.apply((Function1 & Serializable)source -> {
                Option<String> option = LibrariesTab$.MODULE$.addExtsToSource((String)source, (Set<String>)((IterableOnceOps)this.selectedValues().map((Function1 & Serializable)_$12 -> _$12.codeName())).toSet(), tokenizeSource);
                if (option instanceof Some) {
                    String newSource = (String)((Some)option).value();
                    return newSource;
                }
                new OptionPane(this, I18N$.MODULE$.gui().get("common.messages.error"), I18N$.MODULE$.gui().get("tools.libraries.failedToAdd"), OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Error());
                return source;
            });
            recompile.apply$mcV$sp();
        });
        this.homepageButton = new Button(I18N$.MODULE$.gui().apply("homepage", this.i18nPrefix()), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> BrowserLauncher$.MODULE$.openURI(this, this.selectedValue().homepage().toURI()));
        this.uninstallButton = new Button(I18N$.MODULE$.gui().apply("uninstall", this.i18nPrefix()), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.perform("uninstalling", this.uninstall, (Function1<LibraryInfo, Object>)(Function1 & Serializable)_$13 -> _$13.canUninstall(), false));
        this.info = new TextArea(2, 28, TextArea$.MODULE$.$lessinit$greater$default$3());
        this.infoScroll = new ScrollPane(this.info, ScrollPane$.MODULE$.$lessinit$greater$default$2(), ScrollPane$.MODULE$.$lessinit$greater$default$3());
        this.installedVersionLabel = new JLabel(I18N$.MODULE$.gui().apply("installedVersion", this.i18nPrefix()) + ": ");
        this.latestVersionLabel = new JLabel(I18N$.MODULE$.gui().apply("latestVersion", this.i18nPrefix()) + ": ");
        this.minNetLogoVersionLabel = new JLabel(I18N$.MODULE$.gui().apply("minimumVersion", this.i18nPrefix()) + ": ");
        this.installedVersion = new JLabel();
        this.latestVersion = new JLabel();
        this.minNetLogoVersion = new JLabel();
        this.nlvPanel = new Transparent(){
            {
                Transparent.$init$(this);
            }
        };
        this.org$nlogo$app$tools$LibrariesTab$$libraryList.setCellRenderer(new CellRenderer());
        this.installationPanel.add(this.installButton);
        ((Container)((Object)libraryButtonsPanel)).add(this.installationPanel);
        ((Container)((Object)libraryButtonsPanel)).add(this.addToCodeTabButton);
        ((Container)((Object)libraryButtonsPanel)).add(this.homepageButton);
        LibrariesTab.embolden$1(this.installedVersionLabel);
        LibrariesTab.embolden$1(this.latestVersionLabel);
        LibrariesTab.embolden$1(this.minNetLogoVersionLabel);
        Transparent ivPanel = new Transparent(){
            {
                Transparent.$init$(this);
            }
        };
        ((Container)((Object)ivPanel)).add(this.installedVersionLabel);
        ((Container)((Object)ivPanel)).add(this.installedVersion);
        ((JComponent)((Object)ivPanel)).setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        Transparent lvPanel = new Transparent(){
            {
                Transparent.$init$(this);
            }
        };
        ((Container)((Object)lvPanel)).add(this.latestVersionLabel);
        ((Container)((Object)lvPanel)).add(this.latestVersion);
        ((JComponent)((Object)lvPanel)).setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.nlvPanel.add(this.minNetLogoVersionLabel);
        this.nlvPanel.add(this.minNetLogoVersion);
        this.nlvPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.nlvPanel.setVisible(true);
        ((JComponent)((Object)libraryButtonsPanel)).setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.info.setLineWrap(true);
        this.info.setWrapStyleWord(true);
        this.info.setEditable(false);
        ((JComponent)((Object)libraryButtonsPanel)).setAlignmentX(0.0f);
        ((JComponent)((Object)ivPanel)).setAlignmentX(0.0f);
        ((JComponent)((Object)lvPanel)).setAlignmentX(0.0f);
        this.nlvPanel.setAlignmentX(0.0f);
        this.infoScroll.setAlignmentX(0.0f);
        Dimension d = new Dimension(5, 5);
        sidebar.add((Component)((Object)libraryButtonsPanel));
        sidebar.add(new Box.Filler(d, d, d));
        sidebar.add((Component)((Object)ivPanel));
        sidebar.add((Component)((Object)lvPanel));
        sidebar.add(this.nlvPanel);
        sidebar.add(new Box.Filler(d, d, d));
        sidebar.add(this.infoScroll);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(6, 6, 6, 6);
        this.topPanel.add((Component)this.magIcon, c);
        c.insets = new Insets(6, 0, 6, 6);
        c.fill = 2;
        c.weightx = 1.0;
        this.topPanel.add((Component)this.org$nlogo$app$tools$LibrariesTab$$filterField, c);
        this.add((Component)this.libraryScroll, "Center");
        this.add((Component)sidebar, "East");
        this.add((Component)this.topPanel, "North");
        this.org$nlogo$app$tools$LibrariesTab$$listModel.addListDataListener(new ListDataListener(this){
            private final /* synthetic */ LibrariesTab $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void intervalAdded(ListDataEvent e) {
                if (LibrariesTab.org$nlogo$app$tools$LibrariesTab$$_$canUpdateInRange$1(this.$outer.org$nlogo$app$tools$LibrariesTab$$listModel, e.getIndex0(), e.getIndex1())) {
                    this.$outer.updateAllAction().setEnabled(Predef$.MODULE$.Boolean2boolean(LibraryInfoDownloader$.MODULE$.enabled()) && true);
                    return;
                }
            }

            public void intervalRemoved(ListDataEvent e) {
                this.$outer.updateAllAction().setEnabled(Predef$.MODULE$.Boolean2boolean(LibraryInfoDownloader$.MODULE$.enabled()) && LibrariesTab.org$nlogo$app$tools$LibrariesTab$$_$canUpdate$1(this.$outer.org$nlogo$app$tools$LibrariesTab$$listModel));
            }

            public void contentsChanged(ListDataEvent e) {
                this.$outer.updateAllAction().setEnabled(Predef$.MODULE$.Boolean2boolean(LibraryInfoDownloader$.MODULE$.enabled()) && LibrariesTab.org$nlogo$app$tools$LibrariesTab$$_$canUpdate$1(this.$outer.org$nlogo$app$tools$LibrariesTab$$listModel));
            }
        });
        this.org$nlogo$app$tools$LibrariesTab$$libraryList.addListSelectionListener(_$14 -> this.org$nlogo$app$tools$LibrariesTab$$updateSidebar());
        this.org$nlogo$app$tools$LibrariesTab$$libraryList.setSelectedIndex(0);
        this.org$nlogo$app$tools$LibrariesTab$$filterField.getDocument().addDocumentListener(Implicits$.MODULE$.thunk2documentListener((JFunction0.mcV.sp & Serializable)() -> this.org$nlogo$app$tools$LibrariesTab$$listModel.filter(this.org$nlogo$app$tools$LibrariesTab$$filterField.getText())));
        this.updateAllAction().setEnabled(Predef$.MODULE$.Boolean2boolean(LibraryInfoDownloader$.MODULE$.enabled()) && LibrariesTab.org$nlogo$app$tools$LibrariesTab$$_$canUpdate$1(this.org$nlogo$app$tools$LibrariesTab$$listModel));
        this.org$nlogo$app$tools$LibrariesTab$$updateSidebar();
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        this.addAncestorListener(new AncestorListener(this){
            private final /* synthetic */ LibrariesTab $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void ancestorAdded(AncestorEvent e) {
            }

            public void ancestorMoved(AncestorEvent e) {
            }

            public void ancestorRemoved(AncestorEvent e) {
                this.$outer.org$nlogo$app$tools$LibrariesTab$$libraryList.setSelectedIndex(0);
                this.$outer.org$nlogo$app$tools$LibrariesTab$$filterField.setText("");
            }
        });
        this.org$nlogo$app$tools$LibrariesTab$$numOperatedLibs = 0;
    }

    public I18N.Prefix i18nPrefix() {
        return this.i18nPrefix;
    }

    public Action updateAllAction() {
        return this.updateAllAction;
    }

    private Buffer<LibraryInfo> actionableLibraries() {
        return (Buffer)this.selectedValues().filterNot((Function1 & Serializable)lib -> {
            if (!lib.isVersionRequirementMet(Version$.MODULE$.version())) return true;
            LibraryStatus libraryStatus = lib.status();
            LibraryStatus$UpToDate$ libraryStatus$UpToDate$ = LibraryStatus$UpToDate$.MODULE$;
            if (libraryStatus != null) {
                if (!libraryStatus.equals(libraryStatus$UpToDate$)) return false;
                return true;
            }
            if (libraryStatus$UpToDate$ == null) return true;
            return false;
        });
    }

    public void org$nlogo$app$tools$LibrariesTab$$updateSidebar() {
        if (this.selectedValue() != null) {
            this.installedVersion.setText((String)this.selectedValue().installedVersionOpt().getOrElse(LibrariesTab::updateSidebar$$anonfun$1));
            this.latestVersion.setText(this.selectedValue().version());
            this.minNetLogoVersion.setText((String)this.selectedValue().minNetLogoVersion().getOrElse(LibrariesTab::updateSidebar$$anonfun$2));
            this.nlvPanel.setVisible(this.numSelected() == 1 && !this.selectedValue().minNetLogoVersion().isEmpty());
            String infoText = this.numSelected() != 1 ? null : (this.selectedValue().isVersionRequirementMet(Version$.MODULE$.version()) ? this.selectedValue().longDescription() : I18N$.MODULE$.gui().apply("unmetMinimumVersion", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.selectedValue().name(), this.selectedValue().minNetLogoVersion().get()}), this.i18nPrefix()) + "\n\n" + this.selectedValue().longDescription());
            this.info.setText(infoText);
            this.info.select(0, 0);
            this.addToCodeTabButton.setEnabled(this.selectedValues().forall((Function1 & Serializable)_$16 -> {
                LibraryStatus libraryStatus = _$16.status();
                LibraryStatus$CanInstall$ libraryStatus$CanInstall$ = LibraryStatus$CanInstall$.MODULE$;
                return libraryStatus == null ? libraryStatus$CanInstall$ != null : !libraryStatus.equals(libraryStatus$CanInstall$);
            }));
            this.installButton.setText(this.installButtonText());
            this.installButton.setEnabled(Predef$.MODULE$.Boolean2boolean(LibraryInfoDownloader$.MODULE$.enabled()) && this.actionableLibraries().length() > 0);
            this.uninstallButton.setEnabled(Predef$.MODULE$.Boolean2boolean(LibraryInfoDownloader$.MODULE$.enabled()) && ((IterableOnceOps)this.selectedValues().filter((Function1 & Serializable)_$17 -> {
                LibraryStatus libraryStatus = _$17.status();
                LibraryStatus$CanInstall$ libraryStatus$CanInstall$ = LibraryStatus$CanInstall$.MODULE$;
                return libraryStatus == null ? libraryStatus$CanInstall$ != null : !libraryStatus.equals(libraryStatus$CanInstall$);
            })).exists((Function1 & Serializable)_$18 -> !_$18.bundled()));
            this.homepageButton.setEnabled(this.numSelected() == 1);
            String installToolTip = this.numSelected() == 1 ? this.selectedValue().downloadURL().toString() : null;
            this.installButton.setToolTipText(installToolTip);
            String homepageToolTip = this.numSelected() == 1 ? this.selectedValue().homepage().toString() : null;
            this.homepageButton.setToolTipText(homepageToolTip);
            this.updateInstallationPanel();
            return;
        }
        ((SeqOps)new .colon.colon((Object)this.installButton, (List)new .colon.colon((Object)this.uninstallButton, (List)new .colon.colon((Object)this.addToCodeTabButton, (List)new .colon.colon((Object)this.homepageButton, (List)Nil$.MODULE$))))).foreach(_$19 -> _$19.setEnabled(false));
        this.info.setText("");
        this.info.select(0, 0);
    }

    private void updateInstallationPanel() {
        this.installationPanel.removeAll();
        if (!this.actionIsInProgress) {
            if (this.selectedValues().length() == 0 || this.selectedValues().exists((Function1 & Serializable)_$20 -> {
                LibraryStatus libraryStatus = _$20.status();
                LibraryStatus$UpToDate$ libraryStatus$UpToDate$ = LibraryStatus$UpToDate$.MODULE$;
                return libraryStatus == null ? libraryStatus$UpToDate$ != null : !libraryStatus.equals(libraryStatus$UpToDate$);
            })) {
                this.installationPanel.add(this.installButton);
            }
            if (this.selectedValues().exists((Function1 & Serializable)_$21 -> {
                LibraryStatus libraryStatus = _$21.status();
                LibraryStatus$CanInstall$ libraryStatus$CanInstall$ = LibraryStatus$CanInstall$.MODULE$;
                return libraryStatus == null ? libraryStatus$CanInstall$ != null : !libraryStatus.equals(libraryStatus$CanInstall$);
            })) {
                this.installationPanel.add(this.uninstallButton);
            }
        }
        this.installationPanel.revalidate();
        this.installationPanel.repaint();
    }

    private String installButtonText() {
        if (this.actionableLibraries().forall((Function1 & Serializable)_$22 -> {
            LibraryStatus libraryStatus = _$22.status();
            LibraryStatus$CanInstall$ libraryStatus$CanInstall$ = LibraryStatus$CanInstall$.MODULE$;
            return !(libraryStatus != null ? !libraryStatus.equals(libraryStatus$CanInstall$) : libraryStatus$CanInstall$ != null);
        })) {
            return I18N$.MODULE$.gui().apply("install", this.i18nPrefix());
        }
        if (this.actionableLibraries().forall((Function1 & Serializable)_$23 -> {
            LibraryStatus libraryStatus = _$23.status();
            LibraryStatus$CanUpdate$ libraryStatus$CanUpdate$ = LibraryStatus$CanUpdate$.MODULE$;
            return !(libraryStatus != null ? !libraryStatus.equals(libraryStatus$CanUpdate$) : libraryStatus$CanUpdate$ != null);
        })) {
            return I18N$.MODULE$.gui().apply("update", this.i18nPrefix());
        }
        return I18N$.MODULE$.gui().apply("update", this.i18nPrefix()) + " / " + I18N$.MODULE$.gui().apply("install", this.i18nPrefix());
    }

    private void finishManagement() {
        this.org$nlogo$app$tools$LibrariesTab$$updateSidebar();
        this.recompile.apply$mcV$sp();
        ModelsLibrary$.MODULE$.rootNode_$eq((Option<ModelsLibrary.Node>)None$.MODULE$);
    }

    private int numSelected() {
        return this.org$nlogo$app$tools$LibrariesTab$$libraryList.getSelectedIndices().length;
    }

    private LibraryInfo selectedValue() {
        return this.org$nlogo$app$tools$LibrariesTab$$libraryList.getSelectedValue();
    }

    private Buffer<LibraryInfo> selectedValues() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.org$nlogo$app$tools$LibrariesTab$$libraryList.getSelectedValuesList()).asScala();
    }

    private Object wrappedInstall(LibraryInfo lib) {
        Object object;
        try {
            object = this.install.apply((Object)lib);
        }
        catch (IOException ex) {
            object = new OptionPane(this, I18N$.MODULE$.gui().get("common.messages.error"), I18N$.MODULE$.gui().apply("downloadFailed", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{lib.downloadURL()}), this.i18nPrefix()), OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Error());
        }
        return object;
    }

    private boolean containsLib(LibraryInfo info, String text) {
        return (info.name() + info.shortDescription()).toLowerCase().contains(text.toLowerCase());
    }

    private void perform(String opName, Function1<LibraryInfo, BoxedUnit> fn, Function1<LibraryInfo, Object> checkIsTarget, boolean silent) {
        if (this.numSelected() == 1) {
            this.updateSingleOperationStatus(opName, this.selectedValue().name());
            this.actionIsInProgress = true;
            new Worker(this, opName, fn, this.selectedValue(), false, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.actionIsInProgress = false;
                if (!silent) {
                    this.finishManagement();
                    return;
                }
            }).execute();
            return;
        }
        Seq libs = ((IterableOnceOps)this.selectedValues().filter(checkIsTarget)).toSeq();
        this.org$nlogo$app$tools$LibrariesTab$$numOperatedLibs = libs.length();
        this.org$nlogo$app$tools$LibrariesTab$$updateMultipleOperationStatus(opName);
        this.runAllWorkersAndThen(opName, fn, (Seq<LibraryInfo>)libs, true, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (!silent) {
                this.finishManagement();
                return;
            }
        });
    }

    public void org$nlogo$app$tools$LibrariesTab$$updateMultipleOperationStatus(String operation) {
        this.org$nlogo$app$tools$LibrariesTab$$updateStatus.apply((Object)I18N$.MODULE$.gui().apply(operation + "Multiple", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToInteger((int)this.org$nlogo$app$tools$LibrariesTab$$numOperatedLibs), this.category.toLowerCase()}), this.i18nPrefix()));
    }

    private void updateSingleOperationStatus(String operation, String libName) {
        this.org$nlogo$app$tools$LibrariesTab$$updateStatus.apply((Object)I18N$.MODULE$.gui().apply(operation, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{libName}), this.i18nPrefix()));
    }

    private final LibrariesTab$Worker$ Worker() {
        return this.Worker$lzy1;
    }

    private void runAllWorkersAndThen(String operation, Function1<LibraryInfo, BoxedUnit> task, Seq<LibraryInfo> libs, boolean multiple, Function0<BoxedUnit> callback) {
        IntRef numRemaining = IntRef.create((int)this.org$nlogo$app$tools$LibrariesTab$$numOperatedLibs);
        JFunction0.mcV.sp & Serializable cb = (JFunction0.mcV.sp & Serializable)() -> {
            --numRemaining$1.elem;
            if (numRemaining$1.elem == 0) {
                this.actionIsInProgress = false;
                callback.apply$mcV$sp();
                return;
            }
        };
        this.actionIsInProgress = true;
        ((IterableOnceOps)libs.map(arg_0 -> this.runAllWorkersAndThen$$anonfun$1(operation, task, (Function0)cb, arg_0))).foreach(_$25 -> _$25.execute());
    }

    @Override
    public void syncTheme() {
        this.setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.topPanel.setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.magIcon.setIcon(Utils$.MODULE$.iconScaledWithColor("/images/find.png", 15, 15, InterfaceColors$.MODULE$.toolbarImage()));
        this.org$nlogo$app$tools$LibrariesTab$$filterField.syncTheme();
        this.libraryScroll.setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.org$nlogo$app$tools$LibrariesTab$$libraryList.setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.installButton.syncTheme();
        this.addToCodeTabButton.syncTheme();
        this.homepageButton.syncTheme();
        this.uninstallButton.syncTheme();
        this.installedVersionLabel.setForeground(InterfaceColors$.MODULE$.dialogText());
        this.latestVersionLabel.setForeground(InterfaceColors$.MODULE$.dialogText());
        this.minNetLogoVersionLabel.setForeground(InterfaceColors$.MODULE$.dialogText());
        this.installedVersion.setForeground(InterfaceColors$.MODULE$.dialogText());
        this.latestVersion.setForeground(InterfaceColors$.MODULE$.dialogText());
        this.minNetLogoVersion.setForeground(InterfaceColors$.MODULE$.dialogText());
        this.infoScroll.setBorder(new LineBorder(InterfaceColors$.MODULE$.textAreaBorderNoneditable()));
        this.infoScroll.setBackground(InterfaceColors$.MODULE$.textAreaBackground());
        this.info.syncTheme();
    }

    private final /* synthetic */ LibraryInfo $anonfun$1(int i) {
        return this.org$nlogo$app$tools$LibrariesTab$$listModel.getElementAt(i);
    }

    private static final void embolden$1(JLabel l) {
        l.setFont(l.getFont().deriveFont(Collections.singletonMap(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD)));
    }

    public static final boolean org$nlogo$app$tools$LibrariesTab$$_$canUpdate$1(ListModel model) {
        return LibrariesTab.org$nlogo$app$tools$LibrariesTab$$_$canUpdateInRange$1(model, 0, model.getSize() - 1);
    }

    private static final /* synthetic */ LibraryInfo canUpdateInRange$1$$anonfun$1(ListModel model$1, int x$0) {
        return (LibraryInfo)model$1.getElementAt(x$0);
    }

    public static final boolean org$nlogo$app$tools$LibrariesTab$$_$canUpdateInRange$1(ListModel model, int index0, int index1) {
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(index0), index1).map((Function1 & Serializable)x$0 -> LibrariesTab.canUpdateInRange$1$$anonfun$1(model, BoxesRunTime.unboxToInt((Object)x$0))).exists((Function1 & Serializable)_$15 -> {
            LibraryStatus libraryStatus = _$15.status();
            LibraryStatus$CanUpdate$ libraryStatus$CanUpdate$ = LibraryStatus$CanUpdate$.MODULE$;
            return !(libraryStatus != null ? !libraryStatus.equals(libraryStatus$CanUpdate$) : libraryStatus$CanUpdate$ != null);
        });
    }

    private static final String updateSidebar$$anonfun$1() {
        return "N/A";
    }

    private static final String updateSidebar$$anonfun$2() {
        return "";
    }

    public static final /* synthetic */ void org$nlogo$app$tools$LibrariesTab$Worker$$$_$$lessinit$greater$default$5$$anonfun$1() {
    }

    private final /* synthetic */ Worker runAllWorkersAndThen$$anonfun$1(String operation$1, Function1 task$1, Function0 cb$1, LibraryInfo _$24) {
        return new Worker(this, operation$1, (Function1<LibraryInfo, BoxedUnit>)task$1, _$24, true, (Function0<BoxedUnit>)cb$1);
    }

    public class CellRenderer
    extends JPanel
    implements ListCellRenderer<LibraryInfo> {
        private final ScalableIcon noIcon;
        private final ScalableIcon upToDateIcon;
        private final ScalableIcon warningIcon;
        private final ScalableIcon canUpdateIcon;
        private final JLabel iconLabel;
        private final JLabel nameLabel;
        private final JLabel descLabel;

        public CellRenderer() {
            if (LibrariesTab.this == null) {
                throw new NullPointerException();
            }
            super(new GridBagLayout());
            this.noIcon = new ScalableIcon(new EmptyIcon(24, 24), 24, 24);
            this.upToDateIcon = Utils$.MODULE$.iconScaledWithColor("/images/check.png", 24, 24, InterfaceColors$.MODULE$.checkFilled());
            this.warningIcon = Utils$.MODULE$.iconScaledWithColor("/images/exclamation-triangle.png", 24, 24, InterfaceColors$.MODULE$.warningIcon());
            this.canUpdateIcon = Utils$.MODULE$.iconScaledWithColor("/images/update.png", 24, 24, InterfaceColors$.MODULE$.updateIcon());
            this.iconLabel = new JLabel();
            this.nameLabel = new JLabel();
            this.descLabel = new JLabel();
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.gridheight = 2;
            c.anchor = 17;
            c.insets = new Insets(6, 6, 6, 6);
            this.add((Component)this.iconLabel, c);
            c.gridx = 1;
            c.gridy = 0;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.insets = new Insets(6, 0, 3, 6);
            this.add((Component)this.nameLabel, c);
            c.gridy = 1;
            c.insets = new Insets(0, 0, 6, 6);
            this.add((Component)this.descLabel, c);
            this.nameLabel.setFont(this.nameLabel.getFont().deriveFont(14.0f).deriveFont(1));
            Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends LibraryInfo> list, LibraryInfo value, int index, boolean isSelected, boolean hasFocus) {
            this.iconLabel.setIcon(this.statusIcon(value.status(), value.codeName()));
            this.nameLabel.setText(value.name());
            this.descLabel.setText(value.shortDescription());
            if (isSelected) {
                this.setBackground(InterfaceColors$.MODULE$.dialogBackgroundSelected());
                this.nameLabel.setForeground(InterfaceColors$.MODULE$.dialogTextSelected());
                this.descLabel.setForeground(InterfaceColors$.MODULE$.dialogTextSelected());
            } else {
                this.setBackground(InterfaceColors$.MODULE$.dialogBackground());
                this.nameLabel.setForeground(InterfaceColors$.MODULE$.dialogText());
                this.descLabel.setForeground(InterfaceColors$.MODULE$.dialogText());
            }
            return this;
        }

        private Icon statusIcon(LibraryStatus status, String extName) {
            if (!LibrariesTab.this.org$nlogo$app$tools$LibrariesTab$$extPathMappings.contains((Object)extName)) {
                LibraryStatus libraryStatus = status;
                if (LibraryStatus$UpToDate$.MODULE$.equals(libraryStatus)) {
                    return this.upToDateIcon;
                }
                if (LibraryStatus$CanUpdate$.MODULE$.equals(libraryStatus)) {
                    return this.canUpdateIcon;
                }
                if (LibraryStatus$CanInstall$.MODULE$.equals(libraryStatus)) {
                    return this.noIcon;
                }
                throw new MatchError((Object)libraryStatus);
            }
            return this.warningIcon;
        }

        public final /* synthetic */ LibrariesTab org$nlogo$app$tools$LibrariesTab$CellRenderer$$$outer() {
            return LibrariesTab.this;
        }
    }

    public class Worker
    extends SwingWorker<Object, Object> {
        private final String operation;
        private final Function1<LibraryInfo, BoxedUnit> fn;
        private final LibraryInfo lib;
        private final boolean multiple;
        private final Function0<BoxedUnit> callback;
        private final int[] indices;
        private final /* synthetic */ LibrariesTab $outer;

        public Worker(LibrariesTab $outer, String operation, Function1<LibraryInfo, BoxedUnit> fn, LibraryInfo lib, boolean multiple, Function0<BoxedUnit> callback) {
            this.operation = operation;
            this.fn = fn;
            this.lib = lib;
            this.multiple = multiple;
            this.callback = callback;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.indices = $outer.org$nlogo$app$tools$LibrariesTab$$libraryList.getSelectedIndices();
            $outer.org$nlogo$app$tools$LibrariesTab$$updateSidebar();
        }

        @Override
        public Object doInBackground() {
            return this.fn.apply((Object)this.lib);
        }

        @Override
        public void onComplete() {
            this.$outer.org$nlogo$app$tools$LibrariesTab$$updateLists.apply$mcV$sp();
            if (this.multiple && this.$outer.org$nlogo$app$tools$LibrariesTab$$numOperatedLibs > 1) {
                --this.$outer.org$nlogo$app$tools$LibrariesTab$$numOperatedLibs;
                this.$outer.org$nlogo$app$tools$LibrariesTab$$updateMultipleOperationStatus(this.operation);
            } else {
                this.$outer.org$nlogo$app$tools$LibrariesTab$$updateStatus.apply(null);
            }
            this.callback.apply$mcV$sp();
            EventQueue$.MODULE$.invokeLater(() -> this.$outer.org$nlogo$app$tools$LibrariesTab$$libraryList.setSelectedIndices(this.indices));
        }

        public final /* synthetic */ LibrariesTab org$nlogo$app$tools$LibrariesTab$Worker$$$outer() {
            return this.$outer;
        }
    }
}

