/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.core;

import org.nlogo.core.CommandBlock;
import org.nlogo.core.Expression;
import org.nlogo.core.ProcedureDefinition;
import org.nlogo.core.ReporterApp;
import org.nlogo.core.ReporterBlock;
import org.nlogo.core.Statement;
import org.nlogo.core.Statements;

public interface AstVisitor {
    public static void visitProcedureDefinition$(AstVisitor $this, ProcedureDefinition proc) {
        $this.visitProcedureDefinition(proc);
    }

    default public void visitProcedureDefinition(ProcedureDefinition proc) {
        this.visitStatements(proc.statements());
    }

    public static void visitCommandBlock$(AstVisitor $this, CommandBlock block) {
        $this.visitCommandBlock(block);
    }

    default public void visitCommandBlock(CommandBlock block) {
        this.visitStatements(block.statements());
    }

    public static void visitExpression$(AstVisitor $this, Expression exp) {
        $this.visitExpression(exp);
    }

    default public void visitExpression(Expression exp) {
        Expression expression = exp;
        if (expression instanceof ReporterApp) {
            ReporterApp app = (ReporterApp)expression;
            this.visitReporterApp(app);
            return;
        }
        if (expression instanceof CommandBlock) {
            CommandBlock cb = (CommandBlock)expression;
            this.visitCommandBlock(cb);
            return;
        }
        if (expression instanceof ReporterBlock) {
            ReporterBlock rb = (ReporterBlock)expression;
            this.visitReporterBlock(rb);
            return;
        }
        Expression e = expression;
        throw new IllegalStateException();
    }

    public static void visitReporterApp$(AstVisitor $this, ReporterApp app) {
        $this.visitReporterApp(app);
    }

    default public void visitReporterApp(ReporterApp app) {
        app.args().foreach(exp -> this.visitExpression((Expression)exp));
    }

    public static void visitReporterBlock$(AstVisitor $this, ReporterBlock block) {
        $this.visitReporterBlock(block);
    }

    default public void visitReporterBlock(ReporterBlock block) {
        this.visitReporterApp(block.app());
    }

    public static void visitStatement$(AstVisitor $this, Statement stmt) {
        $this.visitStatement(stmt);
    }

    default public void visitStatement(Statement stmt) {
        stmt.args().foreach(exp -> this.visitExpression((Expression)exp));
    }

    public static void visitStatements$(AstVisitor $this, Statements stmts) {
        $this.visitStatements(stmts);
    }

    default public void visitStatements(Statements stmts) {
        stmts.stmts().foreach(stmt -> this.visitStatement((Statement)stmt));
    }
}

