/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.core;

import java.io.Serializable;
import org.nlogo.core.ColorConstants$;
import org.nlogo.core.LogoList;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public interface Color {
    /*
     * WARNING - void declaration
     */
    public static void $init$(Color $this) {
        void var2_2;
        void var1_1;
        $this.org$nlogo$core$Color$_setter_$NumHues_$eq(14);
        $this.org$nlogo$core$Color$_setter_$MaxColor_$eq(10 * $this.NumHues());
        $this.org$nlogo$core$Color$_setter_$BoxedBlack_$eq(Predef$.MODULE$.double2Double(0.0));
        $this.org$nlogo$core$Color$_setter_$BoxedWhite_$eq(Predef$.MODULE$.double2Double(ColorConstants$.MODULE$.White()));
        $this.org$nlogo$core$Color$_setter_$org$nlogo$core$Color$$ColorsRGB_$eq(new int[]{140, 140, 140, 215, 48, 39, 241, 105, 19, 156, 109, 70, 237, 237, 47, 87, 176, 58, 42, 209, 57, 27, 158, 119, 82, 196, 196, 43, 140, 190, 50, 92, 168, 123, 78, 163, 166, 25, 105, 224, 126, 149, 0, 0, 0, 255, 255, 255});
        int[] cache = (int[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), $this.MaxColor() * 10).map((Function1)(JFunction1.mcII.sp & Serializable)colorTimesTen -> this.computeARGBforCache(colorTimesTen)).toArray(ClassTag$.MODULE$.apply(Integer.TYPE));
        cache[0] = -16777216;
        cache[99] = -1;
        $this.org$nlogo$core$Color$_setter_$org$nlogo$core$Color$$ARGB_Cache_$eq((int[])var1_1);
        LinkedHashMap map = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), $this.MaxColor() * 10).foreach((Function1)(JFunction1.mcVI.sp & Serializable)c -> {
            double color = (double)c / 10.0;
            map.update((Object)BoxesRunTime.boxToDouble((double)Int$.MODULE$.int2double(this.getARGBbyPremodulatedColorNumber(color))), (Object)BoxesRunTime.boxToDouble((double)color));
        });
        $this.org$nlogo$core$Color$_setter_$rgbMap_$eq((LinkedHashMap)var2_2);
    }

    public int NumHues();

    public void org$nlogo$core$Color$_setter_$NumHues_$eq(int var1);

    public int MaxColor();

    public void org$nlogo$core$Color$_setter_$MaxColor_$eq(int var1);

    public Double BoxedBlack();

    public void org$nlogo$core$Color$_setter_$BoxedBlack_$eq(Double var1);

    public Double BoxedWhite();

    public void org$nlogo$core$Color$_setter_$BoxedWhite_$eq(Double var1);

    public int[] org$nlogo$core$Color$$ColorsRGB();

    public void org$nlogo$core$Color$_setter_$org$nlogo$core$Color$$ColorsRGB_$eq(int[] var1);

    public int[] org$nlogo$core$Color$$ARGB_Cache();

    public void org$nlogo$core$Color$_setter_$org$nlogo$core$Color$$ARGB_Cache_$eq(int[] var1);

    public LinkedHashMap<Object, Object> rgbMap();

    public void org$nlogo$core$Color$_setter_$rgbMap_$eq(LinkedHashMap var1);

    public static int modulateInteger$(Color $this, int color) {
        return $this.modulateInteger(color);
    }

    default public int modulateInteger(int color) {
        int c = color;
        if ((c < 0 || c >= this.MaxColor()) && (c %= this.MaxColor()) < 0) {
            c += this.MaxColor();
        }
        return c;
    }

    public static double modulateDouble$(Color $this, Double color) {
        return $this.modulateDouble(color);
    }

    default public double modulateDouble(Double color) {
        return this.modulateDouble((double)color);
    }

    public static double modulateDouble$(Color $this, double color) {
        return $this.modulateDouble(color);
    }

    default public double modulateDouble(double color) {
        double c = color;
        if (c < 0.0 || c >= (double)this.MaxColor()) {
            if ((c %= (double)this.MaxColor()) < 0.0) {
                c += (double)this.MaxColor();
            }
            if (c >= (double)this.MaxColor()) {
                c = 139.9999999999999;
            }
        }
        return c;
    }

    public static double findCentralColorNumber$(Color $this, double color) {
        return $this.findCentralColorNumber(color);
    }

    default public double findCentralColorNumber(double color) {
        double c = color < 0.0 || color >= (double)this.MaxColor() ? this.modulateDouble(color) : color;
        return ((double)((int)(c / (double)10)) + 0.5) * (double)10;
    }

    public static double getClosestColorNumberByARGB$(Color $this, int argb) {
        return $this.getClosestColorNumberByARGB(argb);
    }

    default public double getClosestColorNumberByARGB(int argb) {
        return BoxesRunTime.unboxToDouble((Object)this.rgbMap().get((Object)BoxesRunTime.boxToDouble((double)Int$.MODULE$.int2double(argb))).getOrElse(() -> this.getClosestColorNumberByARGB$$anonfun$1(argb)));
    }

    public static double estimateClosestColorNumberByRGB$(Color $this, int argb) {
        return $this.estimateClosestColorNumberByRGB(argb);
    }

    default public double estimateClosestColorNumberByRGB(int argb) {
        LongRef smallestDistance = LongRef.create((long)100000000L);
        DoubleRef closest = DoubleRef.create((double)0.0);
        this.rgbMap().foreach(x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                double k = tuple2._1$mcD$sp();
                double v = tuple2._2$mcD$sp();
                int candidate = (int)k;
                long dist = this.colorDistance(argb, candidate);
                if (dist < smallestDistance$1.elem) {
                    smallestDistance$1.elem = dist;
                    closest$1.elem = v;
                    return;
                }
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        return closest.elem;
    }

    private long colorDistance(int argb1, int argb2) {
        int r1 = argb1 >> 16 & 0xFF;
        int g1 = argb1 >> 8 & 0xFF;
        int b1 = argb1 & 0xFF;
        int r2 = argb2 >> 16 & 0xFF;
        int g2 = argb2 >> 8 & 0xFF;
        int b2 = argb2 & 0xFF;
        int rmean = r1 + r2 / 2;
        int rd = r1 - r2;
        int gd = g1 - g2;
        int bd = b1 - b2;
        return Int$.MODULE$.int2long(((512 + rmean) * rd * rd >> 8) + 4 * gd * gd + ((767 - rmean) * bd * bd >> 8));
    }

    public static int getARGBbyPremodulatedColorNumber$(Color $this, double modulatedColor) {
        return $this.getARGBbyPremodulatedColorNumber(modulatedColor);
    }

    default public int getARGBbyPremodulatedColorNumber(double modulatedColor) {
        return this.org$nlogo$core$Color$$ARGB_Cache()[(int)(modulatedColor * (double)10)];
    }

    private int computeARGBforCache(int colorTimesTen) {
        int baseIndex = colorTimesTen / 100;
        int r = this.org$nlogo$core$Color$$ColorsRGB()[baseIndex * 3];
        int g = this.org$nlogo$core$Color$$ColorsRGB()[baseIndex * 3 + 1];
        int b = this.org$nlogo$core$Color$$ColorsRGB()[baseIndex * 3 + 2];
        double step = (double)(colorTimesTen % 100 - 50) / 50.48 + 0.012;
        if (step < 0.0) {
            r += (int)((double)r * step);
            g += (int)((double)g * step);
            b += (int)((double)b * step);
        } else if (step > 0.0) {
            r += (int)((double)(255 - r) * step);
            g += (int)((double)(255 - g) * step);
            b += (int)((double)(255 - b) * step);
        }
        return -16777216 + (r << 16) + (g << 8) + b;
    }

    public static int getRGBByName$(Color $this, String name) {
        return $this.getRGBByName(name);
    }

    default public int getRGBByName(String name) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])ColorConstants$.MODULE$.ColorNames());
        return this.getARGBByIndex(ArrayOps$.MODULE$.indexOf$extension(object, (Object)name, ArrayOps$.MODULE$.indexOf$default$2$extension(object)));
    }

    public static int getARGBByIndex$(Color $this, int index) {
        return $this.getARGBByIndex(index);
    }

    default public int getARGBByIndex(int index) {
        int n = index;
        if (14 == n) {
            return -16777216;
        }
        if (15 == n) {
            return -1;
        }
        return this.org$nlogo$core$Color$$ARGB_Cache()[index * 100 + 50];
    }

    public static int getARGBIntByRGBAList$(Color $this, LogoList rgba) {
        return $this.getARGBIntByRGBAList(rgba);
    }

    default public int getARGBIntByRGBAList(LogoList rgba) {
        if (rgba.size() == 4) {
            return ((Double)rgba.get(3)).intValue() << 24 | ((Double)rgba.get(0)).intValue() << 16 | ((Double)rgba.get(1)).intValue() << 8 | ((Double)rgba.get(2)).intValue();
        }
        return 0xFF000000 | ((Double)rgba.get(0)).intValue() << 16 | ((Double)rgba.get(1)).intValue() << 8 | ((Double)rgba.get(2)).intValue();
    }

    public static Double argbToColor$(Color $this, int argb) {
        return $this.argbToColor(argb);
    }

    default public Double argbToColor(int argb) {
        return Predef$.MODULE$.double2Double(this.getClosestColorNumberByARGB(argb));
    }

    public static int getRGBInt$(Color $this, int r, int g, int b) {
        return $this.getRGBInt(r, g, b);
    }

    default public int getRGBInt(int r, int g, int b) {
        return ((r << 8) + g << 8) + b;
    }

    public static int getRGBInt$(Color $this, Object c) {
        return $this.getRGBInt(c);
    }

    default public int getRGBInt(Object c) {
        Object object = c;
        if (object instanceof LogoList) {
            LogoList l = (LogoList)object;
            return this.getARGBIntByRGBAList(l);
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            return this.getARGBbyPremodulatedColorNumber(d);
        }
        throw new IllegalArgumentException("Can't get RGB color: " + c);
    }

    private double getClosestColorNumberByARGB$$anonfun$1(int argb$1) {
        return this.estimateClosestColorNumberByRGB(argb$1);
    }
}

