/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.core;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.nlogo.core.I18N$;
import org.nlogo.core.I18N$Prefix$;
import org.nlogo.core.I18NJava;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class I18N {
    public static boolean available(Locale locale) {
        return I18N$.MODULE$.available(locale);
    }

    public static Locale[] availableLocales() {
        return I18N$.MODULE$.availableLocales();
    }

    public static BundleKind errors() {
        return I18N$.MODULE$.errors();
    }

    public static I18NJava errorsJ() {
        return I18N$.MODULE$.errorsJ();
    }

    public static BundleKind gui() {
        return I18N$.MODULE$.gui();
    }

    public static I18NJava guiJ() {
        return I18N$.MODULE$.guiJ();
    }

    public static Option<Locale> localeFromPreferences() {
        return I18N$.MODULE$.localeFromPreferences();
    }

    public static Option<Locale> localeIfAvailable(Locale locale) {
        return I18N$.MODULE$.localeIfAvailable(locale);
    }

    public static BundleKind shared() {
        return I18N$.MODULE$.shared();
    }

    public static class BundleKind
    implements I18NJava {
        private final String name;
        private final Locale defaultLocale;
        private ResourceBundle defaultBundle;
        private final ResourceBundle englishBundle;
        private final Function1<String, String> fn;

        public BundleKind(String name) {
            this.name = name;
            this.defaultLocale = (Locale)I18N$.MODULE$.localeFromPreferences().getOrElse(this::$init$$$anonfun$1);
            this.defaultBundle = this.getBundle(this.defaultLocale());
            this.englishBundle = this.getBundle(Locale.US);
            this.fn = (Function1 & Serializable)key -> this.get((String)key);
        }

        public Locale defaultLocale() {
            return this.defaultLocale;
        }

        public ResourceBundle getBundle(Locale locale) {
            return ResourceBundle.getBundle(this.name, locale);
        }

        public String apply(String key, Prefix prefix) {
            return this.get(prefix.name() + "." + key);
        }

        public String apply(String key, Seq<Object> args, Prefix prefix) {
            return this.getN(prefix.name() + "." + key, args);
        }

        @Override
        public String get(String key) {
            return this.getN(key, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[0]));
        }

        public String getN(String key, Seq<Object> args) {
            String preformattedText = (String)this.getFromBundle$1(key, this.defaultBundle).getOrElse(() -> this.$anonfun$1(key));
            return MessageFormat.format(preformattedText, (Object[])Arrays$.MODULE$.seqToArray(args, Object.class));
        }

        @Override
        public /* synthetic */ String getN(String key, Object ... args) {
            return this.getN(key, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(args));
        }

        public <T> T withLanguage(Locale locale, Function0<T> f) {
            ResourceBundle oldBundle = this.defaultBundle;
            this.defaultBundle = this.getBundle(locale);
            Object v = f.apply();
            this.defaultBundle = oldBundle;
            return (T)v;
        }

        public Set<String> keys(Locale locale) {
            return CollectionConverters$.MODULE$.SetHasAsScala(this.getBundle(locale).keySet()).asScala().toSet();
        }

        public void setLanguage(Locale locale) {
            this.defaultBundle = this.getBundle(locale);
        }

        @Override
        public Function1<String, String> fn() {
            return this.fn;
        }

        private final Locale $init$$$anonfun$1$$anonfun$1() {
            return Locale.US;
        }

        private final Locale $init$$$anonfun$1() {
            return (Locale)I18N$.MODULE$.localeIfAvailable(Locale.getDefault()).getOrElse(this::$init$$$anonfun$1$$anonfun$1);
        }

        private final Option getFromBundle$1(String key$1, ResourceBundle bundle) {
            None$ none$;
            try {
                none$ = Some$.MODULE$.apply((Object)bundle.getString(key$1));
            }
            catch (MissingResourceException m) {
                none$ = None$.MODULE$;
            }
            return none$;
        }

        private final String $anonfun$1$$anonfun$1(String key$3) {
            throw new IllegalArgumentException("internal error, bad translation key: " + key$3 + " for " + this.name);
        }

        private final String $anonfun$1(String key$2) {
            Predef$.MODULE$.println((Object)("unable to find translation for: " + key$2 + " in " + this.name + " for locale: " + this.defaultBundle.getLocale()));
            return (String)this.getFromBundle$1(key$2, this.englishBundle).getOrElse(() -> this.$anonfun$1$$anonfun$1(key$2));
        }
    }

    public static class Prefix
    implements Product,
    Serializable {
        private final String name;

        public static Prefix apply(String string) {
            return I18N$Prefix$.MODULE$.apply(string);
        }

        public static Prefix fromProduct(Product product) {
            return I18N$Prefix$.MODULE$.fromProduct(product);
        }

        public static Prefix unapply(Prefix prefix) {
            return I18N$Prefix$.MODULE$.unapply(prefix);
        }

        public Prefix(String name) {
            this.name = name;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Prefix)) return false;
            Prefix prefix = (Prefix)object;
            String string = this.name();
            String string2 = prefix.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!prefix.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Prefix;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Prefix";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "name";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public Prefix copy(String name) {
            return new Prefix(name);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String _1() {
            return this.name();
        }
    }
}

