/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.fileformat;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.nlogo.api.LabProtocol;
import org.nlogo.api.LabProtocol$;
import org.nlogo.api.RefEnumeratedValueSet;
import org.nlogo.api.RefValueSet;
import org.nlogo.api.SteppedValueSet;
import org.nlogo.core.LiteralParser;
import org.nlogo.fileformat.LabLoader$;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.math.BigDecimal;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public class LabLoader {
    private final LiteralParser literalParser;

    public static String DOCTYPE() {
        return LabLoader$.MODULE$.DOCTYPE();
    }

    public static String XMLVER() {
        return LabLoader$.MODULE$.XMLVER();
    }

    public LabLoader(LiteralParser literalParser) {
        this.literalParser = literalParser;
        if (literalParser == null) {
            throw new Exception("Invalid lab loader!");
        }
    }

    public Seq<LabProtocol> apply(String xml, boolean editNames, Set<String> existingNames) {
        String taggedXml = xml.contains("DOCTYPE experiments") ? xml : LabLoader$.MODULE$.DOCTYPE() + "\n" + xml;
        InputSource inputSource = new InputSource(new ByteArrayInputStream(this.finalToPost(this.ticksToSteps(taggedXml)).getBytes()));
        return this.apply(inputSource, editNames, existingNames);
    }

    public Seq<LabProtocol> apply(InputSource inputSource, boolean editNames, Set<String> existingNames) {
        inputSource.setSystemId(this.getClass().getResource("/system/").toString());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException ex) {
                throw ex;
            }

            public void fatalError(SAXParseException ex) {
                throw ex;
            }

            public void warning(SAXParseException ex) {
                throw ex;
            }
        });
        return this.nodes2list(builder.parse(inputSource).getElementsByTagName("experiment")).map((Function1 & Serializable)x -> this.fixEmptyNames(this.readProtocolElement((Element)x, editNames, existingNames), editNames, existingNames));
    }

    public LabProtocol readProtocolElement(Element element, boolean editNames, Set<String> existingNames) {
        boolean bl;
        String defaultOrder;
        Object name = element.getAttribute("name");
        if (editNames && !((String)name).isEmpty()) {
            if (existingNames.contains(name)) {
                int n = 1;
                while (existingNames.contains((Object)((String)name + " (" + n + ")"))) {
                    ++n;
                }
                name = (String)name + " (" + n + ")";
            }
            existingNames.$plus$eq(name);
        }
        String string = this.readOptional$1(element, "preExperiment");
        String string2 = this.readOptional$1(element, "setup");
        String string3 = this.readOptional$1(element, "go");
        String string4 = this.readOptional$1(element, "postRun");
        String string5 = this.readOptional$1(element, "postExperiment");
        int n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(element.getAttribute("repetitions")));
        String string6 = defaultOrder = element.getAttribute("sequentialRunOrder").toString();
        String string7 = "";
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            bl = true;
        } else {
            String string8 = defaultOrder;
            String string9 = "true";
            bl = !(string8 != null ? !string8.equals(string9) : string9 != null);
        }
        String string10 = element.getAttribute("runMetricsEveryStep");
        String string11 = "true";
        return new LabProtocol((String)name, string, string2, string3, string4, string5, n, bl, !(string10 != null ? !string10.equals(string11) : string11 != null), this.readOptional$1(element, "runMetricsCondition"), !this.exists$1(element, "timeLimit") ? 0 : StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(this.readOneAttribute$1(element, "timeLimit", "steps"))), !this.exists$1(element, "exitCondition") ? "" : this.readOptional$1(element, "exitCondition"), (List<String>)this.readAll$1(element, "metric"), (List<RefValueSet>)this.constants$1(element), (List<List<RefValueSet>>)this.subExperiments$1(element), LabProtocol$.MODULE$.$lessinit$greater$default$16(), LabProtocol$.MODULE$.$lessinit$greater$default$17(), LabProtocol$.MODULE$.$lessinit$greater$default$18(), LabProtocol$.MODULE$.$lessinit$greater$default$19(), LabProtocol$.MODULE$.$lessinit$greater$default$20(), LabProtocol$.MODULE$.$lessinit$greater$default$21(), LabProtocol$.MODULE$.$lessinit$greater$default$22(), LabProtocol$.MODULE$.$lessinit$greater$default$23(), LabProtocol$.MODULE$.$lessinit$greater$default$24());
    }

    public LabProtocol fixEmptyNames(LabProtocol protocol, boolean editNames, Set<String> existingNames) {
        if (editNames && protocol.name().isEmpty() && existingNames.contains((Object)"no name")) {
            int n = 1;
            while (existingNames.contains((Object)("no name (" + n + ")"))) {
                ++n;
            }
            existingNames.$plus$eq((Object)("no name (" + n + ")"));
            return protocol.copy("no name (" + n + ")", protocol.copy$default$2(), protocol.copy$default$3(), protocol.copy$default$4(), protocol.copy$default$5(), protocol.copy$default$6(), protocol.copy$default$7(), protocol.copy$default$8(), protocol.copy$default$9(), protocol.copy$default$10(), protocol.copy$default$11(), protocol.copy$default$12(), protocol.copy$default$13(), protocol.copy$default$14(), protocol.copy$default$15(), protocol.copy$default$16(), protocol.copy$default$17(), protocol.copy$default$18(), protocol.copy$default$19(), protocol.copy$default$20(), protocol.copy$default$21(), protocol.copy$default$22(), protocol.copy$default$23(), protocol.copy$default$24());
        }
        return protocol;
    }

    public List<Element> nodes2list(NodeList nodes) {
        return ((IterableOnceOps)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nodes.getLength()).map((Function1 & Serializable)_$3 -> nodes.item(BoxesRunTime.unboxToInt((Object)_$3))).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Node x) {
                Node node = x;
                if (node instanceof Element) {
                    Element e = (Element)node;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Node x, Function1 function1) {
                Node node = x;
                if (node instanceof Element) {
                    Element e = (Element)node;
                    return e;
                }
                return function1.apply((Object)x);
            }
        })).toList();
    }

    private String ticksToSteps(String str) {
        return str.replaceAll("runMetricsEveryTick=\"", "runMetricsEveryStep=\"").replaceAll("<timeLimit ticks=\"", "<timeLimit steps=\"");
    }

    private String finalToPost(String str) {
        return str.replaceAll("<final>", "<postRun>").replaceAll("</final>", "</postRun>");
    }

    private final String readOneAttribute$1(Element element$1, String name, String attr) {
        return ((Element)this.nodes2list(element$1.getElementsByTagName(name)).head()).getAttribute(attr);
    }

    private final List readAll$1(Element element$2, String name) {
        return this.nodes2list(element$2.getElementsByTagName(name)).map((Function1 & Serializable)_$1 -> _$1.getLastChild().getNodeValue());
    }

    private final String readOptional$1(Element element$6, String name) {
        SeqOps seqOps;
        List list = this.readAll$1(element$6, name);
        if (list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list), 1) == 0) {
            String string;
            String x = string = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
            return x;
        }
        return "";
    }

    private final boolean exists$1(Element element$3, String name) {
        return !this.nodes2list(element$3.getElementsByTagName(name)).isEmpty();
    }

    private static final BigDecimal parse$1(Element e$1, String name) {
        return package$.MODULE$.BigDecimal().apply(e$1.getAttribute(name));
    }

    private static final SteppedValueSet readSteppedValueSetElement$1(Element e) {
        return new SteppedValueSet(e.getAttribute("variable"), LabLoader.parse$1(e, "first"), LabLoader.parse$1(e, "step"), LabLoader.parse$1(e, "last"));
    }

    private static final /* synthetic */ Tuple2 $anonfun$1(NodeList valueElems$1, int i) {
        Node elem = valueElems$1.item(i);
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)i), (Object)elem);
    }

    private final RefEnumeratedValueSet readEnumeratedValueSetElement$1(Element e) {
        NodeList valueElems = e.getElementsByTagName("value");
        IndexedSeq values = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), valueElems.getLength()).map((Function1 & Serializable)i -> LabLoader.$anonfun$1(valueElems, BoxesRunTime.unboxToInt((Object)i))).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int i = BoxesRunTime.unboxToInt((Object)tuple2._1());
                Node elem = (Node)tuple2._2();
                return elem != null;
            }
            throw new MatchError((Object)tuple2);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int i = BoxesRunTime.unboxToInt((Object)tuple2._1());
                Node elem = (Node)tuple2._2();
                return this.literalParser.readFromString(elem.getAttributes().getNamedItem("value").getNodeValue());
            }
            throw new MatchError((Object)tuple2);
        });
        return new RefEnumeratedValueSet(e.getAttribute("variable"), (List<Object>)values.toList());
    }

    private final List constants$1(Element element$4) {
        return this.nodes2list(element$4.getChildNodes()).flatMap((Function1 & Serializable)e -> {
            String string = e.getNodeName();
            return ("steppedValueSet".equals(string) ? Some$.MODULE$.apply((Object)LabLoader.readSteppedValueSetElement$1(e)) : ("enumeratedValueSet".equals(string) ? Some$.MODULE$.apply((Object)this.readEnumeratedValueSetElement$1((Element)e)) : None$.MODULE$)).map((Function1 & Serializable)valueSet -> (RefValueSet)((Object)valueSet));
        });
    }

    private final List subExperiments$1(Element element$5) {
        return this.nodes2list(element$5.getElementsByTagName("subExperiment")).map((Function1 & Serializable)_$2 -> this.nodes2list(_$2.getChildNodes()).map((Function1 & Serializable)e -> {
            IterableOnce iterableOnce;
            String string = e.getNodeName();
            if ("steppedValueSet".equals(string)) {
                iterableOnce = LabLoader.readSteppedValueSetElement$1(e);
            } else if ("enumeratedValueSet".equals(string)) {
                iterableOnce = this.readEnumeratedValueSetElement$1((Element)e);
            } else {
                throw new MatchError((Object)string);
            }
            return iterableOnce;
        }));
    }
}

