/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.fileformat;

import java.io.Serializable;
import java.util.Locale;
import org.nlogo.core.Model;
import org.nlogo.core.SourceRewriter;
import org.nlogo.fileformat.ConversionSet;
import org.nlogo.fileformat.ConversionSet$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class PlotConverter$
implements Serializable {
    public static final PlotConverter$ MODULE$ = new PlotConverter$();

    private PlotConverter$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PlotConverter$.class);
    }

    public Seq<String> allPlotNames(Model model) {
        return (Seq)((IterableOps)model.plots().flatMap((Function1 & Serializable)_$1 -> _$1.display())).filterNot((Function1 & Serializable)_$2 -> _$2.isEmpty());
    }

    public Seq<Tuple2<String, Seq<String>>> allKeyedPenNames(Model model) {
        return (Seq)((IterableOps)model.plots().map((Function1 & Serializable)plot -> Tuple2$.MODULE$.apply(plot.display().getOrElse(PlotConverter$::allKeyedPenNames$$anonfun$1$$anonfun$1), (Object)((List)plot.pens().toSeq()).map((Function1 & Serializable)_$3 -> _$3.display())))).filterNot((Function1 & Serializable)_$4 -> ((String)_$4._1()).isEmpty());
    }

    public Seq<Tuple2<String, String>> generateRenameMappings(Seq<Tuple2<String, Seq<String>>> groupedNames) {
        return (Seq)((IterableOps)groupedNames.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String upper = (String)tuple2._1();
                Seq originals = (Seq)tuple2._2();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)upper);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)originals);
            }
            throw new MatchError((Object)tuple2);
        })).flatMap((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                String upper = (String)tuple2._1();
                Seq originals = (Seq)tuple2._2();
                if (originals.length() > 1) {
                    Seq sortedOriginals = (Seq)((SeqOps)originals.sorted((Ordering)Ordering.String$.MODULE$)).reverse();
                    return (Seq)((IterableOps)sortedOriginals.zipWithIndex()).map((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            String string = (String)tuple2._1();
                            int n = BoxesRunTime.unboxToInt((Object)tuple2._2());
                            String original = string;
                            int index = n;
                            if (index == 0) {
                                return Tuple2$.MODULE$.apply((Object)original, (Object)original);
                            }
                            String original2 = string;
                            int index2 = n;
                            String new_name = original2 + "_" + index2;
                            int new_index = index2;
                            while (((SeqOps)groupedNames.map((Function1 & Serializable)_$5 -> (String)_$5._1())).contains((Object)new_name.toUpperCase(Locale.ENGLISH))) {
                                new_name = original2 + "_" + ++new_index;
                            }
                            return Tuple2$.MODULE$.apply((Object)original2, (Object)(original2 + "_" + new_index));
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }
            }
            return (Seq)package$.MODULE$.Seq().empty();
        });
    }

    public Seq<Tuple2<String, Seq<Tuple2<String, String>>>> determinePenSubstitutions(Seq<Tuple2<String, Seq<String>>> names) {
        return (Seq)((IterableOps)names.map((Function1 & Serializable)plotAndPens -> Tuple2$.MODULE$.apply(plotAndPens._1(), MODULE$.generateRenameMappings((Seq<Tuple2<String, Seq<String>>>)((IterableOps)plotAndPens._2()).groupBy((Function1 & Serializable)_$6 -> _$6.toUpperCase(Locale.ENGLISH)).toSeq())))).filterNot((Function1 & Serializable)_$7 -> ((SeqOps)_$7._2()).isEmpty());
    }

    public Seq<Tuple2<String, String>> determinePlotSubstitutions(Seq<String> names) {
        return this.generateRenameMappings((Seq<Tuple2<String, Seq<String>>>)names.groupBy((Function1 & Serializable)_$8 -> _$8.toUpperCase(Locale.ENGLISH)).toSeq());
    }

    private Seq<Tuple2<String, Seq<Tuple2<String, String>>>> modifyPlotNameKeys(Seq<Tuple2<String, Seq<Tuple2<String, String>>>> groupedPlotAndPens, Seq<Tuple2<String, String>> nameMappings) {
        return (Seq)groupedPlotAndPens.map((Function1 & Serializable)element -> Tuple2$.MODULE$.apply(nameMappings.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).getOrElse(element._1(), () -> PlotConverter$.modifyPlotNameKeys$$anonfun$1$$anonfun$1(element)), element._2()));
    }

    private String clarifyPlotProcedureBody(Seq<Tuple2<String, String>> renamePairs) {
        String nameMap = ((IterableOnceOps)renamePairs.map((Function1 & Serializable)p -> "[\"" + p._1() + "\" \"" + p._2() + "\"]")).mkString("[", " ", "]");
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|  let name-map " + nameMap + "\n        |  let replacement filter [ rename -> first rename = name ] name-map\n        |  let reported-name name\n        |  if not empty? replacement [\n        |    set reported-name item 1 (item 0 replacement)\n        |  ]\n        |  report reported-name"));
    }

    private String clarifyPensProcedureBody(Seq<Tuple2<String, Seq<Tuple2<String, String>>>> renamePensPairs) {
        String penNameMapping = ((IterableOnceOps)renamePensPairs.flatMap((Function1 & Serializable)renamePair -> (IterableOnce)((IterableOps)renamePair._2()).map((Function1 & Serializable)p -> "[ \"" + renamePair._1() + "\" \"" + p._1() + "\" \"" + p._2() + "\" ]"))).mkString("[", " ", "]");
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|  let name-map " + penNameMapping + "\n        |  let replacement filter [ rename -> first rename = plot-name and item 1 rename = name ] name-map\n        |  let reported-name name\n        |  if not empty? replacement [\n        |    set reported-name item 2 (item 0 replacement)\n        |  ]\n        |  report reported-name"));
    }

    private Seq<ConversionSet> buildConversionSet(String description, String reporterName, Seq<Tuple2<String, String>> renames, String conversionTarget) {
        if (renames.nonEmpty()) {
            Function1 & Serializable codeTabTransformation = (Function1 & Serializable)_$9 -> _$9.addReporterProcedure(reporterName, (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)"name", (List)Nil$.MODULE$))), MODULE$.clarifyPlotProcedureBody(renames));
            Seq sharedTransformations = (Seq)((SeqOps)new .colon.colon((Function1 & Serializable)_$10 -> _$10.replaceToken(conversionTarget, conversionTarget + " " + reporterName), (List)Nil$.MODULE$));
            return (Seq)((SeqOps)new .colon.colon((Object)ConversionSet$.MODULE$.apply(description, (Seq<Function1<SourceRewriter, String>>)((Seq)sharedTransformations.$plus$colon((Object)codeTabTransformation)), (Seq<Function1<SourceRewriter, String>>)sharedTransformations, (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)conversionTarget, (List)Nil$.MODULE$))), ConversionSet$.MODULE$.$lessinit$greater$default$5()), (List)Nil$.MODULE$));
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private Seq<ConversionSet> buildPensConversionSet(String description, String reporterName, Seq<Tuple2<String, Seq<Tuple2<String, String>>>> renames, String conversionTarget) {
        if (renames.nonEmpty()) {
            Function1 & Serializable codeTabTransformation = (Function1 & Serializable)_$11 -> _$11.addReporterProcedure(reporterName, (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)"name", (List)Nil$.MODULE$))), MODULE$.clarifyPensProcedureBody(renames));
            Seq sharedTransformations = (Seq)((SeqOps)new .colon.colon((Function1 & Serializable)_$12 -> _$12.replaceToken(conversionTarget, conversionTarget + " " + reporterName), (List)Nil$.MODULE$));
            return (Seq)((SeqOps)new .colon.colon((Object)ConversionSet$.MODULE$.apply(description, (Seq<Function1<SourceRewriter, String>>)((Seq)sharedTransformations.$plus$colon((Object)codeTabTransformation)), (Seq<Function1<SourceRewriter, String>>)sharedTransformations, (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)conversionTarget, (List)Nil$.MODULE$))), ConversionSet$.MODULE$.$lessinit$greater$default$5()), (List)Nil$.MODULE$));
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Seq<ConversionSet> plotCodeConversions(Model model) {
        Seq<Tuple2<String, String>> plotSubstitutions = this.determinePlotSubstitutions(this.allPlotNames(model));
        Seq<ConversionSet> plotConversions = this.buildConversionSet("Make plots case-insensitive", "_clarify-duplicate-plot-name", plotSubstitutions, "set-current-plot");
        Seq<ConversionSet> penConversions = this.buildPensConversionSet("Make pens case-insensitive", "_clarify-duplicate-plot-pen-name", this.modifyPlotNameKeys(this.determinePenSubstitutions(this.allKeyedPenNames(model)), plotSubstitutions), "set-current-plot-pen");
        return (Seq)plotConversions.$plus$plus(penConversions);
    }

    private static final String allKeyedPenNames$$anonfun$1$$anonfun$1() {
        return "";
    }

    private static final String modifyPlotNameKeys$$anonfun$1$$anonfun$1(Tuple2 element$1) {
        return (String)element$1._1();
    }
}

