/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import java.nio.FloatBuffer;
import org.nlogo.api.World3D;
import org.nlogo.gl.render.LightManager$;
import org.nlogo.gl.render.RGBA;
import org.nlogo.gl.render.RGBA$;
import org.nlogo.gl.render.ShapeRenderer;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;

public abstract class Light {
    private RGBA ambient = RGBA$.MODULE$.apply(Predef$.MODULE$.float2Float(1.0f), Predef$.MODULE$.float2Float(1.0f), Predef$.MODULE$.float2Float(1.0f), Predef$.MODULE$.float2Float(1.0f));
    private RGBA diffuse = RGBA$.MODULE$.apply(Predef$.MODULE$.float2Float(1.0f), Predef$.MODULE$.float2Float(1.0f), Predef$.MODULE$.float2Float(1.0f), Predef$.MODULE$.float2Float(1.0f));
    private RGBA specular = RGBA$.MODULE$.apply(Predef$.MODULE$.float2Float(1.0f), Predef$.MODULE$.float2Float(1.0f), Predef$.MODULE$.float2Float(1.0f), Predef$.MODULE$.float2Float(1.0f));
    private int glLightNumber = -1;
    private Option<GL2> glInstance = None$.MODULE$;
    private boolean _isOn = true;

    public RGBA ambient() {
        return this.ambient;
    }

    public void ambient_$eq(RGBA x$1) {
        this.ambient = x$1;
    }

    public RGBA diffuse() {
        return this.diffuse;
    }

    public void diffuse_$eq(RGBA x$1) {
        this.diffuse = x$1;
    }

    public RGBA specular() {
        return this.specular;
    }

    public void specular_$eq(RGBA x$1) {
        this.specular = x$1;
    }

    public int glLightNumber() {
        return this.glLightNumber;
    }

    public void glLightNumber_$eq(int x$1) {
        this.glLightNumber = x$1;
    }

    public Option<GL2> glInstance() {
        return this.glInstance;
    }

    public void glInstance_$eq(Option<GL2> x$1) {
        this.glInstance = x$1;
    }

    public GL2 getGL() {
        return (GL2)this.glInstance().getOrElse(Light::getGL$$anonfun$2);
    }

    public boolean isOn() {
        return this._isOn;
    }

    public void turnOn() {
        this.assertValidLightNumber();
        this._isOn = true;
        GL2 gl = this.getGL();
        gl.glLightfv(this.glLightNumber(), 4608, FloatBuffer.wrap(this.ambient().toFloat4Array()));
        gl.glLightfv(this.glLightNumber(), 4609, FloatBuffer.wrap(this.diffuse().toFloat4Array()));
        gl.glLightfv(this.glLightNumber(), 4610, FloatBuffer.wrap(this.specular().toFloat4Array()));
        gl.glEnable(this.glLightNumber());
    }

    public void turnOff() {
        this.assertValidLightNumber();
        this._isOn = false;
        this.getGL().glDisable(this.glLightNumber());
    }

    public void toggle() {
        if (this.isOn()) {
            this.turnOff();
            return;
        }
        this.turnOn();
    }

    public abstract void applyLight();

    public abstract void showLight(GLU var1, World3D var2, float var3, double var4, ShapeRenderer var6);

    public void renderPositionHintLines(Float x, Float y, Float z, Float minX, Float minY, Float minZ, Float maxX, Float maxY, Float maxZ) {
        GL2 gl = this.getGL();
        gl.glBegin(1);
        gl.glVertex3f(Predef$.MODULE$.Float2float(x), Predef$.MODULE$.Float2float(y), Predef$.MODULE$.Float2float(z));
        gl.glVertex3f(Predef$.MODULE$.Float2float(x), Predef$.MODULE$.Float2float(y), Predef$.MODULE$.Float2float(minZ));
        gl.glEnd();
        gl.glColor4fv(FloatBuffer.wrap(new float[]{0.3f, 0.3f, 0.3f, 1.0f}));
        gl.glBegin(1);
        if (Predef$.MODULE$.Float2float(x) <= Predef$.MODULE$.Float2float(maxX)) {
            gl.glVertex3f(Predef$.MODULE$.Float2float(minX), Predef$.MODULE$.Float2float(y), Predef$.MODULE$.Float2float(minZ));
            gl.glVertex3f(Predef$.MODULE$.Float2float(x), Predef$.MODULE$.Float2float(y), Predef$.MODULE$.Float2float(minZ));
        }
        if (Predef$.MODULE$.Float2float(x) >= Predef$.MODULE$.Float2float(minX)) {
            gl.glVertex3f(Predef$.MODULE$.Float2float(x), Predef$.MODULE$.Float2float(y), Predef$.MODULE$.Float2float(minZ));
            gl.glVertex3f(Predef$.MODULE$.Float2float(maxX), Predef$.MODULE$.Float2float(y), Predef$.MODULE$.Float2float(minZ));
        }
        if (Predef$.MODULE$.Float2float(y) <= Predef$.MODULE$.Float2float(maxY)) {
            gl.glVertex3f(Predef$.MODULE$.Float2float(x), Predef$.MODULE$.Float2float(minY), Predef$.MODULE$.Float2float(minZ));
            gl.glVertex3f(Predef$.MODULE$.Float2float(x), Predef$.MODULE$.Float2float(y), Predef$.MODULE$.Float2float(minZ));
        }
        if (Predef$.MODULE$.Float2float(y) >= Predef$.MODULE$.Float2float(minY)) {
            gl.glVertex3f(Predef$.MODULE$.Float2float(x), Predef$.MODULE$.Float2float(y), Predef$.MODULE$.Float2float(minZ));
            gl.glVertex3f(Predef$.MODULE$.Float2float(x), Predef$.MODULE$.Float2float(maxY), Predef$.MODULE$.Float2float(minZ));
        }
        if (Predef$.MODULE$.Float2float(x) < Predef$.MODULE$.Float2float(minX) || Predef$.MODULE$.Float2float(x) > Predef$.MODULE$.Float2float(maxX)) {
            if (Predef$.MODULE$.Float2float(y) <= Predef$.MODULE$.Float2float(maxY)) {
                gl.glVertex3f(Predef$.MODULE$.Float2float(x), Predef$.MODULE$.Float2float(minY), Predef$.MODULE$.Float2float(minZ));
                gl.glVertex3f(Predef$.MODULE$.Float2float(x) < Predef$.MODULE$.Float2float(minX) ? Predef$.MODULE$.Float2float(minX) : Predef$.MODULE$.Float2float(maxX), Predef$.MODULE$.Float2float(minY), Predef$.MODULE$.Float2float(minZ));
            }
            if (Predef$.MODULE$.Float2float(y) >= Predef$.MODULE$.Float2float(minY)) {
                gl.glVertex3f(Predef$.MODULE$.Float2float(x), Predef$.MODULE$.Float2float(maxY), Predef$.MODULE$.Float2float(minZ));
                gl.glVertex3f(Predef$.MODULE$.Float2float(x) < Predef$.MODULE$.Float2float(minX) ? Predef$.MODULE$.Float2float(minX) : Predef$.MODULE$.Float2float(maxX), Predef$.MODULE$.Float2float(maxY), Predef$.MODULE$.Float2float(minZ));
            }
        }
        if (Predef$.MODULE$.Float2float(y) < Predef$.MODULE$.Float2float(minY) || Predef$.MODULE$.Float2float(y) > Predef$.MODULE$.Float2float(maxY)) {
            if (Predef$.MODULE$.Float2float(x) <= Predef$.MODULE$.Float2float(maxX)) {
                gl.glVertex3f(Predef$.MODULE$.Float2float(minX), Predef$.MODULE$.Float2float(y), Predef$.MODULE$.Float2float(minZ));
                gl.glVertex3f(Predef$.MODULE$.Float2float(minX), Predef$.MODULE$.Float2float(y) < Predef$.MODULE$.Float2float(minY) ? Predef$.MODULE$.Float2float(minY) : Predef$.MODULE$.Float2float(maxY), Predef$.MODULE$.Float2float(minZ));
            }
            if (Predef$.MODULE$.Float2float(x) >= Predef$.MODULE$.Float2float(minX)) {
                gl.glVertex3f(Predef$.MODULE$.Float2float(maxX), Predef$.MODULE$.Float2float(y), Predef$.MODULE$.Float2float(minZ));
                gl.glVertex3f(Predef$.MODULE$.Float2float(maxX), Predef$.MODULE$.Float2float(y) < Predef$.MODULE$.Float2float(minY) ? Predef$.MODULE$.Float2float(minY) : Predef$.MODULE$.Float2float(maxY), Predef$.MODULE$.Float2float(minZ));
            }
        }
        gl.glEnd();
    }

    public void render3DArrow(GLU glu, double xdir, double ydir, double zdir) {
        GL2 gl = this.getGL();
        double RADDEG = 57.29578;
        double azimuth = package$.MODULE$.atan2(ydir, xdir) * RADDEG;
        double elevation = package$.MODULE$.acos(zdir) * RADDEG;
        gl.glDisable(2884);
        gl.glPushMatrix();
        gl.glRotated(azimuth, 0.0, 0.0, 1.0);
        gl.glRotated(elevation, 0.0, 1.0, 0.0);
        glu.gluCylinder(glu.gluNewQuadric(), 0.1, 0.1, 1.0, 12, 12);
        gl.glTranslated(0.0, 0.0, 1.0);
        glu.gluCylinder(glu.gluNewQuadric(), 0.3, 0.0, 0.5, 12, 12);
        gl.glPopMatrix();
        gl.glEnable(2884);
    }

    public void assertValidLightNumber() {
        if (this.glLightNumber() < 16384 && this.glLightNumber() > 16391) {
            Scala3RunTime$ scala3RunTime$ = Scala3RunTime$.MODULE$;
            throw scala.sys.package$.MODULE$.error("Invalid OpenGL light number: " + this.glLightNumber() + ". Light number needs to be between " + 16384 + " and " + 16391 + ". Use LightManager.addLight() and LightManager.removeLight() to add or remove lights.");
        }
    }

    public String getLabel() {
        return "GL_LIGHT" + LightManager$.MODULE$.lightNumbers().indexOf((Object)BoxesRunTime.boxToInteger((int)this.glLightNumber())) + " (" + this.typeLabel() + ")" + (this.isOn() ? "" : " [off]");
    }

    public abstract String typeLabel();

    private static final GL2 getGL$$anonfun$2() {
        throw scala.sys.package$.MODULE$.error("Handle to OpenGL interface must be set before attempting to use the light. Use LightManager.addLight() and LightManager.removeLight() to add or remove lights, and be sure LightManager.init() was called.");
    }
}

