/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import java.io.Serializable;
import java.nio.FloatBuffer;
import org.nlogo.gl.render.LinkLine$;
import scala.Float$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class LinkLine {
    private final double xcor;
    private final short lineStipple;

    public static short[] dashChoices() {
        return LinkLine$.MODULE$.dashChoices();
    }

    public LinkLine(double xcor, int dashIndex) {
        this.xcor = xcor;
        if (dashIndex < 0) {
            throw new Exception("Invalid link line! " + dashIndex);
        }
        this.lineStipple = LinkLine$.MODULE$.dashChoices()[dashIndex];
    }

    public void render(GL2 gl, float x1, float y1, float z1, float x2, float y2, float z2, double curviness, float stroke, int distance) {
        gl.glLineStipple(distance, this.lineStipple);
        if (curviness == 0.0) {
            this.renderLine(gl, x1, y1, z1, x2, y2, z2, stroke);
            return;
        }
        this.renderCurve(gl, x1, y1, z1, x2, y2, z2, curviness, stroke);
    }

    private void renderCurve(GL2 gl, float _x1, float _y1, float _z1, float _x2, float _y2, float _z2, double curviness, float stroke) {
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)_x1), (Object)BoxesRunTime.boxToFloat((float)_y1), (Object)BoxesRunTime.boxToFloat((float)_z1));
        float x1 = BoxesRunTime.unboxToFloat((Object)tuple3._1());
        float y1 = BoxesRunTime.unboxToFloat((Object)tuple3._2());
        float z1 = BoxesRunTime.unboxToFloat((Object)tuple3._3());
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)_x2), (Object)BoxesRunTime.boxToFloat((float)_y2), (Object)BoxesRunTime.boxToFloat((float)_z2));
        float x2 = BoxesRunTime.unboxToFloat((Object)tuple32._1());
        float y2 = BoxesRunTime.unboxToFloat((Object)tuple32._2());
        float z2 = BoxesRunTime.unboxToFloat((Object)tuple32._3());
        float xd = x1 - x2;
        float yd = y2 - y1;
        float zd = z1 - z2;
        double size = package$.MODULE$.sqrt(Float$.MODULE$.float2double(xd * xd + yd * yd + zd * zd));
        double ycomp = (double)xd / size;
        double xcomp = (double)yd / size;
        double zcomp = (double)zd / size;
        if (this.xcor != 0.0) {
            x1 += (float)(xcomp * this.xcor * (double)stroke * (double)0.3f);
            x2 += (float)(xcomp * this.xcor * (double)stroke * (double)0.3f);
            y1 += (float)(ycomp * this.xcor * (double)stroke * (double)0.3f);
            y2 += (float)(ycomp * this.xcor * (double)stroke * (double)0.3f);
            z1 += (float)(zcomp * this.xcor * (double)stroke * (double)0.3f);
            z2 += (float)(zcomp * this.xcor * (double)stroke * (double)0.3f);
        }
        float midX = (x1 + x2) / (float)2 + (float)(-curviness * xcomp / (double)2);
        float midY = (y1 + y2) / (float)2 + (float)(-curviness * ycomp / (double)2);
        float midZ = (z1 + z2) / (float)2 + (float)(-curviness * zcomp / (double)2);
        FloatBuffer controlPoints = FloatBuffer.wrap(new float[]{x1, y1, z1, midX, midY, midZ, x2, y2, z2});
        gl.glMap1f(3479, 0.0f, 1.0f, 3, 3, controlPoints);
        gl.glEnable(3479);
        gl.glBegin(3);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 30).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> gl.glEvalCoord1f((float)i / 30.0f));
        gl.glEnd();
    }

    private void renderLine(GL2 gl, float _x1, float _y1, float _z1, float _x2, float _y2, float _z2, float stroke) {
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)_x1), (Object)BoxesRunTime.boxToFloat((float)_y1), (Object)BoxesRunTime.boxToFloat((float)_z1));
        float x1 = BoxesRunTime.unboxToFloat((Object)tuple3._1());
        float y1 = BoxesRunTime.unboxToFloat((Object)tuple3._2());
        float z1 = BoxesRunTime.unboxToFloat((Object)tuple3._3());
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)_x2), (Object)BoxesRunTime.boxToFloat((float)_y2), (Object)BoxesRunTime.boxToFloat((float)_z2));
        float x2 = BoxesRunTime.unboxToFloat((Object)tuple32._1());
        float y2 = BoxesRunTime.unboxToFloat((Object)tuple32._2());
        float z2 = BoxesRunTime.unboxToFloat((Object)tuple32._3());
        if (this.xcor != 0.0) {
            float xd = x1 - x2;
            float yd = y2 - y1;
            float zd = z1 - z2;
            double size = package$.MODULE$.sqrt(Float$.MODULE$.float2double(xd * xd + yd * yd + zd * zd));
            double ycomp = (double)xd / size * this.xcor * (double)stroke * (double)0.3f;
            double xcomp = (double)yd / size * this.xcor * (double)stroke * (double)0.3f;
            double zcomp = (double)zd / size * this.xcor * (double)stroke * (double)0.3f;
            x1 += (float)xcomp;
            x2 += (float)xcomp;
            y1 += (float)ycomp;
            y2 += (float)ycomp;
            z1 += (float)zcomp;
            z2 += (float)zcomp;
        }
        gl.glBegin(1);
        gl.glNormal3f(0.0f, 0.0f, -1.0f);
        gl.glVertex3f(x1, y1, z1);
        gl.glVertex3f(x2, y2, z2);
        gl.glEnd();
    }
}

