/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import java.awt.Color;
import java.io.Serializable;
import java.nio.FloatBuffer;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentFollowingPerspective;
import org.nlogo.api.Color$;
import org.nlogo.api.Link;
import org.nlogo.api.ObserverOrientation;
import org.nlogo.api.Perspective;
import org.nlogo.api.World;
import org.nlogo.gl.render.AgentRenderer;
import org.nlogo.gl.render.GLLinkShape;
import org.nlogo.gl.render.ShapeRenderer;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.jdk.CollectionConverters$;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;

public class LinkRenderer
extends AgentRenderer {
    public LinkRenderer(World world, ShapeRenderer shapeRenderer) {
        super(world, shapeRenderer);
    }

    private World world$accessor() {
        return super.world();
    }

    private ShapeRenderer shapeRenderer$accessor() {
        return super.shapeRenderer();
    }

    private double lineScale() {
        double distance;
        double d;
        Perspective perspective = this.world$accessor().observer().perspective();
        if (perspective instanceof AgentFollowingPerspective) {
            Perspective afp = (Perspective)((Object)((AgentFollowingPerspective)((Object)perspective)));
            d = ((AgentFollowingPerspective)((Object)afp)).followDistance();
        } else {
            d = distance = ((ObserverOrientation)this.world$accessor().observer().orientation().get()).dist();
        }
        if (distance == 0.0) {
            return 0.0;
        }
        return (double)RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.world$accessor().worldWidth()), this.world$accessor().worldHeight()) * 1.5 / distance;
    }

    public void renderLinks(GL2 gl, GLU glu, int fontSize, double patchSize, Agent outlineAgent) {
        if (this.world$accessor().links() == null) {
            return;
        }
        double scale = this.lineScale();
        ((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(this.world$accessor().links().agents()).asScala().map((Function1 & Serializable)_$1 -> (Link)_$1)).foreach(link -> {
            if (!link.hidden()) {
                Agent agent = outlineAgent;
                Link link2 = link;
                this.renderWrappedLink(gl, (Link)link, fontSize, patchSize, !(agent != null ? !agent.equals(link2) : link2 != null), scale);
                return;
            }
        });
    }

    public float[] getLinkCoords(Link link) {
        return new float[]{(float)link.x1(), (float)link.y1(), 0.0f, (float)link.x2(), (float)link.y2(), 0.0f};
    }

    public void renderWrappedLink(GL2 gl, Link link, int fontSize, double patchSize, boolean outline, double lineScale) {
        double maxx = (double)this.world$accessor().maxPxcor() + 0.5;
        double minx = (double)this.world$accessor().minPxcor() - 0.5;
        double maxy = (double)this.world$accessor().maxPycor() + 0.5;
        double miny = (double)this.world$accessor().minPycor() - 0.5;
        int worldWidth = this.world$accessor().worldWidth();
        int worldHeight = this.world$accessor().worldHeight();
        boolean wrapXRight = false;
        boolean wrapXLeft = false;
        float[] coords = this.getLinkCoords(link);
        double size = link.size();
        GLLinkShape shape = this.shapeRenderer$accessor().getLinkShape(link.shape());
        Color color = Color$.MODULE$.getColor(link.color());
        this.renderLink(gl, shape, color, size, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5], patchSize, link.lineThickness(), link.isDirectedLink(), link, outline);
        if (this.world$accessor().wrappingAllowedInX()) {
            if ((double)coords[3] + size / (double)2 > maxx) {
                this.renderLink(gl, shape, color, size, coords[0] - (float)worldWidth, coords[1], coords[2], coords[3] - (float)worldWidth, coords[4], coords[5], patchSize, link.lineThickness(), link.isDirectedLink(), link, outline);
                wrapXRight = true;
            }
            if ((double)coords[0] - size / (double)2 < minx) {
                this.renderLink(gl, shape, color, size, coords[0] + (float)worldWidth, coords[1], coords[2], coords[3] + (float)worldWidth, coords[4], coords[5], patchSize, link.lineThickness(), link.isDirectedLink(), link, outline);
                wrapXLeft = true;
            }
        }
        if (this.world$accessor().wrappingAllowedInY()) {
            if ((double)coords[4] + size / (double)2 > maxy) {
                this.renderLink(gl, shape, color, size, coords[0], coords[1] - (float)worldHeight, coords[2], coords[3], coords[4] - (float)worldHeight, coords[5], patchSize, link.lineThickness(), link.isDirectedLink(), link, outline);
                if (wrapXRight) {
                    this.renderLink(gl, shape, color, size, coords[0] - (float)worldWidth, coords[1] - (float)worldHeight, coords[2], coords[3] - (float)worldWidth, coords[4] - (float)worldHeight, coords[5], patchSize, link.lineThickness(), link.isDirectedLink(), link, outline);
                }
                if (wrapXLeft) {
                    this.renderLink(gl, shape, color, size, coords[0] + (float)worldWidth, coords[1] - (float)worldHeight, coords[2], coords[3] + (float)worldWidth, coords[4] - (float)worldHeight, coords[5], patchSize, link.lineThickness(), link.isDirectedLink(), link, outline);
                }
            }
            if ((double)coords[1] - size / (double)2 < miny) {
                this.renderLink(gl, shape, color, size, coords[0], coords[1] + (float)worldHeight, coords[2], coords[3], coords[4] + (float)worldHeight, coords[5], patchSize, link.lineThickness(), link.isDirectedLink(), link, outline);
                if (wrapXRight) {
                    this.renderLink(gl, shape, color, size, coords[0] - (float)worldWidth, coords[1] + (float)worldHeight, coords[2], coords[3] - (float)worldWidth, coords[4] + (float)worldHeight, coords[5], patchSize, link.lineThickness(), link.isDirectedLink(), link, outline);
                }
                if (wrapXLeft) {
                    this.renderLink(gl, shape, color, size, coords[0] + (float)worldWidth, coords[1] + (float)worldHeight, coords[2], coords[3] + (float)worldWidth, coords[4] + (float)worldHeight, coords[5], patchSize, link.lineThickness(), link.isDirectedLink(), link, outline);
                }
            }
        }
        if (link.hasLabel()) {
            double[] labelCoords = this.getAgentCoords(link, 1.0);
            this.shapeRenderer$accessor().renderLabel(gl, link.labelString(), link.labelColor(), (float)(labelCoords[0] * (double)0.3f), (float)(labelCoords[1] * (double)0.3f), (float)(labelCoords[2] * (double)0.3f), 1.0f, fontSize, patchSize);
            return;
        }
    }

    private void renderLink(GL2 gl, GLLinkShape shape, Color color, double size, float x1, float y1, float z1, float x2, float y2, float z2, double patchSize, double lineThickness, boolean isDirected, Link link, boolean outline) {
        gl.glPushMatrix();
        gl.glColor4fv(FloatBuffer.wrap(color.getRGBColorComponents(null)));
        gl.glEnable(2852);
        float stroke = (float)RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(1.0), patchSize * lineThickness);
        gl.glLineWidth(stroke);
        shape.render(gl, x1, y1, z1, x2, y2, z2, stroke, isDirected, link, this.shapeRenderer$accessor(), outline, color, this.world$accessor());
        gl.glLineWidth(1.0f);
        gl.glDisable(2852);
        gl.glPopMatrix();
    }

    public void renderIndividualLinks(GL2 gl, GLU glu, Link link, int fontSize, double patchSize, Agent outlineAgent) {
        if (this.world$accessor().links() == null) {
            return;
        }
        if (!link.hidden()) {
            Agent agent = outlineAgent;
            Link link2 = link;
            this.renderWrappedLink(gl, link, fontSize, patchSize, !(agent != null ? !agent.equals(link2) : link2 != null), this.lineScale());
            return;
        }
    }

    public double[] getOrientation(Agent agent) {
        return new double[]{((Link)agent).heading(), 0.0, 0.0};
    }

    private double[] getAgentCoords(Agent agent, double height) {
        Link link = (Link)agent;
        double[] coords = new double[]{this.world$accessor().wrappedObserverX(link.midpointX()), this.world$accessor().wrappedObserverY(link.midpointY()), (height - 1.0) / (double)2};
        String string = link.shape();
        String string2 = "default";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            coords[2] = coords[2] / (double)2;
        }
        return coords;
    }
}

