/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUtessellator;
import java.io.Serializable;
import java.nio.FloatBuffer;
import org.nlogo.gl.render.Tessellator;
import org.nlogo.shape.Polygon;
import scala.Float$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class Polygons$
implements Serializable {
    public static final Polygons$ MODULE$ = new Polygons$();

    private Polygons$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Polygons$.class);
    }

    public void renderPolygon(GL2 gl, GLU glu, Tessellator tessellator, GLUtessellator tess, int offset, Polygon poly, boolean rotatable, boolean is3D) {
        float zDepth = 0.01f + (float)offset * 1.0E-4f;
        if (!poly.marked()) {
            float[] rgb = poly.awtColor().getRGBColorComponents(null);
            gl.glPushAttrib(1);
            gl.glColor3fv(FloatBuffer.wrap(rgb));
        }
        if (!poly.filled()) {
            gl.glPolygonMode(1032, 6913);
        }
        gl.glDisable(2884);
        Tessellator.TessDataObject data = tessellator.createTessDataObject(gl);
        Seq xcoords = poly.xCoords();
        Seq ycoords = poly.yCoords();
        if (is3D) {
            this.renderPolygon3D(gl, glu, tess, data, (Seq<Object>)xcoords, (Seq<Object>)ycoords, zDepth, rotatable);
        } else {
            this.renderPolygon2D(gl, glu, tess, data, (Seq<Object>)xcoords, (Seq<Object>)ycoords, zDepth, rotatable);
        }
        if (!poly.filled()) {
            gl.glPolygonMode(1032, 6914);
        }
        if (rotatable) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), xcoords.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                float[] coords = new float[]{(float)BoxesRunTime.unboxToInt((Object)xcoords.apply(i)) * 0.001f - 0.15f, (float)(300 - BoxesRunTime.unboxToInt((Object)ycoords.apply(i))) * 0.001f - 0.15f, (float)BoxesRunTime.unboxToInt((Object)xcoords.apply((i + 1) % xcoords.size())) * 0.001f - 0.15f, (float)(300 - BoxesRunTime.unboxToInt((Object)ycoords.apply((i + 1) % xcoords.size()))) * 0.001f - 0.15f};
                gl.glBegin(7);
                Tuple3<Object, Object, Object> tuple3 = MODULE$.findNormal(coords[0], coords[1], -zDepth, coords[0], coords[1], zDepth, coords[2], coords[3], zDepth);
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                double normalX = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                double normalY = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                double normalZ = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)normalX), (Object)BoxesRunTime.boxToDouble((double)normalY), (Object)BoxesRunTime.boxToDouble((double)normalZ));
                double normalX2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
                double normalY2 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
                double normalZ2 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
                gl.glNormal3d(normalX2, normalY2, normalZ2);
                gl.glVertex3f(coords[0], coords[1], -zDepth);
                gl.glVertex3f(coords[0], coords[1], zDepth);
                gl.glVertex3f(coords[2], coords[3], zDepth);
                gl.glVertex3f(coords[2], coords[3], -zDepth);
                gl.glEnd();
            });
        }
        gl.glEnable(2884);
        if (!poly.marked()) {
            gl.glPopAttrib();
            return;
        }
    }

    private void renderPolygon2D(GL2 gl, GLU glu, GLUtessellator tess, Tessellator.TessDataObject data, Seq<Object> xcoords, Seq<Object> ycoords, float zDepth, boolean rotatable) {
        GLU.gluTessBeginPolygon((GLUtessellator)tess, (Object)data);
        GLU.gluTessBeginContour((GLUtessellator)tess);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), xcoords.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            double[] coords = new double[]{(double)BoxesRunTime.unboxToInt((Object)xcoords.apply(i)) * 0.001 - 0.15, (double)(300 - BoxesRunTime.unboxToInt((Object)ycoords.apply(i))) * 0.001 - 0.15, Float$.MODULE$.float2double(zDepth)};
            GLU.gluTessVertex((GLUtessellator)tess, (double[])coords, (int)0, (Object)coords);
        });
        GLU.gluTessEndContour((GLUtessellator)tess);
        GLU.gluTessEndPolygon((GLUtessellator)tess);
    }

    private void renderPolygon3D(GL2 gl, GLU glu, GLUtessellator tess, Tessellator.TessDataObject data, Seq<Object> xcoords, Seq<Object> ycoords, float zDepth, boolean rotatable) {
        GLU.gluTessBeginPolygon((GLUtessellator)tess, (Object)data);
        GLU.gluTessBeginContour((GLUtessellator)tess);
        ((IterableOnceOps)xcoords.zip(ycoords)).foreach(x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int x = tuple2._1$mcI$sp();
                int y = tuple2._2$mcI$sp();
                double[] coords = new double[]{(double)x * 0.001 - 0.15, (double)(300 - y) * 0.001 - 0.15, Float$.MODULE$.float2double(zDepth)};
                GLU.gluTessVertex((GLUtessellator)tess, (double[])coords, (int)0, (Object)coords);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        GLU.gluTessEndContour((GLUtessellator)tess);
        GLU.gluTessEndPolygon((GLUtessellator)tess);
        if (rotatable) {
            gl.glBegin(data.tpe());
            gl.glNormal3f(0.0f, 0.0f, -1.0f);
            CollectionConverters$.MODULE$.ListHasAsScala(data.shapeData()).asScala().foreach(element -> {
                Object object = element;
                if (object instanceof double[]) {
                    double[] coords = (double[])object;
                    data.gl().glVertex3d(coords[0], coords[1], Float$.MODULE$.float2double(-zDepth));
                    return;
                }
                if (object instanceof Boolean) {
                    Boolean b = (Boolean)object;
                    gl.glEdgeFlag(b.booleanValue());
                    return;
                }
                throw new IllegalStateException();
            });
            gl.glEnd();
            return;
        }
    }

    private Tuple3<Object, Object, Object> findNormal(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3) {
        float vectX1 = x1 - x2;
        float vectY1 = y1 - y2;
        float vectZ1 = z1 - z2;
        float vectX2 = x3 - x2;
        float vectY2 = y3 - y2;
        float vectZ2 = z3 - z2;
        float normX = vectY1 * vectZ2 - vectY2 * vectZ1;
        float normY = vectX2 * vectZ1 - vectX1 * vectZ2;
        float normZ = vectX1 * vectY2 - vectX2 * vectY1;
        double leng = package$.MODULE$.sqrt(Float$.MODULE$.float2double(normX * normX + normY * normY + normZ * normZ));
        return Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)((double)(-normX) / leng)), (Object)BoxesRunTime.boxToDouble((double)((double)(-normY) / leng)), (Object)BoxesRunTime.boxToDouble((double)((double)(-normZ) / leng)));
    }
}

