/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import java.nio.FloatBuffer;
import org.nlogo.api.World3D;
import org.nlogo.gl.render.Light;
import org.nlogo.gl.render.Position;
import org.nlogo.gl.render.ShapeRenderer;
import scala.Predef$;

public class PositionalLight
extends Light {
    private final Position position;

    public PositionalLight(Position position) {
        this.position = position;
    }

    public Position position() {
        return this.position;
    }

    @Override
    public String typeLabel() {
        return "Positional";
    }

    @Override
    public void applyLight() {
        GL2 gl = this.getGL();
        gl.glEnable(2896);
        if (this.isOn()) {
            gl.glEnable(this.glLightNumber());
            gl.glLightfv(this.glLightNumber(), 4611, FloatBuffer.wrap(this.position().toFloat4Array()));
            return;
        }
        gl.glDisable(this.glLightNumber());
    }

    @Override
    public final void showLight(GLU glu, World3D world, float worldScale, double observerDistance, ShapeRenderer shapeRenderer) {
        GL2 gl = this.getGL();
        gl.glDisable(2896);
        gl.glPushMatrix();
        gl.glTranslatef(Predef$.MODULE$.Float2float(this.position().x()), Predef$.MODULE$.Float2float(this.position().y()), Predef$.MODULE$.Float2float(this.position().z()));
        gl.glColor4fv(FloatBuffer.wrap(new float[]{0.98f, 0.98f, 0.82f, 1.0f}));
        glu.gluSphere(glu.gluNewQuadric(), 0.002 * observerDistance, 16, 16);
        gl.glPopMatrix();
        this.renderPositionHintLines(this.position().x(), this.position().y(), this.position().z(), Predef$.MODULE$.float2Float(worldScale * (float)world.minPxcor()), Predef$.MODULE$.float2Float(worldScale * (float)world.minPycor()), Predef$.MODULE$.float2Float(worldScale * (float)world.minPzcor()), Predef$.MODULE$.float2Float(worldScale * (float)world.maxPxcor()), Predef$.MODULE$.float2Float(worldScale * (float)world.maxPycor()), Predef$.MODULE$.float2Float(worldScale * (float)world.maxPzcor()));
        shapeRenderer.renderLabel(this.getGL(), this.getLabel(), Predef$.MODULE$.double2Double(47.0), Predef$.MODULE$.Float2float(this.position().x()), Predef$.MODULE$.Float2float(this.position().y()), Predef$.MODULE$.Float2float(this.position().z()), 1.0f, 12, world.patchSize());
        gl.glEnable(2896);
    }
}

