/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import scala.Array$;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction1;

public final class TextureUtils$
implements Serializable {
    public static final TextureUtils$ MODULE$ = new TextureUtils$();

    private TextureUtils$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TextureUtils$.class);
    }

    public void makeTexture(GL2 gl, int size) {
        gl.glTexImage2D(3553, 0, 6408, size, size, 0, 6408, 5121, null);
    }

    public int genTexture(GL2 gl) {
        int[] tmp = new int[]{0};
        gl.glGenTextures(1, IntBuffer.wrap(tmp));
        return tmp[0];
    }

    public int calculateTextureSize(GL2 gl, int width, int height) {
        String glRendererName = gl.glGetString(7937).toUpperCase();
        int maxTextureSize = glRendererName.startsWith("ATI RAGE") ? 256 : (glRendererName.startsWith("ATI RADEON 7500") ? 512 : (glRendererName.startsWith("ATI RADEON 9200") ? 512 : 3379));
        return BoxesRunTime.unboxToInt((Object)scala.package$.MODULE$.Iterator().iterate((Object)BoxesRunTime.boxToInteger((int)64), (Function1)(JFunction1.mcII.sp & Serializable)_$1 -> _$1 * 2).dropWhile((Function1)(JFunction1.mcZI.sp & Serializable)size -> (width > size || height > size) && size < (2 + maxTextureSize) / 2).next());
    }

    public byte[][] createTileArray(int width, int height, int textureSize) {
        int numTiles = (int)package$.MODULE$.ceil((double)width / (double)textureSize) * (int)package$.MODULE$.ceil((double)height / (double)textureSize);
        return (byte[][])Array$.MODULE$.fill(numTiles, TextureUtils$::createTileArray$$anonfun$1, ClassTag$.MODULE$.apply(Byte.TYPE).wrap());
    }

    public void setParameters(GL2 gl) {
        gl.glTexParameteri(3553, 10241, 9728);
        gl.glTexParameteri(3553, 10240, 9728);
        gl.glTexParameteri(3553, 10242, 10496);
        gl.glTexParameteri(3553, 10243, 10496);
    }

    public byte[] reuseTexture(GL2 gl, int tileWidth, int tileHeight, int xOffset, int yOffset, int width, int[] colors, byte[] _bytes) {
        int i = 0;
        int size = tileHeight * tileWidth * 4;
        byte[] bytes = (byte[])Option$.MODULE$.apply((Object)_bytes).filter((Function1 & Serializable)_$2 -> {
            Object object = Predef$.MODULE$.byteArrayOps(_$2);
            return ArrayOps$.MODULE$.size$extension(object) == size;
        }).getOrElse(() -> TextureUtils$.$anonfun$2(size));
        for (int x = xOffset; x < tileWidth + xOffset; ++x) {
            for (int y = yOffset; y < tileHeight + yOffset; ++y) {
                int rgb = colors[x + y * width];
                bytes[i] = (byte)(rgb >> 16);
                bytes[++i] = (byte)(rgb >> 8);
                bytes[++i] = (byte)rgb;
                bytes[++i] = (byte)(rgb >> 24);
                ++i;
            }
        }
        gl.glTexSubImage2D(3553, 0, 0, 0, tileHeight, tileWidth, 6408, 5121, (Buffer)ByteBuffer.wrap(bytes));
        return bytes;
    }

    public void renderEmptyPlane(GL2 gl, float _sideX, float _sideY, float _sideZ) {
        float sideX = _sideX * 0.15f;
        float sideY = _sideY * 0.15f;
        float sideZ = _sideZ * 0.15f;
        gl.glColor4f(0.0f, 0.0f, 0.0f, 0.5f);
        gl.glBegin(7);
        gl.glNormal3f(0.0f, 0.0f, -1.0f);
        gl.glVertex3f(-sideX, sideY, -sideZ);
        gl.glVertex3f(-sideX, -sideY, -sideZ);
        gl.glVertex3f(sideX, -sideY, -sideZ);
        gl.glVertex3f(sideX, sideY, -sideZ);
        gl.glEnd();
        gl.glColor4f(0.0f, 0.0f, 0.0f, 0.5f);
        gl.glBegin(7);
        gl.glNormal3f(0.0f, 0.0f, -1.0f);
        gl.glVertex3f(sideX, sideY, -sideZ);
        gl.glVertex3f(sideX, -sideY, -sideZ);
        gl.glVertex3f(-sideX, -sideY, -sideZ);
        gl.glVertex3f(-sideX, sideY, -sideZ);
        gl.glEnd();
    }

    public void renderInPlane(GL2 gl, float _sideX, float _sideY, float _sideZ, float width, float height, float size, float offsetX, float offsetY) {
        float sideX = _sideX * 0.15f;
        float sideY = _sideY * 0.15f;
        float sideZ = _sideZ * 0.15f;
        gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        float offsetStretchX = offsetX / size;
        float offsetStretchY = offsetY / size;
        float textureStretchX = width / size + offsetStretchX;
        float textureStretchY = height / size + offsetStretchY;
        gl.glBegin(7);
        gl.glNormal3f(0.0f, 0.0f, -1.0f);
        gl.glTexCoord2f(offsetStretchY, offsetStretchX);
        gl.glVertex3f(-sideX, sideY, -sideZ);
        gl.glTexCoord2f(textureStretchY, offsetStretchX);
        gl.glVertex3f(-sideX, -sideY, -sideZ);
        gl.glTexCoord2f(textureStretchY, textureStretchX);
        gl.glVertex3f(sideX, -sideY, -sideZ);
        gl.glTexCoord2f(offsetStretchY, textureStretchX);
        gl.glVertex3f(sideX, sideY, -sideZ);
        gl.glEnd();
    }

    private static final byte[] createTileArray$$anonfun$1() {
        return new byte[0];
    }

    private static final byte[] $anonfun$2(int size$2) {
        return new byte[size$2];
    }
}

