/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.mirroring;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import org.nlogo.api.AgentSet;
import org.nlogo.api.Color;
import org.nlogo.api.Dump;
import org.nlogo.api.Link;
import org.nlogo.api.Turtle;
import org.nlogo.api.World;
import org.nlogo.core.AgentKind;
import org.nlogo.core.AgentKindJ;
import org.nlogo.core.LogoList;
import org.nlogo.hubnet.mirroring.AgentData;
import org.nlogo.hubnet.mirroring.ClientWorld;
import org.nlogo.hubnet.mirroring.HubNetLinkStamp;

public class LinkData
extends AgentData
implements Link {
    public static final short DEAD = 0;
    public static final short ENDS = 1;
    public static final short X1 = 2;
    public static final short Y1 = 4;
    public static final short X2 = 8;
    public static final short Y2 = 16;
    public static final short SHAPE = 32;
    public static final short COLOR = 64;
    public static final short HIDDEN = 128;
    public static final short LABEL = 256;
    public static final short LABEL_COLOR = 512;
    public static final short LINE_THICKNESS = 1024;
    public static final short DESTINATION_SIZE = 2048;
    public static final short HEADING = 4096;
    public static final short SIZE = 8192;
    public static final short BREED = 16384;
    public static final short COMPLETE = Short.MAX_VALUE;
    long id;
    long end1;
    long end2;
    private short mask;
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private String shape = "";
    private LogoList color;
    private boolean hidden;
    private String label = "";
    private LogoList labelColor;
    private double lineThickness;
    private boolean directedLink;
    private double destSize;
    private double heading;
    private double size;
    private int breedIndex;
    private static final String[] OVERRIDE_VARIABLES = new String[]{"COLOR", "LABEL", "LABEL-COLOR", "LINE-THICKNESS", "HIDDEN?", "SHAPE"};
    private static final String[] OVERRIDE_METHODS = new String[]{"color", "label", "labelColor", "lineThickness", "hidden", "shape"};

    @Override
    public AgentKind kind() {
        return AgentKindJ.Link();
    }

    @Override
    public long id() {
        return this.id;
    }

    public ClientWorld.LinkKey getKey() {
        return new ClientWorld.LinkKey(this.id, this.end1, this.end2, this.breedIndex);
    }

    public String toString() {
        return "link " + this.id + " " + this.breedIndex;
    }

    public LinkData(HubNetLinkStamp link) {
        this.mask = Short.MAX_VALUE;
        this.x1 = link.x1;
        this.y1 = link.y1;
        this.x2 = link.x2;
        this.y2 = link.y2;
        this.shape = link.shape;
        this.color(link.color);
        this.hidden = link.hidden;
        this.lineThickness = link.lineThickness;
        this.directedLink = link.directedLink;
        this.destSize = link.destSize;
        this.heading = link.heading;
        this.size = link.size;
    }

    LinkData(long id) {
        this.id = id;
        this.mask = 0;
        this.color = LogoList.Empty();
        this.labelColor = LogoList.Empty();
    }

    LinkData(long id, long end1, long end2, short mask, double x1, double y1, double x2, double y2, String shape, Object color, boolean hidden, String label, Object labelColor, double lineThickness, boolean directedLink, double destSize, double heading, double size, int breedIndex) {
        this.id = id;
        this.end1 = end1;
        this.end2 = end2;
        this.mask = mask;
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.shape = shape;
        this.color(color);
        this.hidden = hidden;
        this.label = label;
        this.labelColor(labelColor);
        this.lineThickness = lineThickness;
        this.directedLink = directedLink;
        this.destSize = destSize;
        this.heading = heading;
        this.size = size;
        this.breedIndex = breedIndex;
    }

    LinkData(DataInputStream is) throws IOException {
        this.id = is.readLong();
        this.mask = is.readShort();
        if ((this.mask & 1) == 1) {
            this.end1 = is.readLong();
            this.end2 = is.readLong();
        }
        if ((this.mask & 2) == 2) {
            this.x1 = is.readDouble();
        }
        if ((this.mask & 4) == 4) {
            this.y1 = is.readDouble();
        }
        if ((this.mask & 8) == 8) {
            this.x2 = is.readDouble();
        }
        if ((this.mask & 0x10) == 16) {
            this.y2 = is.readDouble();
        }
        if ((this.mask & 0x20) == 32) {
            this.shape = is.readUTF();
        }
        if ((this.mask & 0x40) == 64) {
            this.color(is.readInt());
        }
        if ((this.mask & 0x80) == 128) {
            this.hidden = is.readBoolean();
        }
        if ((this.mask & 0x100) == 256) {
            this.label = is.readUTF();
        }
        if ((this.mask & 0x200) == 512) {
            this.labelColor(is.readInt());
        }
        if ((this.mask & 0x400) == 1024) {
            this.lineThickness = is.readDouble();
        }
        if ((this.mask & 0x800) == 2048) {
            this.destSize = is.readDouble();
        }
        if ((this.mask & 0x1000) == 4096) {
            this.heading = is.readDouble();
        }
        if ((this.mask & 0x2000) == 8192) {
            this.size = is.readDouble();
        }
        if ((this.mask & 0x4000) == 16384) {
            this.breedIndex = is.readInt();
            this.directedLink = is.readBoolean();
        }
    }

    @Override
    public int getBreedIndex() {
        return this.breedIndex;
    }

    @Override
    public double x1() {
        return this.x1;
    }

    @Override
    public double y1() {
        return this.y1;
    }

    @Override
    public double x2() {
        return this.x2;
    }

    @Override
    public double y2() {
        return this.y2;
    }

    @Override
    public Object color() {
        return this.color;
    }

    public void color(Object color) {
        if (color instanceof Double) {
            this.color((Double)color);
        } else {
            this.color((LogoList)color);
        }
    }

    public void color(Double color) {
        this.color(Color.getARGBbyPremodulatedColorNumber(color));
    }

    public void color(LogoList color) {
        this.color = color;
    }

    public void color(int argb) {
        this.color = Color.getRGBAListByARGB(argb);
    }

    @Override
    public String shape() {
        return this.shape;
    }

    public void shape(String shape) {
        this.shape = shape;
    }

    @Override
    public boolean hidden() {
        return this.hidden;
    }

    public void hidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public String label() {
        return this.label;
    }

    public void label(Object label) {
        this.label = Dump.logoObject(label);
    }

    @Override
    public String labelString() {
        return this.label;
    }

    @Override
    public Object labelColor() {
        return this.labelColor;
    }

    public void labelColor(Object labelColor) {
        if (labelColor instanceof Double) {
            this.labelColor((Double)labelColor);
        } else {
            this.labelColor((LogoList)labelColor);
        }
    }

    public void labelColor(Double labelColor) {
        this.labelColor(Color.getARGBbyPremodulatedColorNumber(labelColor));
    }

    public void labelColor(LogoList labelColor) {
        this.labelColor = labelColor;
    }

    public void labelColor(int argb) {
        this.labelColor = Color.getRGBAListByARGB(argb);
    }

    @Override
    public boolean hasLabel() {
        return this.label != null && this.label.length() > 0;
    }

    @Override
    public double lineThickness() {
        return this.lineThickness;
    }

    public void lineThickness(Double lineThickness) {
        this.lineThickness = lineThickness;
    }

    @Override
    public double heading() {
        return this.heading;
    }

    @Override
    public double xcor() {
        return this.midpointX();
    }

    @Override
    public double ycor() {
        return this.midpointY();
    }

    @Override
    public double spotlightSize() {
        return 1.0;
    }

    @Override
    public boolean wrapSpotlight() {
        return false;
    }

    @Override
    public String getMethodName(int index) {
        return OVERRIDE_METHODS[index];
    }

    public static int getOverrideIndex(String varName) {
        return LinkData.getOverrideIndex(OVERRIDE_VARIABLES, varName);
    }

    @Override
    public double midpointX() {
        return (this.x1 + this.x2) / 2.0;
    }

    @Override
    public double midpointY() {
        return (this.y1 + this.y2) / 2.0;
    }

    @Override
    public Turtle end2() {
        return null;
    }

    @Override
    public Turtle end1() {
        return null;
    }

    @Override
    public boolean isDirectedLink() {
        return this.directedLink;
    }

    @Override
    public double linkDestinationSize() {
        return this.destSize;
    }

    @Override
    public double size() {
        return this.size;
    }

    @Override
    public AgentSet getBreed() {
        throw new UnsupportedOperationException();
    }

    @Override
    public World world() {
        throw new UnsupportedOperationException();
    }

    public String stringRep() {
        if (this.mask == Short.MAX_VALUE) {
            return "Link " + this.id + " (" + this.x1 + ", " + this.y1 + ", " + this.x2 + ", " + this.y2 + ", " + this.shape + ", " + Color.getARGBIntByRGBAList(this.color) + ", , " + this.hidden + ", " + this.label + ", " + Color.getARGBIntByRGBAList(this.labelColor) + ", " + this.lineThickness + ")";
        }
        if (this.mask == 0) {
            return "Link " + this.id + " (dead)";
        }
        return "Link " + this.id + " update (mask " + Integer.toBinaryString(this.mask) + ")";
    }

    boolean isComplete() {
        return (this.mask & Short.MAX_VALUE) == Short.MAX_VALUE;
    }

    boolean isDead() {
        return this.mask == 0;
    }

    LinkData updateFrom(LinkData other) {
        if (other.isDead()) {
            System.err.println("@ " + new Date() + " : ");
            System.err.println("ERROR: attempting incremental update of a dead link (" + this.stringRep() + ").");
            return null;
        }
        LinkData diffs = new LinkData(this.id);
        if ((other.mask & 1) == 1 && this.end1 != other.end1) {
            this.end1 = other.end1;
            this.end2 = other.end2;
            diffs.mask = (short)(diffs.mask | 1);
            diffs.end1 = this.end1;
            diffs.end2 = this.end2;
        }
        if ((other.mask & 2) == 2 && this.x1 != other.x1) {
            this.x1 = other.x1;
            diffs.mask = (short)(diffs.mask | 2);
            diffs.x1 = this.x1;
        }
        if ((other.mask & 4) == 4 && this.y1 != other.y1) {
            this.y1 = other.y1;
            diffs.mask = (short)(diffs.mask | 4);
            diffs.y1 = this.y1;
        }
        if ((other.mask & 8) == 8 && this.x2 != other.x2) {
            this.x2 = other.x2;
            diffs.mask = (short)(diffs.mask | 8);
            diffs.x2 = this.x2;
        }
        if ((other.mask & 0x10) == 16 && this.y2 != other.y2) {
            this.y2 = other.y2;
            diffs.mask = (short)(diffs.mask | 0x10);
            diffs.y2 = this.y2;
        }
        if ((other.mask & 0x20) == 32 && !this.shape.equals(other.shape)) {
            this.shape = other.shape;
            diffs.mask = (short)(diffs.mask | 0x20);
            diffs.shape = this.shape;
        }
        if ((other.mask & 0x40) == 64 && !((Object)this.color).equals(other.color)) {
            this.color = other.color;
            diffs.mask = (short)(diffs.mask | 0x40);
            diffs.color = this.color;
        }
        if ((other.mask & 0x80) == 128 && this.hidden != other.hidden) {
            this.hidden = other.hidden;
            diffs.mask = (short)(diffs.mask | 0x80);
            diffs.hidden = this.hidden;
        }
        if ((other.mask & 0x100) == 256 && !this.label.equals(other.label)) {
            this.label = other.label;
            diffs.mask = (short)(diffs.mask | 0x100);
            diffs.label = this.label;
        }
        if ((other.mask & 0x200) == 512 && !((Object)this.labelColor).equals(other.labelColor)) {
            this.labelColor = other.labelColor;
            diffs.mask = (short)(diffs.mask | 0x200);
            diffs.labelColor = this.labelColor;
        }
        if ((other.mask & 0x400) == 1024 && this.lineThickness != other.lineThickness) {
            this.lineThickness = other.lineThickness;
            diffs.mask = (short)(diffs.mask | 0x400);
            diffs.lineThickness = this.lineThickness;
        }
        if ((other.mask & 0x800) == 2048 && this.destSize != other.destSize) {
            this.destSize = other.destSize;
            diffs.mask = (short)(diffs.mask | 0x800);
            diffs.destSize = this.destSize;
        }
        if ((other.mask & 0x1000) == 4096 && this.heading != other.heading) {
            this.heading = other.heading;
            diffs.mask = (short)(diffs.mask | 0x1000);
            diffs.heading = this.heading;
        }
        if ((other.mask & 0x2000) == 8192 && this.size != other.size) {
            this.size = other.size;
            diffs.mask = (short)(diffs.mask | 0x2000);
            diffs.size = this.size;
        }
        if ((other.mask & 0x4000) == 16384 && this.breedIndex != other.breedIndex) {
            this.breedIndex = other.breedIndex;
            this.directedLink = other.directedLink;
            diffs.mask = (short)(diffs.mask | 0x4000);
            diffs.breedIndex = this.breedIndex;
            diffs.directedLink = this.directedLink;
        }
        if (diffs.mask != 0) {
            return diffs;
        }
        return null;
    }

    void serialize(DataOutputStream os) throws IOException {
        os.writeLong(this.id);
        os.writeShort(this.mask);
        if ((this.mask & 1) == 1) {
            os.writeLong(this.end1);
            os.writeLong(this.end2);
        }
        if ((this.mask & 2) == 2) {
            os.writeDouble(this.x1);
        }
        if ((this.mask & 4) == 4) {
            os.writeDouble(this.y1);
        }
        if ((this.mask & 8) == 8) {
            os.writeDouble(this.x2);
        }
        if ((this.mask & 0x10) == 16) {
            os.writeDouble(this.y2);
        }
        if ((this.mask & 0x20) == 32) {
            os.writeUTF(this.shape);
        }
        if ((this.mask & 0x40) == 64) {
            os.writeInt(Color.getARGBIntByRGBAList(this.color));
        }
        if ((this.mask & 0x80) == 128) {
            os.writeBoolean(this.hidden);
        }
        if ((this.mask & 0x100) == 256) {
            os.writeUTF(this.label);
        }
        if ((this.mask & 0x200) == 512) {
            os.writeInt(Color.getARGBIntByRGBAList(this.labelColor));
        }
        if ((this.mask & 0x400) == 1024) {
            os.writeDouble(this.lineThickness);
        }
        if ((this.mask & 0x800) == 2048) {
            os.writeDouble(this.destSize);
        }
        if ((this.mask & 0x1000) == 4096) {
            os.writeDouble(this.heading);
        }
        if ((this.mask & 0x2000) == 8192) {
            os.writeDouble(this.size);
        }
        if ((this.mask & 0x4000) == 16384) {
            os.writeInt(this.breedIndex);
            os.writeBoolean(this.directedLink);
        }
    }

    @Override
    public String classDisplayName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setVariable(int vn, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getVariable(int vn) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] variables() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int alpha() {
        throw new UnsupportedOperationException();
    }

    public boolean isPartiallyTransparent() {
        throw new UnsupportedOperationException();
    }
}

