/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.protocol;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.nlogo.api.HubNetInterface;
import org.nlogo.api.Version$;
import org.nlogo.hubnet.protocol.ActivityCommand;
import org.nlogo.hubnet.protocol.EnterMessage$;
import org.nlogo.hubnet.protocol.ExitMessage$;
import org.nlogo.hubnet.protocol.HandshakeFromClient;
import org.nlogo.hubnet.protocol.HandshakeFromServer;
import org.nlogo.hubnet.protocol.Message;
import org.nlogo.hubnet.protocol.TestClient$;
import org.nlogo.hubnet.protocol.ViewUpdate;
import org.nlogo.hubnet.protocol.WidgetControl;
import org.nlogo.util.ClassLoaderObjectInputStream;
import org.nlogo.util.ClassLoaderObjectInputStream$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class TestClient
implements Product,
Serializable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(TestClient.class.getDeclaredField("messagesReceived$lzy1"));
    private final String userId;
    private final String clientType;
    private final String ip;
    private final int port;
    private final ExecutorService executor;
    public final ClassLoaderObjectInputStream org$nlogo$hubnet$protocol$TestClient$$in;
    private final ObjectOutputStream out;
    private final String activityName;
    private final HubNetInterface.ClientInterface interfaceSpec;
    private volatile Object messagesReceived$lzy1;
    public boolean org$nlogo$hubnet$protocol$TestClient$$_dead;

    public static TestClient apply(String string, String string2, String string3, int n, ExecutorService executorService) {
        return TestClient$.MODULE$.apply(string, string2, string3, n, executorService);
    }

    public static TestClient create(String string, String string2, String string3, int n) {
        return TestClient$.MODULE$.create(string, string2, string3, n);
    }

    public static TestClient fromProduct(Product product) {
        return TestClient$.MODULE$.fromProduct(product);
    }

    public static ExecutorService pool() {
        return TestClient$.MODULE$.pool();
    }

    public static TestClient unapply(TestClient testClient) {
        return TestClient$.MODULE$.unapply(testClient);
    }

    public static String $lessinit$greater$default$2() {
        return TestClient$.MODULE$.$lessinit$greater$default$2();
    }

    public static String $lessinit$greater$default$3() {
        return TestClient$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$4() {
        return TestClient$.MODULE$.$lessinit$greater$default$4();
    }

    public static ExecutorService $lessinit$greater$default$5() {
        return TestClient$.MODULE$.$lessinit$greater$default$5();
    }

    public TestClient(String userId, String clientType, String ip, int port, ExecutorService executor) {
        this.userId = userId;
        this.clientType = clientType;
        this.ip = ip;
        this.port = port;
        this.executor = executor;
        Socket socket = new Socket(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super($outer.ip(), $outer.port());
                this.setSoTimeout(0);
            }
        };
        this.org$nlogo$hubnet$protocol$TestClient$$in = ClassLoaderObjectInputStream$.MODULE$.apply(Thread.currentThread().getContextClassLoader(), socket.getInputStream());
        this.out = new ObjectOutputStream(socket.getOutputStream());
        Tuple2<String, HubNetInterface.ClientInterface> tuple2 = this.handshake();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String activityName = (String)tuple2._1();
        HubNetInterface.ClientInterface interfaceSpec = (HubNetInterface.ClientInterface)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)activityName, (Object)interfaceSpec);
        this.activityName = (String)tuple22._1();
        this.interfaceSpec = (HubNetInterface.ClientInterface)tuple22._2();
        this.org$nlogo$hubnet$protocol$TestClient$$_dead = false;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.userId()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.clientType()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.ip()));
        n = Statics.mix((int)n, (int)this.port());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.executor()));
        return Statics.finalizeHash((int)n, (int)5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TestClient)) return false;
        TestClient testClient = (TestClient)object;
        if (this.port() != testClient.port()) return false;
        String string = this.userId();
        String string2 = testClient.userId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.clientType();
        String string4 = testClient.clientType();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = this.ip();
        String string6 = testClient.ip();
        if (string5 == null) {
            if (string6 != null) {
                return false;
            }
        } else if (!string5.equals(string6)) return false;
        ExecutorService executorService = this.executor();
        ExecutorService executorService2 = testClient.executor();
        if (executorService == null) {
            if (executorService2 != null) {
                return false;
            }
        } else if (!executorService.equals(executorService2)) return false;
        if (!testClient.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof TestClient;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "TestClient";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this._4());
            }
            case 4: {
                return this._5();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "userId";
            }
            case 1: {
                return "clientType";
            }
            case 2: {
                return "ip";
            }
            case 3: {
                return "port";
            }
            case 4: {
                return "executor";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String userId() {
        return this.userId;
    }

    public String clientType() {
        return this.clientType;
    }

    public String ip() {
        return this.ip;
    }

    public int port() {
        return this.port;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public String activityName() {
        return this.activityName;
    }

    public HubNetInterface.ClientInterface interfaceSpec() {
        return this.interfaceSpec;
    }

    public LinkedBlockingQueue<Message> messagesReceived() {
        Object object = this.messagesReceived$lzy1;
        if (object instanceof LinkedBlockingQueue) {
            return (LinkedBlockingQueue)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LinkedBlockingQueue)this.messagesReceived$lzyINIT1();
    }

    private Object messagesReceived$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.messagesReceived$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals.Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    LinkedBlockingQueue linkedBlockingQueue = null;
                    try {
                        linkedBlockingQueue = new LinkedBlockingQueue();
                        serializable = linkedBlockingQueue == null ? LazyVals.NullValue$.MODULE$ : linkedBlockingQueue;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals.Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.messagesReceived$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, serializable);
                            waiting.countDown();
                        }
                    }
                    return linkedBlockingQueue;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void sendActivityCommand(String message, Object content) {
        this.send(new ActivityCommand(message, content));
    }

    public void close(String reason) {
        this.send(ExitMessage$.MODULE$.apply(reason));
    }

    public List<WidgetControl> getWidgetControls() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.messagesReceived()).asScala().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Message x) {
                Message message = x;
                if (message instanceof WidgetControl) {
                    WidgetControl wc = (WidgetControl)message;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Message x, Function1 function1) {
                Message message = x;
                if (message instanceof WidgetControl) {
                    WidgetControl wc = (WidgetControl)message;
                    return wc;
                }
                return function1.apply((Object)x);
            }
        })).toList();
    }

    public List<ViewUpdate> getViewUpdates() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.messagesReceived()).asScala().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Message x) {
                Message message = x;
                if (message instanceof ViewUpdate) {
                    ViewUpdate vu = (ViewUpdate)message;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Message x, Function1 function1) {
                Message message = x;
                if (message instanceof ViewUpdate) {
                    ViewUpdate vu = (ViewUpdate)message;
                    return vu;
                }
                return function1.apply((Object)x);
            }
        })).toList();
    }

    public Option<Message> nextMessage(long timeoutMillis) {
        return Option$.MODULE$.apply((Object)this.messagesReceived().poll(timeoutMillis, TimeUnit.MILLISECONDS));
    }

    public long nextMessage$default$1() {
        return 200L;
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<String, HubNetInterface.ClientInterface> handshake() {
        void v0;
        try {
            void var2_5;
            Object response;
            this.sendAndReceive$1(Version$.MODULE$.version());
            Object object = response = this.sendAndReceive$1(new HandshakeFromClient(this.userId(), this.clientType()));
            if (!(object instanceof HandshakeFromServer)) {
                Object r = object;
                throw new IllegalStateException(this.userId() + " handshake failed. response:" + r);
            }
            HandshakeFromServer h = (HandshakeFromServer)object;
            this.send(EnterMessage$.MODULE$);
            this.executor().submit(new Receiver());
            Tuple2 result = Tuple2$.MODULE$.apply((Object)h.activityName(), (Object)h.clientInterface());
            v0 = var2_5;
        }
        catch (Exception e) {
            throw new IllegalStateException("dead client: " + this.userId());
        }
        return v0;
    }

    public void send(Object a) {
        this.rawSend(a);
    }

    public void rawSend(Object a) {
        this.out.writeObject(a);
        this.out.flush();
    }

    public boolean dead() {
        return this.org$nlogo$hubnet$protocol$TestClient$$_dead;
    }

    public TestClient copy(String userId, String clientType, String ip, int port, ExecutorService executor) {
        return new TestClient(userId, clientType, ip, port, executor);
    }

    public String copy$default$1() {
        return this.userId();
    }

    public String copy$default$2() {
        return this.clientType();
    }

    public String copy$default$3() {
        return this.ip();
    }

    public int copy$default$4() {
        return this.port();
    }

    public ExecutorService copy$default$5() {
        return this.executor();
    }

    public String _1() {
        return this.userId();
    }

    public String _2() {
        return this.clientType();
    }

    public String _3() {
        return this.ip();
    }

    public int _4() {
        return this.port();
    }

    public ExecutorService _5() {
        return this.executor();
    }

    private final Object sendAndReceive$1(Object a) {
        this.rawSend(a);
        return this.org$nlogo$hubnet$protocol$TestClient$$in.readObject();
    }

    public class Receiver
    implements Runnable {
        public Receiver() {
            if (TestClient.this == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public void run() {
            try {
                TestClient.this.messagesReceived().put((Message)TestClient.this.org$nlogo$hubnet$protocol$TestClient$$in.readObject());
                TestClient.this.executor().submit(this);
            }
            catch (IOException e) {
                TestClient.this.org$nlogo$hubnet$protocol$TestClient$$_dead = true;
            }
        }

        public final /* synthetic */ TestClient org$nlogo$hubnet$protocol$TestClient$Receiver$$$outer() {
            return TestClient.this;
        }
    }
}

