/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.server;

import java.io.Serializable;
import org.nlogo.api.PlotInterface;
import org.nlogo.hubnet.mirroring.HubNetPlotPoint;
import org.nlogo.hubnet.server.ConnectionManager;
import org.nlogo.hubnet.server.HubNetUtils$;
import org.nlogo.plot.Plot;
import org.nlogo.plot.PlotListener;
import org.nlogo.workspace.AbstractWorkspaceScala;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class ServerPlotManager
implements PlotListener {
    private final AbstractWorkspaceScala workspace;
    private final ConnectionManager connectionManager;
    private final Function0<List<Plot>> plots;
    private final Function0<Plot> currentPlot;
    private final ListBuffer<String> narrowcastPlots;

    public ServerPlotManager(AbstractWorkspaceScala workspace, ConnectionManager connectionManager, Function0<List<Plot>> plots, Function0<Plot> currentPlot) {
        this.workspace = workspace;
        this.connectionManager = connectionManager;
        this.plots = plots;
        this.currentPlot = currentPlot;
        this.narrowcastPlots = new ListBuffer();
    }

    public void initPlotListeners() {
        ((List)this.plots.apply()).foreach(plot -> {
            if (this.isBroadcast(plot.name())) {
                plot.setPlotListener(this);
                return;
            }
            plot.removePlotListener();
        });
    }

    private void broadcastToClients(Object a) {
        this.broadcastToClients(a, ((Plot)this.currentPlot.apply()).name());
    }

    private void broadcastToClients(Object a, String plotName) {
        if (this.broadcastEnabled() && this.isBroadcast(plotName)) {
            this.connectionManager.broadcastPlotControl(a, plotName);
            return;
        }
    }

    private void broadcastWidgetToClients(Object a, String widgetName) {
        if (this.broadcastEnabled() && this.isBroadcast(widgetName)) {
            this.connectionManager.broadcast(widgetName, a);
            return;
        }
    }

    private void sendToClient(String clientId, Object a) {
        if (this.workspace.hubNetRunning() && this.isNarrowcast(((Plot)this.currentPlot.apply()).name())) {
            this.connectionManager.sendPlotControl(clientId, a, ((Plot)this.currentPlot.apply()).name());
            return;
        }
    }

    private boolean broadcastEnabled() {
        return this.workspace.hubNetRunning() && HubNetUtils$.MODULE$.plotMirroring();
    }

    private boolean isNarrowcast(String plotName) {
        return this.narrowcastPlots.contains((Object)plotName) && this.connectionManager.isValidTag(plotName);
    }

    private boolean isBroadcast(String plotName) {
        return !this.narrowcastPlots.contains((Object)plotName) && this.connectionManager.isValidTag(plotName);
    }

    public void broadcastPlots() {
        ((IterableOps)this.plots.apply()).withFilter((Function1 & Serializable)p -> this.isBroadcast(p.name())).foreach(p -> this.connectionManager.broadcast(p));
    }

    public void sendPlots(String client) {
        if (this.broadcastEnabled()) {
            ((IterableOps)this.plots.apply()).withFilter((Function1 & Serializable)p -> this.isBroadcast(p.name())).foreach(p -> this.connectionManager.sendPlot(client, (PlotInterface)p));
            return;
        }
    }

    public boolean addNarrowcastPlot(String plotName) {
        Option option = ((List)this.plots.apply()).find((Function1 & Serializable)_$1 -> {
            String string = _$1.name();
            String string2 = plotName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        if (option instanceof Some) {
            Plot plot = (Plot)((Some)option).value();
            this.narrowcastPlots.$plus$eq((Object)plotName);
            plot.removePlotListener();
            return true;
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError((Object)option);
    }

    @Override
    public void clearAll() {
        this.broadcastWidgetToClients(BoxesRunTime.boxToCharacter((char)'a'), "ALL PLOTS");
    }

    @Override
    public void clear() {
        this.broadcastToClients(BoxesRunTime.boxToCharacter((char)'c'));
    }

    @Override
    public void defaultXMin(double defaultXMin) {
        this.xMin(defaultXMin);
    }

    @Override
    public void defaultYMin(double defaultYMin) {
        this.yMin(defaultYMin);
    }

    @Override
    public void defaultXMax(double defaultXMax) {
        this.xMax(defaultXMax);
    }

    @Override
    public void defaultYMax(double defaultYMax) {
        this.yMax(defaultYMax);
    }

    @Override
    public void defaultAutoPlotX(boolean defaultAutoPlotX) {
        this.autoPlotX(defaultAutoPlotX);
    }

    @Override
    public void defaultAutoPlotY(boolean defaultAutoPlotY) {
        this.autoPlotY(defaultAutoPlotY);
    }

    @Override
    public void autoPlotX(boolean flag) {
        if (flag) {
            this.broadcastToClients(BoxesRunTime.boxToCharacter((char)'x'));
            return;
        }
        this.broadcastToClients(BoxesRunTime.boxToCharacter((char)'z'));
    }

    @Override
    public void autoPlotY(boolean flag) {
        if (flag) {
            this.broadcastToClients(BoxesRunTime.boxToCharacter((char)'y'));
            return;
        }
        this.broadcastToClients(BoxesRunTime.boxToCharacter((char)'w'));
    }

    @Override
    public void plotPenMode(int plotPenMode) {
        this.broadcastToClients(BoxesRunTime.boxToShort((short)((short)plotPenMode)));
    }

    @Override
    public void plot(double x, double y) {
        this.broadcastToClients(new HubNetPlotPoint(x, y));
    }

    public void narrowcastPlot(String clientId, double y) {
        this.sendToClient(clientId, new HubNetPlotPoint(y));
    }

    public void narrowcastPlot(String clientId, double x, double y) {
        this.sendToClient(clientId, new HubNetPlotPoint(x, y));
    }

    public void narrowcastClear(String clientId) {
        this.sendToClient(clientId, BoxesRunTime.boxToCharacter((char)'c'));
    }

    public void narrowcastPenDown(String clientId, boolean penDown) {
        this.sendToClient(clientId, BoxesRunTime.boxToBoolean((boolean)penDown));
    }

    public void narrowcastPlotPenMode(String clientId, int plotPenMode) {
        this.sendToClient(clientId, BoxesRunTime.boxToShort((short)((short)plotPenMode)));
    }

    public void narrowcastSetInterval(String clientId, double interval) {
        this.sendToClient(clientId, BoxesRunTime.boxToDouble((double)interval));
    }

    public void narrowcastSetHistogramNumBars(String clientId, int num) {
        this.narrowcastSetInterval(clientId, (((Plot)this.currentPlot.apply()).xMax() - ((Plot)this.currentPlot.apply()).xMin()) / (double)num);
    }

    @Override
    public void resetPen(boolean resetPoints) {
        if (resetPoints) {
            this.broadcastToClients(BoxesRunTime.boxToCharacter((char)'r'));
            return;
        }
        this.broadcastToClients(BoxesRunTime.boxToCharacter((char)'p'));
    }

    @Override
    public void penDown(boolean penDown) {
        this.broadcastToClients(BoxesRunTime.boxToBoolean((boolean)penDown));
    }

    @Override
    public void setHistogramNumBars(int num) {
        ((Plot)this.currentPlot.apply()).currentPen().foreach(pen -> this.setInterval(pen.interval()));
    }

    @Override
    public void currentPen(String penName) {
        this.broadcastToClients(penName);
    }

    @Override
    public void setPenColor(int color) {
        this.broadcastToClients(BoxesRunTime.boxToInteger((int)color));
    }

    @Override
    public void setInterval(double interval) {
        this.broadcastToClients(BoxesRunTime.boxToDouble((double)interval));
    }

    @Override
    public void xRange(double min, double max) {
        this.broadcastToClients(package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)'x'), BoxesRunTime.boxToDouble((double)min), BoxesRunTime.boxToDouble((double)max)})));
    }

    @Override
    public void yRange(double min, double max) {
        this.broadcastToClients(package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)'y'), BoxesRunTime.boxToDouble((double)min), BoxesRunTime.boxToDouble((double)max)})));
    }

    @Override
    public void xMin(double min) {
        this.xRange(min, ((Plot)this.currentPlot.apply()).xMax());
    }

    @Override
    public void xMax(double max) {
        this.xRange(((Plot)this.currentPlot.apply()).xMin(), max);
    }

    @Override
    public void yMin(double min) {
        this.yRange(min, ((Plot)this.currentPlot.apply()).yMax());
    }

    @Override
    public void yMax(double max) {
        this.yRange(((Plot)this.currentPlot.apply()).yMin(), max);
    }
}

