/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.lab;

import java.io.PrintWriter;
import java.io.Serializable;
import org.nlogo.api.LabExporterType$;
import org.nlogo.api.LabPostProcessorInputFormat;
import org.nlogo.api.LabPostProcessorInputFormat$Spreadsheet$;
import org.nlogo.api.LabPostProcessorInputFormat$Table$;
import org.nlogo.api.LabProtocol;
import org.nlogo.core.WorldDimensions;
import org.nlogo.lab.Exporter;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple5;
import scala.Tuple5$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Range;
import scala.collection.mutable.Seq;
import scala.collection.mutable.Seq$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public class ListsExporter
extends Exporter {
    private final PrintWriter out;
    private final LabPostProcessorInputFormat.Format in;

    public ListsExporter(String modelFileName, WorldDimensions initialDims, LabProtocol protocol, PrintWriter out, LabPostProcessorInputFormat.Format in) {
        this.out = out;
        this.in = in;
        super(modelFileName, initialDims, protocol, out, LabExporterType$.MODULE$.LISTS());
    }

    public void finish() {
        this.writeExportHeader();
        LabPostProcessorInputFormat.Format format = this.in;
        if (format instanceof LabPostProcessorInputFormat.Spreadsheet) {
            String string;
            LabPostProcessorInputFormat.Spreadsheet spreadsheet = LabPostProcessorInputFormat$Spreadsheet$.MODULE$.unapply((LabPostProcessorInputFormat.Spreadsheet)format);
            String fileName = string = spreadsheet._1();
            BufferedSource source = Source$.MODULE$.fromFile(fileName, Codec$.MODULE$.fallbackSystemCodec());
            Iterator lines = source.getLines();
            ObjectRef runNumbers = ObjectRef.create(null);
            String first = (String)lines.next();
            if (first.contains("BehaviorSpace results")) {
                lines = lines.drop(5);
                Object object = Predef$.MODULE$.refArrayOps((Object[])((String)lines.next()).split(","));
                runNumbers.elem = Predef$.MODULE$.wrapRefArray((Object[])((String[])ArrayOps$.MODULE$.tail$extension(object))).toList();
            } else {
                Object object = Predef$.MODULE$.refArrayOps((Object[])first.split(","));
                runNumbers.elem = Predef$.MODULE$.wrapRefArray((Object[])((String[])ArrayOps$.MODULE$.tail$extension(object))).toList();
            }
            List parameters = lines.takeWhile((Function1 & Serializable)x -> !x.split(",")[0].contains("[reporter]") && !x.split(",")[0].contains("[total steps]")).map((Function1 & Serializable)_$1 -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])_$1.split(","));
                return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$2 -> !_$2.isEmpty())).toList();
            }).toList();
            int runWidth = ((List)runNumbers.elem).length() / ((List)((List)runNumbers.elem).distinct()).length();
            lines = lines.dropWhile((Function1 & Serializable)x -> !x.split(",")[0].contains("[all run data]") && !x.split(",")[0].contains("[final value]"));
            this.out.print(this.csv().header("[reporter]") + "," + this.csv().header("[run number]"));
            parameters.foreach(parameter -> this.out.print("," + parameter.apply(0)));
            this.out.print("," + this.csv().header("[step]"));
            if (!lines.hasNext()) {
                this.out.println();
                this.out.close();
                return;
            }
            Object object = Predef$.MODULE$.refArrayOps((Object[])((String)lines.next()).split(","));
            List reporters = Predef$.MODULE$.wrapRefArray((Object[])((String[])ArrayOps$.MODULE$.tail$extension(object))).toList();
            List data = lines.filter((Function1 & Serializable)_$3 -> !_$3.replace(",", "").isEmpty()).map((Function1 & Serializable)_$4 -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])_$4.split(","));
                return Predef$.MODULE$.wrapRefArray((Object[])((String[])ArrayOps$.MODULE$.tail$extension(object))).toList();
            }).toList();
            List count = (List)data.map((Function1 & Serializable)_$5 -> _$5.filter((Function1 & Serializable)_$6 -> _$6.contains("[")).map((Function1 & Serializable)_$7 -> _$7.split(" ").length)).flatten(Predef$.MODULE$.$conforms());
            if (count.length() > 0) {
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), BoxesRunTime.unboxToInt((Object)count.max((Ordering)Ordering.Int$.MODULE$))).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.out.print("," + this.csv().header("[" + i + "]")));
            }
            this.out.println();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ((List)runNumbers.elem).length()).by(runWidth).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), runWidth).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
                if (((String)((LinearSeqOps)data.apply(0)).apply(i + j)).contains("[")) {
                    RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), data.length()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)k -> {
                        this.out.print(reporters.apply(i + j) + "," + ((List)runNumbers$3.elem).apply(i) + ",");
                        if (parameters.length() > 0) {
                            this.out.print(parameters.map((Function1 & Serializable)_$8 -> (String)_$8.apply(i / runWidth + 1)).mkString(",") + ",");
                        }
                        Object object = Predef$.MODULE$.refArrayOps((Object[])((String)((LinearSeqOps)data.apply(k)).apply(i + j)).replaceAll("[\"\\[\\]]", "").split(" "));
                        this.out.println(((LinearSeqOps)data.apply(k)).apply(i) + "," + Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)s -> this.csv().header((String)s), ClassTag$.MODULE$.apply(String.class))).mkString(","));
                    });
                    return;
                }
            }));
            source.close();
        } else if (format instanceof LabPostProcessorInputFormat.Table) {
            String string;
            LabPostProcessorInputFormat.Table table = LabPostProcessorInputFormat$Table$.MODULE$.unapply((LabPostProcessorInputFormat.Table)format);
            String fileName = string = table._1();
            BufferedSource source = Source$.MODULE$.fromFile(fileName, Codec$.MODULE$.fallbackSystemCodec());
            Iterator lines = source.getLines();
            ObjectRef header = ObjectRef.create((Object)null);
            String first = (String)lines.next();
            if (first.contains("BehaviorSpace results")) {
                lines = lines.drop(5);
                header.elem = ((String)lines.next()).split(",");
            } else {
                header.elem = first.split(",");
            }
            Object object = Predef$.MODULE$.refArrayOps((Object[])((String[])header.elem));
            int stepIndex = ArrayOps$.MODULE$.indexWhere$extension(object, (Function1 & Serializable)_$9 -> _$9.contains("[step]"), ArrayOps$.MODULE$.indexWhere$default$2$extension(object));
            Range parameterIndices = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), stepIndex);
            ObjectRef sortedLines = ObjectRef.create((Object)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple5[0]))));
            lines.foreach(line -> {
                String[] els = line.split(",");
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(stepIndex + 1), els.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    if (els[i].contains("[")) {
                        Object object = Predef$.MODULE$.refArrayOps((Object[])els[i].replaceAll("[\"\\[\\]]", "").split(" "));
                        sortedLines$2.elem = (Seq)((Seq)sortedLines$2.elem).$colon$plus((Object)Tuple5$.MODULE$.apply((Object)((String[])header$2.elem)[i], (Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(els[0].replaceAll("\\D", "")))), (Object)parameterIndices.map((Function1 & Serializable)_$10 -> ListsExporter.finish$$anonfun$5$$anonfun$1$$anonfun$1(els, BoxesRunTime.unboxToInt((Object)_$10))).mkString(","), (Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(els[stepIndex].replaceAll("\\D", "")))), (Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)s -> this.csv().header((String)s), ClassTag$.MODULE$.apply(String.class))).mkString(",")));
                        return;
                    }
                });
            });
            this.out.print(this.csv().header("[reporter]") + "," + this.csv().header("[run number]"));
            parameterIndices.foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.out.print("," + ((String[])header$3.elem)[i]));
            this.out.print("," + this.csv().header("[step]"));
            if (((Seq)sortedLines.elem).length() > 0) {
                sortedLines.elem = (Seq)((Seq)sortedLines.elem).sortWith((Function2 & Serializable)(a, b) -> {
                    if (BoxesRunTime.unboxToInt((Object)a._2()) == BoxesRunTime.unboxToInt((Object)b._2())) {
                        if (BoxesRunTime.equals((Object)a._1(), (Object)b._1())) {
                            return BoxesRunTime.unboxToInt((Object)a._4()) < BoxesRunTime.unboxToInt((Object)b._4());
                        }
                        Object object = Predef$.MODULE$.refArrayOps((Object[])((String[])header$4.elem));
                        Object object2 = Predef$.MODULE$.refArrayOps((Object[])((String[])header$4.elem));
                        return ArrayOps$.MODULE$.indexOf$extension(object, a._1(), ArrayOps$.MODULE$.indexOf$default$2$extension(object)) < ArrayOps$.MODULE$.indexOf$extension(object2, b._1(), ArrayOps$.MODULE$.indexOf$default$2$extension(object2));
                    }
                    return BoxesRunTime.unboxToInt((Object)a._2()) < BoxesRunTime.unboxToInt((Object)b._2());
                });
                Seq count = (Seq)((IterableOps)((Seq)sortedLines.elem).filter((Function1 & Serializable)_$11 -> ((String)_$11._5()).contains(","))).map((Function1 & Serializable)_$12 -> ((String)_$12._5()).split(",").length);
                if (count.length() > 0) {
                    RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), BoxesRunTime.unboxToInt((Object)((IterableOnceOps)((Seq)sortedLines.elem).map((Function1 & Serializable)_$13 -> ((String)_$13._5()).split(",").length)).max((Ordering)Ordering.Int$.MODULE$))).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.out.print("," + this.csv().header("[" + i + "]")));
                }
                this.out.println();
                ((Seq)sortedLines.elem).foreach(line -> this.out.println(line._1() + "," + this.csv().header(line._2().toString()) + "," + ((String)(!((String)line._3()).isEmpty() ? (String)line._3() + "," : "") + this.csv().header(line._4().toString()) + "," + line._5())));
            } else {
                this.out.println();
            }
            source.close();
        } else {
            throw new IllegalStateException();
        }
        this.out.close();
    }

    @Override
    public void experimentCompleted() {
        this.finish();
    }

    @Override
    public void experimentAborted() {
        this.finish();
    }

    private static final /* synthetic */ String finish$$anonfun$5$$anonfun$1$$anonfun$1(String[] els$2, int _$10) {
        return els$2[_$10];
    }
}

