/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.lab;

import java.io.PrintWriter;
import java.io.Serializable;
import org.nlogo.api.LabExporterType$;
import org.nlogo.api.LabProtocol;
import org.nlogo.core.WorldDimensions;
import org.nlogo.lab.Exporter;
import org.nlogo.lab.PartialData;
import org.nlogo.lab.SpreadsheetExporter$;
import org.nlogo.nvm.Workspace;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class SpreadsheetExporter
extends Exporter {
    private final LabProtocol protocol;
    private final PrintWriter out;
    private final PartialData partialData;
    private final HashMap<Object, Run> runs;

    public static PartialData $lessinit$greater$default$5() {
        return SpreadsheetExporter$.MODULE$.$lessinit$greater$default$5();
    }

    public SpreadsheetExporter(String modelFileName, WorldDimensions initialDims, LabProtocol protocol, PrintWriter out, PartialData partialData) {
        this.protocol = protocol;
        this.out = out;
        this.partialData = partialData;
        super(modelFileName, initialDims, protocol, out, LabExporterType$.MODULE$.SPREADSHEET());
        this.runs = new HashMap();
    }

    public HashMap<Object, Run> runs() {
        return this.runs;
    }

    @Override
    public void runStarted(Workspace w, int runNumber, List<Tuple2<String, Object>> settings) {
        this.runs().update((Object)BoxesRunTime.boxToInteger((int)runNumber), (Object)new Run(this, settings));
    }

    @Override
    public void measurementsTaken(Workspace w, int runNumber, int step, List<Object> values) {
        ((Run)this.runs().apply((Object)BoxesRunTime.boxToInteger((int)runNumber))).addMeasurements(step, values);
    }

    @Override
    public void runCompleted(Workspace w, int runNumber, int steps) {
        ((Run)this.runs().apply((Object)BoxesRunTime.boxToInteger((int)runNumber))).done_$eq(true);
        ((Run)this.runs().apply((Object)BoxesRunTime.boxToInteger((int)runNumber))).steps_$eq(steps);
    }

    public void finish() {
        this.runs().keySet().foreach((Function1)(JFunction1.mcVI.sp & Serializable)runNumber -> {
            if (!((Run)this.runs().apply((Object)BoxesRunTime.boxToInteger((int)runNumber))).done()) {
                this.runs().$minus$eq((Object)BoxesRunTime.boxToInteger((int)runNumber));
                return;
            }
        });
        this.writeExportHeader();
        this.writeSummary();
        if (!this.protocol.metrics().isEmpty()) {
            this.writeRunData();
        }
        this.out.close();
    }

    @Override
    public void experimentCompleted() {
        this.finish();
    }

    @Override
    public void experimentAborted() {
        this.finish();
    }

    public List<Object> runNumbers() {
        return (List)this.runs().keySet().toList().sorted((Ordering)Ordering.Int$.MODULE$);
    }

    public void foreachRun(Function2<Run, Object, Option<Object>> fn) {
        List outputs = this.runNumbers().flatMap((Function1 & Serializable)runNumber -> this.$anonfun$1(fn, BoxesRunTime.unboxToInt((Object)runNumber)));
        this.out.println(outputs.mkString(","));
    }

    public void writeSummary() {
        this.out.print(this.csv().header("[run number]"));
        this.out.print(this.partialData.runNumbers());
        this.runNumbers().foreach((Function1)(JFunction1.mcVI.sp & Serializable)runNumber -> this.out.print(package$.MODULE$.List().fill(this.protocol.metrics().length() + 1, () -> this.writeSummary$$anonfun$1$$anonfun$1(runNumber)).mkString(",", ",", "")));
        this.out.println();
        IntRef i = IntRef.create((int)0);
        ((List)this.protocol.valueSets().apply(0)).map((Function1 & Serializable)_$1 -> _$1.variableName()).foreach(v -> {
            this.out.print(this.csv().header((String)v) + ",");
            if (this.partialData.variables().length() > 0) {
                this.out.print((String)this.partialData.variables().apply(i$1.elem));
            }
            ++i$1.elem;
            this.foreachRun((Function2<Run, Object, Option<Object>>)(Function2 & Serializable)(run, metricNumber) -> SpreadsheetExporter.writeSummary$$anonfun$3$$anonfun$1(v, (Run)run, BoxesRunTime.unboxToInt((Object)metricNumber)));
        });
        if (!(!this.protocol.runMetricsEveryStep() && this.protocol.runMetricsCondition().isEmpty() || this.protocol.metrics().isEmpty())) {
            this.out.print(this.csv().header("[reporter]"));
            this.out.print(this.partialData.reporters());
            this.runs().foreach(x$1 -> {
                Tuple2 tuple2 = x$1;
                this.out.print("," + this.csv().header("[step]"));
                this.protocol.metrics().foreach(metric -> this.out.print("," + this.csv().header((String)metric)));
            });
            this.out.println();
            this.out.print(this.csv().header("[final]") + this.partialData.finals() + ",");
            this.foreachRun((Function2<Run, Object, Option<Object>>)(Function2 & Serializable)(run, metricNumber) -> ((Run)run).lastMeasurement(BoxesRunTime.unboxToInt((Object)metricNumber)));
            this.out.print(this.csv().header("[min]") + this.partialData.mins() + ",");
            this.foreachRun((Function2<Run, Object, Option<Object>>)(Function2 & Serializable)(run, metricNumber) -> ((Run)run).minMeasurement(BoxesRunTime.unboxToInt((Object)metricNumber)));
            this.out.print(this.csv().header("[max]") + this.partialData.maxes() + ",");
            this.foreachRun((Function2<Run, Object, Option<Object>>)(Function2 & Serializable)(run, metricNumber) -> ((Run)run).maxMeasurement(BoxesRunTime.unboxToInt((Object)metricNumber)));
            this.out.print(this.csv().header("[mean]") + this.partialData.means() + ",");
            this.foreachRun((Function2<Run, Object, Option<Object>>)(Function2 & Serializable)(run, metricNumber) -> ((Run)run).meanMeasurement(BoxesRunTime.unboxToInt((Object)metricNumber)));
        }
        this.out.print(this.csv().header("[total steps]") + this.partialData.steps() + ",");
        this.foreachRun((Function2<Run, Object, Option<Object>>)(Function2 & Serializable)(run, metricNumber) -> Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((Run)run).steps())));
    }

    public void writeRunData() {
        this.out.println();
        this.out.print(this.csv().header(this.protocol.runMetricsEveryStep() || !this.protocol.runMetricsCondition().isEmpty() ? "[all run data]" : "[final value]"));
        this.out.print(this.partialData.dataHeaders());
        this.runs().foreach(x$1 -> {
            Tuple2 tuple2 = x$1;
            this.out.print("," + this.csv().header("[step]"));
            this.protocol.metrics().foreach(metric -> this.out.print("," + this.csv().header((String)metric)));
        });
        this.out.println();
        if (this.runs().isEmpty()) {
            return;
        }
        int mostMeasurements = this.protocol.runMetricsEveryStep() ? BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.runs().values().map((Function1 & Serializable)_$3 -> _$3.steps())).max((Ordering)Ordering.Int$.MODULE$)) : (!this.protocol.runMetricsCondition().isEmpty() ? BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.runs().values().map((Function1 & Serializable)_$4 -> _$4.numMeasurements())).max((Ordering)Ordering.Int$.MODULE$)) : 0);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), mostMeasurements).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            if (!this.partialData.data().isEmpty()) {
                this.out.print((String)this.partialData.data().head());
                this.partialData.data_$eq((Seq<String>)((Seq)this.partialData.data().tail()));
            }
            this.out.print(",");
            this.foreachRun((Function2<Run, Object, Option<Object>>)(Function2 & Serializable)(run, metricNumber) -> this.writeRunData$$anonfun$2$$anonfun$1(i, (Run)run, BoxesRunTime.unboxToInt((Object)metricNumber)));
        });
    }

    private static final String $anonfun$3() {
        return "";
    }

    private final /* synthetic */ Tuple2 $anonfun$1$$anonfun$1(Function2 fn$2, int runNumber$1, int j) {
        String output = (String)((Option)fn$2.apply(this.runs().apply((Object)BoxesRunTime.boxToInteger((int)runNumber$1)), (Object)BoxesRunTime.boxToInteger((int)j))).map((Function1 & Serializable)obj -> this.csv().data(obj)).getOrElse(SpreadsheetExporter::$anonfun$3);
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)j), (Object)output);
    }

    private final /* synthetic */ IterableOnce $anonfun$1(Function2 fn$1, int runNumber) {
        return (IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.protocol.metrics().length() + 1).map((Function1 & Serializable)j -> this.$anonfun$1$$anonfun$1(fn$1, runNumber, BoxesRunTime.unboxToInt((Object)j))).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int j = BoxesRunTime.unboxToInt((Object)tuple2._1());
                String output = (String)tuple2._2();
                return output;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private final String writeSummary$$anonfun$1$$anonfun$1(int runNumber$2) {
        return this.csv().number(runNumber$2);
    }

    private static final /* synthetic */ Option writeSummary$$anonfun$3$$anonfun$1(String v$1, Run run, int metricNumber) {
        if (metricNumber == 0) {
            return Some$.MODULE$.apply(((Tuple2)run.settings().find((Function1 & Serializable)_$2 -> {
                Object object = _$2._1();
                String string = v$1;
                return !(object != null ? !object.equals(string) : string != null);
            }).get())._2());
        }
        return None$.MODULE$;
    }

    private final /* synthetic */ Option writeRunData$$anonfun$2$$anonfun$1(int i$2, Run run, int metricNumber) {
        if (this.protocol.runMetricsEveryStep() && i$2 > run.steps()) {
            return None$.MODULE$;
        }
        if (!this.protocol.runMetricsCondition().isEmpty() && i$2 > run.numMeasurements() - 1) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply(run.getMeasurement(i$2, metricNumber));
    }

    public static final /* synthetic */ Object org$nlogo$lab$SpreadsheetExporter$Run$$_$lastMeasurement$$anonfun$1(int metricNumber$1, Object[] _$5) {
        return _$5[metricNumber$1];
    }

    public static final /* synthetic */ Object org$nlogo$lab$SpreadsheetExporter$Run$$_$doubles$$anonfun$1(int metricNumber$2, Object[] _$6) {
        return _$6[metricNumber$2];
    }

    public static final /* synthetic */ boolean org$nlogo$lab$SpreadsheetExporter$Run$$_$minMeasurement$$anonfun$1(Seq _$7) {
        return _$7.nonEmpty();
    }

    public static final /* synthetic */ double org$nlogo$lab$SpreadsheetExporter$Run$$_$minMeasurement$$anonfun$2(Seq _$8) {
        return BoxesRunTime.unboxToDouble((Object)_$8.min((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$));
    }

    public static final /* synthetic */ boolean org$nlogo$lab$SpreadsheetExporter$Run$$_$maxMeasurement$$anonfun$1(Seq _$9) {
        return _$9.nonEmpty();
    }

    public static final /* synthetic */ double org$nlogo$lab$SpreadsheetExporter$Run$$_$maxMeasurement$$anonfun$2(Seq _$10) {
        return BoxesRunTime.unboxToDouble((Object)_$10.max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$));
    }

    public class Run {
        private final List<Tuple2<String, Object>> settings;
        private boolean done;
        private int steps;
        private int numMeasurements;
        private final ArrayBuffer<Object[]> measurements;
        private final /* synthetic */ SpreadsheetExporter $outer;

        public Run(SpreadsheetExporter $outer, List<Tuple2<String, Object>> settings) {
            this.settings = settings;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.done = false;
            this.steps = 0;
            this.numMeasurements = 0;
            this.measurements = new ArrayBuffer();
        }

        public List<Tuple2<String, Object>> settings() {
            return this.settings;
        }

        public boolean done() {
            return this.done;
        }

        public void done_$eq(boolean x$1) {
            this.done = x$1;
        }

        public int steps() {
            return this.steps;
        }

        public void steps_$eq(int x$1) {
            this.steps = x$1;
        }

        public int numMeasurements() {
            return this.numMeasurements;
        }

        public void numMeasurements_$eq(int x$1) {
            this.numMeasurements = x$1;
        }

        public ArrayBuffer<Object[]> measurements() {
            return this.measurements;
        }

        public void addMeasurements(int step, List<Object> values) {
            Double d = BoxesRunTime.boxToDouble((double)step);
            this.measurements().$plus$eq(values.$colon$colon((Object)d).toArray(ClassTag$.MODULE$.apply(Object.class)));
            this.numMeasurements_$eq(this.numMeasurements() + 1);
        }

        public Object getMeasurement(int measurementNumber, int metricNumber) {
            return ((Object[])this.measurements().apply(measurementNumber))[metricNumber];
        }

        public Option<Object> lastMeasurement(int metricNumber) {
            return this.measurements().lastOption().map(arg_0 -> SpreadsheetExporter.org$nlogo$lab$SpreadsheetExporter$Run$$_$lastMeasurement$$anonfun$1(metricNumber, arg_0));
        }

        public Seq<Object> doubles(int metricNumber) {
            return ((IterableOnceOps)((StrictOptimizedIterableOps)this.measurements().map(arg_0 -> SpreadsheetExporter.org$nlogo$lab$SpreadsheetExporter$Run$$_$doubles$$anonfun$1(metricNumber, arg_0))).collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Object x) {
                    Object object = x;
                    if (object instanceof Double) {
                        Double d = (Double)object;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Object x, Function1 function1) {
                    Object object = x;
                    if (object instanceof Double) {
                        Double d = (Double)object;
                        return BoxesRunTime.boxToDouble((double)d);
                    }
                    return function1.apply(x);
                }
            })).toSeq();
        }

        public Option<Object> minMeasurement(int metricNumber) {
            return Some$.MODULE$.apply(this.doubles(metricNumber)).filter(SpreadsheetExporter::org$nlogo$lab$SpreadsheetExporter$Run$$_$minMeasurement$$anonfun$1).map(SpreadsheetExporter::org$nlogo$lab$SpreadsheetExporter$Run$$_$minMeasurement$$anonfun$2);
        }

        public Option<Object> maxMeasurement(int metricNumber) {
            return Some$.MODULE$.apply(this.doubles(metricNumber)).filter(SpreadsheetExporter::org$nlogo$lab$SpreadsheetExporter$Run$$_$maxMeasurement$$anonfun$1).map(SpreadsheetExporter::org$nlogo$lab$SpreadsheetExporter$Run$$_$maxMeasurement$$anonfun$2);
        }

        public Option<Object> meanMeasurement(int metricNumber) {
            return Some$.MODULE$.apply(this.doubles(metricNumber)).filter((Function1 & Serializable)_$11 -> _$11.size() == this.measurements().size()).map((Function1 & Serializable)_$12 -> BoxesRunTime.unboxToDouble((Object)_$12.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)this.measurements().size());
        }

        public final /* synthetic */ SpreadsheetExporter org$nlogo$lab$SpreadsheetExporter$Run$$$outer() {
            return this.$outer;
        }
    }
}

