/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.lab;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Locale;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.nlogo.agent.World;
import org.nlogo.api.Dump$;
import org.nlogo.api.ExportPlotWarningAction;
import org.nlogo.api.ExportPlotWarningAction$Ignore$;
import org.nlogo.api.ExportPlotWarningAction$Output$;
import org.nlogo.api.LabPostProcessorInputFormat;
import org.nlogo.api.LabProtocol;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoException$;
import org.nlogo.api.MersenneTwisterFast;
import org.nlogo.api.SimpleJobOwner;
import org.nlogo.api.WorldDimensionException;
import org.nlogo.core.AgentKind$Observer$;
import org.nlogo.core.I18N$;
import org.nlogo.core.WorldDimensions;
import org.nlogo.lab.ListsExporter;
import org.nlogo.lab.SpreadsheetExporter;
import org.nlogo.lab.SpreadsheetExporter$;
import org.nlogo.lab.StatsExporter;
import org.nlogo.lab.TableExporter;
import org.nlogo.lab.Worker$;
import org.nlogo.nvm.Command;
import org.nlogo.nvm.LabInterface;
import org.nlogo.nvm.Procedure;
import org.nlogo.nvm.Workspace;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public class Worker
implements LabInterface.Worker {
    private final LabProtocol protocol;
    private final Function0<BoxedUnit> supervisorWriting;
    private final ListBuffer<LabInterface.ProgressListener> listeners;
    private Seq<Runner> runners;
    private final WeakHashMap<Workspace, Procedures> proceduresMap;

    public static Function0<BoxedUnit> $lessinit$greater$default$2() {
        return Worker$.MODULE$.$lessinit$greater$default$2();
    }

    public Worker(LabProtocol protocol, Function0<BoxedUnit> supervisorWriting) {
        this.protocol = protocol;
        this.supervisorWriting = supervisorWriting;
        this.listeners = new ListBuffer();
        this.runners = null;
        this.proceduresMap = new WeakHashMap();
    }

    @Override
    public LabProtocol protocol() {
        return this.protocol;
    }

    public Function0<BoxedUnit> supervisorWriting() {
        return this.supervisorWriting;
    }

    public ListBuffer<LabInterface.ProgressListener> listeners() {
        return this.listeners;
    }

    @Override
    public void addListener(LabInterface.ProgressListener listener) {
        this.listeners().$plus$eq((Object)listener);
    }

    @Override
    public void addSpreadsheetWriter(String modelFileName, WorldDimensions initialDims, PrintWriter w) {
        this.addListener(new SpreadsheetExporter(modelFileName, initialDims, this.protocol(), w, SpreadsheetExporter$.MODULE$.$lessinit$greater$default$5()));
    }

    @Override
    public void addTableWriter(String modelFileName, WorldDimensions initialDims, PrintWriter w) {
        this.addListener(new TableExporter(modelFileName, initialDims, this.protocol(), w));
    }

    @Override
    public void addStatsWriter(String modelFileName, WorldDimensions initialDims, PrintWriter w, LabPostProcessorInputFormat.Format in) {
        this.addListener(new StatsExporter(modelFileName, initialDims, this.protocol(), w, in));
    }

    @Override
    public void addListsWriter(String modelFileName, WorldDimensions initialDims, PrintWriter w, LabPostProcessorInputFormat.Format in) {
        this.addListener(new ListsExporter(modelFileName, initialDims, this.protocol(), w, in));
    }

    public Seq<Runner> runners() {
        return this.runners;
    }

    public void runners_$eq(Seq<Runner> x$1) {
        this.runners = x$1;
    }

    public WeakHashMap<Workspace, Procedures> proceduresMap() {
        return this.proceduresMap;
    }

    @Override
    public void run(Workspace initialWorkspace, Function0<Workspace> fn, int threads) {
        Seq<String> globals = initialWorkspace.world().program().interfaceGlobals();
        Map initialState = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        globals.foreach(g -> initialState.update(g, initialWorkspace.world().getObserverVariableByName((String)g)));
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        try {
            try {
                this.listeners().foreach(_$1 -> _$1.experimentStarted());
                initialWorkspace.runCompiledCommands(new SimpleJobOwner("BehaviorSpace", initialWorkspace.world().mainRNG(), AgentKind$Observer$.MODULE$), new Procedures(this, initialWorkspace).preExperimentProcedure());
                if (initialWorkspace.lastLogoException() != null) {
                    LogoException ex = initialWorkspace.lastLogoException();
                    initialWorkspace.clearLastLogoException();
                    this.listeners().foreach(_$2 -> _$2.runtimeError(initialWorkspace, 0, ex));
                }
                this.runners_$eq((Seq<Runner>)this.protocol().refElements().zip((IterableOnce)package$.MODULE$.LazyList().from(1).iterator()).drop(this.protocol().runsCompleted()).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        List settings = (List)tuple2._1();
                        int runNumber = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        return new Runner(this, runNumber, (List<Tuple2<String, Object>>)settings, fn);
                    }
                    throw new MatchError((Object)tuple2);
                }).toSeq());
                Buffer futures = CollectionConverters$.MODULE$.ListHasAsScala(executor.invokeAll(CollectionConverters$.MODULE$.SeqHasAsJava(this.runners()).asJava())).asScala();
                initialWorkspace.runCompiledCommands(new SimpleJobOwner("BehaviorSpace", initialWorkspace.world().mainRNG(), AgentKind$Observer$.MODULE$), new Procedures(this, initialWorkspace).postExperimentProcedure());
                if (initialWorkspace.lastLogoException() != null) {
                    LogoException ex = initialWorkspace.lastLogoException();
                    initialWorkspace.clearLastLogoException();
                    this.listeners().foreach(_$3 -> _$3.runtimeError(initialWorkspace, this.protocol().countRuns(), ex));
                }
                executor.shutdown();
                executor.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
                this.supervisorWriting().apply$mcV$sp();
                this.listeners().foreach(_$4 -> _$4.experimentCompleted());
                futures.foreach(_$5 -> _$5.get());
            }
            catch (InterruptedException interruptedException) {
                this.runners().foreach(_$6 -> _$6.aborted_$eq(true));
                this.listeners().foreach(_$7 -> _$7.experimentAborted());
            }
        }
        finally {
            executor.shutdown();
            this.runners_$eq(null);
            globals.foreach(g -> initialWorkspace.world().setObserverVariableByName((String)g, initialState.apply(g)));
        }
    }

    @Override
    public void compile(Workspace w) {
        new Procedures(this, w);
    }

    @Override
    public void abort() {
        if (this.runners() != null) {
            this.runners().foreach(_$8 -> _$8.aborted_$eq(true));
        }
        this.supervisorWriting().apply$mcV$sp();
    }

    public static final /* synthetic */ boolean org$nlogo$lab$Worker$Procedures$$_$$lessinit$greater$$anonfun$1(String _$9) {
        return _$9.trim().startsWith(";");
    }

    public static final /* synthetic */ boolean org$nlogo$lab$Worker$Procedures$$_$$lessinit$greater$$anonfun$2(String _$10) {
        return _$10.trim().isEmpty();
    }

    public static final /* synthetic */ Procedure org$nlogo$lab$Worker$Procedures$$_$$lessinit$greater$$anonfun$3(Workspace workspace$1, String source) {
        return workspace$1.compileReporter(source);
    }

    public static final /* synthetic */ Procedure org$nlogo$lab$Worker$Procedures$$_$$lessinit$greater$$anonfun$4(Workspace workspace$2, String _$11) {
        return workspace$2.compileReporter(_$11);
    }

    /*
     * Unable to fully structure code
     */
    private static final /* synthetic */ void checkForPlotExportCommand$1$$anonfun$1(BooleanRef exportCommandFound$1, Command c) {
        var2_2 = c.getClass().getSimpleName();
        switch (var2_2 == null ? 0 : var2_2.hashCode()) {
            case -719939130: {
                if (!"_exportinterface".equals(var2_2)) {
                    break;
                }
                ** GOTO lbl17
            }
            case 1298332724: {
                if (!"_exportplot".equals(var2_2)) {
                    break;
                }
                ** GOTO lbl17
            }
            case 1593608895: {
                if (!"_exportplots".equals(var2_2)) {
                    break;
                }
                ** GOTO lbl17
            }
            case 1600165535: {
                if (!"_exportworld".equals(var2_2)) break;
lbl17:
                // 4 sources

                exportCommandFound$1.elem = true;
                return;
            }
        }
    }

    private static final boolean checkForPlotExportCommand$1(Command[] code) {
        BooleanRef exportCommandFound = BooleanRef.create((boolean)false);
        Object object = Predef$.MODULE$.refArrayOps((Object[])code);
        ArrayOps$.MODULE$.foreach$extension(object, arg_0 -> Worker.checkForPlotExportCommand$1$$anonfun$1(exportCommandFound, arg_0));
        return exportCommandFound.elem;
    }

    public static final void org$nlogo$lab$Worker$Runner$$_$checkForPlotExport$1(Workspace ws$8, Procedures procedures$4) {
        if (!ws$8.shouldUpdatePlots() && (Worker.checkForPlotExportCommand$1(procedures$4.preExperimentProcedure().code()) || Worker.checkForPlotExportCommand$1(procedures$4.postRunProcedure().code()) || Worker.checkForPlotExportCommand$1(procedures$4.goProcedure().code()) || Worker.checkForPlotExportCommand$1(procedures$4.setupProcedure().code()) || Worker.checkForPlotExportCommand$1(procedures$4.postExperimentProcedure().code()))) {
            ws$8.setTriedToExportPlot(true);
            ExportPlotWarningAction exportPlotWarningAction = ws$8.exportPlotWarningAction();
            if (ExportPlotWarningAction$Output$.MODULE$.equals(exportPlotWarningAction)) {
                ws$8.setExportPlotWarningAction(ExportPlotWarningAction$Ignore$.MODULE$);
                Predef$.MODULE$.println((Object)I18N$.MODULE$.shared().get("tools.behaviorSpace.runoptions.updateplotsandmonitors.error"));
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ void org$nlogo$lab$Worker$Runner$$_$callHelper$$anonfun$3(Workspace ws$13, IntRef steps$1, LabInterface.ProgressListener _$16) {
        _$16.stepCompleted(ws$13, steps$1.elem);
    }

    public class Procedures {
        private final Workspace workspace;
        private final Procedure preExperimentProcedure;
        private final Procedure setupProcedure;
        private final Procedure goProcedure;
        private final Procedure postRunProcedure;
        private final Procedure postExperimentProcedure;
        private final Option<Procedure> exitProcedure;
        private final List<Procedure> metricProcedures;
        private final Option<Procedure> runMetricsConditionProcedure;
        private final /* synthetic */ Worker $outer;

        public Procedures(Worker $outer, Workspace workspace) {
            this.workspace = workspace;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.preExperimentProcedure = workspace.compileCommands($outer.protocol().preExperimentCommands());
            this.setupProcedure = workspace.compileCommands($outer.protocol().setupCommands());
            this.goProcedure = workspace.compileCommands($outer.protocol().goCommands() + "\n__experimentstepend");
            this.postRunProcedure = workspace.compileCommands($outer.protocol().postRunCommands());
            this.postExperimentProcedure = workspace.compileCommands($outer.protocol().postExperimentCommands());
            Object object = Predef$.MODULE$.refArrayOps((Object[])$outer.protocol().exitCondition().split("\n"));
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.dropWhile$extension(object, Worker::org$nlogo$lab$Worker$Procedures$$_$$lessinit$greater$$anonfun$1));
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.dropWhile$extension(object2, Worker::org$nlogo$lab$Worker$Procedures$$_$$lessinit$greater$$anonfun$2));
            this.exitProcedure = ArrayOps$.MODULE$.headOption$extension(object3).map(arg_0 -> Worker.org$nlogo$lab$Worker$Procedures$$_$$lessinit$greater$$anonfun$3(workspace, arg_0));
            this.metricProcedures = $outer.protocol().metrics().map(arg_0 -> Worker.org$nlogo$lab$Worker$Procedures$$_$$lessinit$greater$$anonfun$4(workspace, arg_0));
            this.runMetricsConditionProcedure = $outer.protocol().runMetricsCondition().isEmpty() ? None$.MODULE$ : Some$.MODULE$.apply((Object)workspace.compileReporter($outer.protocol().runMetricsCondition()));
        }

        public Procedure preExperimentProcedure() {
            return this.preExperimentProcedure;
        }

        public Procedure setupProcedure() {
            return this.setupProcedure;
        }

        public Procedure goProcedure() {
            return this.goProcedure;
        }

        public Procedure postRunProcedure() {
            return this.postRunProcedure;
        }

        public Procedure postExperimentProcedure() {
            return this.postExperimentProcedure;
        }

        public Option<Procedure> exitProcedure() {
            return this.exitProcedure;
        }

        public List<Procedure> metricProcedures() {
            return this.metricProcedures;
        }

        public Option<Procedure> runMetricsConditionProcedure() {
            return this.runMetricsConditionProcedure;
        }

        public final /* synthetic */ Worker org$nlogo$lab$Worker$Procedures$$$outer() {
            return this.$outer;
        }
    }

    public class Runner
    implements Callable<BoxedUnit> {
        private final int runNumber;
        private final List<Tuple2<String, Object>> settings;
        private final Function0<Workspace> fn;
        private volatile boolean aborted;
        private final /* synthetic */ Worker $outer;

        public Runner(Worker $outer, int runNumber, List<Tuple2<String, Object>> settings, Function0<Workspace> fn) {
            this.runNumber = runNumber;
            this.settings = settings;
            this.fn = fn;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.aborted = false;
        }

        private SimpleJobOwner owner(MersenneTwisterFast rng) {
            return new SimpleJobOwner("BehaviorSpace", rng, AgentKind$Observer$.MODULE$);
        }

        public boolean aborted() {
            return this.aborted;
        }

        public void aborted_$eq(boolean x$1) {
            this.aborted = x$1;
        }

        public void eachListener(Function1<LabInterface.ProgressListener, BoxedUnit> fn) {
            ListBuffer<LabInterface.ProgressListener> listBuffer = this.$outer.listeners();
            synchronized (listBuffer) {
                this.$outer.listeners().foreach(fn);
            }
        }

        @Override
        public void call() {
            if (!this.aborted()) {
                Workspace workspace = (Workspace)this.fn.apply();
                if (workspace != null) {
                    block4: {
                        try {
                            this.callHelper(workspace);
                        }
                        catch (Throwable t) {
                            if (this.aborted()) break block4;
                            this.eachListener(_$12 -> _$12.runtimeError(workspace, this.runNumber, t));
                        }
                    }
                    return;
                }
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        public void callHelper(Workspace ws) {
            Procedures procedures;
            if (this.$outer.proceduresMap().containsKey(ws)) {
                procedures = this.$outer.proceduresMap().get(ws);
            } else {
                void var3_2;
                Procedures newProcedures = new Procedures(this.$outer, ws);
                this.$outer.proceduresMap().put(ws, newProcedures);
                procedures = var3_2;
            }
            Procedures procedures2 = procedures;
            int lastMeasuredStep = -1;
            ws.behaviorSpaceRunNumber(this.runNumber);
            ws.behaviorSpaceExperimentName(this.$outer.protocol().name());
            this.setVariables$1(ws, this.settings);
            this.eachListener(_$14 -> _$14.runStarted(ws, this.runNumber, this.settings));
            Worker.org$nlogo$lab$Worker$Runner$$_$checkForPlotExport$1(ws, procedures2);
            ws.runCompiledCommands(this.owner(ws.world().mainRNG()), procedures2.setupProcedure());
            this.checkForRuntimeError$1(ws);
            if ((this.$outer.protocol().runMetricsEveryStep() || this.shouldTakeMeasurements$1(procedures2, ws)) && this.$outer.listeners().nonEmpty()) {
                List m = this.takeMeasurements$1(procedures2, ws);
                this.eachListener(_$15 -> _$15.measurementsTaken(ws, this.runNumber, 0, (List<Object>)m));
                this.checkForRuntimeError$1(ws);
                lastMeasuredStep = 0;
            }
            IntRef steps = IntRef.create((int)0);
            while (!(this.$outer.protocol().timeLimit() != 0 && steps.elem >= this.$outer.protocol().timeLimit() || this.exitConditionTrue$1(procedures2, ws) || ws.runCompiledCommands(this.owner(ws.world().mainRNG()), procedures2.goProcedure()))) {
                this.checkForRuntimeError$1(ws);
                ++steps.elem;
                this.eachListener(arg_0 -> Worker.org$nlogo$lab$Worker$Runner$$_$callHelper$$anonfun$3(ws, steps, arg_0));
                if ((this.$outer.protocol().runMetricsEveryStep() || this.shouldTakeMeasurements$1(procedures2, ws)) && this.$outer.listeners().nonEmpty()) {
                    List m = this.takeMeasurements$1(procedures2, ws);
                    this.eachListener(_$17 -> _$17.measurementsTaken(ws, this.runNumber, steps$2.elem, (List<Object>)m));
                    this.checkForRuntimeError$1(ws);
                    lastMeasuredStep = steps.elem;
                }
                ws.updateDisplay(false);
                if (!this.aborted()) continue;
                return;
            }
            if (!this.$outer.protocol().runMetricsEveryStep() && steps.elem != lastMeasuredStep && this.$outer.listeners().nonEmpty()) {
                List m = this.takeMeasurements$1(procedures2, ws);
                this.eachListener(_$18 -> _$18.measurementsTaken(ws, this.runNumber, steps$3.elem, (List<Object>)m));
                this.checkForRuntimeError$1(ws);
            }
            ws.runCompiledCommands(this.owner(ws.world().mainRNG()), procedures2.postRunProcedure());
            this.checkForRuntimeError$1(ws);
            this.eachListener(_$19 -> _$19.runCompleted(ws, this.runNumber, steps$4.elem));
        }

        public final /* synthetic */ Worker org$nlogo$lab$Worker$Runner$$$outer() {
            return this.$outer;
        }

        private final void setVariables$1(Workspace ws$1, List settings) {
            World world = ws$1.world();
            ObjectRef d = ObjectRef.create((Object)world.getDimensions());
            settings.foreach(x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Object value = tuple2._2();
                    if (world.isDimensionVariable(name)) {
                        int v = ((Double)value).intValue();
                        try {
                            d$1.elem = world.setDimensionVariable(name, v, (WorldDimensions)d$1.elem);
                        }
                        catch (WorldDimensionException e) {
                            throw new FailedException("You cannot set " + name + " to " + v);
                        }
                        return;
                    }
                    if (name.equalsIgnoreCase("RANDOM-SEED")) {
                        ws$1.world().mainRNG().setSeed(((Double)value).longValue());
                        return;
                    }
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            if (!world.equalDimensions((WorldDimensions)d.elem)) {
                ws$1.setDimensions((WorldDimensions)d.elem);
            }
            settings.foreach(x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Object value = tuple2._2();
                    if (!world.isDimensionVariable(name) && !name.equalsIgnoreCase("RANDOM-SEED")) {
                        World world = ws$1.world();
                        synchronized (world) {
                            if (ws$1.world().observerOwnsIndexOf(name.toUpperCase(Locale.ENGLISH)) == -1) {
                                throw new FailedException("Global variable does not exist:\n" + name);
                            }
                            ws$1.world().setObserverVariableByName(name, value);
                        }
                        return;
                    }
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
        }

        private final boolean exitConditionTrue$1(Procedures procedures$1, Workspace ws$4) {
            Option<Procedure> option = procedures$1.exitProcedure();
            if (None$.MODULE$.equals(option)) {
                return false;
            }
            if (option instanceof Some) {
                Procedure procedure = (Procedure)((Some)option).value();
                Object object = ws$4.runCompiledReporter(this.owner(ws$4.world().mainRNG().clone()), procedure);
                if (object instanceof Throwable) {
                    Throwable t = (Throwable)object;
                    throw t;
                }
                if (object instanceof Boolean) {
                    Boolean b = (Boolean)object;
                    return b;
                }
                if (object == null) {
                    throw new FailedException("Stopping condition failed to report a result:\n" + this.$outer.protocol().exitCondition());
                }
                if (object != null) {
                    Object result = object;
                    throw new FailedException("Stopping condition should report true or false, but instead reported the " + Dump$.MODULE$.typeName(result) + " " + Dump$.MODULE$.logoObject(result));
                }
                throw new MatchError(object);
            }
            throw new MatchError(option);
        }

        private final boolean shouldTakeMeasurements$1(Procedures procedures$2, Workspace ws$5) {
            Option<Procedure> option = procedures$2.runMetricsConditionProcedure();
            if (None$.MODULE$.equals(option)) {
                return false;
            }
            if (option instanceof Some) {
                Procedure procedure = (Procedure)((Some)option).value();
                Object object = ws$5.runCompiledReporter(this.owner(ws$5.world().mainRNG().clone()), procedure);
                if (object instanceof Throwable) {
                    Throwable t = (Throwable)object;
                    throw new FailedException("Metrics condition reporter encountered an error: " + t);
                }
                if (object instanceof Boolean) {
                    Boolean b = (Boolean)object;
                    return b;
                }
                if (object == null) {
                    throw new FailedException("Metrics condition reporter failed to report a result:\n" + this.$outer.protocol().runMetricsCondition());
                }
                if (object != null) {
                    Object result = object;
                    throw new FailedException("Metrics condition should report true or false, but instead reported the " + Dump$.MODULE$.typeName(result) + " " + Dump$.MODULE$.logoObject(result));
                }
                throw new MatchError(object);
            }
            throw new MatchError(option);
        }

        private final List takeMeasurements$1(Procedures procedures$3, Workspace ws$6) {
            return procedures$3.metricProcedures().map((Function1 & Serializable)proc -> {
                Object result = ws$6.runCompiledReporter(this.owner(ws$6.world().mainRNG().clone()), (Procedure)proc);
                if (result == null) {
                    throw new FailedException("Reporter for measuring runs failed to report a result:\n" + result);
                }
                return result;
            });
        }

        private final void checkForRuntimeError$1(Workspace ws$9) {
            if (ws$9.lastLogoException() != null) {
                LogoException ex = ws$9.lastLogoException();
                ws$9.clearLastLogoException();
                if (!this.aborted()) {
                    this.eachListener(_$13 -> _$13.runtimeError(ws$9, this.runNumber, ex));
                    return;
                }
                return;
            }
        }

        public class FailedException
        extends LogoException {
            public FailedException(String message) {
                if (Runner.this == null) {
                    throw new NullPointerException();
                }
                super(message, LogoException$.MODULE$.$lessinit$greater$default$2());
            }

            public final /* synthetic */ Runner org$nlogo$lab$Worker$Runner$FailedException$$$outer() {
                return Runner.this;
            }
        }
    }
}

