/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.lab.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import org.nlogo.agent.World;
import org.nlogo.analytics.Analytics$;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.LabProtocol;
import org.nlogo.api.LabProtocol$;
import org.nlogo.api.RefEnumeratedValueSet;
import org.nlogo.api.RefValueSet;
import org.nlogo.awt.UserCancelException;
import org.nlogo.core.I18N;
import org.nlogo.core.I18N$;
import org.nlogo.core.I18N$Prefix$;
import org.nlogo.lab.gui.LabManager;
import org.nlogo.lab.gui.ManagerDialog;
import org.nlogo.lab.gui.ProtocolEditable;
import org.nlogo.lab.gui.Supervisor;
import org.nlogo.swing.Button;
import org.nlogo.swing.FileDialog$;
import org.nlogo.swing.OptionPane;
import org.nlogo.swing.OptionPane$Icons$;
import org.nlogo.swing.OptionPane$Options$;
import org.nlogo.swing.Positioning$;
import org.nlogo.swing.ScrollPane;
import org.nlogo.swing.ScrollPane$;
import org.nlogo.swing.Transparent;
import org.nlogo.swing.Utils$;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.theme.ThemeSync;
import org.nlogo.window.EditDialogFactory;
import org.nlogo.window.MenuBarFactory;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ListBuffer;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public class ManagerDialog
extends JDialog
implements ListSelectionListener,
ThemeSync {
    private final LabManager manager;
    private final EditDialogFactory dialogFactory;
    public final MenuBarFactory org$nlogo$lab$gui$ManagerDialog$$menuFactory;
    public final JList<LabProtocol> org$nlogo$lab$gui$ManagerDialog$$jlist;
    private final DefaultListModel<LabProtocol> listModel;
    public final I18N.Prefix org$nlogo$lab$gui$ManagerDialog$$i18NPrefix;
    private final AbstractAction editAction;
    private final AbstractAction newAction;
    private final AbstractAction deleteAction;
    private final AbstractAction duplicateAction;
    private final AbstractAction importAction;
    private final AbstractAction exportAction;
    public final AbstractAction org$nlogo$lab$gui$ManagerDialog$$closeAction;
    private final AbstractAction abortAction;
    private final AbstractAction runAction;
    public boolean org$nlogo$lab$gui$ManagerDialog$$blockActions;
    private int editIndex;
    private final JLabel listLabel;
    private final ScrollPane scrollPane;
    public final Button org$nlogo$lab$gui$ManagerDialog$$newButton;
    public final Button org$nlogo$lab$gui$ManagerDialog$$editButton;
    public final Button org$nlogo$lab$gui$ManagerDialog$$duplicateButton;
    public final Button org$nlogo$lab$gui$ManagerDialog$$deleteButton;
    public final Button org$nlogo$lab$gui$ManagerDialog$$importButton;
    public final Button org$nlogo$lab$gui$ManagerDialog$$exportButton;
    public final Button org$nlogo$lab$gui$ManagerDialog$$abortButton;
    public final Button org$nlogo$lab$gui$ManagerDialog$$runButton;

    public ManagerDialog(LabManager manager, EditDialogFactory dialogFactory, MenuBarFactory menuFactory) {
        this.manager = manager;
        this.dialogFactory = dialogFactory;
        this.org$nlogo$lab$gui$ManagerDialog$$menuFactory = menuFactory;
        super(manager.workspace().getFrame());
        this.org$nlogo$lab$gui$ManagerDialog$$jlist = new JList();
        this.listModel = new DefaultListModel();
        this.org$nlogo$lab$gui$ManagerDialog$$i18NPrefix = I18N$Prefix$.MODULE$.apply("tools.behaviorSpace");
        this.editAction = this.makeAction(I18N$.MODULE$.gui().apply("edit", this.org$nlogo$lab$gui$ManagerDialog$$i18NPrefix), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.org$nlogo$lab$gui$ManagerDialog$$edit());
        this.newAction = this.makeAction(I18N$.MODULE$.gui().apply("new", this.org$nlogo$lab$gui$ManagerDialog$$i18NPrefix), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.makeNew());
        this.deleteAction = this.makeAction(I18N$.MODULE$.gui().apply("delete", this.org$nlogo$lab$gui$ManagerDialog$$i18NPrefix), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.delete());
        this.duplicateAction = this.makeAction(I18N$.MODULE$.gui().apply("duplicate", this.org$nlogo$lab$gui$ManagerDialog$$i18NPrefix), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.duplicate());
        this.importAction = this.makeAction(I18N$.MODULE$.gui().apply("import", this.org$nlogo$lab$gui$ManagerDialog$$i18NPrefix), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.importnl());
        this.exportAction = this.makeAction(I18N$.MODULE$.gui().apply("export", this.org$nlogo$lab$gui$ManagerDialog$$i18NPrefix), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.export());
        this.org$nlogo$lab$gui$ManagerDialog$$closeAction = this.makeAction(I18N$.MODULE$.gui().apply("close", this.org$nlogo$lab$gui$ManagerDialog$$i18NPrefix), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> manager.close());
        this.abortAction = this.makeAction(I18N$.MODULE$.gui().apply("abort", this.org$nlogo$lab$gui$ManagerDialog$$i18NPrefix), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.abort());
        this.runAction = this.makeAction(I18N$.MODULE$.gui().apply("run", this.org$nlogo$lab$gui$ManagerDialog$$i18NPrefix), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.run());
        this.org$nlogo$lab$gui$ManagerDialog$$blockActions = false;
        this.editIndex = 0;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(this){
            private final /* synthetic */ ManagerDialog $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void windowClosing(WindowEvent e) {
                this.$outer.org$nlogo$lab$gui$ManagerDialog$$closeAction.actionPerformed(null);
            }
        });
        this.setTitle(I18N$.MODULE$.gui().get("menu.tools.behaviorSpace"));
        this.org$nlogo$lab$gui$ManagerDialog$$jlist.setVisibleRowCount(5);
        this.org$nlogo$lab$gui$ManagerDialog$$jlist.setModel(this.listModel);
        this.org$nlogo$lab$gui$ManagerDialog$$jlist.addListSelectionListener(this);
        this.org$nlogo$lab$gui$ManagerDialog$$jlist.addMouseListener(new MouseInputAdapter(this){
            private final /* synthetic */ ManagerDialog $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1 && this.$outer.org$nlogo$lab$gui$ManagerDialog$$jlist.getSelectedIndices().length == 1 && this.$outer.org$nlogo$lab$gui$ManagerDialog$$selectedProtocol().runsCompleted() == 0 && !this.$outer.org$nlogo$lab$gui$ManagerDialog$$blockActions) {
                    this.$outer.org$nlogo$lab$gui$ManagerDialog$$edit();
                    return;
                }
            }
        });
        this.org$nlogo$lab$gui$ManagerDialog$$jlist.setCellRenderer(new ProtocolRenderer());
        this.listLabel = new JLabel(I18N$.MODULE$.gui().apply("experiments", this.org$nlogo$lab$gui$ManagerDialog$$i18NPrefix));
        this.scrollPane = new ScrollPane(this.org$nlogo$lab$gui$ManagerDialog$$jlist, ScrollPane$.MODULE$.$lessinit$greater$default$2(), ScrollPane$.MODULE$.$lessinit$greater$default$3());
        this.org$nlogo$lab$gui$ManagerDialog$$newButton = new Button(this.newAction);
        this.org$nlogo$lab$gui$ManagerDialog$$editButton = new Button(this.editAction);
        this.org$nlogo$lab$gui$ManagerDialog$$duplicateButton = new Button(this.duplicateAction);
        this.org$nlogo$lab$gui$ManagerDialog$$deleteButton = new Button(this.deleteAction);
        this.org$nlogo$lab$gui$ManagerDialog$$importButton = new Button(this.importAction);
        this.org$nlogo$lab$gui$ManagerDialog$$exportButton = new Button(this.exportAction);
        this.org$nlogo$lab$gui$ManagerDialog$$abortButton = new Button(this.abortAction);
        this.org$nlogo$lab$gui$ManagerDialog$$runButton = new Button(this.runAction);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(6, 6, 6, 6);
        this.getContentPane().add((Component)this.listLabel, c);
        c.anchor = 10;
        c.fill = 1;
        c.weighty = 1.0;
        c.insets = new Insets(0, 6, 6, 6);
        this.getContentPane().add((Component)this.scrollPane, c);
        c.fill = 2;
        c.weighty = 0.0;
        c.insets = new Insets(0, 6, 6, 6);
        this.getContentPane().add((Component)((Object)new Transparent(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(new FlowLayout(1, 6, 0));
                Transparent.$init$(this);
                this.add($outer.org$nlogo$lab$gui$ManagerDialog$$newButton);
                this.add($outer.org$nlogo$lab$gui$ManagerDialog$$editButton);
                this.add($outer.org$nlogo$lab$gui$ManagerDialog$$duplicateButton);
                this.add($outer.org$nlogo$lab$gui$ManagerDialog$$deleteButton);
            }
        }), c);
        this.getContentPane().add((Component)((Object)new Transparent(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(new FlowLayout(1, 6, 0));
                Transparent.$init$(this);
                this.add($outer.org$nlogo$lab$gui$ManagerDialog$$importButton);
                this.add($outer.org$nlogo$lab$gui$ManagerDialog$$exportButton);
                this.add($outer.org$nlogo$lab$gui$ManagerDialog$$abortButton);
                this.add($outer.org$nlogo$lab$gui$ManagerDialog$$runButton);
            }
        }), c);
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        this.pack();
        Positioning$.MODULE$.center(this, manager.workspace().getFrame());
        JMenuBar menus = new JMenuBar(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.add($outer.org$nlogo$lab$gui$ManagerDialog$$menuFactory.createFileMenu());
                this.setPreferredSize(new Dimension(0, 0));
            }
        };
        this.setJMenuBar(menus);
        Utils$.MODULE$.addEscKeyAction(this, (Action)this.org$nlogo$lab$gui$ManagerDialog$$closeAction);
        this.getRootPane().setDefaultButton(this.org$nlogo$lab$gui$ManagerDialog$$runButton);
    }

    public void saveProtocol(LabProtocol protocol, int runsCompleted) {
        protocol.runsCompleted_$eq(runsCompleted);
        this.update();
        this.select(protocol);
    }

    private AbstractAction makeAction(String name, Function0<BoxedUnit> fn) {
        return new AbstractAction(name, fn){
            private final Function0 fn$2;
            {
                this.fn$2 = fn$1;
                super(name$3);
            }

            public void actionPerformed(ActionEvent e) {
                this.fn$2.apply$mcV$sp();
            }
        };
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(super.getPreferredSize().width), 400), RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(super.getPreferredSize().height), 300));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.org$nlogo$lab$gui$ManagerDialog$$blockActions) {
            this.editAction.setEnabled(false);
            this.newAction.setEnabled(false);
            this.deleteAction.setEnabled(false);
            this.duplicateAction.setEnabled(false);
            this.importAction.setEnabled(false);
            this.exportAction.setEnabled(false);
            this.org$nlogo$lab$gui$ManagerDialog$$closeAction.setEnabled(false);
            this.abortAction.setEnabled(false);
            this.runAction.setEnabled(false);
            return;
        }
        int count = this.org$nlogo$lab$gui$ManagerDialog$$jlist.getSelectedIndices().length;
        this.editAction.setEnabled(count == 1 && this.org$nlogo$lab$gui$ManagerDialog$$selectedProtocol().runsCompleted() == 0);
        this.newAction.setEnabled(true);
        this.deleteAction.setEnabled(count > 0);
        this.duplicateAction.setEnabled(count == 1);
        this.importAction.setEnabled(true);
        this.exportAction.setEnabled(count > 0);
        this.org$nlogo$lab$gui$ManagerDialog$$closeAction.setEnabled(true);
        this.abortAction.setEnabled(count == 1 && this.org$nlogo$lab$gui$ManagerDialog$$selectedProtocol().runsCompleted() != 0);
        this.runAction.setEnabled(count == 1);
    }

    private void run() {
        try {
            this.editIndex = this.selectedIndex();
            this.manager.prepareForRun();
            new Supervisor(this, this.manager.workspace(), this.org$nlogo$lab$gui$ManagerDialog$$selectedProtocol(), this.manager.workspaceFactory(), this.dialogFactory, (Function2<LabProtocol, Object, BoxedUnit>)(Function2 & Serializable)(v1, v2) -> {
                this.run$$anonfun$1((LabProtocol)v1, BoxesRunTime.unboxToInt((Object)v2));
                return BoxedUnit.UNIT;
            }).start();
        }
        catch (UserCancelException ex) {
            Exceptions$.MODULE$.ignore(ex);
        }
    }

    private void makeNew() {
        List list;
        LabProtocol labProtocol = LabProtocol$.MODULE$.defaultGUIProtocol();
        World world = this.manager.workspace().world();
        synchronized (world) {
            list = this.manager.workspace().world().program().interfaceGlobals().toList().map((Function1 & Serializable)x$1 -> {
                String string = x$1;
                if (string != null) {
                    String variableName = string;
                    return new RefEnumeratedValueSet(variableName, (List<Object>)((List)new .colon.colon(this.manager.workspace().world().getObserverVariableByName(variableName), (List)Nil$.MODULE$)));
                }
                throw new MatchError((Object)string);
            });
        }
        List list2 = list;
        String string = labProtocol.copy$default$1();
        String string2 = labProtocol.copy$default$2();
        String string3 = labProtocol.copy$default$3();
        String string4 = labProtocol.copy$default$4();
        String string5 = labProtocol.copy$default$5();
        String string6 = labProtocol.copy$default$6();
        int n = labProtocol.copy$default$7();
        boolean bl = labProtocol.copy$default$8();
        boolean bl2 = labProtocol.copy$default$9();
        String string7 = labProtocol.copy$default$10();
        int n2 = labProtocol.copy$default$11();
        String string8 = labProtocol.copy$default$12();
        List<String> list3 = labProtocol.copy$default$13();
        List<List<RefValueSet>> list4 = labProtocol.copy$default$15();
        int n3 = labProtocol.copy$default$16();
        String string9 = labProtocol.copy$default$17();
        String string10 = labProtocol.copy$default$18();
        String string11 = labProtocol.copy$default$19();
        String string12 = labProtocol.copy$default$20();
        boolean bl3 = labProtocol.copy$default$21();
        boolean bl4 = labProtocol.copy$default$22();
        boolean bl5 = labProtocol.copy$default$23();
        int n4 = labProtocol.copy$default$24();
        this.editProtocol(labProtocol.copy(string, string2, string3, string4, string5, string6, n, bl, bl2, string7, n2, string8, list3, (List<RefValueSet>)list2, list4, n3, string9, string10, string11, string12, bl3, bl4, bl5, n4), true);
    }

    private void duplicate() {
        LabProtocol labProtocol = this.org$nlogo$lab$gui$ManagerDialog$$selectedProtocol();
        String string = this.org$nlogo$lab$gui$ManagerDialog$$selectedProtocol().name() + " (copy)";
        String string2 = labProtocol.copy$default$2();
        String string3 = labProtocol.copy$default$3();
        String string4 = labProtocol.copy$default$4();
        String string5 = labProtocol.copy$default$5();
        String string6 = labProtocol.copy$default$6();
        int n = labProtocol.copy$default$7();
        boolean bl = labProtocol.copy$default$8();
        boolean bl2 = labProtocol.copy$default$9();
        String string7 = labProtocol.copy$default$10();
        int n2 = labProtocol.copy$default$11();
        String string8 = labProtocol.copy$default$12();
        List<String> list = labProtocol.copy$default$13();
        List<RefValueSet> list2 = labProtocol.copy$default$14();
        List<List<RefValueSet>> list3 = labProtocol.copy$default$15();
        int n3 = labProtocol.copy$default$16();
        String string9 = labProtocol.copy$default$17();
        String string10 = labProtocol.copy$default$18();
        String string11 = labProtocol.copy$default$19();
        String string12 = labProtocol.copy$default$20();
        boolean bl3 = labProtocol.copy$default$21();
        boolean bl4 = labProtocol.copy$default$22();
        boolean bl5 = labProtocol.copy$default$23();
        this.editProtocol(labProtocol.copy(string, string2, string3, string4, string5, string6, n, bl, bl2, string7, n2, string8, list, list2, list3, n3, string9, string10, string11, string12, bl3, bl4, bl5, 0), true);
    }

    public void org$nlogo$lab$gui$ManagerDialog$$edit() {
        this.editProtocol(this.org$nlogo$lab$gui$ManagerDialog$$selectedProtocol(), false);
    }

    private void editProtocol(LabProtocol protocol, boolean isNew) {
        this.org$nlogo$lab$gui$ManagerDialog$$blockActions = true;
        if (!isNew) {
            this.editIndex = this.selectedIndex();
        }
        this.update();
        Analytics$.MODULE$.bspaceOpen();
        ProtocolEditable editable = new ProtocolEditable(protocol, this.manager.workspace().getFrame(), this.manager.workspace(), this.dialogFactory.colorizer(), this.manager.workspace().world(), (Seq<String>)((IterableOnceOps)((StrictOptimizedIterableOps)this.manager.protocols().map((Function1 & Serializable)_$1 -> _$1.name())).filter((Function1 & Serializable)_$2 -> {
            if (isNew) return true;
            String string = _$2;
            String string2 = protocol.name();
            if (string == null) {
                if (string2 == null) return false;
                return true;
            } else if (string.equals(string2)) return false;
            return true;
        })).toSeq());
        this.dialogFactory.create(this.manager.workspace().getFrame(), editable, (Function1<Object, BoxedUnit>)(Function1 & Serializable)v1 -> {
            this.editProtocol$$anonfun$1(editable, isNew, BoxesRunTime.unboxToBoolean((Object)v1));
            return BoxedUnit.UNIT;
        });
    }

    private void delete() {
        String message;
        int[] selected = this.org$nlogo$lab$gui$ManagerDialog$$jlist.getSelectedIndices();
        String string = message = selected.length > 1 ? I18N$.MODULE$.gui().apply("delete.confirm.multiple", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToInteger((int)selected.length).toString()}), this.org$nlogo$lab$gui$ManagerDialog$$i18NPrefix) : I18N$.MODULE$.gui().apply("delete.confirm.one", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.listModel.getElementAt(selected[0]).name()}), this.org$nlogo$lab$gui$ManagerDialog$$i18NPrefix);
        if (new OptionPane(this, I18N$.MODULE$.gui().apply("delete", this.org$nlogo$lab$gui$ManagerDialog$$i18NPrefix), message, OptionPane$Options$.MODULE$.YesNo(), OptionPane$Icons$.MODULE$.Question()).getSelectedIndex() == 0) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), selected.length).foreach((Function1 & Serializable)i -> this.delete$$anonfun$1(selected, BoxesRunTime.unboxToInt((Object)i)));
            this.update();
            int newSize = this.manager.protocols().size();
            if (newSize > 0) {
                this.select(selected[0] >= newSize ? RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(selected[0] - 1), newSize - 1) : selected[0]);
            }
            this.manager.dirty();
            return;
        }
    }

    private void importnl() {
        try {
            FileDialog dialog = new FileDialog(this.manager.workspace().getFrame(), I18N$.MODULE$.gui().apply("import.dialog", this.org$nlogo$lab$gui$ManagerDialog$$i18NPrefix));
            dialog.setDirectory(System.getProperty("user.home"));
            public class Org_nlogo_lab_gui_ManagerDialog$XMLFilter$1
            implements FilenameFilter {
                public Org_nlogo_lab_gui_ManagerDialog$XMLFilter$1() {
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean accept(File dir, String name) {
                    String[] split = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(name), '.');
                    if (split.length != 2) return false;
                    String string = split[1];
                    String string2 = "xml";
                    if (string != null) {
                        if (!string.equals(string2)) return false;
                        return true;
                    }
                    if (string2 == null) return true;
                    return false;
                }
            }
            dialog.setFilenameFilter(new Org_nlogo_lab_gui_ManagerDialog$XMLFilter$1());
            dialog.setMultipleMode(true);
            dialog.setVisible(true);
            Object object = Predef$.MODULE$.refArrayOps((Object[])dialog.getFiles());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)file -> {
                Tuple2 tuple2;
                Try<Tuple2<Seq<LabProtocol>, Set<String>>> try_ = this.manager.modelLoader().readExperiments(Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec()).mkString(), true, (Set<String>)((IterableOnceOps)this.manager.protocols().map((Function1 & Serializable)_$3 -> _$3.name())).toSet());
                if (try_ instanceof Success && (tuple2 = (Tuple2)((Success)try_).value()) != null) {
                    Seq protocols = (Seq)tuple2._1();
                    protocols.foreach(p -> this.manager.addProtocol((LabProtocol)p));
                    return BoxedUnit.UNIT;
                }
                if (try_ instanceof Failure) {
                    return new OptionPane(this.manager.workspace().getFrame(), I18N$.MODULE$.gui().apply("invalid", this.org$nlogo$lab$gui$ManagerDialog$$i18NPrefix), I18N$.MODULE$.gui().apply("error.import", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{file.getName()}), this.org$nlogo$lab$gui$ManagerDialog$$i18NPrefix), OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Error());
                }
                throw new MatchError(try_);
            });
            this.update();
        }
        catch (UserCancelException e) {
            Exceptions$.MODULE$.ignore(e);
        }
    }

    private void export() {
        try {
            int[] indices = this.org$nlogo$lab$gui$ManagerDialog$$jlist.getSelectedIndices();
            String modelName = this.manager.workspace().getModelFileName() == null ? "" : StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(this.manager.workspace().getModelFileName()), '.')[0] + '-';
            Object path = FileDialog$.MODULE$.showFiles((Component)this.manager.workspace().getFrame(), I18N$.MODULE$.gui().apply("export.dialog", this.org$nlogo$lab$gui$ManagerDialog$$i18NPrefix), 1, indices.length == 1 ? modelName + this.org$nlogo$lab$gui$ManagerDialog$$selectedProtocol().name() + "-experiment.xml" : modelName + "experiments.xml", FileDialog$.MODULE$.showFiles$default$5());
            if (!((String)path).endsWith(".xml")) {
                path = (String)path + ".xml";
            }
            PrintWriter out = new PrintWriter((String)path);
            this.manager.modelLoader().writeExperiments(this.selectedProtocols(), out);
            out.println();
            out.close();
        }
        catch (UserCancelException e) {
            Exceptions$.MODULE$.ignore(e);
        }
    }

    private void abort() {
        this.saveProtocol(this.org$nlogo$lab$gui$ManagerDialog$$selectedProtocol(), 0);
    }

    public void update() {
        this.listModel.clear();
        this.manager.protocols().foreach(_$4 -> this.listModel.addElement((LabProtocol)_$4));
        this.manager.workspace().getExperimentManager().setGUIExperiments((Seq<LabProtocol>)this.manager.protocols().toSeq());
        this.valueChanged(null);
        if (this.manager.protocols().size() > 0) {
            this.org$nlogo$lab$gui$ManagerDialog$$jlist.setSelectedIndices(new int[]{0});
            return;
        }
    }

    private void select(int index) {
        this.org$nlogo$lab$gui$ManagerDialog$$jlist.setSelectedIndices(new int[]{index});
        this.org$nlogo$lab$gui$ManagerDialog$$jlist.ensureIndexIsVisible(index);
    }

    private void select(LabProtocol targetProtocol) {
        int index = this.manager.protocols().indexWhere((Function1 & Serializable)_$5 -> _$5 == targetProtocol);
        this.org$nlogo$lab$gui$ManagerDialog$$jlist.setSelectedIndices(new int[]{index});
        this.org$nlogo$lab$gui$ManagerDialog$$jlist.ensureIndexIsVisible(index);
    }

    private int selectedIndex() {
        Object object;
        int[] nArray = this.org$nlogo$lab$gui$ManagerDialog$$jlist.getSelectedIndices();
        if (nArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)nArray), 1) == 0) {
            int n = BoxesRunTime.unboxToInt((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0));
            if (true) {
                int i = n;
                return i;
            }
        }
        return -1;
    }

    public LabProtocol org$nlogo$lab$gui$ManagerDialog$$selectedProtocol() {
        return (LabProtocol)this.manager.protocols().apply(this.org$nlogo$lab$gui$ManagerDialog$$jlist.getSelectedIndices()[0]);
    }

    private Seq<LabProtocol> selectedProtocols() {
        Object object = Predef$.MODULE$.intArrayOps(this.org$nlogo$lab$gui$ManagerDialog$$jlist.getSelectedIndices());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, this.manager.protocols(), ClassTag$.MODULE$.apply(LabProtocol.class)));
        return ArrayOps$.MODULE$.toSeq$extension(object2);
    }

    @Override
    public void syncTheme() {
        this.getContentPane().setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.listLabel.setForeground(InterfaceColors$.MODULE$.dialogText());
        this.scrollPane.setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.org$nlogo$lab$gui$ManagerDialog$$jlist.setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.org$nlogo$lab$gui$ManagerDialog$$newButton.syncTheme();
        this.org$nlogo$lab$gui$ManagerDialog$$editButton.syncTheme();
        this.org$nlogo$lab$gui$ManagerDialog$$duplicateButton.syncTheme();
        this.org$nlogo$lab$gui$ManagerDialog$$deleteButton.syncTheme();
        this.org$nlogo$lab$gui$ManagerDialog$$importButton.syncTheme();
        this.org$nlogo$lab$gui$ManagerDialog$$exportButton.syncTheme();
        this.org$nlogo$lab$gui$ManagerDialog$$abortButton.syncTheme();
        this.org$nlogo$lab$gui$ManagerDialog$$runButton.syncTheme();
        this.dialogFactory.syncTheme();
    }

    private final /* synthetic */ void run$$anonfun$1(LabProtocol protocol, int runsCompleted) {
        this.saveProtocol(protocol, runsCompleted);
    }

    private final /* synthetic */ void editProtocol$$anonfun$1(ProtocolEditable editable$1, boolean isNew$2, boolean success) {
        this.org$nlogo$lab$gui$ManagerDialog$$blockActions = false;
        if (success) {
            Growable growable;
            LabProtocol newProtocol = (LabProtocol)editable$1.get().get();
            if (isNew$2) {
                growable = this.manager.protocols().$plus$eq((Object)newProtocol);
            } else {
                this.manager.protocols().update(this.editIndex, (Object)newProtocol);
                growable = BoxedUnit.UNIT;
            }
            this.update();
            this.select(newProtocol);
            return;
        }
        this.update();
    }

    private final /* synthetic */ ListBuffer delete$$anonfun$1(int[] selected$1, int i) {
        return (ListBuffer)this.manager.protocols().$minus$eq((Object)this.listModel.getElementAt(selected$1[i]));
    }

    public class ProtocolRenderer
    extends JPanel
    implements ListCellRenderer<LabProtocol> {
        private final JLabel label;

        public ProtocolRenderer() {
            if (ManagerDialog.this == null) {
                throw new NullPointerException();
            }
            super(new FlowLayout(0));
            this.label = new JLabel();
            this.add(this.label);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends LabProtocol> list, LabProtocol proto, int index, boolean isSelected, boolean cellHasFocus) {
            this.label.setText((String)(proto.runsCompleted() != 0 ? I18N$.MODULE$.gui().apply("inProgress", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{proto.name(), BoxesRunTime.boxToInteger((int)proto.runsCompleted()).toString(), BoxesRunTime.boxToInteger((int)proto.countRuns()).toString()}), ManagerDialog.this.org$nlogo$lab$gui$ManagerDialog$$i18NPrefix) : proto.name() + " (" + proto.countRuns() + " run" + (proto.countRuns() != 1 ? "s" : "") + ")"));
            if (isSelected) {
                this.setBackground(InterfaceColors$.MODULE$.dialogBackgroundSelected());
                this.label.setForeground(InterfaceColors$.MODULE$.dialogTextSelected());
            } else {
                this.setBackground(InterfaceColors$.MODULE$.dialogBackground());
                this.label.setForeground(InterfaceColors$.MODULE$.dialogText());
            }
            return this;
        }

        public final /* synthetic */ ManagerDialog org$nlogo$lab$gui$ManagerDialog$ProtocolRenderer$$$outer() {
            return ManagerDialog.this;
        }
    }
}

