/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.lab.gui;

import java.awt.Window;
import java.io.Serializable;
import java.nio.file.Path;
import org.nlogo.api.LabDefaultValues$;
import org.nlogo.api.LabProtocol;
import org.nlogo.awt.UserCancelException;
import org.nlogo.core.I18N;
import org.nlogo.core.I18N$;
import org.nlogo.core.I18N$Prefix$;
import org.nlogo.lab.gui.RunOptionsDialog$Prefs$;
import org.nlogo.lab.gui.RunOptionsEditPanel;
import org.nlogo.window.DummyErrorHandler;
import org.nlogo.window.EditDialogFactory;
import org.nlogo.window.EditPanel;
import org.nlogo.window.Editable;
import scala.Option;
import scala.Some$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class RunOptionsDialog {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RunOptionsDialog.class.getDeclaredField("Prefs$lzy1"));
    private final Window parent;
    private final EditDialogFactory dialogFactory;
    public final Option<Path> org$nlogo$lab$gui$RunOptionsDialog$$currentDirectory;
    public final LabProtocol org$nlogo$lab$gui$RunOptionsDialog$$protocol;
    private final String spreadsheetFile;
    private final String tableFile;
    private final String statsFile;
    private final String listsFile;
    private final int totalProcessors;
    private final int defaultProcessors;
    private final boolean mirrorHeadlessOutput;
    private volatile Object Prefs$lzy1;

    public RunOptionsDialog(Window parent, EditDialogFactory dialogFactory, Option<Path> currentDirectory, String filePrefix, LabProtocol protocol) {
        this.parent = parent;
        this.dialogFactory = dialogFactory;
        this.org$nlogo$lab$gui$RunOptionsDialog$$currentDirectory = currentDirectory;
        this.org$nlogo$lab$gui$RunOptionsDialog$$protocol = protocol;
        this.spreadsheetFile = filePrefix + "-spreadsheet.csv";
        this.tableFile = filePrefix + "-table.csv";
        this.statsFile = filePrefix + "-stats.csv";
        this.listsFile = filePrefix + "-lists.csv";
        this.totalProcessors = Runtime.getRuntime().availableProcessors();
        this.defaultProcessors = LabDefaultValues$.MODULE$.getDefaultThreads();
        this.mirrorHeadlessOutput = LabDefaultValues$.MODULE$.getDefaultMirrorHeadlessOutput();
    }

    public String spreadsheetFile() {
        return this.spreadsheetFile;
    }

    public String tableFile() {
        return this.tableFile;
    }

    public String statsFile() {
        return this.statsFile;
    }

    public String listsFile() {
        return this.listsFile;
    }

    public int totalProcessors() {
        return this.totalProcessors;
    }

    public int defaultProcessors() {
        return this.defaultProcessors;
    }

    public boolean mirrorHeadlessOutput() {
        return this.mirrorHeadlessOutput;
    }

    public final RunOptionsDialog$Prefs$ Prefs() {
        Object object = this.Prefs$lzy1;
        if (object instanceof RunOptionsDialog$Prefs$) {
            return (RunOptionsDialog$Prefs$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RunOptionsDialog$Prefs$)this.Prefs$lzyINIT1();
    }

    private Object Prefs$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Prefs$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals.Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    RunOptionsDialog$Prefs$ runOptionsDialog$Prefs$ = null;
                    try {
                        runOptionsDialog$Prefs$ = new RunOptionsDialog$Prefs$(this);
                        serializable = runOptionsDialog$Prefs$ == null ? LazyVals.NullValue$.MODULE$ : runOptionsDialog$Prefs$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals.Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Prefs$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, serializable);
                            waiting.countDown();
                        }
                    }
                    return runOptionsDialog$Prefs$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void run() {
        EditableRunOptions editable = new EditableRunOptions();
        if (this.dialogFactory.canceled(this.parent, editable)) {
            throw new UserCancelException();
        }
        this.Prefs().updateFrom(this.org$nlogo$lab$gui$RunOptionsDialog$$protocol);
    }

    public class EditableRunOptions
    implements Editable,
    DummyErrorHandler {
        private final String classDisplayName;
        private final int sourceOffset;

        public EditableRunOptions() {
            if (RunOptionsDialog.this == null) {
                throw new NullPointerException();
            }
            I18N.Prefix i18nPrefix = I18N$Prefix$.MODULE$.apply("tools.behaviorSpace.runoptions");
            this.classDisplayName = I18N$.MODULE$.gui().apply("title", i18nPrefix);
            this.sourceOffset = 0;
        }

        @Override
        public String classDisplayName() {
            return this.classDisplayName;
        }

        public String spreadsheet() {
            return RunOptionsDialog.this.org$nlogo$lab$gui$RunOptionsDialog$$protocol.spreadsheet();
        }

        public void setSpreadsheet(String s) {
            RunOptionsDialog.this.org$nlogo$lab$gui$RunOptionsDialog$$protocol.spreadsheet_$eq(s);
        }

        public String table() {
            return RunOptionsDialog.this.org$nlogo$lab$gui$RunOptionsDialog$$protocol.table();
        }

        public void setTable(String s) {
            RunOptionsDialog.this.org$nlogo$lab$gui$RunOptionsDialog$$protocol.table_$eq(s);
        }

        public String stats() {
            return RunOptionsDialog.this.org$nlogo$lab$gui$RunOptionsDialog$$protocol.stats();
        }

        public void setStats(String s) {
            RunOptionsDialog.this.org$nlogo$lab$gui$RunOptionsDialog$$protocol.stats_$eq(s);
        }

        public String lists() {
            return RunOptionsDialog.this.org$nlogo$lab$gui$RunOptionsDialog$$protocol.lists();
        }

        public void setLists(String s) {
            RunOptionsDialog.this.org$nlogo$lab$gui$RunOptionsDialog$$protocol.lists_$eq(s);
        }

        public boolean updateView() {
            return RunOptionsDialog.this.org$nlogo$lab$gui$RunOptionsDialog$$protocol.updateView();
        }

        public void setUpdateView(boolean b) {
            RunOptionsDialog.this.org$nlogo$lab$gui$RunOptionsDialog$$protocol.updateView_$eq(b);
        }

        public boolean updatePlotsAndMonitors() {
            return RunOptionsDialog.this.org$nlogo$lab$gui$RunOptionsDialog$$protocol.updatePlotsAndMonitors();
        }

        public void setUpdatePlotsAndMonitors(boolean b) {
            RunOptionsDialog.this.org$nlogo$lab$gui$RunOptionsDialog$$protocol.updatePlotsAndMonitors_$eq(b);
        }

        public int threadCount() {
            return RunOptionsDialog.this.org$nlogo$lab$gui$RunOptionsDialog$$protocol.threadCount();
        }

        public void setThreadCount(int i) {
            RunOptionsDialog.this.org$nlogo$lab$gui$RunOptionsDialog$$protocol.threadCount_$eq(i);
        }

        public boolean mirrorHeadlessOutput() {
            return RunOptionsDialog.this.org$nlogo$lab$gui$RunOptionsDialog$$protocol.mirrorHeadlessOutput();
        }

        public void setMirrorHeadlessOutput(boolean b) {
            RunOptionsDialog.this.org$nlogo$lab$gui$RunOptionsDialog$$protocol.mirrorHeadlessOutput_$eq(b);
        }

        @Override
        public EditPanel editPanel() {
            return new RunOptionsEditPanel(this, RunOptionsDialog.this.org$nlogo$lab$gui$RunOptionsDialog$$currentDirectory, RunOptionsDialog.this.spreadsheetFile(), RunOptionsDialog.this.tableFile(), RunOptionsDialog.this.statsFile(), RunOptionsDialog.this.listsFile(), BoxesRunTime.boxToInteger((int)RunOptionsDialog.this.defaultProcessors()).toString(), BoxesRunTime.boxToInteger((int)RunOptionsDialog.this.totalProcessors()).toString());
        }

        @Override
        public Option<String> helpLink() {
            return Some$.MODULE$.apply((Object)"behaviorspace.html#running-an-experiment");
        }

        @Override
        public int sourceOffset() {
            return this.sourceOffset;
        }

        @Override
        public boolean editFinished() {
            return true;
        }

        public final /* synthetic */ RunOptionsDialog org$nlogo$lab$gui$RunOptionsDialog$EditableRunOptions$$$outer() {
            return RunOptionsDialog.this;
        }
    }
}

