/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import org.nlogo.agent.ImportPatchColors;
import org.nlogo.api.Activation;
import org.nlogo.api.Agent;
import org.nlogo.api.MersenneTwisterFast;
import org.nlogo.api.World;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.Workspace;

public class ExtensionContext
implements org.nlogo.api.Context {
    private final Workspace workspace;
    private final Context nvmContext;

    public ExtensionContext(Workspace workspace, Context nvmContext) {
        this.workspace = workspace;
        this.nvmContext = nvmContext;
    }

    @Override
    public Workspace workspace() {
        return this.workspace;
    }

    public Context nvmContext() {
        return this.nvmContext;
    }

    @Override
    public Agent getAgent() {
        return this.nvmContext().agent;
    }

    @Override
    public MersenneTwisterFast getRNG() {
        return this.nvmContext().job.random;
    }

    @Override
    public BufferedImage getDrawing() {
        return this.workspace().getAndCreateDrawing();
    }

    @Override
    public World world() {
        return this.workspace().world();
    }

    @Override
    public String attachCurrentDirectory(String path) throws MalformedURLException {
        return this.workspace().fileManager().attachPrefix(path);
    }

    public String attachModelDir(String filePath) throws MalformedURLException {
        return this.workspace().attachModelDir(filePath);
    }

    @Override
    public void importPcolors(BufferedImage image, boolean asNetLogoColors) {
        ImportPatchColors.doImport(image, this.workspace().world(), asNetLogoColors);
    }

    @Override
    public Activation activation() {
        return this.nvmContext().activation;
    }
}

