/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.parse;

import java.io.Serializable;
import org.nlogo.core.Breed;
import org.nlogo.core.CompilationEnvironment;
import org.nlogo.core.CompilationOperand;
import org.nlogo.core.CompilerException;
import org.nlogo.core.ErrorSource;
import org.nlogo.core.Fail$;
import org.nlogo.core.FrontEndProcedure;
import org.nlogo.core.I18N$;
import org.nlogo.core.LibraryInfo;
import org.nlogo.core.LibraryManager;
import org.nlogo.core.LibraryStatus;
import org.nlogo.core.LibraryStatus$CanInstall$;
import org.nlogo.core.ProcedureSyntax;
import org.nlogo.core.ProcedureSyntax$;
import org.nlogo.core.Program;
import org.nlogo.core.SourceLocatable;
import org.nlogo.core.StructureResults;
import org.nlogo.core.StructureResults$;
import org.nlogo.core.Token;
import org.nlogo.core.TokenType;
import org.nlogo.core.TokenType$CloseBracket$;
import org.nlogo.core.TokenType$Comment$;
import org.nlogo.core.TokenType$Eof$;
import org.nlogo.core.TokenType$Ident$;
import org.nlogo.core.TokenType$Literal$;
import org.nlogo.core.TokenType$OpenBracket$;
import org.nlogo.core.TokenizerInterface;
import org.nlogo.parse.IncludeFile$;
import org.nlogo.parse.Namer0$;
import org.nlogo.parse.StructureParser;
import org.nlogo.parse.SymbolTable;
import org.nlogo.parse.SymbolTable$;
import org.nlogo.parse.SymbolType$BreedVariable$;
import org.nlogo.parse.SymbolType$GlobalVariable$;
import org.nlogo.parse.SymbolType$LinkBreed$;
import org.nlogo.parse.SymbolType$LinkBreedSingular$;
import org.nlogo.parse.SymbolType$LinkBreedVariable$;
import org.nlogo.parse.SymbolType$LinkVariable$;
import org.nlogo.parse.SymbolType$PatchVariable$;
import org.nlogo.parse.SymbolType$PrimitiveCommand$;
import org.nlogo.parse.SymbolType$PrimitiveReporter$;
import org.nlogo.parse.SymbolType$ProcedureSymbol$;
import org.nlogo.parse.SymbolType$TurtleBreed$;
import org.nlogo.parse.SymbolType$TurtleBreedSingular$;
import org.nlogo.parse.SymbolType$TurtleVariable$;
import org.nlogo.util.PathUtils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class StructureParser$
implements Serializable {
    private static final String IncludeFilesEndInNLS;
    public static final StructureParser$ MODULE$;

    private StructureParser$() {
    }

    static {
        MODULE$ = new StructureParser$();
        IncludeFilesEndInNLS = "Included files must end with .nls";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StructureParser$.class);
    }

    public String IncludeFilesEndInNLS() {
        return IncludeFilesEndInNLS;
    }

    public StructureResults parseSources(TokenizerInterface tokenizer, CompilationOperand compilationData, Function2<CompilationEnvironment, String, Option<Tuple2<String, String>>> includeFile) {
        return this.parsingWithExtensions(compilationData, (Function0<StructureResults>)((Function0 & Serializable)() -> StructureParser$.parseSources$$anonfun$1(compilationData, tokenizer, includeFile)));
    }

    public Function2<CompilationEnvironment, String, Option<Tuple2<String, String>>> parseSources$default$3() {
        return (Function2 & Serializable)(compilationEnvironment, suppliedPath) -> IncludeFile$.MODULE$.apply((CompilationEnvironment)compilationEnvironment, (String)suppliedPath);
    }

    private StructureResults parsingWithExtensions(CompilationOperand compilationData, Function0<StructureResults> results) {
        if (compilationData.subprogram()) {
            return (StructureResults)results.apply();
        }
        compilationData.extensionManager().startFullCompilation();
        StructureResults r = (StructureResults)results.apply();
        r.extensions().foreach(token -> {
            String text = token.text().toLowerCase();
            if (compilationData.shouldAutoInstallLibs()) {
                LibraryManager lm = compilationData.libraryManager();
                lm.lookupExtension(text, "").filter((Function1 & Serializable)_$2 -> {
                    LibraryStatus libraryStatus = _$2.status();
                    LibraryStatus$CanInstall$ libraryStatus$CanInstall$ = LibraryStatus$CanInstall$.MODULE$;
                    return !(libraryStatus != null ? !libraryStatus.equals(libraryStatus$CanInstall$) : libraryStatus$CanInstall$ != null);
                }).foreach(info -> lm.installExtension((LibraryInfo)info));
            }
            compilationData.extensionManager().importExtension(text, new ErrorSource((Token)token));
        });
        compilationData.extensionManager().finishFullCompilation();
        return r;
    }

    private StructureResults parseOne(TokenizerInterface tokenizer, StructureParser structureParser, String source, String filename, StructureResults oldResults) {
        Iterator tokens = tokenizer.tokenizeString(source, filename).filter((Function1 & Serializable)_$3 -> {
            TokenType tokenType = _$3.tpe();
            TokenType$Comment$ tokenType$Comment$ = TokenType$Comment$.MODULE$;
            return tokenType == null ? tokenType$Comment$ != null : !tokenType.equals(tokenType$Comment$);
        }).map((Function1)Namer0$.MODULE$);
        return structureParser.parse((Iterator<Token>)tokens, oldResults);
    }

    public SymbolTable usedNames(Program program, ListMap<String, FrontEndProcedure> procedures) {
        SymbolTable symTable = SymbolTable$.MODULE$.empty().addSymbols((Iterable<String>)program.dialect().tokenMapper().allCommandNames(), SymbolType$PrimitiveCommand$.MODULE$).addSymbols((Iterable<String>)program.dialect().tokenMapper().allReporterNames(), SymbolType$PrimitiveReporter$.MODULE$).addSymbols((Iterable<String>)program.globals(), SymbolType$GlobalVariable$.MODULE$).addSymbols((Iterable<String>)program.turtlesOwn(), SymbolType$TurtleVariable$.MODULE$).addSymbols((Iterable<String>)program.patchesOwn(), SymbolType$PatchVariable$.MODULE$).addSymbols((Iterable<String>)((Iterable)program.linksOwn().filterNot((Function1 & Serializable)elem -> program.turtlesOwn().contains(elem))), SymbolType$LinkVariable$.MODULE$).addSymbols((Iterable<String>)((Iterable)program.breeds().values().map((Function1 & Serializable)_$4 -> _$4.singular())), SymbolType$TurtleBreedSingular$.MODULE$).addSymbols((Iterable<String>)program.breeds().keys(), SymbolType$TurtleBreed$.MODULE$).addSymbols((Iterable<String>)((Iterable)program.linkBreeds().values().map((Function1 & Serializable)_$5 -> _$5.singular())), SymbolType$LinkBreedSingular$.MODULE$).addSymbols((Iterable<String>)program.linkBreeds().keys(), SymbolType$LinkBreed$.MODULE$).addSymbols((Iterable<String>)procedures.keys(), SymbolType$ProcedureSymbol$.MODULE$);
        return (SymbolTable)((Object)program.breeds().values().foldLeft((Object)symTable, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, x$2);
            if (tuple2 != null) {
                SymbolTable symbolTable = (SymbolTable)((Object)((Object)tuple2._1()));
                Breed breed = (Breed)tuple2._2();
                SymbolTable table = symbolTable;
                Breed breed2 = breed;
                if (breed2.isLinkBreed()) {
                    return table.addSymbols((Iterable<String>)breed2.owns(), SymbolType$LinkBreedVariable$.MODULE$.apply(breed2.name()));
                }
                SymbolTable table2 = symbolTable;
                Breed breed3 = breed;
                return table2.addSymbols((Iterable<String>)breed3.owns(), SymbolType$BreedVariable$.MODULE$.apply(breed3.name()));
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    public Map<String, ProcedureSyntax> findProcedurePositions(Seq<Token> tokens2) {
        return ((IterableOnceOps)this.splitOnProcedureStarts$1(tokens2, (Seq)((SeqOps)Nil$.MODULE$)).flatMap((Function1 & Serializable)tokens -> this.procedureSyntax$1((Seq)tokens))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Seq<String> findIncludes(Iterator<Token> tokens) throws CompilerException {
        Iterator includesPositionedTokens = tokens.dropWhile((Function1 & Serializable)_$6 -> !_$6.text().equalsIgnoreCase("__includes"));
        if (includesPositionedTokens.isEmpty()) {
            return (Seq)((SeqOps)Nil$.MODULE$);
        }
        includesPositionedTokens.next();
        Iterator includesWithoutComments = includesPositionedTokens.filter((Function1 & Serializable)_$7 -> {
            TokenType tokenType = _$7.tpe();
            TokenType$Comment$ tokenType$Comment$ = TokenType$Comment$.MODULE$;
            return tokenType == null ? tokenType$Comment$ != null : !tokenType.equals(tokenType$Comment$);
        });
        TokenType tokenType = ((Token)includesWithoutComments.next()).tpe();
        TokenType$OpenBracket$ tokenType$OpenBracket$ = TokenType$OpenBracket$.MODULE$;
        if (tokenType == null ? tokenType$OpenBracket$ != null : !tokenType.equals(tokenType$OpenBracket$)) {
            throw Fail$.MODULE$.exception("Did not find expected open bracket for __includes declaration", (SourceLocatable)tokens.next());
        }
        return includesWithoutComments.takeWhile((Function1 & Serializable)_$8 -> {
            TokenType tokenType = _$8.tpe();
            TokenType$CloseBracket$ tokenType$CloseBracket$ = TokenType$CloseBracket$.MODULE$;
            return tokenType == null ? tokenType$CloseBracket$ != null : !tokenType.equals(tokenType$CloseBracket$);
        }).filter((Function1 & Serializable)_$9 -> {
            TokenType tokenType = _$9.tpe();
            TokenType$Literal$ tokenType$Literal$ = TokenType$Literal$.MODULE$;
            return !(tokenType != null ? !tokenType.equals(tokenType$Literal$) : tokenType$Literal$ != null);
        }).map((Function1 & Serializable)_$10 -> _$10.value()).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof String) {
                    String s = (String)object;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof String) {
                    String s = (String)object;
                    return PathUtils$.MODULE$.standardize(StructureParser$.MODULE$.resolveIncludePath(s));
                }
                return function1.apply(x);
            }
        }).toSeq();
    }

    public String resolveIncludePath(String path) {
        String name = System.getProperty("os.name");
        if (name == null || name.startsWith("Windows")) {
            return path;
        }
        return path.replaceFirst("^~", System.getProperty("user.home"));
    }

    public Seq<String> findExtensions(Iterator<Token> tokens) {
        Iterator openBracket;
        block3: {
            block2: {
                openBracket = tokens.dropWhile((Function1 & Serializable)_$11 -> !_$11.text().equalsIgnoreCase("extensions")).drop(1).dropWhile((Function1 & Serializable)_$12 -> {
                    TokenType tokenType = _$12.tpe();
                    TokenType$Comment$ tokenType$Comment$ = TokenType$Comment$.MODULE$;
                    return !(tokenType != null ? !tokenType.equals(tokenType$Comment$) : tokenType$Comment$ != null);
                });
                if (openBracket.isEmpty()) break block2;
                TokenType tokenType = ((Token)openBracket.next()).tpe();
                TokenType$OpenBracket$ tokenType$OpenBracket$ = TokenType$OpenBracket$.MODULE$;
                if (!(tokenType == null ? tokenType$OpenBracket$ != null : !tokenType.equals(tokenType$OpenBracket$))) break block3;
            }
            return (Seq)((SeqOps)Nil$.MODULE$);
        }
        return openBracket.takeWhile((Function1 & Serializable)_$13 -> {
            TokenType tokenType = _$13.tpe();
            TokenType$CloseBracket$ tokenType$CloseBracket$ = TokenType$CloseBracket$.MODULE$;
            return tokenType == null ? tokenType$CloseBracket$ != null : !tokenType.equals(tokenType$CloseBracket$);
        }).filter((Function1 & Serializable)_$14 -> {
            TokenType tokenType = _$14.tpe();
            TokenType$Ident$ tokenType$Ident$ = TokenType$Ident$.MODULE$;
            return !(tokenType != null ? !tokenType.equals(tokenType$Ident$) : tokenType$Ident$ != null);
        }).map((Function1 & Serializable)_$15 -> _$15.value().toString()).toSeq();
    }

    private static final String parseSources$$anonfun$1$$anonfun$1$$anonfun$1() {
        return MODULE$.IncludeFilesEndInNLS();
    }

    private static final StructureResults parseSources$$anonfun$1(CompilationOperand compilationData$1, TokenizerInterface tokenizer$1, Function2 includeFile$1) {
        StructureParser structureParser = new StructureParser(compilationData$1.displayName(), compilationData$1.subprogram());
        StructureResults firstResults = (StructureResults)compilationData$1.sources().foldLeft((Object)StructureResults$.MODULE$.apply(compilationData$1.containingProgram(), compilationData$1.oldProcedures(), StructureResults$.MODULE$.$lessinit$greater$default$3(), StructureResults$.MODULE$.$lessinit$greater$default$4(), StructureResults$.MODULE$.$lessinit$greater$default$5(), StructureResults$.MODULE$.$lessinit$greater$default$6()), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                StructureResults results = (StructureResults)tuple2._1();
                if (tuple22 != null) {
                    String filename = (String)tuple22._1();
                    String source = (String)tuple22._2();
                    return MODULE$.parseOne(tokenizer$1, structureParser, source, filename, results);
                }
            }
            throw new MatchError((Object)tuple2);
        });
        if (compilationData$1.subprogram()) {
            return firstResults;
        }
        return (StructureResults)package$.MODULE$.Iterator().iterate((Object)firstResults, (Function1 & Serializable)results -> {
            Tuple2 tuple2;
            String suppliedPath = MODULE$.resolveIncludePath((String)((Token)results.includes().head()).value());
            Fail$.MODULE$.cAssert(suppliedPath.endsWith(".nls"), (Function0<String>)((Function0 & Serializable)StructureParser$::parseSources$$anonfun$1$$anonfun$1$$anonfun$1), (SourceLocatable)results.includes().head());
            Option option = (Option)includeFile$1.apply((Object)compilationData$1.compilationEnvironment(), (Object)suppliedPath);
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                String path = (String)tuple2._1();
                String fileContents = (String)tuple2._2();
                Seq seq = (Seq)results.includes().tail();
                Seq seq2 = (Seq)results.includedSources().$colon$plus((Object)suppliedPath);
                Program program = results.copy$default$1();
                ListMap<String, FrontEndProcedure> listMap = results.copy$default$2();
                Map<String, Iterable<Token>> map = results.copy$default$3();
                Seq<Token> seq3 = results.copy$default$6();
                return MODULE$.parseOne(tokenizer$1, structureParser, fileContents, path, results.copy(program, listMap, map, (Seq<Token>)seq, (Seq<String>)seq2, seq3));
            }
            if (None$.MODULE$.equals(option)) {
                throw Fail$.MODULE$.exception(I18N$.MODULE$.errors().getN("compiler.StructureParser.includeNotFound", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{suppliedPath})), (SourceLocatable)results.includes().head());
            }
            throw new MatchError((Object)option);
        }).dropWhile((Function1 & Serializable)_$1 -> _$1.includes().nonEmpty()).next();
    }

    private final Option procedureSyntax$1(Seq tokens) {
        Token ident = (Token)tokens.apply(1);
        TokenType tokenType = ident.tpe();
        TokenType$Ident$ tokenType$Ident$ = TokenType$Ident$.MODULE$;
        if (!(tokenType != null ? !tokenType.equals(tokenType$Ident$) : tokenType$Ident$ != null)) {
            return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)ident.text(), (Object)ProcedureSyntax$.MODULE$.apply((Token)tokens.head(), ident, (Token)tokens.last())));
        }
        return None$.MODULE$;
    }

    private final Seq splitOnProcedureStarts$1(Seq tokens, Seq existingProcs) {
        while (true) {
            block11: {
                Seq remainingTokens;
                int sizeToEnd;
                Tuple2 tuple2;
                block10: {
                    Object headValue;
                    block9: {
                        block8: {
                            if (tokens.isEmpty()) break block8;
                            TokenType tokenType = ((Token)tokens.head()).tpe();
                            TokenType$Eof$ tokenType$Eof$ = TokenType$Eof$.MODULE$;
                            if (tokenType != null ? !tokenType.equals(tokenType$Eof$) : tokenType$Eof$ != null) break block9;
                        }
                        return existingProcs;
                    }
                    Object object = headValue = ((Token)tokens.head()).value();
                    String string = "TO";
                    if (!(object == null ? string != null : !object.equals(string))) break block10;
                    Object object2 = headValue;
                    String string2 = "TO-REPORT";
                    if (object2 != null ? !object2.equals(string2) : string2 != null) break block11;
                }
                if ((tuple2 = tokens.splitAt((sizeToEnd = ((SeqOps)tokens.takeWhile((Function1 & Serializable)t -> {
                    Object object = t.value();
                    String string = "END";
                    return object == null ? string != null : !object.equals(string);
                })).size()) + 1)) == null) {
                    throw new MatchError((Object)tuple2);
                }
                Seq procedureTokens = (Seq)tuple2._1();
                Seq remainingTokens2 = (Seq)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)procedureTokens, (Object)remainingTokens2);
                Seq procedureTokens2 = (Seq)tuple22._1();
                Seq seq = remainingTokens = (Seq)tuple22._2();
                Seq seq2 = (Seq)existingProcs.$colon$plus((Object)procedureTokens2);
                tokens = seq;
                existingProcs = seq2;
                continue;
            }
            tokens = (Seq)tokens.dropWhile((Function1 & Serializable)t -> {
                Object object = t.value();
                String string = "TO";
                if (object == null) {
                    if (string == null) return false;
                } else if (object.equals(string)) return false;
                Object object2 = t.value();
                String string2 = "TO-REPORT";
                if (object2 == null) {
                    if (string2 == null) return false;
                    return true;
                } else if (object2.equals(string2)) return false;
                return true;
            });
        }
    }
}

