/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.plot;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import org.nlogo.plot.Plot;
import org.nlogo.plot.PlotPen;
import org.nlogo.plot.PlotPen$;
import org.nlogo.plot.PlotPoint;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BooleanRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class PlotPainter {
    private final Plot plot;
    private Graphics gOff;
    private BufferedImage offScreenImage;
    private int height;
    private int width;

    public PlotPainter(Plot plot) {
        this.plot = plot;
        this.gOff = null;
        this.offScreenImage = null;
        this.height = 0;
        this.width = 0;
    }

    public void setupOffscreenImage(int width, int height) {
        if ((this.offScreenImage == null || this.width != width || this.height != height) && width > 0 && height > 0) {
            this.width = width;
            this.height = height;
            if (this.offScreenImage != null) {
                this.offScreenImage.flush();
                this.offScreenImage = null;
            }
            this.offScreenImage = new BufferedImage(width, height, 2);
            if (this.gOff != null) {
                this.gOff.dispose();
            }
            this.gOff = this.offScreenImage.getGraphics();
            this.gOff.setColor(new Color(this.plot.backgroundColor()));
            this.gOff.fillRect(0, 0, width, height);
            this.refresh();
            return;
        }
    }

    public void drawImage(Graphics g) {
        g.drawImage(this.offScreenImage, 0, 0, null);
    }

    public void refresh() {
        if (this.gOff != null) {
            this.gOff.setColor(new Color(this.plot.backgroundColor()));
            this.gOff.fillRect(0, 0, this.offScreenImage.getWidth(), this.offScreenImage.getHeight());
            this.plot.pens().withFilter((Function1 & Serializable)pen -> !pen.hidden()).foreach(pen -> {
                pen.penModeChanged_$eq(false);
                this.refreshPen((PlotPen)pen, this.collectPointsForPainting((PlotPen)pen));
            });
            return;
        }
    }

    private Seq<PlotPoint> collectPointsForPainting(PlotPen pen) {
        int n = pen.mode();
        if (PlotPen$.MODULE$.POINT_MODE() == n || PlotPen$.MODULE$.LINE_MODE() == n) {
            return (Vector)pen.points().toSeq();
        }
        if (PlotPen$.MODULE$.BAR_MODE() == n) {
            return (Vector)((Seq)pen.points().flatMap((Function1 & Serializable)old -> {
                double d = old.x() + pen.interval();
                double d2 = old.copy$default$2();
                int n = old.copy$default$4();
                return (SeqOps)new .colon.colon((Object)old.copy(old.copy$default$1(), 0.0, true, old.copy$default$4()), (List)new .colon.colon((Object)old.copy(old.copy$default$1(), old.copy$default$2(), true, old.copy$default$4()), (List)new .colon.colon((Object)old.copy(d, d2, true, n), (List)new .colon.colon((Object)old.copy(old.x() + pen.interval(), 0.0, true, old.copy$default$4()), (List)Nil$.MODULE$))));
            })).toSeq();
        }
        int m = n;
        throw new IllegalStateException();
    }

    private void refreshPen(PlotPen pen, Seq<PlotPoint> pointsToPlot) {
        if (this.gOff == null) {
            return;
        }
        ObjectRef last = ObjectRef.create(null);
        IntRef color = IntRef.create((int)0);
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(0, 0);
        IntRef minY = IntRef.create((int)sp2._1$mcI$sp());
        IntRef maxY = IntRef.create((int)sp2._2$mcI$sp());
        BooleanRef coalescing = BooleanRef.create((boolean)false);
        ((Graphics2D)this.gOff).setRenderingHint(RenderingHints.KEY_ANTIALIASING, pen.mode() == PlotPen$.MODULE$.POINT_MODE() ? RenderingHints.VALUE_ANTIALIAS_OFF : RenderingHints.VALUE_ANTIALIAS_ON);
        int size = pointsToPlot.size();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), size).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            PlotPoint next = (PlotPoint)pointsToPlot.apply(i);
            if (next.color() != color$2.elem) {
                color$2.elem = next.color();
                this.gOff.setColor(new Color(color$2.elem));
            }
            if (pen.mode() == PlotPen$.MODULE$.POINT_MODE()) {
                this.drawPoint(this.gOff, next);
            } else if ((PlotPoint)last$1.elem == null) {
                if (next.isDown()) {
                    this.drawEdge(this.gOff, next, next);
                }
            } else if (i != size - 1 && this.screenX(((PlotPoint)last$1.elem).x()) == this.screenX(next.x()) && ((PlotPoint)last$1.elem).color() == next.color() && ((PlotPoint)last$1.elem).isDown() && next.isDown()) {
                int y = this.screenY(next.y());
                if (coalescing$1.elem) {
                    if (y < minY$1.elem) {
                        minY$1.elem = y;
                    }
                    if (y > maxY$1.elem) {
                        maxY$1.elem = y;
                    }
                } else {
                    ((Graphics2D)this.gOff).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    this.drawEdge(this.gOff, (PlotPoint)last$1.elem, next);
                    coalescing$1.elem = true;
                    minY$1.elem = y;
                    maxY$1.elem = y;
                }
            } else {
                if (coalescing$1.elem) {
                    this.gOff.setColor(new Color(((PlotPoint)last$1.elem).color()));
                    this.gOff.fillRect(this.screenX(((PlotPoint)last$1.elem).x()), minY$1.elem, 1, maxY$1.elem - minY$1.elem + 1);
                    coalescing$1.elem = false;
                    ((Graphics2D)this.gOff).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    this.gOff.setColor(new Color(color$2.elem));
                }
                if (next.isDown()) {
                    this.drawEdge(this.gOff, (PlotPoint)last$1.elem, next);
                }
            }
            last$1.elem = next;
        });
    }

    private void drawPoint(Graphics g, PlotPoint p) {
        g.drawRect(this.screenX(p.x()), this.screenY(p.y()), 1, 1);
    }

    private void drawEdge(Graphics g, PlotPoint p1, PlotPoint p2) {
        int x1 = this.screenX(p1.x());
        int y1 = this.screenY(p1.y());
        int x2 = this.screenX(p2.x());
        int y2 = this.screenY(p2.y());
        if (!(x1 < 0 && x2 < 0 || x1 > this.width && x2 > this.width || y1 < 0 && y2 < 0 || y1 > this.height && y2 > this.height)) {
            g.drawLine(x1, y1, x2, y2);
            return;
        }
    }

    private int screenX(double x) {
        double range = this.plot.xMax() - this.plot.xMin();
        double scale = range / (double)(this.width - 1);
        return this.screen(StrictMath.rint((x - this.plot.xMin()) / scale));
    }

    private int screenY(double y) {
        double range = this.plot.yMax() - this.plot.yMin();
        double scale = range / (double)(this.height - 1);
        return this.screen(StrictMath.rint((double)(this.height - 1) - (y - this.plot.yMin()) / scale));
    }

    private int screen(double p) {
        if (p > (double)16383) {
            return 16383;
        }
        if (p < (double)-16383) {
            return -16383;
        }
        return (int)p;
    }
}

