/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.plot;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.nlogo.api.PlotPenInterface;
import org.nlogo.api.StringUtils$;
import org.nlogo.core.PlotPenState;
import org.nlogo.core.PlotPenState$;
import org.nlogo.plot.Plot;
import org.nlogo.plot.PlotPen$;
import org.nlogo.plot.PlotPoint;
import org.nlogo.plot.PlotPoint$;
import scala.None$;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public class PlotPen
implements PlotPenInterface,
Serializable {
    private static final long serialVersionUID = 0L;
    private Plot plot;
    private String name;
    private boolean temporary;
    private String setupCode;
    private String updateCode;
    private double x;
    private int defaultColor;
    private int _color;
    private boolean inLegend;
    private double defaultInterval;
    private double _interval;
    private int defaultMode;
    private int _mode;
    private boolean penModeChanged;
    private boolean _isDown;
    private boolean _hidden;
    private Option<Exception> _runtimeError;
    private Vector<PlotPoint> points;

    public static int BAR_MODE() {
        return PlotPen$.MODULE$.BAR_MODE();
    }

    public static int LINE_MODE() {
        return PlotPen$.MODULE$.LINE_MODE();
    }

    public static int POINT_MODE() {
        return PlotPen$.MODULE$.POINT_MODE();
    }

    public static boolean isValidPlotPenMode(int n) {
        return PlotPen$.MODULE$.isValidPlotPenMode(n);
    }

    public static double $lessinit$greater$default$6() {
        return PlotPen$.MODULE$.$lessinit$greater$default$6();
    }

    public static int $lessinit$greater$default$7() {
        return PlotPen$.MODULE$.$lessinit$greater$default$7();
    }

    public static int $lessinit$greater$default$8() {
        return PlotPen$.MODULE$.$lessinit$greater$default$8();
    }

    public static boolean $lessinit$greater$default$9() {
        return PlotPen$.MODULE$.$lessinit$greater$default$9();
    }

    public static double $lessinit$greater$default$10() {
        return PlotPen$.MODULE$.$lessinit$greater$default$10();
    }

    public static double $lessinit$greater$default$11() {
        return PlotPen$.MODULE$.$lessinit$greater$default$11();
    }

    public static int $lessinit$greater$default$12() {
        return PlotPen$.MODULE$.$lessinit$greater$default$12();
    }

    public static int $lessinit$greater$default$13() {
        return PlotPen$.MODULE$.$lessinit$greater$default$13();
    }

    public static boolean $lessinit$greater$default$14() {
        return PlotPen$.MODULE$.$lessinit$greater$default$14();
    }

    public static boolean $lessinit$greater$default$15() {
        return PlotPen$.MODULE$.$lessinit$greater$default$15();
    }

    public static boolean $lessinit$greater$default$16() {
        return PlotPen$.MODULE$.$lessinit$greater$default$16();
    }

    public PlotPen(Plot plot, String name, boolean temporary, String setupCode, String updateCode, double x, int defaultColor, int _color, boolean inLegend, double defaultInterval, double _interval, int defaultMode, int _mode, boolean penModeChanged, boolean _isDown, boolean _hidden) {
        this.plot = plot;
        this.name = name;
        this.temporary = temporary;
        this.setupCode = setupCode;
        this.updateCode = updateCode;
        this.x = x;
        this.defaultColor = defaultColor;
        this._color = _color;
        this.inLegend = inLegend;
        this.defaultInterval = defaultInterval;
        this._interval = _interval;
        this.defaultMode = defaultMode;
        this._mode = _mode;
        this.penModeChanged = penModeChanged;
        this._isDown = _isDown;
        this._hidden = _hidden;
        this._runtimeError = None$.MODULE$;
        this.hardReset();
        this.plot().addPen(this);
        this.points = (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    public Plot plot() {
        return this.plot;
    }

    public void plot_$eq(Plot x$1) {
        this.plot = x$1;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void name_$eq(String x$1) {
        this.name = x$1;
    }

    public boolean temporary() {
        return this.temporary;
    }

    public void temporary_$eq(boolean x$1) {
        this.temporary = x$1;
    }

    public String setupCode() {
        return this.setupCode;
    }

    public void setupCode_$eq(String x$1) {
        this.setupCode = x$1;
    }

    public String updateCode() {
        return this.updateCode;
    }

    public void updateCode_$eq(String x$1) {
        this.updateCode = x$1;
    }

    public double x() {
        return this.x;
    }

    public void x_$eq(double x$1) {
        this.x = x$1;
    }

    public int defaultColor() {
        return this.defaultColor;
    }

    public void defaultColor_$eq(int x$1) {
        this.defaultColor = x$1;
    }

    private int _color() {
        return this._color;
    }

    private void _color_$eq(int x$0) {
        this._color = x$0;
    }

    public boolean inLegend() {
        return this.inLegend;
    }

    public void inLegend_$eq(boolean x$1) {
        this.inLegend = x$1;
    }

    public double defaultInterval() {
        return this.defaultInterval;
    }

    public void defaultInterval_$eq(double x$1) {
        this.defaultInterval = x$1;
    }

    private double _interval() {
        return this._interval;
    }

    private void _interval_$eq(double x$0) {
        this._interval = x$0;
    }

    public int defaultMode() {
        return this.defaultMode;
    }

    public void defaultMode_$eq(int x$1) {
        this.defaultMode = x$1;
    }

    private int _mode() {
        return this._mode;
    }

    private void _mode_$eq(int x$0) {
        this._mode = x$0;
    }

    public boolean penModeChanged() {
        return this.penModeChanged;
    }

    public void penModeChanged_$eq(boolean x$1) {
        this.penModeChanged = x$1;
    }

    private boolean _isDown() {
        return this._isDown;
    }

    private void _isDown_$eq(boolean x$0) {
        this._isDown = x$0;
    }

    private boolean _hidden() {
        return this._hidden;
    }

    private void _hidden_$eq(boolean x$0) {
        this._hidden = x$0;
    }

    public String toString() {
        return "PlotPen(" + this.name() + ", " + this.plot() + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof PlotPen)) return false;
        PlotPen pen = (PlotPen)object;
        String string = this.name();
        String string2 = pen.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.setupCode();
        String string4 = pen.setupCode();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = this.updateCode();
        String string6 = pen.updateCode();
        if (string5 == null) {
            if (string6 != null) {
                return false;
            }
        } else if (!string5.equals(string6)) return false;
        if (this.defaultColor() != pen.defaultColor()) return false;
        if (this.inLegend() != pen.inLegend()) return false;
        if (this.defaultInterval() != pen.defaultInterval()) return false;
        if (this.defaultMode() != pen.defaultMode()) return false;
        return true;
    }

    @Override
    public PlotPenState state() {
        return PlotPenState$.MODULE$.apply(this.x(), this._color(), this._interval(), this._mode(), this._isDown(), this._hidden());
    }

    @Override
    public void state_$eq(PlotPenState s) {
        this.x_$eq(s.x());
        this.color_$eq(s.color());
        this.interval_$eq(s.interval());
        this.mode_$eq(s.mode());
        this.isDown_$eq(s.isDown());
        this.hidden_$eq(s.hidden());
    }

    public Vector<PlotPoint> points() {
        return this.points;
    }

    public void points_$eq(Vector<PlotPoint> x$1) {
        this.points = x$1;
    }

    public int color() {
        return this._color();
    }

    public void color_$eq(int newColor) {
        if (this._color() != newColor) {
            this._color_$eq(newColor);
            this.plot().pensDirty_$eq(true);
            this.plot().plotListener().foreach(_$1 -> _$1.setPenColor(newColor));
            return;
        }
    }

    public double interval() {
        return this._interval();
    }

    public void interval_$eq(double newInterval) {
        this._interval_$eq(newInterval);
        this.plot().plotListener().foreach(_$2 -> _$2.setInterval(newInterval));
    }

    public boolean hidden() {
        return this._hidden();
    }

    public void hidden_$eq(boolean newIsHidden) {
        if (this._hidden() != newIsHidden) {
            this._hidden_$eq(newIsHidden);
            this.plot().pensDirty_$eq(true);
            return;
        }
    }

    public boolean isDown() {
        return this._isDown();
    }

    public void isDown_$eq(boolean newIsDown) {
        this._isDown_$eq(newIsDown);
        this.plot().plotListener().foreach(_$3 -> _$3.penDown(newIsDown));
    }

    public int mode() {
        return this._mode();
    }

    public void mode_$eq(int newMode) {
        if (this.mode() != newMode) {
            this.penModeChanged_$eq(true);
            this._mode_$eq(newMode);
            this.plot().makeDirty();
            this.plot().plotListener().foreach(_$4 -> _$4.plotPenMode(newMode));
            return;
        }
    }

    public void setupCode(String code) {
        this.setupCode_$eq(code == null ? "" : code);
    }

    public void updateCode(String code) {
        this.updateCode_$eq(code == null ? "" : code);
    }

    public String saveString() {
        return "\"" + StringUtils$.MODULE$.escapeString(this.setupCode().trim()) + "\" \"" + StringUtils$.MODULE$.escapeString(this.updateCode().trim()) + "\"";
    }

    public void hardReset() {
        this.softReset();
        if (!this.temporary()) {
            this.color_$eq(this.defaultColor());
            this.mode_$eq(this.defaultMode());
            this.interval_$eq(this.defaultInterval());
            return;
        }
    }

    public void plotListenerReset(boolean hardReset) {
        this.plot().plotListener().foreach(_$5 -> _$5.resetPen(hardReset));
    }

    public void softReset() {
        this.x_$eq(0.0);
        this.isDown_$eq(true);
        this.points_$eq((Vector<PlotPoint>)((Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]))));
        this.runtimeError_$eq((Option<Exception>)None$.MODULE$);
    }

    public void plot(double y) {
        if (this.points().nonEmpty()) {
            this.x_$eq(this.x() + this.interval());
        }
        this.plot(this.x(), y);
    }

    public void plot(double x, double y) {
        this.x_$eq(x);
        this.points_$eq((Vector<PlotPoint>)((Vector)this.points().$colon$plus((Object)PlotPoint$.MODULE$.apply(x, y, this.isDown(), this.color()))));
        if (this.isDown()) {
            this.plot().perhapsGrowRanges(this, x, y);
        }
        this.plot().plotListener().foreach(_$6 -> _$6.plot(x, y));
    }

    @Override
    public void plot(double x, double y, int color, boolean isDown) {
        this.points_$eq((Vector<PlotPoint>)((Vector)this.points().$colon$plus((Object)PlotPoint$.MODULE$.apply(x, y, isDown, color))));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.name());
        out.writeBoolean(this.temporary());
        out.writeDouble(this.x());
        out.writeInt(this.color());
        out.writeObject(this.points());
        out.writeDouble(this.interval());
        out.writeBoolean(this.isDown());
        out.writeInt(this.mode());
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        this.name_$eq((String)in.readObject());
        this.temporary_$eq(in.readBoolean());
        this.x_$eq(in.readDouble());
        this._color_$eq(in.readInt());
        this.points_$eq((Vector<PlotPoint>)this.readPointList(in).toVector());
        this._interval_$eq(in.readDouble());
        this._isDown_$eq(in.readBoolean());
        this._mode_$eq(in.readInt());
    }

    public Seq<PlotPoint> readPointList(ObjectInputStream in) throws ClassNotFoundException, IOException {
        return (Seq)in.readObject();
    }

    public Option<Exception> runtimeError() {
        return this._runtimeError;
    }

    public void runtimeError_$eq(Option<Exception> e) {
        this._runtimeError = e;
    }
}

