/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Base64;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import org.nlogo.api.Color$;
import org.nlogo.api.Dump$;
import org.nlogo.api.Graphics2DWrapper;
import org.nlogo.api.World;
import org.nlogo.core.File;
import org.nlogo.render.LinkDrawer;
import org.nlogo.render.TrailDrawerJ;
import org.nlogo.render.TurtleDrawer;
import scala.Array;
import scala.Array$;
import scala.Float$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.util.matching.Regex;

public class TrailDrawer
extends TrailDrawerJ {
    private final World world;

    public TrailDrawer(World world, TurtleDrawer turtleDrawer, LinkDrawer linkDrawer) {
        this.world = world;
        super(world, turtleDrawer, linkDrawer);
    }

    @Override
    public void exportDrawingToCSV(PrintWriter writer) {
        if (!this.drawingBlank) {
            String patchSize = Double.toString(this.world.patchSize());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.drawingImage, "png", baos);
            baos.flush();
            byte[] bytes = baos.toByteArray();
            baos.close();
            String base64 = "data:image/png;base64," + Base64.getEncoder().encodeToString(bytes);
            ((SeqOps)new .colon.colon((Object)"DRAWING", (List)new .colon.colon((Object)patchSize, (List)new .colon.colon((Object)base64, (List)Nil$.MODULE$)))).foreach(line -> writer.println(Dump$.MODULE$.csv().encode((String)line)));
        }
        writer.println();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void importDrawingBase64(String base64) throws IOException {
        Tuple2 tuple2;
        String[] arr = base64.split(",");
        String[] stringArray = arr;
        if (stringArray == null) throw new Exception("Invalid base64 string");
        Object object = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 1) == 0) {
            String string;
            String rb64 = string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
            tuple2 = Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)rb64);
        } else {
            String string;
            List list;
            Option option;
            if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 2) != 0) throw new Exception("Invalid base64 string");
            String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
            String string3 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
            String prefix = string2;
            String rb64 = string3;
            Regex MimeRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^data:(.*?);base64$"));
            String string4 = prefix;
            if (string4 == null || (option = MimeRegex.unapplySeq((CharSequence)string4)).isEmpty() || (list = (List)option.get()).lengthCompare(1) != 0) {
                throw new MatchError((Object)string4);
            }
            String mime = string = (String)list.apply(0);
            String mime2 = mime;
            tuple2 = Tuple2$.MODULE$.apply((Object)Option$.MODULE$.apply((Object)mime2), (Object)rb64);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Option mimeOpt = (Option)tuple22._1();
        String rawBase64 = (String)tuple22._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)mimeOpt, (Object)rawBase64);
        Option mimeOpt2 = (Option)tuple23._1();
        String rawBase642 = (String)tuple23._2();
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.getDecoder().decode(rawBase642));
        this.importDrawing(bais, (Option<String>)mimeOpt2);
    }

    @Override
    public void importDrawing(InputStream is, Option<String> mimeType) throws IOException {
        BufferedImage bufferedImage;
        float scaley;
        float scale;
        BufferedImage image;
        if (this.drawingImage == null) {
            this.setUpDrawingImage();
        }
        if ((image = ImageIO.read(is)) == null) {
            throw new IIOException("Unsupported image format.");
        }
        float scalex = (float)this.getWidth() / (float)image.getWidth();
        float f = scale = scalex < (scaley = (float)this.getHeight() / (float)image.getHeight()) ? scalex : scaley;
        if (scale == 1.0f) {
            bufferedImage = image;
        } else {
            AffineTransformOp trans = new AffineTransformOp(AffineTransform.getScaleInstance(Float$.MODULE$.float2double(scale), Float$.MODULE$.float2double(scale)), 2);
            if (image.getColorModel().getColorSpace().getType() == 6 && !image.getColorModel().hasAlpha()) {
                BufferedImage scaled = trans.createCompatibleDestImage(image, image.getColorModel());
                trans.filter(image, scaled);
                bufferedImage = scaled;
            } else {
                bufferedImage = trans.filter(image, null);
            }
        }
        BufferedImage scaledImage = bufferedImage;
        int xOffset = (this.getWidth() - scaledImage.getWidth()) / 2;
        int yOffset = (this.getHeight() - scaledImage.getHeight()) / 2;
        this.drawingImage.createGraphics().drawImage((Image)scaledImage, xOffset, yOffset, null);
        this.markDirty();
        this.sendPixels(true);
    }

    @Override
    public Option<String> importDrawing$default$2() {
        return None$.MODULE$;
    }

    @Override
    public void importDrawing(File file) throws IOException {
        try {
            this.importDrawing(file.getInputStream(), this.importDrawing$default$2());
        }
        catch (IIOException ex) {
            throw new IIOException("Unsupported image format: " + file.getPath(), ex);
        }
    }

    @Override
    public void setColors(int[] colors, int width, int height) {
        this.setUpDrawingImage();
        BufferedImage image = new BufferedImage(width, height, 2);
        image.setRGB(0, 0, width, height, colors, 0, width);
        this.drawingImage.createGraphics().drawImage((Image)image, 0, 0, null);
        this.drawingBlank = false;
        this.drawingDirty = true;
        this.sendPixels(true);
    }

    @Override
    public void clearDrawing() {
        if (this.drawingImage != null) {
            this.setUpDrawingImage();
            return;
        }
    }

    @Override
    public void rescaleDrawing() {
        BufferedImage oldImage = this.drawingImage;
        this.setUpDrawingImage();
        if (oldImage != null && this.drawingImage != null) {
            this.drawingImage.createGraphics().drawImage(oldImage, 0, 0, this.width, this.height, null);
            this.drawingDirty = true;
            return;
        }
    }

    @Override
    public BufferedImage getAndCreateDrawing(boolean dirty) {
        if (this.drawingImage == null) {
            this.setUpDrawingImage();
        }
        if (dirty) {
            this.drawingBlank = false;
            this.drawingDirty = true;
        }
        return this.drawingImage;
    }

    @Override
    public void readImage(InputStream is) throws IOException {
        this.setUpDrawingImage();
        this.readImage(ImageIO.read(is));
    }

    @Override
    public void drawLine(double x1, double y1, double x2, double y2, Object penColor, double penSize, String penMode) {
        if (this.drawingImage == null) {
            this.setUpDrawingImage();
        }
        Graphics2DWrapper tg = new Graphics2DWrapper((Graphics2D)this.drawingImage.getGraphics());
        tg.setPenWidth(penSize);
        if (penMode.equals("erase")) {
            tg.setComposite(AlphaComposite.Clear);
            this.drawWrappedLine(tg, x1, y1, x2, y2, penSize);
            tg.setComposite(AlphaComposite.SrcOver);
            return;
        }
        tg.antiAliasing(true);
        tg.setColor(Color$.MODULE$.getColor(penColor));
        this.drawWrappedLine(tg, x1, y1, x2, y2, penSize);
        tg.antiAliasing(false);
    }

    private void setUpDrawingImage() {
        BufferedImage bufferedImage;
        this.width = (int)StrictMath.round(this.world.patchSize() * (double)this.world.worldWidth());
        this.height = (int)StrictMath.round(this.world.patchSize() * (double)this.world.worldHeight());
        if (this.width > 0 && this.height > 0) {
            this.colorArray = null;
            bufferedImage = new BufferedImage(this.width, this.height, 2);
        } else {
            bufferedImage = null;
        }
        this.drawingImage = bufferedImage;
        this.drawingBlank = true;
    }
}

