/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import org.nlogo.api.Agent;
import org.nlogo.api.Graphics2DWrapper;
import org.nlogo.api.Link;
import org.nlogo.api.Perspective;
import org.nlogo.api.TrailDrawerInterface;
import org.nlogo.api.Turtle;
import org.nlogo.api.ViewSettings;
import org.nlogo.api.WorkspaceContext;
import org.nlogo.api.World;
import org.nlogo.render.LinkDrawer;
import org.nlogo.render.TopologyRenderer;
import org.nlogo.render.TurtleDrawer;

public abstract class TrailDrawerJ
implements TrailDrawerInterface,
ViewSettings {
    private final World world;
    protected BufferedImage drawingImage = null;
    protected int width;
    protected int height;
    int[] colorArray = null;
    public TopologyRenderer topology;
    private final TurtleDrawer turtleDrawer;
    private final LinkDrawer linkDrawer;
    protected boolean drawingDirty = false;
    protected boolean drawingBlank = true;
    protected boolean _sendPixels = false;

    public TrailDrawerJ(World world, TurtleDrawer turtleDrawer, LinkDrawer linkDrawer) {
        this.world = world;
        this.turtleDrawer = turtleDrawer;
        this.linkDrawer = linkDrawer;
    }

    @Override
    public int[] colors() {
        if (this.drawingDirty) {
            if (this.colorArray == null) {
                this.colorArray = new int[this.width * this.height * 4];
            }
            WritableRaster raster = this.drawingImage.getRaster();
            raster.getDataElements(0, 0, this.width, this.height, this.colorArray);
        }
        return this.colorArray;
    }

    public void setTopology(TopologyRenderer topology) {
        this.topology = topology;
    }

    @Override
    public boolean sendPixels() {
        return this._sendPixels;
    }

    @Override
    public void sendPixels(boolean dirty) {
        this._sendPixels = dirty;
    }

    @Override
    public boolean isDirty() {
        return this.drawingDirty;
    }

    @Override
    public boolean isBlank() {
        return this.drawingBlank;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void markDirty() {
        this.drawingBlank = false;
        this.drawingDirty = true;
    }

    @Override
    public void markClean() {
        this.drawingDirty = false;
    }

    @Override
    public Object getDrawing() {
        return this.drawingImage;
    }

    @Override
    public void readImage(BufferedImage image) throws IOException {
        Graphics2D dg = this.drawingImage.createGraphics();
        dg.drawImage((Image)image, 0, 0, null);
        this.drawingBlank = false;
        this.drawingDirty = true;
    }

    @Override
    public void stamp(Agent agent, boolean erase) {
        Graphics2DWrapper tg = new Graphics2DWrapper(this.getAndCreateDrawing(false).createGraphics());
        tg.antiAliasing(true);
        tg.setComposite(erase ? AlphaComposite.Clear : AlphaComposite.SrcOver);
        this.topology.prepareToPaint(this, this.width, this.height);
        if (agent instanceof Turtle) {
            this.turtleDrawer.drawTurtleShape(tg, this.topology, (Turtle)agent, this.world.patchSize());
        } else if (agent instanceof Link) {
            this.linkDrawer.drawLink(tg, this.topology, (Link)agent, this.world.patchSize(), false);
        }
        tg.antiAliasing(false);
        this.markDirty();
    }

    protected void drawWrappedLine(Graphics2DWrapper tg, double x1, double y1, double x2, double y2, double penSize) {
        double temp;
        double startX = x1;
        double startY = y1;
        double endX = x1;
        double endY = y1;
        if (endX < startX) {
            temp = endX;
            endX = startX;
            startX = temp;
        }
        if (endY < startY) {
            temp = endY;
            endY = startY;
            startY = temp;
        }
        double xdiff = x2 - x1;
        double ydiff = y2 - y1;
        double distX = x2 - x1;
        double distY = y2 - y1;
        double newStartX = 0.0;
        double newStartY = 0.0;
        double maxy = (double)this.world.maxPycor() + 0.4999999;
        double maxx = (double)this.world.maxPxcor() + 0.4999999;
        double miny = (double)this.world.minPycor() - 0.5;
        double minx = (double)this.world.minPxcor() - 0.5;
        double pixelSize = 1.0 / this.world.patchSize();
        int count = 0;
        do {
            endX = startX + distX;
            endY = startY + distY;
            if (endY < miny) {
                endY = miny;
                endX = xdiff * (endY - startY) / ydiff + startX;
                newStartY = maxy;
                newStartX = endX;
                if (newStartX == minx) {
                    newStartX = maxx;
                } else if (newStartX == maxx) {
                    newStartX = minx;
                }
            }
            if (endY > maxy) {
                endY = maxy;
                newStartX = endX = xdiff * (endY - startY) / ydiff + startX;
                newStartY = miny;
                if (newStartX == minx) {
                    newStartX = maxx;
                } else if (newStartX == maxx) {
                    newStartX = minx;
                }
            }
            if (endX < minx) {
                endX = minx;
                endY = ydiff * (endX - startX) / xdiff + startY;
                newStartX = maxx;
                newStartY = endY;
                if (newStartY == miny) {
                    newStartY = maxy;
                } else if (newStartY == maxy) {
                    newStartY = miny;
                }
            }
            if (endX > maxx) {
                endX = maxx;
                endY = ydiff * (endX - startX) / xdiff + startY;
                newStartX = minx;
                newStartY = endY;
                if (newStartY == miny) {
                    newStartY = maxy;
                } else if (newStartY == maxy) {
                    newStartY = miny;
                }
            }
            this.topology.drawLine(tg, startX, startY, endX, endY, penSize);
            startX = newStartX;
            startY = newStartY;
        } while (++count < 100 && (StrictMath.abs(distY -= endY - startY) >= pixelSize || StrictMath.abs(distX -= endX - startX) >= pixelSize));
        this.markDirty();
    }

    @Override
    public int fontSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double patchSize() {
        return this.world.patchSize();
    }

    @Override
    public double viewWidth() {
        return this.world.worldWidth();
    }

    @Override
    public double viewHeight() {
        return this.world.worldHeight();
    }

    @Override
    public Perspective perspective() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double viewOffsetX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double viewOffsetY() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean drawSpotlight() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean renderPerspective() {
        return false;
    }

    @Override
    public WorkspaceContext workspaceContext() {
        throw new UnsupportedOperationException();
    }
}

