/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.core.Shape;
import org.nlogo.core.Shape$;
import org.nlogo.shape.Element;
import scala.Int$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxesRunTime;

public class Line
extends Element
implements Shape.Line {
    private static final long serialVersionUID = 0L;
    private Point start = null;
    private Point end = null;
    private String modifiedPoint = null;

    public Line(Color color) {
        super(color);
    }

    @Override
    public Tuple2<Object, Object> startPoint() {
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)this.start().getX())), (Object)BoxesRunTime.boxToInteger((int)((int)this.start().getY())));
    }

    @Override
    public Tuple2<Object, Object> endPoint() {
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)this.end().getX())), (Object)BoxesRunTime.boxToInteger((int)((int)this.end().getY())));
    }

    private Point start() {
        return this.start;
    }

    private void start_$eq(Point x$0) {
        this.start = x$0;
    }

    private Point end() {
        return this.end;
    }

    private void end_$eq(Point x$0) {
        this.end = x$0;
    }

    public Line(Point start, Point last, Color color) {
        this(color);
        this.start_$eq(start);
        this.end_$eq(last);
    }

    public Line(Color color, boolean marked, Point start, Point end) {
        this(start, end, color);
        this.marked_$eq(marked);
    }

    public Point getStart() {
        return this.start();
    }

    public Point getEnd() {
        return this.end();
    }

    @Override
    public Object clone() {
        Line newLine = (Line)super.clone();
        newLine.start_$eq((Point)newLine.start().clone());
        newLine.end_$eq((Point)newLine.end().clone());
        return newLine;
    }

    @Override
    public Rectangle bounds() {
        return this.createRect(this.start(), this.end());
    }

    @Override
    public Point[] getHandles() {
        return new Point[]{this.start(), this.end()};
    }

    @Override
    public boolean contains(Point p) {
        return new Line2D.Double(this.start(), this.end()).ptSegDist(p) < (double)3;
    }

    @Override
    public void modify(Point start, Point last) {
        this.end().x = last.x;
        this.end().y = last.y;
    }

    @Override
    public void reshapeElement(Point oldPoint, Point newPoint) {
        String string = this.modifiedPoint;
        String string2 = "start";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.start_$eq(newPoint);
        }
        String string3 = this.modifiedPoint;
        String string4 = "end";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            this.end_$eq(newPoint);
            return;
        }
    }

    @Override
    public void setModifiedPoint(Point modified) {
        Point point = modified;
        Point point2 = this.start();
        if (!(point != null ? !((Object)point).equals(point2) : point2 != null)) {
            this.modifiedPoint = "start";
            return;
        }
        Point point3 = modified;
        Point point4 = this.end();
        if (!(point3 != null ? !((Object)point3).equals(point4) : point4 != null)) {
            this.modifiedPoint = "end";
            return;
        }
    }

    @Override
    public void moveElement(int xOffset, int yOffset) {
        Point point = this.start();
        point.x += xOffset;
        Point point2 = this.start();
        point2.y += yOffset;
        Point point3 = this.end();
        point3.x += xOffset;
        Point point4 = this.end();
        point4.y += yOffset;
    }

    @Override
    public void rotateLeft() {
        int temp = this.start().x;
        this.start().x = this.start().y;
        this.start().y = Shape$.MODULE$.Width() - temp;
        temp = this.end().x;
        this.end().x = this.end().y;
        this.end().y = Shape$.MODULE$.Width() - temp;
    }

    @Override
    public void rotateRight() {
        int temp = this.start().x;
        this.start().x = Shape$.MODULE$.Width() - this.start().y;
        this.start().y = temp;
        temp = this.end().x;
        this.end().x = Shape$.MODULE$.Width() - this.end().y;
        this.end().y = temp;
    }

    @Override
    public void flipHorizontal() {
        this.start().x = Shape$.MODULE$.Width() - this.start().x;
        this.end().x = Shape$.MODULE$.Width() - this.end().x;
    }

    @Override
    public void flipVertical() {
        this.start().y = Shape$.MODULE$.Width() - this.start().y;
        this.end().y = Shape$.MODULE$.Width() - this.end().y;
    }

    @Override
    public void draw(GraphicsInterface g, Color turtleColor, double scale, double angle) {
        g.setColor(this.displayColor(turtleColor));
        g.drawLine(Int$.MODULE$.int2double(this.start().x), Int$.MODULE$.int2double(this.start().y), Int$.MODULE$.int2double(this.end().x), Int$.MODULE$.int2double(this.end().y));
    }

    public void fill(GraphicsInterface g) {
    }

    public String toString() {
        return "Line " + this.awtColor().getRGB() + " " + this.marked() + " " + this.start().x + " " + this.start().y + " " + this.end().x + " " + this.end().y;
    }

    @Override
    public String toReadableString() {
        return "Line with color " + this.awtColor() + " and bounds " + this.bounds();
    }
}

