/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.Serializable;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.Link;
import org.nlogo.core.Shape;
import org.nlogo.shape.DrawableShape;
import org.nlogo.shape.LinkLine;
import org.nlogo.shape.LinkShape$;
import org.nlogo.shape.VectorShape;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class LinkShape
implements Shape.LinkShape,
Cloneable,
Serializable,
DrawableShape {
    private static final long serialVersionUID = 0L;
    private String name = "";
    private final boolean isRotatable;
    private final int getEditableColorIndex;
    private double curviness = 0.0;
    private VectorShape directionIndicator = LinkShape$.MODULE$.getDefaultLinkDirectionShape();
    private LinkLine[] lines = new LinkLine[]{new LinkLine(-0.2, false), new LinkLine(0.0, true), new LinkLine(0.2, false)};

    public static VectorShape getDefaultLinkDirectionShape() {
        return LinkShape$.MODULE$.getDefaultLinkDirectionShape();
    }

    public static LinkShape getDefaultLinkShape() {
        return LinkShape$.MODULE$.getDefaultLinkShape();
    }

    public LinkShape() {
        this.isRotatable = true;
        this.getEditableColorIndex = 0;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void name_$eq(String x$1) {
        this.name = x$1;
    }

    @Override
    public boolean isRotatable() {
        return this.isRotatable;
    }

    @Override
    public int getEditableColorIndex() {
        return this.getEditableColorIndex;
    }

    @Override
    public double curviness() {
        return this.curviness;
    }

    public void curviness_$eq(double x$1) {
        this.curviness = x$1;
    }

    @Override
    public Seq<Shape.LinkLine> linkLines() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.lines());
        return ArrayOps$.MODULE$.toSeq$extension(object);
    }

    @Override
    public Shape.VectorShape indicator() {
        return this.directionIndicator();
    }

    public VectorShape directionIndicator() {
        return this.directionIndicator;
    }

    public void directionIndicator_$eq(VectorShape x$1) {
        this.directionIndicator = x$1;
    }

    private LinkLine[] lines() {
        return this.lines;
    }

    private void lines_$eq(LinkLine[] x$0) {
        this.lines = x$0;
    }

    public LinkLine getLine(int i) {
        return this.lines()[i];
    }

    public void setLineVisible(int index, boolean visible) {
        this.lines()[index].visible_$eq(visible);
    }

    public void add(int index, LinkLine line) {
        this.lines()[index] = line;
    }

    public void setDashiness(int index, float[] dashes) {
        this.lines()[index].dashes_$eq(dashes);
    }

    public String dashinessString(int index) {
        return this.lines()[index].dashinessString();
    }

    public void setDashes(int index, String str) {
        this.lines()[index].parseDashes(str);
    }

    public boolean isTooSimpleToPaint() {
        return !this.lines()[0].visible() && !this.lines()[2].visible() && this.curviness() == 0.0 && this.lines()[1].isStraightPlainLine();
    }

    @Override
    public void paint(GraphicsInterface g, Color color, int x, int y, double cellSize, int angle) {
        this.paint(g, color, Int$.MODULE$.int2double(x), Int$.MODULE$.int2double(y), cellSize / (double)2, 2.0, angle, 0.0, 0.0, true);
    }

    public void paint(GraphicsInterface g, Color color, double x, double y, double cellSize, double size, int angle, double lineThickness, double destSize, boolean isDirected) {
        double aR = StrictMath.toRadians(Int$.MODULE$.int2double(angle));
        double aSin = StrictMath.sin(aR) * size * cellSize;
        double aCos = StrictMath.cos(aR) * size * cellSize;
        this.paint(g, color, x + aSin + cellSize * size / (double)2, y + aCos, x + cellSize * size / (double)2, y, cellSize, size, lineThickness, destSize, isDirected);
    }

    public void paint(GraphicsInterface g, Color color, double x1, double y1, double x2, double y2, double cellSize, double size, double lineThickness, double destSize, boolean isDirected) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.lines());
        ArrayOps$.MODULE$.withFilter$extension(object, (Function1 & Serializable)line -> line.visible()).foreach(line -> {
            float lt = (float)StrictMath.max(1.0, cellSize * lineThickness);
            Shape shape = line.getShape(x1, y1, x2, y2, this.curviness(), size, cellSize, lt);
            line.paint(g, color, cellSize, lt, shape);
        });
        if (isDirected) {
            Shape arc = this.lines()[1].getShape(x2, y2, x1, y1, -this.curviness(), size, cellSize, 1.0f);
            this.paintDirectionIndicator(g, color, arc, cellSize, lineThickness, size, destSize + 1.0);
            return;
        }
    }

    public double[] directionIndicatorTransform(double x1, double y1, double x2, double y2, double linkLength, double destSize, Link link, double cellSize, double size) {
        if (this.curviness() == 0.0) {
            return new double[]{link.heading(), x2 + (x1 - x2) / linkLength * destSize * (double)2 / (double)3, y2 - (y2 - y1) / linkLength * destSize * (double)2 / (double)3};
        }
        Shape arc = this.lines()[1].getShape(x2, y2, x1, y1, this.curviness() * (double)3, linkLength, cellSize, 1.0f);
        double[] trans = this.directionIndicatorTransform(arc, this.destShape(arc, destSize, cellSize));
        trans[0] = -trans[0] + (double)180;
        return trans;
    }

    public void paintDirectionIndicator(GraphicsInterface g, Color color, double x1, double y1, double x2, double y2, double heading, double cellSize, double lineThickness, double destSize, double linkLength) {
        double xcomp = (x1 - x2) / linkLength * destSize * (double)2 / (double)3;
        double ycomp = (y2 - y1) / linkLength * destSize * (double)2 / (double)3;
        double xmid = (x1 - x2) / (double)2;
        double ymid = (y2 - y1) / (double)2;
        if (StrictMath.abs(xmid) < StrictMath.abs(xcomp) && StrictMath.abs(ymid) < StrictMath.abs(ycomp)) {
            xcomp = xmid;
            ycomp = ymid;
        }
        double scaleFactor = this.directionIndicatorScale(lineThickness, cellSize);
        this.directionIndicator().paint(g, color, x2 + xcomp - cellSize * scaleFactor / (double)2, y2 - ycomp - cellSize * scaleFactor / (double)2, scaleFactor, cellSize, (int)heading, lineThickness);
    }

    public int numLines() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.lines());
        return ArrayOps$.MODULE$.count$extension(object, (Function1 & Serializable)_$1 -> _$1.visible());
    }

    public void paintDirectionIndicator(GraphicsInterface g, Color color, Shape arc, double cellSize, double lineThickness, double size, double destSize) {
        double[] trans = this.directionIndicatorTransform(arc, this.destShape(arc, destSize, cellSize));
        double scale = this.directionIndicatorScale(lineThickness, cellSize);
        this.directionIndicator().paint(g, color, trans[1] - cellSize * scale / (double)2, trans[2] - cellSize * scale / (double)2, scale, cellSize, (int)trans[0], lineThickness);
    }

    private double directionIndicatorScale(double lineThickness, double cellSize) {
        return (lineThickness * StrictMath.sqrt(cellSize / (double)2) + (double)2) * StrictMath.max(1.0, (double)this.numLines() / 1.5);
    }

    public Shape destShape(Shape arc, double size, double cellSize) {
        PathIterator i = arc.getPathIterator(null, 1.0);
        double[] p = new double[6];
        i.currentSegment(p);
        AffineTransform trans = AffineTransform.getTranslateInstance(p[0], p[1]);
        trans.scale(cellSize, cellSize);
        trans.scale(size, size);
        return trans.createTransformedShape(new Ellipse2D.Double(-0.5, -0.5, 1.0, 1.0));
    }

    public double[] directionIndicatorTransform(Shape arc, Shape dest) {
        double[] pts = new double[6];
        Point2D.Double p1 = null;
        Point2D.Double p2 = null;
        PathIterator i = arc.getPathIterator(null, 1.0);
        while (!i.isDone()) {
            int ret = i.currentSegment(pts);
            if (ret == 0) {
                p2 = new Point2D.Double(pts[0], pts[1]);
            } else if (ret == 1) {
                p1 = p2;
                p2 = new Point2D.Double(pts[0], pts[1]);
                if (dest.contains(p1) && !dest.contains(p2)) {
                    return this.directionIndicatorTransform(new Line2D.Double(p1, p2), dest);
                }
            }
            i.next();
        }
        return new double[3];
    }

    public double[] directionIndicatorTransform(Line2D initialLine, Shape dest) {
        Line2D line = initialLine;
        double dx = line.getX1() - line.getX2();
        double dy = line.getY1() - line.getY2();
        while (dx * dx + dy * dy > 1.0) {
            line = this.lastOutsideSegment(line, dest);
            dx = line.getX1() - line.getX2();
            dy = line.getY1() - line.getY2();
        }
        double angle = ((double)270 + StrictMath.toDegrees(Math.PI + StrictMath.atan2(dy, dx))) % (double)360;
        return new double[]{angle, line.getX1(), line.getY1()};
    }

    public Line2D lastOutsideSegment(Line2D initialLine, Shape dest) {
        Line2D line = initialLine;
        Line2D.Double left = new Line2D.Double();
        Line2D.Double right = new Line2D.Double();
        do {
            this.split(line, left, right);
        } while (!dest.contains((line = left).getP2()) && Math.abs(line.getP1().distance(line.getP2())) > 0.25);
        return right;
    }

    public void split(Line2D src, Line2D left, Line2D right) {
        double x1 = src.getX1();
        double y1 = src.getY1();
        double x2 = src.getX2();
        double y2 = src.getY2();
        double mx = x1 + (x2 - x1) / 2.0;
        double my = y1 + (y2 - y1) / 2.0;
        left.setLine(x1, y1, mx, my);
        right.setLine(mx, my, x2, y2);
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        void v0;
        try {
            void var1_1;
            LinkShape newShape = (LinkShape)super.clone();
            newShape.directionIndicator_$eq(this.directionIndicator().clone());
            newShape.lines_$eq(new LinkLine[this.lines().length]);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.lines().length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                newShape$1.lines()[i] = (LinkLine)this.lines()[i].clone();
            });
            v0 = var1_1;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
        return v0;
    }

    public String toString() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.lines());
        String linesString = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$2 -> _$2.toString(), ClassTag$.MODULE$.apply(String.class))).mkString("\n");
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|" + this.name() + "\n        |" + this.curviness() + "\n        |" + linesString + "\n        |" + this.directionIndicator().toString()));
    }
}

