/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape.editor;

import java.awt.Component;
import java.io.Serializable;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import org.nlogo.core.I18N$;
import org.nlogo.core.Shape;
import org.nlogo.core.ShapeList;
import org.nlogo.core.ShapeList$;
import org.nlogo.core.ShapeListTracker;
import org.nlogo.shape.editor.EditorDialog;
import org.nlogo.shape.editor.ShapeCellRenderer;
import org.nlogo.swing.OptionPane;
import org.nlogo.swing.OptionPane$Icons$;
import org.nlogo.swing.OptionPane$Options$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class DrawableList<A extends Shape>
extends JList<A>
implements EditorDialog.VectorShapeContainer {
    private final ShapeListTracker shapeTracker;
    private final Component parent;
    private final ClassTag<A> ct;
    private final DefaultListModel<A> listModel;

    public DrawableList(ShapeListTracker shapeTracker, int rows, int height, Component parent, ClassTag<A> ct) {
        this.shapeTracker = shapeTracker;
        this.parent = parent;
        this.ct = ct;
        this.listModel = new DefaultListModel();
        this.setVisibleRowCount(rows);
        this.setModel(this.listModel());
        this.setFixedCellHeight(height);
        this.setCellRenderer(new ShapeCellRenderer());
    }

    public ShapeList shapeList() {
        return this.shapeTracker.shapeList();
    }

    public DefaultListModel<A> listModel() {
        return this.listModel;
    }

    public void update(Option<String> name) {
        this.listModel().clear();
        Option<String> option = name;
        if (option instanceof Some) {
            String str = (String)((Some)option).value();
            this.shapeList().shapes().foreach(x$1 -> {
                Shape shape;
                Shape s;
                Option option;
                Shape shape2 = x$1;
                if (shape2 != null && !(option = this.ct.unapply((Object)shape2)).isEmpty() && (s = (shape = (Shape)option.get())).name().toLowerCase().contains(str.toLowerCase())) {
                    this.listModel().addElement(s);
                    return;
                }
            });
            return;
        }
        this.shapeList().shapes().foreach(x$1 -> {
            Option option;
            Shape shape = x$1;
            if (shape != null && !(option = this.ct.unapply((Object)shape)).isEmpty()) {
                Shape shape2;
                Shape s = shape2 = (Shape)option.get();
                this.listModel().addElement(s);
                return;
            }
        });
    }

    public Option<String> update$default$1() {
        return None$.MODULE$;
    }

    @Override
    public void update(Shape originalShape, Shape newShape) {
        String string = originalShape.name();
        String string2 = newShape.name();
        if (string == null ? string2 != null : !string.equals(string2)) {
            String string3 = ShapeList$.MODULE$.DefaultShapeName();
            String string4 = originalShape.name();
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                this.removeShape(originalShape);
            }
        }
        this.addShape(newShape);
        this.update(this.update$default$1());
        this.selectShapeName(newShape.name());
    }

    public void selectShapeName(String name) {
        int namedIndex = -1;
        for (int index = 0; index < this.listModel().size() && namedIndex == -1; ++index) {
            String string = ((Shape)this.listModel().getElementAt(index)).name();
            String string2 = name;
            if (string != null ? !string.equals(string2) : string2 != null) continue;
            namedIndex = index;
        }
        this.addSelectionInterval(namedIndex, namedIndex);
        this.ensureIndexIsVisible(namedIndex);
    }

    public A elementAt(int index) {
        return (A)((Shape)this.listModel().getElementAt(index));
    }

    public Option<A> getOneSelected() {
        int[] selected = this.getSelectedIndices();
        if (selected.length == 1) {
            return Option$.MODULE$.apply(this.listModel().get(selected[0]));
        }
        return None$.MODULE$;
    }

    public Option<A> getShape(int index) {
        return Option$.MODULE$.apply(this.listModel().get(index));
    }

    public Set<String> getShapeNames() {
        return this.shapeList().names();
    }

    @Override
    public boolean exists(String name) {
        return this.shapeList().exists(name);
    }

    public void selectShapeIndex(int index) {
        if (index < this.listModel().size()) {
            this.addSelectionInterval(index, index);
            this.ensureIndexIsVisible(index);
            return;
        }
    }

    private boolean confirmDeletion(int deleteCount) {
        None$ message = deleteCount > 1 ? Some$.MODULE$.apply((Object)I18N$.MODULE$.gui().getN("tools.shapesEditor.delete.many.confirm", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToInteger((int)deleteCount)}))) : (deleteCount == 1 ? Some$.MODULE$.apply((Object)I18N$.MODULE$.gui().get("tools.shapesEditor.delete.one.confirm")) : None$.MODULE$);
        return BoxesRunTime.unboxToBoolean((Object)message.map((Function1 & Serializable)msg -> new OptionPane(this.parent, I18N$.MODULE$.gui().get("tools.shapesEditor.delete"), (String)msg, OptionPane$Options$.MODULE$.YesNo(), OptionPane$Icons$.MODULE$.Question()).getSelectedIndex() == 0).getOrElse(DrawableList::confirmDeletion$$anonfun$2));
    }

    public Seq<Shape> deleteShapes() {
        int[] selected = this.getSelectedIndices();
        Object object = Predef$.MODULE$.intArrayOps(selected);
        if (this.confirmDeletion(ArrayOps$.MODULE$.size$extension(object))) {
            Object object2 = Predef$.MODULE$.intArrayOps(selected);
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)i -> this.$anonfun$1(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(Tuple2.class)));
            Object[] shapesToDelete = (Tuple2[])ArrayOps$.MODULE$.filter$extension(object3, (Function1 & Serializable)_$1 -> {
                String string = ((Shape)_$1._2()).name();
                String string2 = ShapeList$.MODULE$.DefaultShapeName();
                return string == null ? string2 != null : !string.equals(string2);
            });
            Object object4 = Predef$.MODULE$.refArrayOps(shapesToDelete);
            Object object5 = Predef$.MODULE$.refArrayOps((Object[])((Tuple2[])ArrayOps$.MODULE$.reverse$extension(object4)));
            ArrayOps$.MODULE$.foreach$extension(object5, (Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    int i = BoxesRunTime.unboxToInt((Object)tuple2._1());
                    Shape shape = (Shape)tuple2._2();
                    this.removeShape(shape);
                    return (Shape)this.listModel().remove(i);
                }
                throw new MatchError((Object)tuple2);
            });
            int newSelectedShapeIndex = selected[0] >= this.listModel().size() ? selected[0] - 1 : selected[0];
            this.selectShapeIndex(newSelectedShapeIndex);
            Object object6 = Predef$.MODULE$.refArrayOps(shapesToDelete);
            Object object7 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.collect$extension(object6, (PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Tuple2 x) {
                    Shape shape;
                    Tuple2 tuple2 = x;
                    if (tuple2 != null && (shape = (Shape)tuple2._2()) != null) {
                        Shape s = shape;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Tuple2 x, Function1 function1) {
                    Shape shape;
                    Tuple2 tuple2 = x;
                    if (tuple2 != null && (shape = (Shape)tuple2._2()) != null) {
                        Shape s = shape;
                        return s;
                    }
                    return function1.apply((Object)x);
                }
            }, this.ct));
            return ArrayOps$.MODULE$.toSeq$extension(object7);
        }
        return (Seq)((SeqOps)Nil$.MODULE$);
    }

    public void addShape(Shape shape) {
        Option$.MODULE$.apply((Object)shape).foreach(newShape -> this.shapeTracker.add((Shape)newShape));
    }

    public void removeShape(Shape shape) {
        Option$.MODULE$.apply((Object)shape).foreach(shapeToRemove -> this.shapeTracker.removeShape((Shape)shapeToRemove));
    }

    private static final boolean confirmDeletion$$anonfun$2() {
        return false;
    }

    private final /* synthetic */ Tuple2 $anonfun$1(int i) {
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)i), this.listModel().get(i));
    }
}

