/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import org.nlogo.analytics.Analytics$;
import org.nlogo.api.Color$;
import org.nlogo.core.I18N;
import org.nlogo.core.I18N$;
import org.nlogo.core.I18N$Prefix$;
import org.nlogo.core.Shape;
import org.nlogo.shape.Element;
import org.nlogo.shape.VectorShape;
import org.nlogo.shape.editor.EditorDialog$;
import org.nlogo.shape.editor.ElementType;
import org.nlogo.shape.editor.ElementType$Circle$;
import org.nlogo.shape.editor.ElementType$Line$;
import org.nlogo.shape.editor.ElementType$None$;
import org.nlogo.shape.editor.ElementType$Polygon$;
import org.nlogo.shape.editor.ElementType$Rectangle$;
import org.nlogo.shape.editor.ShapePreview;
import org.nlogo.shape.editor.ShapeView;
import org.nlogo.swing.Button;
import org.nlogo.swing.ButtonPanel;
import org.nlogo.swing.CheckBox;
import org.nlogo.swing.ComboBox;
import org.nlogo.swing.DialogButton;
import org.nlogo.swing.MenuItem;
import org.nlogo.swing.OptionPane;
import org.nlogo.swing.OptionPane$Icons$;
import org.nlogo.swing.OptionPane$Options$;
import org.nlogo.swing.TextField;
import org.nlogo.swing.TextField$;
import org.nlogo.swing.ToggleButton;
import org.nlogo.swing.Transparent;
import org.nlogo.swing.Utils$;
import org.nlogo.theme.InterfaceColors$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

public class EditorDialog
extends JDialog
implements PropertyChangeListener {
    private final VectorShapeContainer container;
    public final VectorShape org$nlogo$shape$editor$EditorDialog$$originalShape;
    public final boolean org$nlogo$shape$editor$EditorDialog$$nameEditable;
    public final I18N.Prefix org$nlogo$shape$editor$EditorDialog$$i18nPrefix;
    public final VectorShape org$nlogo$shape$editor$EditorDialog$$shape;
    public final ShapeView org$nlogo$shape$editor$EditorDialog$$shapeView;
    public ElementType org$nlogo$shape$editor$EditorDialog$$elementType;
    private Color elementColor;
    public boolean org$nlogo$shape$editor$EditorDialog$$editingElements;
    public final ShapePreview[] org$nlogo$shape$editor$EditorDialog$$previews;
    public final TextField org$nlogo$shape$editor$EditorDialog$$nameText;
    public final ToggleButton org$nlogo$shape$editor$EditorDialog$$editElements;
    private Option<UndoableEdit> undoableEdit;
    public final Button org$nlogo$shape$editor$EditorDialog$$deleteSelected;
    public final Button org$nlogo$shape$editor$EditorDialog$$duplicateSelected;
    private final Button bringToFront;
    private final Button sendToBack;
    private final Button undoButton;
    private final JToolBar colorGrid;
    private final ButtonGroup colorGroup;
    public final IndexedSeq<ColorPanel> org$nlogo$shape$editor$EditorDialog$$colors;
    private final ComboBox<ColorPanel> colorSelection;
    public boolean org$nlogo$shape$editor$EditorDialog$$fillShapes;
    public boolean org$nlogo$shape$editor$EditorDialog$$shapeRotatable;
    private boolean snapToGrid;
    public final AbstractAction org$nlogo$shape$editor$EditorDialog$$closingAction;
    public final JPanel org$nlogo$shape$editor$EditorDialog$$leftPanel;
    public final JPanel org$nlogo$shape$editor$EditorDialog$$rightPanel;
    public final JPanel org$nlogo$shape$editor$EditorDialog$$previewPanel;
    public final JPanel org$nlogo$shape$editor$EditorDialog$$graphicPanel;
    public final JLabel org$nlogo$shape$editor$EditorDialog$$nameLabel;

    public static Color getColor(int n) {
        return EditorDialog$.MODULE$.getColor(n);
    }

    public EditorDialog(JDialog parent, VectorShapeContainer container, VectorShape originalShape, boolean nameEditable) {
        this.container = container;
        this.org$nlogo$shape$editor$EditorDialog$$originalShape = originalShape;
        this.org$nlogo$shape$editor$EditorDialog$$nameEditable = nameEditable;
        super(parent, I18N$.MODULE$.gui().get("tools.shapesEditor"), true);
        this.org$nlogo$shape$editor$EditorDialog$$i18nPrefix = I18N$Prefix$.MODULE$.apply("tools.shapesEditor");
        this.org$nlogo$shape$editor$EditorDialog$$shape = originalShape.clone();
        this.org$nlogo$shape$editor$EditorDialog$$shapeView = new ShapeView(this, this.org$nlogo$shape$editor$EditorDialog$$shape);
        this.org$nlogo$shape$editor$EditorDialog$$elementType = ElementType$None$.MODULE$;
        this.elementColor = EditorDialog$.MODULE$.getColor(this.org$nlogo$shape$editor$EditorDialog$$shape.getEditableColorIndex());
        this.org$nlogo$shape$editor$EditorDialog$$editingElements = false;
        this.org$nlogo$shape$editor$EditorDialog$$previews = new ShapePreview[]{new ShapePreview(this.org$nlogo$shape$editor$EditorDialog$$shape, 9, 5), new ShapePreview(this.org$nlogo$shape$editor$EditorDialog$$shape, 12, -4), new ShapePreview(this.org$nlogo$shape$editor$EditorDialog$$shape, 20, 3), new ShapePreview(this.org$nlogo$shape$editor$EditorDialog$$shape, 30, -2), new ShapePreview(this.org$nlogo$shape$editor$EditorDialog$$shape, 50, 1)};
        this.org$nlogo$shape$editor$EditorDialog$$nameText = new TextField(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(4, $outer.org$nlogo$shape$editor$EditorDialog$$shape.name(), TextField$.MODULE$.$lessinit$greater$default$3());
                this.setEnabled($outer.org$nlogo$shape$editor$EditorDialog$$nameEditable);
            }
        };
        this.org$nlogo$shape$editor$EditorDialog$$editElements = new ToggleButton(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super($outer.org$nlogo$shape$editor$EditorDialog$$_$$anon$superArg$1$1());
                this.setIcon(Utils$.MODULE$.iconScaledWithColor("/images/shapes-editor/arrow.png", 15, 15, InterfaceColors$.MODULE$.toolbarText()));
                this.setSelected(false);
            }
        };
        this.undoableEdit = None$.MODULE$;
        this.org$nlogo$shape$editor$EditorDialog$$deleteSelected = new Button(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(I18N$.MODULE$.gui().apply("delete", $outer.org$nlogo$shape$editor$EditorDialog$$i18nPrefix), (Function0<BoxedUnit>)$outer.org$nlogo$shape$editor$EditorDialog$$_$$anon$superArg$2$1());
                this.setEnabled(false);
            }
        };
        this.org$nlogo$shape$editor$EditorDialog$$duplicateSelected = new Button(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(I18N$.MODULE$.gui().apply("duplicate", $outer.org$nlogo$shape$editor$EditorDialog$$i18nPrefix), (Function0<BoxedUnit>)$outer.org$nlogo$shape$editor$EditorDialog$$_$$anon$superArg$3$1());
                this.setEnabled(false);
            }
        };
        this.bringToFront = new Button(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(I18N$.MODULE$.gui().apply("bringToFront", $outer.org$nlogo$shape$editor$EditorDialog$$i18nPrefix), (Function0<BoxedUnit>)$outer.org$nlogo$shape$editor$EditorDialog$$_$$anon$superArg$4$1());
                this.setEnabled(false);
            }
        };
        this.sendToBack = new Button(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(I18N$.MODULE$.gui().apply("sendToBack", $outer.org$nlogo$shape$editor$EditorDialog$$i18nPrefix), (Function0<BoxedUnit>)$outer.org$nlogo$shape$editor$EditorDialog$$_$$anon$superArg$5$1());
                this.setEnabled(false);
            }
        };
        this.undoButton = new Button(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(I18N$.MODULE$.gui().apply("undo", $outer.org$nlogo$shape$editor$EditorDialog$$i18nPrefix), (Function0<BoxedUnit>)$outer.org$nlogo$shape$editor$EditorDialog$$_$$anon$superArg$6$1());
                this.setEnabled(false);
            }
        };
        this.colorGrid = new Transparent(){
            {
                Transparent.$init$(this);
                this.setFloatable(false);
                this.setLayout(new GridLayout(4, 4, 3, 3));
            }
        };
        this.colorGroup = new ButtonGroup();
        Object object = Predef$.MODULE$.refArrayOps((Object[])Color$.MODULE$.ColorNames());
        this.org$nlogo$shape$editor$EditorDialog$$colors = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(object)).map((Function1 & Serializable)i -> this.$init$$$anonfun$1(BoxesRunTime.unboxToInt((Object)i)));
        this.colorSelection = new ComboBox<ColorPanel>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super($outer.org$nlogo$shape$editor$EditorDialog$$colors.toList());
                this.addItemListener(arg_0 -> EditorDialog.org$nlogo$shape$editor$EditorDialog$$anon$11$$_$$lessinit$greater$$anonfun$2($outer, arg_0));
            }
        };
        this.colorSelection.setSelectedIndex(this.org$nlogo$shape$editor$EditorDialog$$shape.getEditableColorIndex());
        this.org$nlogo$shape$editor$EditorDialog$$fillShapes = true;
        this.org$nlogo$shape$editor$EditorDialog$$shapeRotatable = this.org$nlogo$shape$editor$EditorDialog$$shape.isRotatable();
        this.snapToGrid = true;
        this.org$nlogo$shape$editor$EditorDialog$$shape.addPropertyChangeListener(this);
        this.org$nlogo$shape$editor$EditorDialog$$shape.addPropertyChangeListener(this.org$nlogo$shape$editor$EditorDialog$$shapeView);
        this.setLocation(parent.getX() + 10, parent.getY() + 10);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.org$nlogo$shape$editor$EditorDialog$$closingAction = new AbstractAction(this){
            private final /* synthetic */ EditorDialog $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void actionPerformed(ActionEvent e) {
                String string = this.$outer.org$nlogo$shape$editor$EditorDialog$$originalShape.toString();
                String string2 = this.$outer.org$nlogo$shape$editor$EditorDialog$$getCurrentShape().toString();
                if ((string == null ? string2 != null : !string.equals(string2)) && new OptionPane(this.$outer, I18N$.MODULE$.gui().apply("confirmCancel", this.$outer.org$nlogo$shape$editor$EditorDialog$$i18nPrefix), I18N$.MODULE$.gui().apply("confirmCancel.message", this.$outer.org$nlogo$shape$editor$EditorDialog$$i18nPrefix), OptionPane$Options$.MODULE$.YesNo(), OptionPane$Icons$.MODULE$.Question()).getSelectedIndex() != 0) {
                    return;
                }
                this.$outer.dispose();
            }
        };
        this.addWindowListener(new WindowAdapter(this){
            private final /* synthetic */ EditorDialog $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void windowClosing(WindowEvent e) {
                this.$outer.org$nlogo$shape$editor$EditorDialog$$closingAction.actionPerformed(null);
            }
        });
        Utils$.MODULE$.addEscKeyAction(this, (Action)this.org$nlogo$shape$editor$EditorDialog$$closingAction);
        this.org$nlogo$shape$editor$EditorDialog$$leftPanel = new Transparent(){
            {
                Transparent.$init$(this);
            }
        };
        this.org$nlogo$shape$editor$EditorDialog$$rightPanel = new Transparent(){
            {
                Transparent.$init$(this);
            }
        };
        Transparent editingToolBar = new Transparent(){
            {
                Transparent.$init$(this);
                this.setFloatable(false);
                this.setLayout(new GridLayout(4, 2, 3, 3));
            }
        };
        ButtonGroup editingToolGroup = new ButtonGroup();
        this.org$nlogo$shape$editor$EditorDialog$$editElements.setToolTipText(I18N$.MODULE$.gui().apply("select", this.org$nlogo$shape$editor$EditorDialog$$i18nPrefix));
        ((Container)((Object)editingToolBar)).add(this.org$nlogo$shape$editor$EditorDialog$$editElements);
        editingToolGroup.add(this.org$nlogo$shape$editor$EditorDialog$$editElements);
        this.addToolBarButton((JToolBar)((Object)editingToolBar), editingToolGroup, new CreateAction(this, "line", ElementType$Line$.MODULE$, false));
        this.addToolBarButton((JToolBar)((Object)editingToolBar), editingToolGroup, new CreateAction(this, "rectangleFilled", ElementType$Rectangle$.MODULE$, true));
        this.addToolBarButton((JToolBar)((Object)editingToolBar), editingToolGroup, new CreateAction(this, "rectangle", ElementType$Rectangle$.MODULE$, false));
        this.addToolBarButton((JToolBar)((Object)editingToolBar), editingToolGroup, new CreateAction(this, "circleFilled", ElementType$Circle$.MODULE$, true));
        this.addToolBarButton((JToolBar)((Object)editingToolBar), editingToolGroup, new CreateAction(this, "circle", ElementType$Circle$.MODULE$, false));
        this.addToolBarButton((JToolBar)((Object)editingToolBar), editingToolGroup, new CreateAction(this, "polygonFilled", ElementType$Polygon$.MODULE$, true));
        this.addToolBarButton((JToolBar)((Object)editingToolBar), editingToolGroup, new CreateAction(this, "polygon", ElementType$Polygon$.MODULE$, false));
        CheckBox snapToGridButton = new CheckBox(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(I18N$.MODULE$.gui().apply("snapToGrid", $outer.org$nlogo$shape$editor$EditorDialog$$i18nPrefix), (Function1<Object, BoxedUnit>)$outer.org$nlogo$shape$editor$EditorDialog$$_$_$$anon$superArg$8$1());
                this.setForeground(InterfaceColors$.MODULE$.dialogText());
                this.setSelected(true);
            }
        };
        CheckBox rotatableButton = new CheckBox(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(I18N$.MODULE$.gui().apply("rotatable", $outer.org$nlogo$shape$editor$EditorDialog$$i18nPrefix), (Function1<Object, BoxedUnit>)$outer.org$nlogo$shape$editor$EditorDialog$$_$_$$anon$superArg$9$1());
                this.setForeground(InterfaceColors$.MODULE$.dialogText());
                this.setSelected($outer.org$nlogo$shape$editor$EditorDialog$$shapeRotatable);
            }
        };
        Button rotateLeftButton = new Button(I18N$.MODULE$.gui().apply("rotateLeft", this.org$nlogo$shape$editor$EditorDialog$$i18nPrefix), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Option<Element> option = this.org$nlogo$shape$editor$EditorDialog$$shapeView.getSelectedElement();
            if (option instanceof Some) {
                Element element = (Element)((Some)option).value();
                this.makeUndoableModification(element, this.org$nlogo$shape$editor$EditorDialog$$shape.getElements().indexOf((Object)element));
                element.rotateLeft();
            } else if (None$.MODULE$.equals(option)) {
                this.undoableEdit = None$.MODULE$;
                this.undoButton.setEnabled(false);
                this.org$nlogo$shape$editor$EditorDialog$$shape.rotateLeft();
            } else {
                throw new MatchError(option);
            }
            this.org$nlogo$shape$editor$EditorDialog$$shapeView.repaint();
        });
        Button rotateRightButton = new Button(I18N$.MODULE$.gui().apply("rotateRight", this.org$nlogo$shape$editor$EditorDialog$$i18nPrefix), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Option<Element> option = this.org$nlogo$shape$editor$EditorDialog$$shapeView.getSelectedElement();
            if (option instanceof Some) {
                Element element = (Element)((Some)option).value();
                this.makeUndoableModification(element, this.org$nlogo$shape$editor$EditorDialog$$shape.getElements().indexOf((Object)element));
                element.rotateRight();
            } else if (None$.MODULE$.equals(option)) {
                this.undoableEdit = None$.MODULE$;
                this.undoButton.setEnabled(false);
                this.org$nlogo$shape$editor$EditorDialog$$shape.rotateRight();
            } else {
                throw new MatchError(option);
            }
            this.org$nlogo$shape$editor$EditorDialog$$shapeView.repaint();
        });
        Button flipHorizontalButton = new Button(I18N$.MODULE$.gui().apply("flipHorizontal", this.org$nlogo$shape$editor$EditorDialog$$i18nPrefix), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Option<Element> option = this.org$nlogo$shape$editor$EditorDialog$$shapeView.getSelectedElement();
            if (option instanceof Some) {
                Element element = (Element)((Some)option).value();
                this.makeUndoableModification(element, this.org$nlogo$shape$editor$EditorDialog$$shape.getElements().indexOf((Object)element));
                element.flipHorizontal();
            } else if (None$.MODULE$.equals(option)) {
                this.undoableEdit = None$.MODULE$;
                this.undoButton.setEnabled(false);
                this.org$nlogo$shape$editor$EditorDialog$$shape.flipHorizontal();
            } else {
                throw new MatchError(option);
            }
            this.org$nlogo$shape$editor$EditorDialog$$shapeView.repaint();
        });
        Button flipVerticalButton = new Button(I18N$.MODULE$.gui().apply("flipVertical", this.org$nlogo$shape$editor$EditorDialog$$i18nPrefix), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Option<Element> option = this.org$nlogo$shape$editor$EditorDialog$$shapeView.getSelectedElement();
            if (option instanceof Some) {
                Element element = (Element)((Some)option).value();
                this.makeUndoableModification(element, this.org$nlogo$shape$editor$EditorDialog$$shape.getElements().indexOf((Object)element));
                element.flipVertical();
            } else if (None$.MODULE$.equals(option)) {
                this.undoableEdit = None$.MODULE$;
                this.undoButton.setEnabled(false);
                this.org$nlogo$shape$editor$EditorDialog$$shape.flipVertical();
            } else {
                throw new MatchError(option);
            }
            this.org$nlogo$shape$editor$EditorDialog$$shapeView.repaint();
        });
        this.org$nlogo$shape$editor$EditorDialog$$leftPanel.add((Component)((Object)editingToolBar));
        this.org$nlogo$shape$editor$EditorDialog$$leftPanel.add(snapToGridButton);
        this.org$nlogo$shape$editor$EditorDialog$$leftPanel.add(this.colorGrid);
        this.org$nlogo$shape$editor$EditorDialog$$leftPanel.add(Box.createVerticalStrut(10));
        this.org$nlogo$shape$editor$EditorDialog$$leftPanel.add(new JLabel(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(I18N$.MODULE$.gui().apply("colorChanges", $outer.org$nlogo$shape$editor$EditorDialog$$i18nPrefix));
                this.setForeground(InterfaceColors$.MODULE$.dialogText());
            }
        });
        this.org$nlogo$shape$editor$EditorDialog$$leftPanel.add(Box.createVerticalStrut(3));
        this.org$nlogo$shape$editor$EditorDialog$$leftPanel.add(this.colorSelection);
        this.org$nlogo$shape$editor$EditorDialog$$leftPanel.add(this.org$nlogo$shape$editor$EditorDialog$$deleteSelected);
        this.org$nlogo$shape$editor$EditorDialog$$leftPanel.add(this.org$nlogo$shape$editor$EditorDialog$$duplicateSelected);
        this.org$nlogo$shape$editor$EditorDialog$$leftPanel.add(this.bringToFront);
        this.org$nlogo$shape$editor$EditorDialog$$leftPanel.add(this.sendToBack);
        this.org$nlogo$shape$editor$EditorDialog$$leftPanel.add(this.undoButton);
        this.org$nlogo$shape$editor$EditorDialog$$leftPanel.add(rotatableButton);
        this.org$nlogo$shape$editor$EditorDialog$$rightPanel.add(rotateLeftButton);
        this.org$nlogo$shape$editor$EditorDialog$$rightPanel.add(rotateRightButton);
        this.org$nlogo$shape$editor$EditorDialog$$rightPanel.add(flipHorizontalButton);
        this.org$nlogo$shape$editor$EditorDialog$$rightPanel.add(flipVerticalButton);
        DialogButton done = new DialogButton(true, I18N$.MODULE$.gui().get("common.buttons.ok"), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.saveShape());
        DialogButton cancel = new DialogButton(false, I18N$.MODULE$.gui().get("common.buttons.cancel"), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.dispose());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])this.org$nlogo$shape$editor$EditorDialog$$previews);
        ArrayOps$.MODULE$.foreach$extension(object2, listener -> this.org$nlogo$shape$editor$EditorDialog$$shape.addPropertyChangeListener((PropertyChangeListener)listener));
        this.org$nlogo$shape$editor$EditorDialog$$previewPanel = new JPanel(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.setLayout(new BoxLayout(this, 0));
                Object object = Predef$.MODULE$.refArrayOps((Object[])$outer.org$nlogo$shape$editor$EditorDialog$$previews);
                ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)x$0 -> this.add((Component)x$0));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$init$$$anonfun$10(java.awt.Component )}, serializedLambda);
            }
        };
        this.org$nlogo$shape$editor$EditorDialog$$graphicPanel = new JPanel(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.setLayout(new BoxLayout(this, 1));
                this.add($outer.org$nlogo$shape$editor$EditorDialog$$shapeView);
                this.add($outer.org$nlogo$shape$editor$EditorDialog$$previewPanel);
            }
        };
        Transparent drawingPanel = new Transparent(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                Transparent.$init$(this);
                this.setLayout(new BoxLayout(this, 0));
                this.add(Box.createHorizontalStrut(10));
                this.add($outer.org$nlogo$shape$editor$EditorDialog$$leftPanel);
                this.add(Box.createHorizontalStrut(15));
                this.add($outer.org$nlogo$shape$editor$EditorDialog$$graphicPanel);
                this.add(Box.createHorizontalStrut(15));
                this.add($outer.org$nlogo$shape$editor$EditorDialog$$rightPanel);
                this.add(Box.createHorizontalStrut(10));
            }
        };
        ButtonPanel buttonPanel = new ButtonPanel((Seq<JComponent>)((Seq)((SeqOps)new .colon.colon((Object)done, (List)new .colon.colon((Object)cancel, (List)Nil$.MODULE$)))));
        this.org$nlogo$shape$editor$EditorDialog$$nameLabel = new JLabel(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(I18N$.MODULE$.gui().apply("name", $outer.org$nlogo$shape$editor$EditorDialog$$i18nPrefix));
                this.setForeground(InterfaceColors$.MODULE$.dialogText());
            }
        };
        Transparent namePanel = new Transparent(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                Transparent.$init$(this);
                this.setLayout(new BoxLayout(this, 0));
                this.add(Box.createHorizontalStrut(10));
                this.add($outer.org$nlogo$shape$editor$EditorDialog$$nameLabel);
                this.add(Box.createHorizontalStrut(5));
                this.add($outer.org$nlogo$shape$editor$EditorDialog$$nameText);
                this.add(Box.createHorizontalStrut(5));
            }
        };
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.getContentPane().add(Box.createVerticalStrut(10));
        this.getContentPane().add((Component)((Object)namePanel));
        this.getContentPane().add(Box.createVerticalStrut(15));
        this.getContentPane().add((Component)((Object)drawingPanel));
        this.getContentPane().add(Box.createVerticalStrut(15));
        this.getContentPane().add(buttonPanel);
        this.getContentPane().add(Box.createVerticalStrut(10));
        this.getRootPane().setDefaultButton(done);
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])this.org$nlogo$shape$editor$EditorDialog$$previews);
        ArrayOps$.MODULE$.foreach$extension(object3, _$3 -> _$3.updateRotation(this.org$nlogo$shape$editor$EditorDialog$$shapeRotatable));
        this.pack();
        this.org$nlogo$shape$editor$EditorDialog$$nameText.requestFocus();
        this.setEditingElements(true);
        this.setVisible(true);
        this.org$nlogo$shape$editor$EditorDialog$$shape.changed();
    }

    public ElementType getElementType() {
        return this.org$nlogo$shape$editor$EditorDialog$$elementType;
    }

    public Color getElementColor() {
        return this.elementColor;
    }

    public boolean isFillShapes() {
        return this.org$nlogo$shape$editor$EditorDialog$$fillShapes;
    }

    public boolean isRotatable() {
        return this.org$nlogo$shape$editor$EditorDialog$$shapeRotatable;
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public boolean isEditingElements() {
        return this.org$nlogo$shape$editor$EditorDialog$$editingElements;
    }

    public void setEditingElements(boolean e) {
        this.org$nlogo$shape$editor$EditorDialog$$editingElements = e;
        this.org$nlogo$shape$editor$EditorDialog$$editElements.setSelected(e);
        if (e) {
            this.org$nlogo$shape$editor$EditorDialog$$shapeView.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        this.org$nlogo$shape$editor$EditorDialog$$shapeView.setCursor(Cursor.getPredefinedCursor(1));
    }

    public void makeUndoableModification(Element el, int z) {
        UndoableModification mod = new UndoableModification(this, el, z);
        this.undoableEdit = Some$.MODULE$.apply((Object)mod);
        this.undoButton.setEnabled(mod.canUndo());
    }

    public void makeUndoableDraw(Element el) {
        UndoableDraw draw = new UndoableDraw(this, el);
        this.undoableEdit = Some$.MODULE$.apply((Object)draw);
        this.undoButton.setEnabled(draw.canUndo());
    }

    public void makeUndoableUnfinishedPolygon() {
        UndoableUnfinishedPolygon poly = new UndoableUnfinishedPolygon();
        this.undoableEdit = Some$.MODULE$.apply((Object)poly);
        this.undoButton.setEnabled(poly.canUndo());
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.org$nlogo$shape$editor$EditorDialog$$deleteSelected.setEnabled(this.org$nlogo$shape$editor$EditorDialog$$shapeView.getSelectedElement().isDefined());
        this.org$nlogo$shape$editor$EditorDialog$$duplicateSelected.setEnabled(this.org$nlogo$shape$editor$EditorDialog$$shapeView.getSelectedElement().isDefined());
        this.bringToFront.setEnabled(this.org$nlogo$shape$editor$EditorDialog$$shapeView.getSelectedElement().isDefined());
        this.sendToBack.setEnabled(this.org$nlogo$shape$editor$EditorDialog$$shapeView.getSelectedElement().isDefined());
    }

    private void saveShape() {
        String name = this.org$nlogo$shape$editor$EditorDialog$$nameText.getText().trim().toLowerCase();
        if (name.isEmpty()) {
            new OptionPane(this, I18N$.MODULE$.gui().apply("invalid", this.org$nlogo$shape$editor$EditorDialog$$i18nPrefix), I18N$.MODULE$.gui().apply("nameEmpty", this.org$nlogo$shape$editor$EditorDialog$$i18nPrefix), OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Error());
            return;
        }
        if (this.container.exists(name)) {
            String string = name;
            String string2 = this.org$nlogo$shape$editor$EditorDialog$$originalShape.name();
            if ((string == null ? string2 != null : !string.equals(string2)) && new OptionPane(this, I18N$.MODULE$.gui().apply("confirmOverwrite", this.org$nlogo$shape$editor$EditorDialog$$i18nPrefix), I18N$.MODULE$.gui().apply("nameConflict", this.org$nlogo$shape$editor$EditorDialog$$i18nPrefix), OptionPane$Options$.MODULE$.YesNo(), OptionPane$Icons$.MODULE$.Question()).getSelectedIndex() != 0) {
                return;
            }
        }
        VectorShape newShape = this.org$nlogo$shape$editor$EditorDialog$$shape;
        newShape.name_$eq(name);
        newShape.setRotatable(this.org$nlogo$shape$editor$EditorDialog$$shapeRotatable);
        newShape.markRecolorableElements(EditorDialog$.MODULE$.getColor(this.org$nlogo$shape$editor$EditorDialog$$shape.getEditableColorIndex()), this.org$nlogo$shape$editor$EditorDialog$$shape.getEditableColorIndex());
        this.container.update(this.org$nlogo$shape$editor$EditorDialog$$originalShape, newShape);
        this.dispose();
    }

    public VectorShape org$nlogo$shape$editor$EditorDialog$$getCurrentShape() {
        VectorShape currentShape = this.org$nlogo$shape$editor$EditorDialog$$shape.clone();
        currentShape.name_$eq(this.org$nlogo$shape$editor$EditorDialog$$nameText.getText());
        currentShape.setRotatable(this.org$nlogo$shape$editor$EditorDialog$$shapeRotatable);
        currentShape.markRecolorableElements(EditorDialog$.MODULE$.getColor(this.org$nlogo$shape$editor$EditorDialog$$shape.getEditableColorIndex()), this.org$nlogo$shape$editor$EditorDialog$$shape.getEditableColorIndex());
        return currentShape;
    }

    private void setEditableColor() {
        this.org$nlogo$shape$editor$EditorDialog$$shape.setEditableColorIndex(this.colorSelection.getSelectedIndex());
        this.org$nlogo$shape$editor$EditorDialog$$shape.markRecolorableElements(EditorDialog$.MODULE$.getColor(this.org$nlogo$shape$editor$EditorDialog$$shape.getEditableColorIndex()), this.org$nlogo$shape$editor$EditorDialog$$shape.getEditableColorIndex());
    }

    private ToggleButton addToolBarButton(JToolBar toolbar, ButtonGroup group, Action action) {
        return new ToggleButton(action, toolbar, group){
            {
                this.setBorder(null);
                this.setText(null);
                toolbar$1.add(this);
                group$1.add(this);
            }

            public Insets getInsets() {
                return new Insets(3, 3, 3, 3);
            }
        };
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            Analytics$.MODULE$.turtleShapeEdit();
        }
        super.setVisible(visible);
    }

    public final AbstractAction org$nlogo$shape$editor$EditorDialog$$_$$anon$superArg$1$1() {
        return new AbstractAction(this){
            private final /* synthetic */ EditorDialog $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void actionPerformed(ActionEvent e) {
                this.$outer.org$nlogo$shape$editor$EditorDialog$$editingElements = this.$outer.org$nlogo$shape$editor$EditorDialog$$editElements.isSelected();
                this.$outer.org$nlogo$shape$editor$EditorDialog$$shapeView.deselectAll();
                this.$outer.org$nlogo$shape$editor$EditorDialog$$deleteSelected.setEnabled(false);
                this.$outer.org$nlogo$shape$editor$EditorDialog$$duplicateSelected.setEnabled(false);
                if (this.$outer.org$nlogo$shape$editor$EditorDialog$$editingElements) {
                    this.$outer.org$nlogo$shape$editor$EditorDialog$$shapeView.setCursor(Cursor.getPredefinedCursor(0));
                } else {
                    this.$outer.org$nlogo$shape$editor$EditorDialog$$shapeView.setCursor(Cursor.getPredefinedCursor(1));
                }
                this.$outer.org$nlogo$shape$editor$EditorDialog$$shapeView.selfFinishPolygon(true);
            }
        };
    }

    public final Function0 org$nlogo$shape$editor$EditorDialog$$_$$anon$superArg$2$1() {
        return (JFunction0.mcV.sp & Serializable)() -> this.org$nlogo$shape$editor$EditorDialog$$shapeView.getSelectedElement().foreach(element -> {
            this.undoableEdit = Some$.MODULE$.apply((Object)new UndoableDeleteEdit(this, (Element)element, this.org$nlogo$shape$editor$EditorDialog$$shape.getElements().indexOf(element)));
            this.undoButton.setEnabled(((UndoableEdit)this.undoableEdit.get()).canUndo());
            this.org$nlogo$shape$editor$EditorDialog$$shape.remove((Element)element);
            this.org$nlogo$shape$editor$EditorDialog$$shapeView.deselectAll();
            if (this.org$nlogo$shape$editor$EditorDialog$$shape.getElements().isEmpty()) {
                this.org$nlogo$shape$editor$EditorDialog$$deleteSelected.setEnabled(false);
                this.bringToFront.setEnabled(false);
                this.sendToBack.setEnabled(false);
                this.org$nlogo$shape$editor$EditorDialog$$shape.changed();
                return;
            }
        });
    }

    public final Function0 org$nlogo$shape$editor$EditorDialog$$_$$anon$superArg$3$1() {
        return (JFunction0.mcV.sp & Serializable)() -> this.org$nlogo$shape$editor$EditorDialog$$shapeView.getSelectedElement().foreach(element -> {
            Element newElement = (Element)element.clone();
            this.org$nlogo$shape$editor$EditorDialog$$shape.add(newElement);
            this.makeUndoableDraw(newElement);
        });
    }

    public final Function0 org$nlogo$shape$editor$EditorDialog$$_$$anon$superArg$4$1() {
        return (JFunction0.mcV.sp & Serializable)() -> this.org$nlogo$shape$editor$EditorDialog$$shapeView.getSelectedElement().foreach(element -> {
            this.makeUndoableModification((Element)element, this.org$nlogo$shape$editor$EditorDialog$$shape.getElements().indexOf(element));
            this.org$nlogo$shape$editor$EditorDialog$$shape.remove((Element)element);
            this.org$nlogo$shape$editor$EditorDialog$$shape.add((Element)element);
        });
    }

    public final Function0 org$nlogo$shape$editor$EditorDialog$$_$$anon$superArg$5$1() {
        return (JFunction0.mcV.sp & Serializable)() -> this.org$nlogo$shape$editor$EditorDialog$$shapeView.getSelectedElement().foreach(element -> {
            this.makeUndoableModification((Element)element, this.org$nlogo$shape$editor$EditorDialog$$shape.getElements().indexOf(element));
            this.org$nlogo$shape$editor$EditorDialog$$shape.remove((Element)element);
            this.org$nlogo$shape$editor$EditorDialog$$shape.addAtPosition(0, (Element)element);
        });
    }

    public final Function0 org$nlogo$shape$editor$EditorDialog$$_$$anon$superArg$6$1() {
        return (JFunction0.mcV.sp & Serializable)() -> this.undoableEdit.foreach(edit -> {
            edit.undo();
            this.undoButton.setEnabled(edit.canUndo());
            this.org$nlogo$shape$editor$EditorDialog$$shapeView.deselectAll();
        });
    }

    public final Function0 org$nlogo$shape$editor$EditorDialog$$_$_$$anon$superArg$7$1(Color color$2) {
        return (JFunction0.mcV.sp & Serializable)() -> {
            this.elementColor = color$2;
            this.org$nlogo$shape$editor$EditorDialog$$shapeView.getSelectedElement().foreach(element -> {
                if (this.org$nlogo$shape$editor$EditorDialog$$editingElements) {
                    this.makeUndoableModification((Element)element, this.org$nlogo$shape$editor$EditorDialog$$shape.getElements().indexOf(element));
                    element.awtColor_$eq(color$2);
                    this.org$nlogo$shape$editor$EditorDialog$$shapeView.repaint();
                    return;
                }
            });
        };
    }

    private final /* synthetic */ ColorPanel $init$$$anonfun$1(int i) {
        String name = Color$.MODULE$.ColorNames()[i];
        Color color = EditorDialog$.MODULE$.getColor(i);
        ToggleButton button = new ToggleButton(name, color, this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(name$1, (Function0<BoxedUnit>)$outer.org$nlogo$shape$editor$EditorDialog$$_$_$$anon$superArg$7$1(color$1));
                this.setText(null);
                this.setBorder(null);
                this.setToolTipText(I18N$.MODULE$.gui().apply("drawIn", $outer.org$nlogo$shape$editor$EditorDialog$$i18nPrefix) + " " + name$1);
                this.setBackgroundColor(color$1);
                this.setBackgroundHoverColor(color$1);
            }

            public Dimension getPreferredSize() {
                return new Dimension(20, 20);
            }
        };
        this.colorGrid.add(button);
        this.colorGroup.add(button);
        if (i == this.org$nlogo$shape$editor$EditorDialog$$shape.getEditableColorIndex()) {
            button.setSelected(true);
        }
        return new ColorPanel(this, i);
    }

    public static final /* synthetic */ void org$nlogo$shape$editor$EditorDialog$$anon$11$$_$$lessinit$greater$$anonfun$2(EditorDialog $outer$1, ItemEvent _$1) {
        $outer$1.setEditableColor();
    }

    private final /* synthetic */ void $anon$superArg$8$1$$anonfun$1(boolean selected) {
        this.snapToGrid = selected;
    }

    public final Function1 org$nlogo$shape$editor$EditorDialog$$_$_$$anon$superArg$8$1() {
        return (Function1 & Serializable)v1 -> {
            this.$anon$superArg$8$1$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)v1));
            return BoxedUnit.UNIT;
        };
    }

    private final /* synthetic */ void $anon$superArg$9$1$$anonfun$1(boolean selected) {
        this.org$nlogo$shape$editor$EditorDialog$$shapeRotatable = selected;
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.org$nlogo$shape$editor$EditorDialog$$previews);
        ArrayOps$.MODULE$.foreach$extension(object, _$2 -> _$2.updateRotation(this.org$nlogo$shape$editor$EditorDialog$$shapeRotatable));
        this.org$nlogo$shape$editor$EditorDialog$$shape.setRotatable(this.org$nlogo$shape$editor$EditorDialog$$shapeRotatable);
        this.org$nlogo$shape$editor$EditorDialog$$shapeView.repaint();
    }

    public final Function1 org$nlogo$shape$editor$EditorDialog$$_$_$$anon$superArg$9$1() {
        return (Function1 & Serializable)v1 -> {
            this.$anon$superArg$9$1$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)v1));
            return BoxedUnit.UNIT;
        };
    }

    public class ColorPanel
    extends JPanel
    implements Transparent,
    ComboBox.Clone {
        public final int org$nlogo$shape$editor$EditorDialog$ColorPanel$$index;
        private final JLabel label;
        private final /* synthetic */ EditorDialog $outer;

        public ColorPanel(EditorDialog $outer, int index) {
            this.org$nlogo$shape$editor$EditorDialog$ColorPanel$$index = index;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(new FlowLayout(0, 6, 0));
            Transparent.$init$(this);
            String name = Color$.MODULE$.getColorNameByIndex(index);
            this.label = new JLabel(BoxesRunTime.boxToCharacter((char)RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(name), 0)))).toString() + name.substring(1));
            this.add(new JPanel(this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.setBackground(EditorDialog$.MODULE$.getColor($outer.org$nlogo$shape$editor$EditorDialog$ColorPanel$$index));
                    this.setPreferredSize(new Dimension(10, 10));
                }
            });
            this.add(this.label);
        }

        @Override
        public void paintComponent(Graphics g) {
            MenuItem item;
            Container container = this.getParent();
            if (container instanceof MenuItem && (item = (MenuItem)container).isArmed()) {
                this.label.setForeground(InterfaceColors$.MODULE$.menuTextHover());
            } else {
                this.label.setForeground(InterfaceColors$.MODULE$.toolbarText());
            }
            super.paintComponent(g);
        }

        @Override
        public Component getClone() {
            return new ColorPanel(this.$outer, this.org$nlogo$shape$editor$EditorDialog$ColorPanel$$index);
        }

        public final /* synthetic */ EditorDialog org$nlogo$shape$editor$EditorDialog$ColorPanel$$$outer() {
            return this.$outer;
        }
    }

    public class CreateAction
    extends AbstractAction {
        private final ElementType typeID;
        private final boolean filled;
        private final /* synthetic */ EditorDialog $outer;

        public CreateAction(EditorDialog $outer, String name, ElementType typeID, boolean filled) {
            this.typeID = typeID;
            this.filled = filled;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(name);
            this.putValue("SmallIcon", Utils$.MODULE$.iconScaledWithColor("/images/shapes-editor/" + name + ".png", 15, 15, InterfaceColors$.MODULE$.toolbarText()));
            this.putValue("ShortDescription", I18N$.MODULE$.gui().apply(name, $outer.org$nlogo$shape$editor$EditorDialog$$i18nPrefix));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.$outer.org$nlogo$shape$editor$EditorDialog$$shapeView.selfFinishPolygon(true);
            this.$outer.org$nlogo$shape$editor$EditorDialog$$elementType = this.typeID;
            this.$outer.org$nlogo$shape$editor$EditorDialog$$fillShapes = this.filled;
            this.$outer.org$nlogo$shape$editor$EditorDialog$$editingElements = false;
            this.$outer.org$nlogo$shape$editor$EditorDialog$$shapeView.deselectAll();
            this.$outer.org$nlogo$shape$editor$EditorDialog$$shapeView.setCursor(Cursor.getPredefinedCursor(1));
        }

        public final /* synthetic */ EditorDialog org$nlogo$shape$editor$EditorDialog$CreateAction$$$outer() {
            return this.$outer;
        }
    }

    public class UndoableDeleteEdit
    extends AbstractUndoableEdit {
        private final int zOrder;
        private final Element deletedElement;
        private final /* synthetic */ EditorDialog $outer;

        public UndoableDeleteEdit(EditorDialog $outer, Element el, int zOrder) {
            this.zOrder = zOrder;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.deletedElement = (Element)el.clone();
        }

        @Override
        public void undo() {
            super.undo();
            this.$outer.org$nlogo$shape$editor$EditorDialog$$shape.addAtPosition(this.zOrder, this.deletedElement);
        }

        public final /* synthetic */ EditorDialog org$nlogo$shape$editor$EditorDialog$UndoableDeleteEdit$$$outer() {
            return this.$outer;
        }
    }

    public class UndoableDraw
    extends AbstractUndoableEdit {
        private final Element newElement;
        private final /* synthetic */ EditorDialog $outer;

        public UndoableDraw(EditorDialog $outer, Element newElement) {
            this.newElement = newElement;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public void undo() {
            super.undo();
            this.$outer.org$nlogo$shape$editor$EditorDialog$$shape.remove(this.newElement);
        }

        public final /* synthetic */ EditorDialog org$nlogo$shape$editor$EditorDialog$UndoableDraw$$$outer() {
            return this.$outer;
        }
    }

    public class UndoableModification
    extends AbstractUndoableEdit {
        private final Element el;
        private final int zOrder;
        private final Element originalElement;
        private final /* synthetic */ EditorDialog $outer;

        public UndoableModification(EditorDialog $outer, Element el, int zOrder) {
            this.el = el;
            this.zOrder = zOrder;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.originalElement = (Element)el.clone();
        }

        @Override
        public void undo() {
            super.undo();
            this.$outer.org$nlogo$shape$editor$EditorDialog$$shape.remove(this.el);
            this.$outer.org$nlogo$shape$editor$EditorDialog$$shape.addAtPosition(this.zOrder, this.originalElement);
            if (this.$outer.org$nlogo$shape$editor$EditorDialog$$shapeView.getSelectedElement().isDefined()) {
                this.$outer.org$nlogo$shape$editor$EditorDialog$$shapeView.selectElement(this.originalElement);
                return;
            }
        }

        public final /* synthetic */ EditorDialog org$nlogo$shape$editor$EditorDialog$UndoableModification$$$outer() {
            return this.$outer;
        }
    }

    public class UndoableUnfinishedPolygon
    extends AbstractUndoableEdit {
        public UndoableUnfinishedPolygon() {
            if (EditorDialog.this == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public void undo() {
            super.undo();
            EditorDialog.this.org$nlogo$shape$editor$EditorDialog$$shapeView.setTempElement(null);
        }

        public final /* synthetic */ EditorDialog org$nlogo$shape$editor$EditorDialog$UndoableUnfinishedPolygon$$$outer() {
            return EditorDialog.this;
        }
    }

    public static interface VectorShapeContainer {
        public boolean exists(String var1);

        public void update(Shape var1, Shape var2);
    }
}

