/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.nlogo.core.I18N;
import org.nlogo.core.I18N$;
import org.nlogo.core.I18N$Prefix$;
import org.nlogo.core.Shape;
import org.nlogo.shape.editor.DrawableList;
import org.nlogo.shape.editor.ManagerDialog;
import org.nlogo.swing.ButtonPanel;
import org.nlogo.swing.DialogButton;
import org.nlogo.swing.InputOptionPane;
import org.nlogo.swing.InputOptionPane$;
import org.nlogo.swing.OptionPane;
import org.nlogo.swing.OptionPane$Icons$;
import org.nlogo.swing.OptionPane$Options$;
import org.nlogo.swing.ScrollPane;
import org.nlogo.swing.ScrollPane$;
import org.nlogo.swing.Utils$;
import org.nlogo.theme.InterfaceColors$;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public class ImportDialog
extends JDialog
implements ListSelectionListener {
    private final ManagerDialog<? extends Shape> manager;
    public final DrawableList<? extends Shape> org$nlogo$shape$editor$ImportDialog$$list;
    private final I18N.Prefix i18nPrefix;

    public ImportDialog(JDialog parent, ManagerDialog<? extends Shape> manager, DrawableList<? extends Shape> list) {
        this.manager = manager;
        this.org$nlogo$shape$editor$ImportDialog$$list = list;
        super(parent, I18N$.MODULE$.gui().get("tools.shapesEditor.importFromLibrary"), true);
        this.i18nPrefix = I18N$Prefix$.MODULE$.apply("tools.shapesEditor.import");
        DialogButton importButton = new DialogButton(true, I18N$.MODULE$.gui().get("tools.shapesEditor.import"), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.org$nlogo$shape$editor$ImportDialog$$importSelectedShapes());
        DialogButton cancelButton = new DialogButton(false, I18N$.MODULE$.gui().get("common.buttons.cancel"), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.dispose());
        this.getContentPane().setLayout(new BorderLayout(0, 10));
        this.getContentPane().add((Component)new ScrollPane(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super($outer.org$nlogo$shape$editor$ImportDialog$$list, ScrollPane$.MODULE$.$lessinit$greater$default$2(), ScrollPane$.MODULE$.$lessinit$greater$default$3());
                this.setBackground(InterfaceColors$.MODULE$.dialogBackground());
            }
        }, "Center");
        this.getContentPane().add((Component)new ButtonPanel((Seq<JComponent>)((Seq)((SeqOps)new .colon.colon((Object)importButton, (List)new .colon.colon((Object)cancelButton, (List)Nil$.MODULE$))))), "South");
        this.getRootPane().setDefaultButton(importButton);
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        Utils$.MODULE$.addEscKeyAction(this, (Action)new AbstractAction(this){
            private final /* synthetic */ ImportDialog $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void actionPerformed(ActionEvent e) {
                this.$outer.dispose();
            }
        });
        list.update(list.update$default$1());
        list.setBackground(InterfaceColors$.MODULE$.dialogBackground());
        list.addMouseListener(new MouseAdapter(this){
            private final /* synthetic */ ImportDialog $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    this.$outer.org$nlogo$shape$editor$ImportDialog$$importSelectedShapes();
                    return;
                }
            }
        });
        this.getContentPane().setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.pack();
        this.setLocation(manager.getLocation().x + 10, manager.getLocation().y + 10);
        this.setVisible(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int[] selected = this.org$nlogo$shape$editor$ImportDialog$$list.getSelectedIndices();
        if (selected.length == 1) {
            this.org$nlogo$shape$editor$ImportDialog$$list.ensureIndexIsVisible(selected[0]);
            return;
        }
    }

    public void org$nlogo$shape$editor$ImportDialog$$importSelectedShapes() {
        Seq choices = (Seq)((SeqOps)new .colon.colon((Object)I18N$.MODULE$.gui().apply("replace", this.i18nPrefix), (List)new .colon.colon((Object)I18N$.MODULE$.gui().apply("rename", this.i18nPrefix), (List)new .colon.colon((Object)I18N$.MODULE$.gui().get("common.buttons.cancel"), (List)Nil$.MODULE$))));
        Object object = Predef$.MODULE$.intArrayOps(this.org$nlogo$shape$editor$ImportDialog$$list.getSelectedIndices());
        Option shapes = (Option)ArrayOps$.MODULE$.foldLeft$extension(object, (Object)Option$.MODULE$.apply((Object)((SeqOps)Nil$.MODULE$)), (Function2 & Serializable)(x$1, x$2) -> this.$anonfun$3(choices, (Option)x$1, BoxesRunTime.unboxToInt((Object)x$2)));
        shapes.foreach(s -> {
            s.foreach(shape -> this.manager.shapesList().addShape((Shape)shape));
            this.manager.shapesList().update(this.manager.shapesList().update$default$1());
            this.manager.shapesList().selectShapeName("default");
            this.dispose();
        });
    }

    public void sendImportWarning(String message) {
        new OptionPane(this, I18N$.MODULE$.gui().get("tools.shapesEditor.import"), message, OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Warning());
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(super.getPreferredSize().width), 260), super.getPreferredSize().height);
    }

    private final /* synthetic */ Option $anonfun$3(Seq choices$1, Option x$1, int x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, (Object)BoxesRunTime.boxToInteger((int)x$2));
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            if (None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            if (option instanceof Some) {
                Seq s = (Seq)((Some)option).value();
                int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                Shape shape = (Shape)this.org$nlogo$shape$editor$ImportDialog$$list.getShape(index).get();
                int choice = 1;
                while (this.manager.shapesList().exists(shape.name()) && choice == 1) {
                    String name;
                    choice = new OptionPane(this, I18N$.MODULE$.gui().get("tools.shapesEditor.import"), I18N$.MODULE$.gui().apply("nameConflict", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{shape.name()}), this.i18nPrefix), (Seq<String>)choices$1, OptionPane$Icons$.MODULE$.Warning()).getSelectedIndex();
                    if (choice != 1 || (name = new InputOptionPane((Component)this, I18N$.MODULE$.gui().apply("importShapes", this.i18nPrefix), I18N$.MODULE$.gui().apply("importAs", this.i18nPrefix), InputOptionPane$.MODULE$.$lessinit$greater$default$4()).getInput()) == null) continue;
                    shape.name_$eq(name);
                }
                if (choice == -1 || choice == 2) {
                    return None$.MODULE$;
                }
                return Some$.MODULE$.apply(s.$colon$plus((Object)shape));
            }
        }
        throw new MatchError((Object)tuple2);
    }
}

