/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.nlogo.api.Graphics2DWrapper;
import org.nlogo.awt.Fonts;
import org.nlogo.shape.Element;
import org.nlogo.shape.VectorShape;
import org.nlogo.shape.editor.EditorDialog;

class ShapePreview
extends JPanel
implements PropertyChangeListener {
    private int rotationAngle;
    private final int rotationSpeed;
    private boolean stopRotation = false;
    private final int scale;
    private final VectorShape shape;
    Timer timer = new Timer(30, new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ShapePreview.this.rotate();
        }
    });
    private int colorNumber = 5;

    ShapePreview(VectorShape shape, int scale, int rotationSpeed) {
        this.shape = shape;
        this.scale = scale;
        this.rotationSpeed = rotationSpeed;
        this.rotationAngle = 0;
        this.setBackground(Color.DARK_GRAY);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(60, 78);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(60, 78);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(60, 78);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        int x;
        super.paintComponent(g);
        int y = x = Element.round(0.5 * (double)this.getWidth() - 0.5 * (double)this.scale);
        g.setColor(Color.BLACK);
        g.fillRect(x, y, this.scale, this.scale);
        g.setFont(new Font(Fonts.platformFont(), 0, 10));
        g.drawString(Integer.toString(this.scale), (this.getWidth() - g.getFontMetrics().stringWidth(Integer.toString(this.scale))) / 2, y + this.scale + g.getFontMetrics().getHeight() + 2);
        g.clipRect(x, y, this.scale, this.scale);
        VectorShape vectorShape = this.shape;
        synchronized (vectorShape) {
            Graphics2DWrapper g2 = new Graphics2DWrapper((Graphics2D)g);
            g2.antiAliasing(true);
            this.shape.paint(g2, new Color(org.nlogo.api.Color.getARGBbyPremodulatedColorNumber(this.colorNumber)), x, y, this.scale, this.rotationAngle);
            this.shape.setRotatable(true);
        }
    }

    void updateRotation(boolean rotatable) {
        this.stopRotation = !rotatable;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.timer.start();
    }

    @Override
    public void removeNotify() {
        this.timer.stop();
        super.removeNotify();
    }

    private int newColorNumber() {
        return 5 + 10 * (int)((long)StrictMath.floor(System.currentTimeMillis() / 200L) % 14L);
    }

    private void rotate() {
        int lastColorNumber = this.colorNumber;
        this.colorNumber = this.newColorNumber();
        if (this.colorNumber != lastColorNumber) {
            this.shape.markRecolorableElements(EditorDialog.getColor(this.shape.getEditableColorIndex()), this.shape.getEditableColorIndex());
            this.repaint();
        }
        if (!this.stopRotation || this.rotationAngle != 0) {
            int fastSpeed;
            int newRotationAngle;
            this.rotationAngle = this.stopRotation ? ((newRotationAngle = (this.rotationAngle + (fastSpeed = this.rotationSpeed > 0 ? 16 : -16) + 360) % 360) - this.rotationAngle != fastSpeed ? 0 : newRotationAngle) : (this.rotationAngle + this.rotationSpeed + 360) % 360;
            this.repaint();
        }
    }
}

