/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.Serializable;
import javax.swing.JFileChooser;
import org.nlogo.awt.Hierarchy$;
import org.nlogo.awt.UserCancelException;
import org.nlogo.core.I18N$;
import org.nlogo.swing.OptionPane;
import org.nlogo.swing.OptionPane$Icons$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class FileDialog$
implements Serializable {
    private static Option<String> currentDirectory;
    public static final FileDialog$ MODULE$;

    private FileDialog$() {
    }

    static {
        MODULE$ = new FileDialog$();
        currentDirectory = None$.MODULE$;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FileDialog$.class);
    }

    public void setDirectory(String directory) {
        currentDirectory = Option$.MODULE$.apply((Object)directory);
    }

    public String getDirectory() {
        return (String)currentDirectory.getOrElse(FileDialog$::getDirectory$$anonfun$1);
    }

    public String showFiles(Component component, String title, int mode, String file, List<String> allowed) throws UserCancelException {
        return this.showFiles(Hierarchy$.MODULE$.getFrame(component), title, mode, file, allowed);
    }

    public List<String> showFiles$default$5() {
        return package$.MODULE$.Nil();
    }

    public Option<String> confirmFileOverwrite(Component owner, String path) {
        if (new OptionPane(owner, I18N$.MODULE$.gui().get("common.netlogo"), I18N$.MODULE$.gui().getN("file.save.warn.overwrite", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{path})), (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)I18N$.MODULE$.gui().get("common.buttons.replace"), (List)new .colon.colon((Object)I18N$.MODULE$.gui().get("common.buttons.cancel"), (List)Nil$.MODULE$)))), OptionPane$Icons$.MODULE$.Question()).getSelectedIndex() != 0) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)path);
    }

    public String showFiles(Frame parentFrame, String title, int mode) throws UserCancelException {
        return this.showFiles(parentFrame, title, mode, null, (List<String>)package$.MODULE$.Nil());
    }

    public String showDirectories(Frame parentFrame, String title) throws UserCancelException {
        JFileChooser chooser;
        do {
            chooser = new JFileChooser(this.getDirectory());
            chooser.setDialogTitle(title);
            chooser.setFileSelectionMode(1);
            if (chooser.showOpenDialog(parentFrame) != 0) {
                throw new UserCancelException();
            }
            this.setDirectory(this.selectedDirectory(chooser));
        } while (!chooser.getSelectedFile().exists());
        return chooser.getSelectedFile().getAbsolutePath();
    }

    private String showFiles(Frame parentFrame, String title, int mode, String file, List<String> allowed) throws UserCancelException {
        FileDialog chooser;
        while (true) {
            chooser = new FileDialog(parentFrame, title, mode);
            chooser.setDirectory(this.getDirectory());
            if (file != null) {
                chooser.setFile(file);
            }
            chooser.setVisible(true);
            if (chooser.getFile() == null) {
                throw new UserCancelException();
            }
            this.setDirectory(chooser.getDirectory());
            if (mode != 0 || new File(this.getDirectory() + chooser.getFile()).exists()) break;
            file = chooser.getFile();
        }
        if (chooser.getDirectory() == null) {
            return chooser.getFile();
        }
        return chooser.getDirectory() + chooser.getFile();
    }

    private String selectedDirectory(JFileChooser chooser) {
        File file = chooser.getSelectedFile();
        File dir = file.isDirectory() ? file : chooser.getCurrentDirectory();
        return dir.getAbsolutePath();
    }

    private static final String getDirectory$$anonfun$1() {
        return System.getProperty("user.home");
    }
}

