/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.nlogo.swing.FloatingTabbedPane;
import org.nlogo.swing.Utils$;
import org.nlogo.theme.InterfaceColors$;
import scala.Function1;
import scala.Predef$;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class FloatingTabbedPaneUI
extends BasicTabbedPaneUI {
    private final FloatingTabbedPane tabbedPane;

    public FloatingTabbedPaneUI(FloatingTabbedPane tabbedPane) {
        this.tabbedPane = tabbedPane;
    }

    @Override
    public Insets getContentBorderInsets(int tabPlacement) {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        return fontHeight + 5;
    }

    @Override
    public int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return super.getTabLabelShiftY(tabPlacement, tabIndex, true);
    }

    @Override
    public Insets getTabAreaInsets(int tabPlacement) {
        IntRef x = IntRef.create((int)(this.tabbedPane.getWidth() / 2));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.tabbedPane.getTabCount()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> x$1.elem -= this.calculateTabWidth(tabPlacement, i, this.getFontMetrics()) / 2);
        return new Insets(10, x.elem, 0, 0);
    }

    @Override
    public void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        super.paintTabArea(g, tabPlacement, selectedIndex);
        Graphics2D g2d = Utils$.MODULE$.initGraphics2D(g);
        IntRef x = IntRef.create((int)(this.getTabAreaInsets((int)tabPlacement).left + this.calculateTabWidth(tabPlacement, 0, this.getFontMetrics())));
        int y = this.getTabAreaInsets((int)tabPlacement).top;
        int height = this.calculateTabHeight(tabPlacement, 0, this.getFontMetrics().getHeight());
        g2d.setColor(InterfaceColors$.MODULE$.tabSeparator());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.tabbedPane.getTabCount()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            if (i != selectedIndex && i != selectedIndex + 1) {
                g2d.drawLine(x$2.elem, y + 5, x$2.elem, y + height - 5);
            }
            x$2.elem += this.calculateTabWidth(tabPlacement, i, this.getFontMetrics());
        });
    }

    @Override
    public void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Graphics2D g2d = Utils$.MODULE$.initGraphics2D(g);
        if (isSelected) {
            if (this.tabbedPane.getError(tabIndex)) {
                g2d.setColor(InterfaceColors$.MODULE$.tabBackgroundError());
            } else {
                g2d.setColor(InterfaceColors$.MODULE$.tabBackgroundSelected());
            }
        } else if (this.tabbedPane.isHover(tabIndex)) {
            g2d.setColor(InterfaceColors$.MODULE$.tabBackgroundHover());
        } else {
            g2d.setColor(InterfaceColors$.MODULE$.tabBackground());
        }
        if (this.tabbedPane.getTabCount() == 1) {
            g2d.fillRoundRect(x, y, w, h, 10, 10);
            return;
        }
        if (tabIndex == 0) {
            g2d.fillRoundRect(x, y, w - 10, h, 10, 10);
            g2d.fillRect(x + w - 20, y, 20, h);
            return;
        }
        if (tabIndex == this.tabbedPane.getTabCount() - 1) {
            g2d.fillRoundRect(x + 10, y, w - 10, h, 10, 10);
            g2d.fillRect(x, y, 20, h);
            return;
        }
        g2d.fillRect(x, y, w, h);
    }

    @Override
    public void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (!isSelected) {
            Graphics2D g2d = Utils$.MODULE$.initGraphics2D(g);
            g2d.setColor(InterfaceColors$.MODULE$.tabBorder());
            if (tabIndex == 0) {
                g2d.drawArc(x, y, 10, 10, 90, 90);
                g2d.drawArc(x, y + h - 11, 10, 10, 180, 90);
                g2d.drawLine(x, y + 5, x, y + h - 5);
                g2d.drawLine(x + 5, y, x + w, y);
                g2d.drawLine(x + 5, y + h - 1, x + w, y + h - 1);
                return;
            }
            if (tabIndex == this.tabbedPane.getTabCount() - 1) {
                g2d.drawArc(x + w - 10, y, 10, 10, 0, 90);
                g2d.drawArc(x + w - 10, y + h - 11, 10, 10, 270, 90);
                g2d.drawLine(x + w, y + 5, x + w, y + h - 5);
                g2d.drawLine(x, y, x + w - 5, y);
                g2d.drawLine(x, y + h - 1, x + w - 5, y + h - 1);
                return;
            }
            g2d.drawLine(x, y, x + w, y);
            g2d.drawLine(x, y + h - 1, x + w, y + h - 1);
            return;
        }
    }

    @Override
    public void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = Utils$.MODULE$.initGraphics2D(g);
        g2d.setColor(this.tabbedPane.getBackground());
        g2d.fillRect(0, 0, this.tabbedPane.getWidth(), this.tabbedPane.getHeight());
        super.paint(g, c);
    }
}

