/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import org.nlogo.swing.Utils$;

public class ScalableIcon
implements Icon {
    private final Icon icon;
    private final int width;
    private final int height;

    public ScalableIcon(Icon icon, int width, int height) {
        this.icon = icon;
        this.width = width;
        this.height = height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = Utils$.MODULE$.initGraphics2D(g);
        AffineTransform transform = g2d.getTransform();
        double scaleX = transform.getScaleX();
        double scaleY = transform.getScaleY();
        AffineTransform scaled = (AffineTransform)transform.clone();
        scaled.concatenate(AffineTransform.getScaleInstance(1.0 / scaleX, 1.0 / scaleY));
        g2d.setTransform(scaled);
        this.icon.paintIcon(c, g2d, (int)((double)x * scaleX), (int)((double)y * scaleY));
        g2d.setTransform(transform);
    }
}

