/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.lang.invoke.StringConcatFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.nlogo.swing.CloseButton;
import org.nlogo.swing.CloseableTab;
import org.nlogo.swing.FloatingTabbedPane;
import org.nlogo.theme.InterfaceColors$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public class TabLabel
extends JPanel {
    private final Component tab;
    private FloatingTabbedPane tabbedPane;
    private final JLabel textLabel;
    private String rawText;
    private Option<CloseButton> closeButton;
    private boolean error;

    public TabLabel(FloatingTabbedPane startPane, String text, Component tab) {
        this.tab = tab;
        super(new GridBagLayout());
        this.tabbedPane = startPane;
        this.textLabel = new JLabel(text);
        this.rawText = text;
        this.closeButton = None$.MODULE$;
        this.error = false;
        this.setOpaque(false);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        this.add((Component)this.textLabel, c);
        Component component = tab;
        if (component instanceof CloseableTab) {
            CloseableTab closeable = (CloseableTab)((Object)component);
            CloseButton button = new CloseButton();
            button.addMouseListener(new MouseAdapter(closeable){
                private final CloseableTab closeable$1;
                {
                    this.closeable$1 = closeable$2;
                }

                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1) {
                        this.closeable$1.close();
                        return;
                    }
                }
            });
            c.fill = 0;
            c.weightx = 0.0;
            this.add((Component)button, c);
            this.closeButton = Some$.MODULE$.apply((Object)button);
        }
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
    }

    public void setTabbedPane(FloatingTabbedPane tabbedPane) {
        this.tabbedPane = tabbedPane;
    }

    public void setText(String text) {
        this.rawText = text;
    }

    public String getText() {
        return this.rawText;
    }

    public int boldWidth() {
        return new JLabel((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"<html><b>\u0001</b></html>"}, (String)this.rawText))).getPreferredSize().width;
    }

    public boolean error() {
        return this.error;
    }

    public void error_$eq(boolean x$1) {
        this.error = x$1;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.boldWidth() + BoxesRunTime.unboxToInt((Object)this.closeButton.map((Function1 & Serializable)_$1 -> _$1.getPreferredSize().width + 10).getOrElse(TabLabel::getPreferredSize$$anonfun$2)), super.getPreferredSize().height);
    }

    @Override
    public void paintComponent(Graphics g) {
        Component component = this.tab;
        Component component2 = this.tabbedPane.getSelectedComponent();
        if (!(component != null ? !component.equals(component2) : component2 != null)) {
            this.textLabel.setForeground(InterfaceColors$.MODULE$.tabTextSelected());
            this.textLabel.setText("<html><b>" + this.rawText + "</b></html>");
            this.closeButton.foreach(_$2 -> _$2.setForeground(InterfaceColors$.MODULE$.tabTextSelected()));
        } else if (this.tabbedPane.getError(this.tabbedPane.indexOfComponent(this.tab))) {
            this.textLabel.setForeground(InterfaceColors$.MODULE$.tabTextError());
            this.textLabel.setText("<html><b>" + this.rawText + "</b></html>");
            this.closeButton.foreach(_$3 -> _$3.setForeground(InterfaceColors$.MODULE$.tabTextError()));
        } else {
            this.textLabel.setForeground(InterfaceColors$.MODULE$.tabText());
            this.textLabel.setText(this.rawText);
            this.closeButton.foreach(_$4 -> _$4.setForeground(InterfaceColors$.MODULE$.tabText()));
        }
        super.paintComponent(g);
    }

    private static final int getPreferredSize$$anonfun$2() {
        return 0;
    }
}

