/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Timer;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.nlogo.swing.UserAction;
import org.nlogo.swing.UserAction$KeyBindings$;

public class UndoManager
extends javax.swing.undo.UndoManager
implements ActionListener,
FocusListener,
PropertyChangeListener {
    private static final int EDIT_COMPOSITION_THRESHOLD = 200;
    private static UndoAction undoAction = new UndoAction();
    private static RedoAction redoAction = new RedoAction();
    private static UndoManager currentManager = null;
    private final Timer _timer = new Timer(200, this);
    private CompoundEdit _editInProgress = null;
    private long _lastEditTime = 0L;
    private Object _lastEditSource = null;

    public static UndoAction undoAction() {
        return undoAction;
    }

    public static RedoAction redoAction() {
        return redoAction;
    }

    static UndoManager currentManager() {
        return currentManager;
    }

    public static void setCurrentManager(UndoManager manager) {
        currentManager = manager;
        undoAction.updateUndoState();
        redoAction.updateRedoState();
    }

    public void watch(JTextComponent textComponent) {
        textComponent.getDocument().addUndoableEditListener(this);
        textComponent.addPropertyChangeListener(this);
        textComponent.addFocusListener(this);
    }

    @Override
    public synchronized void undo() throws CannotUndoException {
        this.closeEditInProgress(true);
        super.undo();
    }

    @Override
    public synchronized void redo() throws CannotRedoException {
        this.closeEditInProgress(false);
        super.redo();
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this._timer.stop();
        long currentTime = System.currentTimeMillis();
        Object currentSource = e.getSource();
        if (this._editInProgress == null) {
            this._editInProgress = new CompoundEdit();
        } else if (this._lastEditSource != currentSource || currentTime - this._lastEditTime > 200L) {
            this.closeEditInProgress(false);
            this._editInProgress = new CompoundEdit();
        }
        this._editInProgress.addEdit(e.getEdit());
        this._lastEditTime = currentTime;
        this._lastEditSource = currentSource;
        this._timer.restart();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this._timer) {
            this.closeEditInProgress(true);
        }
    }

    private void closeEditInProgress(boolean perform) {
        if (this._editInProgress != null) {
            this._editInProgress.end();
            if (perform) {
                this.addEdit(this._editInProgress);
            } else {
                this._editInProgress.die();
            }
            this._editInProgress = null;
            this._lastEditTime = 0L;
            this._lastEditSource = null;
            this._timer.stop();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("document")) {
            ((Document)event.getOldValue()).removeUndoableEditListener(this);
            ((Document)event.getNewValue()).addUndoableEditListener(this);
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        UndoManager.setCurrentManager(this);
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (!event.isTemporary()) {
            UndoManager.setCurrentManager(null);
        }
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        boolean result = super.addEdit(anEdit);
        if (this == currentManager) {
            undoAction.updateUndoState();
            redoAction.updateRedoState();
        }
        return result;
    }

    @Override
    public void discardAllEdits() {
        this.closeEditInProgress(false);
        super.discardAllEdits();
        if (this == currentManager) {
            undoAction.updateUndoState();
            redoAction.updateRedoState();
        }
    }

    static class UndoAction
    extends AbstractAction
    implements UserAction.MenuAction {
        public UndoAction() {
            super("Undo");
            this.category_$eq("org.nlogo.swing.EditCategory");
            this.group_$eq("org.nlogo.swing.EditUndoGroup");
            this.accelerator_$eq(UserAction$KeyBindings$.MODULE$.keystroke(90, true, false, false));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (currentManager.canUndo()) {
                currentManager.undo();
                this.updateUndoState();
                redoAction.updateRedoState();
            }
        }

        protected void updateUndoState() {
            if (currentManager != null && currentManager.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", currentManager.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }

    static class RedoAction
    extends AbstractAction
    implements UserAction.MenuAction {
        public RedoAction() {
            super("Redo");
            this.category_$eq("org.nlogo.swing.EditCategory");
            this.group_$eq("org.nlogo.swing.EditUndoGroup");
            this.accelerator_$eq(UserAction$KeyBindings$.MODULE$.keystroke(89, true, false, false));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            currentManager.redo();
            this.updateRedoState();
            undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (currentManager != null && currentManager.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", currentManager.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }
}

