/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.border.LineBorder;
import org.nlogo.agent.World;
import org.nlogo.core.I18N$;
import org.nlogo.core.View$;
import org.nlogo.core.Widget;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.window.DummyViewEditPanel;
import org.nlogo.window.EditPanel;
import org.nlogo.window.Editable;
import org.nlogo.window.MouseMode;
import org.nlogo.window.SingleErrorWidget;
import scala.Option;
import scala.Some$;

public class DummyViewWidget
extends SingleErrorWidget
implements Editable {
    private final World world;
    private int newWidth;
    private int newHeight;

    public DummyViewWidget(World world) {
        this.world = world;
        this.setBackgroundColor(Color.BLACK);
        this.newWidth = (int)StrictMath.round((double)world.worldWidth() * world.patchSize());
        this.newHeight = (int)StrictMath.round((double)world.worldHeight() * world.patchSize());
        this.setSize(this.newWidth, this.newHeight);
    }

    public World world() {
        return this.world;
    }

    @Override
    public String classDisplayName() {
        return I18N$.MODULE$.gui().get("tabs.run.widgets.view");
    }

    @Override
    public EditPanel editPanel() {
        return new DummyViewEditPanel(this);
    }

    @Override
    public Option<Editable> getEditable() {
        return Some$.MODULE$.apply((Object)this);
    }

    public int width() {
        return this.newWidth;
    }

    public void setWidth(int width) {
        this.newWidth = width;
    }

    public int height() {
        return this.newHeight;
    }

    public void setHeight(int height) {
        this.newHeight = height;
    }

    @Override
    public boolean editFinished() {
        if (this.newWidth != this.getWidth() || this.newHeight != this.getHeight()) {
            this.setSize(new Dimension(this.newWidth, this.newHeight));
            this.resetSizeInfo();
        }
        return true;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.world().worldWidth(), this.world().worldHeight());
    }

    @Override
    public Rectangle constrainDrag(Rectangle newBounds, Rectangle originalBounds, MouseMode mouseMode) {
        this.newWidth = newBounds.width;
        this.newHeight = newBounds.height;
        return newBounds;
    }

    @Override
    public boolean hasContextMenu() {
        return false;
    }

    @Override
    public void syncTheme() {
        this.setBorder(new LineBorder(InterfaceColors$.MODULE$.viewBorder(), 2));
    }

    @Override
    public Widget model() {
        Rectangle b = this.getUnzoomedBounds();
        return View$.MODULE$.apply(b.x, b.y, b.width, b.height, this.world().getDimensions(), View$.MODULE$.$lessinit$greater$default$6(), View$.MODULE$.$lessinit$greater$default$7(), View$.MODULE$.$lessinit$greater$default$8(), View$.MODULE$.$lessinit$greater$default$9(), View$.MODULE$.$lessinit$greater$default$10());
    }

    @Override
    public void load(Widget view) {
        this.setBounds(view.x(), view.y(), view.width(), view.height());
        this.newWidth = this.getWidth();
        this.newHeight = this.getHeight();
    }
}

