/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import org.nlogo.swing.Utils$;
import org.nlogo.theme.InterfaceColors$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

public class ErrorLabel
extends JLabel {
    private int originalFontSize;

    public ErrorLabel() {
        this.setOpaque(true);
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.setVisible(false);
        this.originalFontSize = -1;
    }

    public void setError(Option<Exception> error, int offset) {
        Option<Exception> option = error;
        if (option instanceof Some) {
            Exception e = (Exception)((Some)option).value();
            this.setForeground(InterfaceColors$.MODULE$.errorLabelText());
            this.setBackground(InterfaceColors$.MODULE$.errorLabelBackground());
            this.setIcon(Utils$.MODULE$.iconScaledWithColor("/images/error.png", 15, 15, InterfaceColors$.MODULE$.errorLabelText()));
            this.setText("<html><b>" + this.encodeHTML(e.getMessage()) + "</b></html>");
            this.setVisible(true);
            return;
        }
        this.setVisible(false);
    }

    public void setWarning(Option<String> warning) {
        Option<String> option = warning;
        if (option instanceof Some) {
            String str = (String)((Some)option).value();
            this.setForeground(InterfaceColors$.MODULE$.warningLabelText());
            this.setBackground(InterfaceColors$.MODULE$.warningLabelBackground());
            this.setIcon(Utils$.MODULE$.iconScaledWithColor("/images/exclamation-triangle.png", 15, 15, InterfaceColors$.MODULE$.warningLabelText()));
            this.setText("<html><b>" + this.encodeHTML(str) + "</b></html>");
            this.setVisible(true);
            return;
        }
        this.setVisible(false);
    }

    public void zoom(double zoomFactor) {
        if (this.originalFontSize == -1) {
            this.originalFontSize = this.getFont().getSize();
        }
        this.setFont(this.getFont().deriveFont((float)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)this.originalFontSize * zoomFactor))));
        this.repaint();
        this.revalidate();
    }

    private String encodeHTML(String s) {
        return StringOps$.MODULE$.flatMap$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)c -> ErrorLabel.encode$1(BoxesRunTime.unboxToChar((Object)c)));
    }

    private static final String encode$1(char c) {
        if (c > '\u007f' || c == '\"' || c == '<' || c == '>' || c == '/') {
            return "&#" + c + ";";
        }
        return BoxesRunTime.boxToCharacter((char)c).toString();
    }
}

