/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.JLayeredPane;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.RandomServices;
import org.nlogo.api.Version$;
import org.nlogo.awt.Images$;
import org.nlogo.core.View;
import org.nlogo.editor.EditorConfiguration;
import org.nlogo.plot.PlotManager;
import org.nlogo.swing.MenuItem;
import org.nlogo.swing.PopupMenu;
import org.nlogo.swing.PopupMenu$;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.theme.ThemeSync;
import org.nlogo.util.SysInfo$;
import org.nlogo.window.ButtonWidget;
import org.nlogo.window.ChooserWidget;
import org.nlogo.window.EditorFactory;
import org.nlogo.window.Events;
import org.nlogo.window.InputBoxWidget;
import org.nlogo.window.MonitorWidget;
import org.nlogo.window.OutputWidget;
import org.nlogo.window.PlotWidget;
import org.nlogo.window.PlotWidget$;
import org.nlogo.window.SliderWidget;
import org.nlogo.window.SwitchWidget;
import org.nlogo.window.ViewWidgetInterface;
import org.nlogo.window.Widget;
import org.nlogo.window.WidgetContainer;
import org.nlogo.window.WidgetRegistry$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.IntRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

public class InterfacePanelLite
extends JLayeredPane
implements WidgetContainer,
FocusListener,
Events.LoadWidgetsEvent.Handler,
Events.OutputEvent.Handler,
ThemeSync {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(InterfacePanelLite.class.getDeclaredField("iPMouseListener$lzy1"));
    private final ViewWidgetInterface viewWidget;
    private final CompilerServices compiler;
    private final RandomServices random;
    private final PlotManager plotManager;
    private final EditorFactory editorFactory;
    private final ExtensionManager extensionManager;
    private final Map<String, Widget> widgets;
    private boolean _sliderEventOnReleaseOnly;
    private volatile Object iPMouseListener$lzy1;
    private final scala.collection.immutable.Map<String, Function0<Widget>> widgetBuilderMap;

    public InterfacePanelLite(ViewWidgetInterface viewWidget, CompilerServices compiler, RandomServices random, PlotManager plotManager, EditorFactory editorFactory, ExtensionManager extensionManager) {
        this.viewWidget = viewWidget;
        this.compiler = compiler;
        this.random = random;
        this.plotManager = plotManager;
        this.editorFactory = editorFactory;
        this.extensionManager = extensionManager;
        this.widgets = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this._sliderEventOnReleaseOnly = false;
        this.setOpaque(true);
        this.addFocusListener(this);
        this.addMouseListener(this.iPMouseListener());
        this.addKeyListener(this.getKeyAdapter());
        this.syncTheme();
        Object[] objectArray = new Tuple2[8];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Monitor");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Function0 & Serializable)() -> new MonitorWidget(random.auxRNG(), compiler, editorFactory.colorizer()));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Plot");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Function0 & Serializable)() -> PlotWidget$.MODULE$.apply(plotManager, compiler, editorFactory.colorizer()));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Slider");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Function0 & Serializable)() -> new SliderWidget(this.sliderEventOnReleaseOnly(), random.auxRNG(), compiler, editorFactory.colorizer(), extensionManager));
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Switch");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Function0 & Serializable)() -> new SwitchWidget(compiler, extensionManager));
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Chooser");
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Function0 & Serializable)() -> new ChooserWidget(compiler, editorFactory.colorizer(), extensionManager));
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"InputBox");
        objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Function0 & Serializable)() -> {
            EditorConfiguration singleLineConfig = editorFactory.defaultConfiguration(1, 10).withFocusTraversalEnabled(true);
            EditorConfiguration multiLineConfig = editorFactory.defaultConfiguration(5, 20);
            return new InputBoxWidget(editorFactory.newEditor(singleLineConfig), editorFactory.newEditor(multiLineConfig), compiler, extensionManager, this);
        });
        String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Button");
        objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Function0 & Serializable)() -> new ButtonWidget(random.mainRNG(), compiler, editorFactory.colorizer()));
        String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Output");
        objectArray[7] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (Function0 & Serializable)() -> new OutputWidget());
        this.widgetBuilderMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public ViewWidgetInterface viewWidget() {
        return this.viewWidget;
    }

    public KeyAdapter getKeyAdapter() {
        return new ButtonKeyAdapter();
    }

    private MouseAdapter iPMouseListener() {
        Object object = this.iPMouseListener$lzy1;
        if (object instanceof MouseAdapter) {
            return (MouseAdapter)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (MouseAdapter)this.iPMouseListener$lzyINIT1();
    }

    private Object iPMouseListener$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.iPMouseListener$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    MouseAdapter mouseAdapter = null;
                    try {
                        mouseAdapter = new MouseAdapter(this){
                            private final /* synthetic */ InterfacePanelLite $outer;
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }

                            public void mousePressed(MouseEvent e) {
                                if (e.isPopupTrigger()) {
                                    this.$outer.org$nlogo$window$InterfacePanelLite$$doPopup(e);
                                    return;
                                }
                                this.$outer.requestFocus();
                            }

                            public void mouseReleased(MouseEvent e) {
                                if (e.isPopupTrigger()) {
                                    this.$outer.org$nlogo$window$InterfacePanelLite$$doPopup(e);
                                    return;
                                }
                            }
                        };
                        object2 = mouseAdapter == null ? LazyVals.NullValue$.MODULE$ : mouseAdapter;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.iPMouseListener$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return mouseAdapter;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.enableButtonKeys(true);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.enableButtonKeys(false);
    }

    @Override
    public void requestFocus() {
        this.requestFocusInWindow();
    }

    public void reset() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.getComponents());
        ArrayOps$.MODULE$.foreach$extension(object, x$1 -> {
            Component component = x$1;
            if (component instanceof PlotWidget) {
                PlotWidget pw = (PlotWidget)component;
                this.plotManager.forgetPlot(pw.plot());
                return;
            }
            if (component instanceof ViewWidgetInterface) {
                ViewWidgetInterface vwi = (ViewWidgetInterface)((Object)component);
                this.remove((Component)((Object)vwi));
                return;
            }
        });
    }

    private void enableButtonKeys(boolean enabled) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.getComponents());
        ArrayOps$.MODULE$.foreach$extension(object, x$1 -> {
            Component component = x$1;
            if (component instanceof ButtonWidget) {
                ButtonWidget b = (ButtonWidget)component;
                b.keyEnabled(enabled);
                return;
            }
        });
    }

    public ButtonWidget findActionButton(char key) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.getComponents());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.collect$extension(object, (PartialFunction)new Serializable(key){
            private final char key$1;
            {
                this.key$1 = key$2;
            }

            public final boolean isDefinedAt(Component x) {
                ButtonWidget b;
                Component component = x;
                return component instanceof ButtonWidget && Character.toUpperCase((b = (ButtonWidget)component).actionKey()) == Character.toUpperCase(this.key$1);
            }

            public final Object applyOrElse(Component x, Function1 function1) {
                ButtonWidget b;
                Component component = x;
                if (component instanceof ButtonWidget && Character.toUpperCase((b = (ButtonWidget)component).actionKey()) == Character.toUpperCase(this.key$1)) {
                    return b;
                }
                return function1.apply((Object)x);
            }
        }, ClassTag$.MODULE$.apply(ButtonWidget.class)));
        return (ButtonWidget)ArrayOps$.MODULE$.headOption$extension(object2).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        IntRef maxX = IntRef.create((int)0);
        IntRef maxY = IntRef.create((int)0);
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.getComponents());
        ArrayOps$.MODULE$.foreach$extension(object, component -> {
            Point location = component.getLocation();
            Dimension size = component.getSize();
            int x = location.x + size.width;
            int y = location.y + size.height;
            if (x > maxX$1.elem) {
                maxX$1.elem = x;
            }
            if (y > maxY$1.elem) {
                maxY$1.elem = y;
                return;
            }
        });
        return new Dimension(maxX.elem + 8, maxY.elem + 8);
    }

    private OutputWidget getOutputWidget() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.getComponents());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.collect$extension(object, (PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Component x) {
                Component component = x;
                if (component instanceof OutputWidget) {
                    OutputWidget ow = (OutputWidget)component;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Component x, Function1 function1) {
                Component component = x;
                if (component instanceof OutputWidget) {
                    OutputWidget ow = (OutputWidget)component;
                    return ow;
                }
                return function1.apply((Object)x);
            }
        }, ClassTag$.MODULE$.apply(OutputWidget.class)));
        return (OutputWidget)ArrayOps$.MODULE$.headOption$extension(object2).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public void handle(Events.OutputEvent e) {
        if (!e.toCommandCenter && this.getOutputWidget() != null) {
            if (e.clear) {
                this.getOutputWidget().outputArea().clear();
            }
            if (e.outputObject != null) {
                this.getOutputWidget().outputArea().append(e.outputObject, e.wrapLines);
                return;
            }
            return;
        }
    }

    @Override
    public Rectangle getUnzoomedBounds(Component component) {
        return component.getBounds();
    }

    @Override
    public void resetZoomInfo(Widget widget) {
    }

    @Override
    public void resetSizeInfo(Widget widget) {
    }

    @Override
    public boolean isZoomed() {
        return false;
    }

    public void org$nlogo$window$InterfacePanelLite$$doPopup(MouseEvent e) {
        PopupMenu menu = new PopupMenu(PopupMenu$.MODULE$.$lessinit$greater$default$1());
        menu.add(new MenuItem(Version$.MODULE$.version())).setEnabled(false);
        menu.add(new MenuItem(SysInfo$.MODULE$.getOSInfoString())).setEnabled(false);
        menu.add(new MenuItem(SysInfo$.MODULE$.getVMInfoString())).setEnabled(false);
        menu.add(new MenuItem(SysInfo$.MODULE$.getMemoryInfoString())).setEnabled(false);
        menu.show(this, e.getX(), e.getY());
    }

    private void addWidget(Widget widget, int x, int y) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)widget.displayName());
        this.widgets.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)widget));
        widget.addPopupListeners();
        this.add((Component)widget, JLayeredPane.DEFAULT_LAYER);
        this.moveToFront(widget);
        widget.setLocation(x, y);
        widget.validate();
        widget.syncTheme();
    }

    public void hideWidget(String widgetName) {
        this.widgets.get((Object)widgetName).foreach(_$1 -> _$1.setVisible(false));
    }

    public void showWidget(String widgetName) {
        this.widgets.get((Object)widgetName).foreach(_$2 -> _$2.setVisible(true));
    }

    public boolean sliderEventOnReleaseOnly() {
        return this._sliderEventOnReleaseOnly;
    }

    public void sliderEventOnReleaseOnly(boolean sliderEventOnReleaseOnly) {
        this._sliderEventOnReleaseOnly = sliderEventOnReleaseOnly;
    }

    @Override
    public Seq<org.nlogo.core.Widget> allWidgets() {
        return (Seq)((IterableOnceOps)((IterableOps)this.widgets.map((Function1 & Serializable)_$3 -> (Widget)_$3._2())).map((Function1 & Serializable)_$4 -> _$4.model())).toSeq().distinct();
    }

    @Override
    public Widget loadWidget(org.nlogo.core.Widget coreWidget) {
        Widget widget;
        block5: {
            try {
                int x = coreWidget.x();
                int y = coreWidget.y();
                org.nlogo.core.Widget widget2 = coreWidget;
                if (widget2 instanceof View) {
                    View v = (View)widget2;
                    try {
                        ((Widget)((Object)this.viewWidget())).load(v);
                    }
                    catch (RuntimeException ex) {
                        Exceptions$.MODULE$.handle(ex);
                    }
                    ((Component)((Object)this.viewWidget())).setSize(((Component)((Object)this.viewWidget())).getSize());
                    this.addWidget((Widget)((Object)this.viewWidget()), x, y);
                    widget = (Widget)((Object)this.viewWidget());
                    break block5;
                }
                String name = coreWidget.getClass().getSimpleName();
                Option newGuy = this.widgetBuilderMap.get((Object)name).flatMap((Function1 & Serializable)createWidget -> {
                    Some some;
                    try {
                        some = Some$.MODULE$.apply(createWidget.apply());
                    }
                    catch (RuntimeException ex) {
                        Exceptions$.MODULE$.handle(ex);
                        some = None$.MODULE$;
                    }
                    return some;
                }).orElse(() -> InterfacePanelLite.$anonfun$2(name));
                newGuy.foreach(w -> {
                    w.load(coreWidget);
                    this.addWidget((Widget)w, x, y);
                });
                widget = (Widget)newGuy.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            catch (RuntimeException ex) {
                Exceptions$.MODULE$.handle(ex);
                widget = null;
            }
        }
        return widget;
    }

    @Override
    public void handle(Events.LoadWidgetsEvent e) {
        try {
            this.setVisible(false);
            e.widgets.foreach((Function1 & Serializable)coreWidget -> this.loadWidget((org.nlogo.core.Widget)coreWidget));
        }
        finally {
            this.setVisible(true);
            this.revalidate();
        }
    }

    public BufferedImage interfaceImage() {
        return Images$.MODULE$.paintToImage(this);
    }

    @Override
    public void syncTheme() {
        this.setBackground(InterfaceColors$.MODULE$.interfaceBackground());
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.getComponents());
        ArrayOps$.MODULE$.foreach$extension(object, _$5 -> {
            Component component = _$5;
            if (component instanceof ThemeSync) {
                Component ts = (Component)((Object)((ThemeSync)((Object)component)));
                ((ThemeSync)((Object)ts)).syncTheme();
                return;
            }
        });
    }

    private static final Option $anonfun$2(String name$1) {
        return Option$.MODULE$.apply((Object)WidgetRegistry$.MODULE$.apply(name$1));
    }

    public class ButtonKeyAdapter
    extends KeyAdapter {
        public ButtonKeyAdapter() {
            if (InterfacePanelLite.this == null) {
                throw new NullPointerException();
            }
        }

        public boolean keyIsHandleable(KeyEvent e) {
            return e.getKeyChar() != '\uffff' && !e.isActionKey() && (e.getModifiersEx() & InterfacePanelLite.this.getToolkit().getMenuShortcutKeyMaskEx()) == 0;
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (this.keyIsHandleable(e)) {
                Option$.MODULE$.apply((Object)InterfacePanelLite.this.findActionButton(e.getKeyChar())).foreach(button -> this.buttonKeyed((ButtonWidget)button));
                return;
            }
        }

        public void buttonKeyed(ButtonWidget button) {
            button.keyTriggered();
        }

        public final /* synthetic */ InterfacePanelLite org$nlogo$window$InterfacePanelLite$ButtonKeyAdapter$$$outer() {
            return InterfacePanelLite.this;
        }
    }
}

