/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.util.ArrayList;
import java.util.List;
import org.nlogo.api.JobOwner;
import org.nlogo.api.NetLogoListener;
import org.nlogo.core.AgentKindJ;
import org.nlogo.window.ButtonWidget;
import org.nlogo.window.ChooserWidget;
import org.nlogo.window.Events;
import org.nlogo.window.InputBoxWidget;
import org.nlogo.window.ProceduresInterface;
import org.nlogo.window.SliderWidget;

public class NetLogoListenerManager
implements Events.AddJobEvent.Handler,
Events.InterfaceGlobalEvent.Handler,
Events.BeforeLoadEvent.Handler,
Events.JobRemovedEvent.Handler,
Events.CompiledEvent.Handler {
    private final List<NetLogoListener> listeners = new ArrayList<NetLogoListener>();

    @Override
    public void handle(Events.BeforeLoadEvent e) {
        for (NetLogoListener listener : this.listeners) {
            listener.modelOpened((String)e.modelPath.getOrElse(() -> "new model"));
        }
    }

    @Override
    public void handle(Events.AddJobEvent e) {
        if (e.owner instanceof ButtonWidget) {
            for (NetLogoListener listener : this.listeners) {
                listener.buttonPressed(((ButtonWidget)e.owner).displayName());
            }
        }
    }

    @Override
    public void handle(Events.InterfaceGlobalEvent e) {
        if (!e.updating) {
            for (NetLogoListener listener : this.listeners) {
                if (e.widget instanceof SliderWidget) {
                    SliderWidget slider = (SliderWidget)e.widget;
                    listener.sliderChanged(e.widget.name(), slider.value(), slider.minimum(), slider.increment(), slider.maximum(), e.valueChanged, e.buttonReleased);
                    continue;
                }
                if (e.widget.classDisplayName().equals("Switch")) {
                    listener.switchChanged(e.widget.name(), (Boolean)e.widget.valueObject(), e.valueChanged);
                    continue;
                }
                if (e.widget instanceof ChooserWidget) {
                    listener.chooserChanged(e.widget.name(), e.widget.valueObject(), e.valueChanged);
                    continue;
                }
                if (e.widget instanceof InputBoxWidget) {
                    listener.inputBoxChanged(e.widget.name(), e.widget.valueObject(), e.valueChanged);
                    continue;
                }
                throw new IllegalStateException("unknown widget type: " + e.widget);
            }
        }
    }

    @Override
    public void handle(Events.JobRemovedEvent e) {
        if (e.owner instanceof ButtonWidget) {
            for (NetLogoListener listener : this.listeners) {
                listener.buttonStopped(((ButtonWidget)e.owner).displayName());
            }
        }
    }

    @Override
    public void handle(Events.CompiledEvent e) {
        block10: {
            block9: {
                if (!(e.sourceOwner instanceof JobOwner)) break block9;
                char agentType = 'O';
                if (e.sourceOwner.kind() == AgentKindJ.Turtle()) {
                    agentType = 'T';
                } else if (e.sourceOwner.kind() == AgentKindJ.Patch()) {
                    agentType = 'P';
                } else if (e.sourceOwner.kind() == AgentKindJ.Link()) {
                    agentType = 'L';
                } else if (e.sourceOwner.kind() != AgentKindJ.Observer()) {
                    throw new IllegalStateException("unexpected agent class: " + e.sourceOwner.kind());
                }
                for (NetLogoListener listener : this.listeners) {
                    if (!((JobOwner)e.sourceOwner).isCommandCenter()) continue;
                    listener.commandEntered(e.sourceOwner.classDisplayName(), e.sourceOwner.innerSource(), agentType, e.error);
                }
                break block10;
            }
            if (!(e.sourceOwner instanceof ProceduresInterface)) break block10;
            for (NetLogoListener listener : this.listeners) {
                listener.codeTabCompiled(e.sourceOwner.innerSource(), e.error);
            }
        }
    }

    public void tickCounterChanged(double ticks) {
        for (NetLogoListener listener : this.listeners) {
            listener.tickCounterChanged(ticks);
        }
    }

    public void possibleViewUpdate() {
        for (NetLogoListener listener : this.listeners) {
            listener.possibleViewUpdate();
        }
    }

    public void addListener(NetLogoListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(NetLogoListener listener) {
        this.listeners.remove(listener);
    }

    public void clearListeners(NetLogoListener listener) {
        this.listeners.clear();
    }
}

