/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.nlogo.api.Dump$;
import org.nlogo.core.I18N$;
import org.nlogo.core.Output;
import org.nlogo.core.Output$;
import org.nlogo.core.Widget;
import org.nlogo.swing.MenuItem;
import org.nlogo.swing.MenuItem$;
import org.nlogo.swing.PopupMenu;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.window.CommandCenterInterface;
import org.nlogo.window.EditPanel;
import org.nlogo.window.Editable;
import org.nlogo.window.Events;
import org.nlogo.window.OutputArea;
import org.nlogo.window.OutputEditPanel;
import org.nlogo.window.SingleErrorWidget;
import scala.Option;
import scala.Some$;

public class OutputWidget
extends SingleErrorWidget
implements CommandCenterInterface,
Events.ExportWorldEvent.Handler,
Editable {
    private final OutputArea outputArea;
    private final GridBagConstraints c;

    public OutputWidget() {
        this.displayName(I18N$.MODULE$.gui().get("tabs.run.widgets.output"));
        this.outputArea = new OutputArea();
        this.setLayout(new GridBagLayout());
        this.c = new GridBagConstraints();
        this.c().weightx = 1.0;
        this.c().weighty = 1.0;
        this.c().fill = 1;
        this.c().insets = new Insets(this.zoom(8.0), this.zoom(8.0), this.zoom(8.0), this.zoom(8.0));
        this.add((Component)this.outputArea(), this.c());
        this.originalFont_$eq(this.outputArea().getFont());
    }

    public OutputArea outputArea() {
        return this.outputArea;
    }

    public GridBagConstraints c() {
        return this.c;
    }

    @Override
    public EditPanel editPanel() {
        return new OutputEditPanel(this);
    }

    @Override
    public Option<Editable> getEditable() {
        return Some$.MODULE$.apply((Object)this);
    }

    public int fontSize() {
        return this.originalFont().getSize();
    }

    public void setFontSize(int newSize) {
        int zoomDiff = this.outputArea().fontSize() - this.fontSize();
        this.outputArea().fontSize(newSize + zoomDiff);
        this.originalFont_$eq(this.originalFont().deriveFont((float)newSize));
    }

    @Override
    public String classDisplayName() {
        return I18N$.MODULE$.gui().get("tabs.run.widgets.output");
    }

    @Override
    public void setZoomFactor(double zoomFactor) {
        super.setZoomFactor(zoomFactor);
        this.outputArea().zoomFactor_$eq(zoomFactor);
    }

    @Override
    public boolean exportable() {
        return true;
    }

    @Override
    public String getDefaultExportName() {
        return "output.txt";
    }

    public String valueText() {
        return this.outputArea().text().getText();
    }

    @Override
    public boolean hasContextMenu() {
        return true;
    }

    @Override
    public boolean copyable() {
        return false;
    }

    @Override
    public void repaintPrompt() {
    }

    @Override
    public void cycleAgentType(boolean forward) {
    }

    @Override
    public void populateContextMenu(PopupMenu menu, Point p) {
        menu.add(new MenuItem(new AbstractAction(this){
            private final /* synthetic */ OutputWidget $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(I18N$.MODULE$.gui().get("tabs.run.widget.copyselectedtext"));
            }

            public void actionPerformed(ActionEvent e) {
                this.$outer.outputArea().text().copy();
            }
        }, MenuItem$.MODULE$.$lessinit$greater$default$2()));
        menu.add(new MenuItem(new AbstractAction(this){
            private final /* synthetic */ OutputWidget $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(I18N$.MODULE$.gui().get("tabs.run.widget.clear"));
            }

            public void actionPerformed(ActionEvent e) {
                this.$outer.outputArea().clear();
            }
        }, MenuItem$.MODULE$.$lessinit$greater$default$2()));
    }

    @Override
    public void syncTheme() {
        this.setBackgroundColor(InterfaceColors$.MODULE$.outputBackground());
        this.outputArea().syncTheme();
    }

    @Override
    public void handle(Events.ExportWorldEvent e) {
        e.writer.println(Dump$.MODULE$.csv().encode("OUTPUT"));
        Dump$.MODULE$.csv().stringToCSV(e.writer, this.outputArea().getTextForExport());
    }

    @Override
    public void load(Widget model) {
        Widget widget = model;
        if (widget instanceof Output) {
            Output output = (Output)widget;
            this.setSize(output.width(), output.height());
            this.setFontSize(output.fontSize());
            return;
        }
    }

    @Override
    public Widget model() {
        Rectangle b = this.getUnzoomedBounds();
        return Output$.MODULE$.apply(b.x, b.y, b.width, b.height, this.fontSize());
    }
}

