/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.io.Serializable;
import org.nlogo.core.UpdateMode;
import org.nlogo.core.UpdateMode$Continuous$;
import org.nlogo.core.UpdateMode$TickBased$;
import org.nlogo.window.UpdateManager$ContinuousPolicy$;
import org.nlogo.window.UpdateManager$TickBasedPolicy$;
import org.nlogo.window.UpdateManagerInterface;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

public abstract class UpdateManager
implements UpdateManagerInterface {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(UpdateManager.class.getDeclaredField("ContinuousPolicy$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(UpdateManager.class.getDeclaredField("TickBasedPolicy$lzy1"));
    private final double ForeverAgo;
    public long org$nlogo$window$UpdateManager$$lastUpdateNanos = 0L;
    public double org$nlogo$window$UpdateManager$$lastUpdateTicks = this.ForeverAgo;
    public int org$nlogo$window$UpdateManager$$pseudoTicks = 0;
    private long nanoGap = 0L;
    private double tickGap = 1.0;
    private long frameRateGap = 0L;
    private long timeSmoothingWillBeDone = 0L;
    private double _speed = 0.0;
    private volatile Object TickBasedPolicy$lzy1;
    private volatile Object ContinuousPolicy$lzy1;

    public UpdateManager() {
        this.ForeverAgo = -2.0;
    }

    public abstract double defaultFrameRate();

    public abstract double ticks();

    public abstract UpdateMode updateMode();

    @Override
    public void reset() {
        this.org$nlogo$window$UpdateManager$$lastUpdateTicks = this.ForeverAgo;
        this.org$nlogo$window$UpdateManager$$pseudoTicks = 0;
        this.org$nlogo$window$UpdateManager$$lastUpdateNanos = 0L;
    }

    @Override
    public void pseudoTick() {
        ++this.org$nlogo$window$UpdateManager$$pseudoTicks;
    }

    @Override
    public boolean shouldUpdateNow() {
        return this.updatePolicy().shouldUpdateNow(System.nanoTime());
    }

    @Override
    public boolean shouldComeUpForAirAgain() {
        return this.updatePolicy().shouldComeUpForAirAgain();
    }

    @Override
    public void beginPainting() {
        if (this.updatePolicy().frameDoneWhenPaintingBegins()) {
            this.frameDone();
            return;
        }
    }

    @Override
    public void donePainting() {
        if (!this.updatePolicy().frameDoneWhenPaintingBegins()) {
            this.frameDone();
            return;
        }
    }

    @Override
    public boolean isDoneSmoothing() {
        boolean bl;
        long now = System.nanoTime();
        if (now >= this.timeSmoothingWillBeDone) {
            this.org$nlogo$window$UpdateManager$$lastUpdateNanos = now;
            return true;
        }
        UpdateManager updateManager = this;
        synchronized (updateManager) {
            try {
                this.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(10000000L), this.timeSmoothingWillBeDone - now));
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            bl = false;
        }
        return bl;
    }

    private void frameDone() {
        long now = System.nanoTime();
        this.timeSmoothingWillBeDone = now + this.updatePolicy().smoothingPause(now);
        this.org$nlogo$window$UpdateManager$$lastUpdateNanos = System.nanoTime();
        this.org$nlogo$window$UpdateManager$$lastUpdateTicks = this.ticks();
        this.org$nlogo$window$UpdateManager$$pseudoTicks = 0;
    }

    @Override
    public double speed() {
        return this._speed;
    }

    @Override
    public void speed_$eq(double speed) {
        this._speed = speed;
        this.recompute();
    }

    @Override
    public void recompute() {
        this.nanoGap = this.updatePolicy().nanoGap();
        this.tickGap = this.updatePolicy().tickGap();
        this.frameRateGap = this.updatePolicy().frameRateGap();
    }

    @Override
    public void nudgeSleeper() {
        UpdateManager updateManager = this;
        synchronized (updateManager) {
            this.notifyAll();
        }
    }

    private void sleep(long nanos) {
        UpdateManager updateManager = this;
        synchronized (updateManager) {
            BoxedUnit boxedUnit;
            try {
                this.wait(nanos / 1000000L, (int)(nanos % 1000000L));
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public void pause() {
        long now = System.nanoTime();
        this.pauseUntil((Function0<Object>)(Function0 & Serializable)() -> now + this.updatePolicy().slowdown());
    }

    private void pauseUntil(Function0<Object> deadline) {
        long remaining = deadline.apply$mcJ$sp() - System.nanoTime();
        UpdateManager updateManager = this;
        synchronized (updateManager) {
            while (remaining > 0L && !Thread.currentThread().isInterrupted()) {
                this.sleep(remaining);
                remaining = deadline.apply$mcJ$sp() - System.nanoTime();
            }
        }
    }

    public String debugInfo() {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("speed = %.0f, frameRateGap = %.2f fps, nanoGap = %.2f fps, slowdown = %.1f ms, every %.3f ticks"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.speed()), BoxesRunTime.boxToDouble((double)(1.0E9 / (double)this.frameRateGap)), BoxesRunTime.boxToDouble((double)(1.0E9 / (double)this.nanoGap)), BoxesRunTime.boxToDouble((double)((double)this.updatePolicy().slowdown() / 1000000.0)), BoxesRunTime.boxToDouble((double)this.tickGap)}));
    }

    public double org$nlogo$window$UpdateManager$$checkTicks() {
        double result = this.ticks();
        if (result < this.org$nlogo$window$UpdateManager$$lastUpdateTicks) {
            this.org$nlogo$window$UpdateManager$$lastUpdateTicks = this.ForeverAgo;
        }
        return result;
    }

    private UpdatePolicy updatePolicy() {
        UpdateMode updateMode = this.updateMode();
        if (UpdateMode$Continuous$.MODULE$.equals(updateMode)) {
            return this.ContinuousPolicy();
        }
        if (UpdateMode$TickBased$.MODULE$.equals(updateMode)) {
            return this.TickBasedPolicy();
        }
        throw new MatchError((Object)updateMode);
    }

    private final UpdateManager$TickBasedPolicy$ TickBasedPolicy() {
        Object object = this.TickBasedPolicy$lzy1;
        if (object instanceof UpdateManager$TickBasedPolicy$) {
            return (UpdateManager$TickBasedPolicy$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (UpdateManager$TickBasedPolicy$)this.TickBasedPolicy$lzyINIT1();
    }

    private Object TickBasedPolicy$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.TickBasedPolicy$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals.Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    UpdateManager$TickBasedPolicy$ updateManager$TickBasedPolicy$ = null;
                    try {
                        updateManager$TickBasedPolicy$ = new UpdateManager$TickBasedPolicy$(this);
                        serializable = updateManager$TickBasedPolicy$ == null ? LazyVals.NullValue$.MODULE$ : updateManager$TickBasedPolicy$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals.Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.TickBasedPolicy$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, serializable);
                            waiting.countDown();
                        }
                    }
                    return updateManager$TickBasedPolicy$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private final UpdateManager$ContinuousPolicy$ ContinuousPolicy() {
        Object object = this.ContinuousPolicy$lzy1;
        if (object instanceof UpdateManager$ContinuousPolicy$) {
            return (UpdateManager$ContinuousPolicy$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (UpdateManager$ContinuousPolicy$)this.ContinuousPolicy$lzyINIT1();
    }

    private Object ContinuousPolicy$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.ContinuousPolicy$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, null, LazyVals.Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    UpdateManager$ContinuousPolicy$ updateManager$ContinuousPolicy$ = null;
                    try {
                        updateManager$ContinuousPolicy$ = new UpdateManager$ContinuousPolicy$(this);
                        serializable = updateManager$ContinuousPolicy$ == null ? LazyVals.NullValue$.MODULE$ : updateManager$ContinuousPolicy$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, LazyVals.Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.ContinuousPolicy$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$1, waiting, serializable);
                            waiting.countDown();
                        }
                    }
                    return updateManager$ContinuousPolicy$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$1, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public interface UpdatePolicy {
        public boolean frameDoneWhenPaintingBegins();

        public long slowdown();

        public long frameRateGap();

        public long nanoGap();

        public double tickGap();

        public boolean shouldUpdateNow(long var1);

        public long smoothingPause(long var1);

        public boolean shouldComeUpForAirAgain();

        public static double ticksSinceUpdate$(UpdatePolicy $this) {
            return $this.ticksSinceUpdate();
        }

        default public double ticksSinceUpdate() {
            return this.org$nlogo$window$UpdateManager$UpdatePolicy$$$outer().org$nlogo$window$UpdateManager$$checkTicks() - this.org$nlogo$window$UpdateManager$UpdatePolicy$$$outer().org$nlogo$window$UpdateManager$$lastUpdateTicks + (double)this.org$nlogo$window$UpdateManager$UpdatePolicy$$$outer().org$nlogo$window$UpdateManager$$pseudoTicks;
        }

        public static boolean enoughTimePassed$(UpdatePolicy $this, long now) {
            return $this.enoughTimePassed(now);
        }

        default public boolean enoughTimePassed(long now) {
            return now - this.org$nlogo$window$UpdateManager$UpdatePolicy$$$outer().org$nlogo$window$UpdateManager$$lastUpdateNanos >= this.nanoGap();
        }

        public /* synthetic */ UpdateManager org$nlogo$window$UpdateManager$UpdatePolicy$$$outer();
    }
}

