/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Dimension;
import org.nlogo.window.EditPanel;
import org.nlogo.window.Editable;
import org.nlogo.window.Widget;
import org.nlogo.window.WidgetWrapperInterface;
import scala.Predef$;
import scala.runtime.RichInt$;

public abstract class WidgetEditPanel
extends EditPanel {
    private final WidgetWrapperInterface wrapper;
    private final Dimension originalSize;
    private Dimension originalPreferredSize;

    public WidgetEditPanel(Widget target) {
        super((Editable)((Object)target));
        this.wrapper = (WidgetWrapperInterface)((Object)target.getParent());
        this.originalSize = this.wrapper.getSize();
        this.originalPreferredSize = this.wrapper.getPreferredSize();
    }

    @Override
    public void apply(boolean swapSizes) {
        super.apply(swapSizes);
        this.resizeWidget(swapSizes);
    }

    @Override
    public void revert() {
        super.revert();
        this.wrapper.setSize(this.originalSize);
    }

    private void resizeWidget(boolean swapSizes) {
        Dimension prefSize = this.wrapper.getPreferredSize();
        if (this.wrapper.isNew()) {
            Dimension currentSize = this.wrapper.getSize();
            if (prefSize.width != currentSize.width) {
                prefSize.width = this.wrapper.snapToGrid(prefSize.width);
            }
            if (prefSize.height != currentSize.height) {
                prefSize.height = this.wrapper.snapToGrid(prefSize.height);
            }
            this.wrapper.setSize(prefSize);
            return;
        }
        Dimension dimension = this.originalPreferredSize;
        Dimension dimension2 = prefSize;
        if (dimension == null ? dimension2 != null : !((Object)dimension).equals(dimension2)) {
            int width = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(10000), RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(prefSize.width), swapSizes ? this.originalSize.height : this.originalSize.width));
            int height = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(10000), RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(prefSize.height), swapSizes ? this.originalSize.width : this.originalSize.height));
            Dimension currentSize = this.wrapper.getSize();
            if (width != currentSize.width) {
                width = this.wrapper.snapToGrid(width);
            }
            if (height != currentSize.height) {
                height = this.wrapper.snapToGrid(height);
            }
            this.wrapper.setSize(width, height);
            this.originalPreferredSize = this.wrapper.getPreferredSize();
            return;
        }
    }
}

