/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.nlogo.awt.Fonts$;
import org.nlogo.swing.Transparent;
import org.nlogo.swing.Utils$;
import org.nlogo.theme.InterfaceColors$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public class WorldPreview
extends JPanel
implements Transparent {
    public final int org$nlogo$window$WorldPreview$$width;
    public final int org$nlogo$window$WorldPreview$$height;
    public boolean org$nlogo$window$WorldPreview$$wrapX;
    public boolean org$nlogo$window$WorldPreview$$wrapY;
    public int org$nlogo$window$WorldPreview$$minx;
    public int org$nlogo$window$WorldPreview$$maxx;
    public int org$nlogo$window$WorldPreview$$miny;
    public int org$nlogo$window$WorldPreview$$maxy;
    public Set<String> org$nlogo$window$WorldPreview$$errors;
    private final JLabel shapeLabel;

    public WorldPreview(int width, int height) {
        this.org$nlogo$window$WorldPreview$$width = width;
        this.org$nlogo$window$WorldPreview$$height = height;
        super(new BorderLayout());
        Transparent.$init$(this);
        this.org$nlogo$window$WorldPreview$$wrapX = false;
        this.org$nlogo$window$WorldPreview$$wrapY = false;
        this.org$nlogo$window$WorldPreview$$minx = 0;
        this.org$nlogo$window$WorldPreview$$maxx = 0;
        this.org$nlogo$window$WorldPreview$$miny = 0;
        this.org$nlogo$window$WorldPreview$$maxy = 0;
        this.org$nlogo$window$WorldPreview$$errors = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.shapeLabel = new JLabel(){
            {
                this.setForeground(InterfaceColors$.MODULE$.dialogText());
            }
        };
        this.add((Component)new PreviewPanel(), "North");
        this.add((Component)this.shapeLabel, "South");
        this.setVisible(true);
    }

    public void updateInt(String field, int value) {
        String string = field;
        String string2 = "minPxcor";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.org$nlogo$window$WorldPreview$$minx = value;
        } else {
            String string3 = field;
            String string4 = "maxPxcor";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                this.org$nlogo$window$WorldPreview$$maxx = value;
            } else {
                String string5 = field;
                String string6 = "minPycor";
                if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                    this.org$nlogo$window$WorldPreview$$miny = value;
                } else {
                    String string7 = field;
                    String string8 = "maxPycor";
                    if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                        this.org$nlogo$window$WorldPreview$$maxy = value;
                    }
                }
            }
        }
        this.removeError(field);
        this.updateLabel();
        this.repaint();
    }

    public void updateBoolean(String field, boolean value) {
        String string = field;
        String string2 = "wrappingX";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.org$nlogo$window$WorldPreview$$wrapX = value;
        } else {
            String string3 = field;
            String string4 = "wrappingY";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                this.org$nlogo$window$WorldPreview$$wrapY = value;
            }
        }
        this.updateLabel();
        this.repaint();
    }

    public void setError(String field) {
        this.org$nlogo$window$WorldPreview$$errors = (Set)this.org$nlogo$window$WorldPreview$$errors.$plus((Object)field);
        this.repaint();
    }

    public void removeError(String field) {
        this.org$nlogo$window$WorldPreview$$errors = (Set)this.org$nlogo$window$WorldPreview$$errors.$minus((Object)field);
        this.repaint();
    }

    /*
     * Unable to fully structure code
     */
    private void updateLabel() {
        block6: {
            block4: {
                block5: {
                    var2_1 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.org$nlogo$window$WorldPreview$$wrapX), (Object)BoxesRunTime.boxToBoolean((boolean)this.org$nlogo$window$WorldPreview$$wrapY));
                    if (var2_1 == null) ** GOTO lbl-1000
                    var3_2 = var2_1._1$mcZ$sp();
                    var4_3 = var2_1._2$mcZ$sp();
                    if (!var3_2) break block4;
                    if (!var4_3) break block5;
                    v0 = "Torus";
                    break block6;
                }
                if (var4_3) break block4;
                v0 = "Vertical Cylinder";
                break block6;
            }
            if (var3_2) ** GOTO lbl-1000
            if (var4_3) {
                v0 = "Horizontal Cylinder";
            } else if (!var4_3) {
                v0 = "Box";
            } else lbl-1000:
            // 3 sources

            {
                throw new MatchError((Object)var2_1);
            }
        }
        text = v0;
        this.shapeLabel.setText(text + ": " + (this.org$nlogo$window$WorldPreview$$maxx - this.org$nlogo$window$WorldPreview$$minx + 1) + " x " + (this.org$nlogo$window$WorldPreview$$maxy - this.org$nlogo$window$WorldPreview$$miny + 1));
    }

    public class PreviewPanel
    extends JPanel {
        private final JLabel topLeft;
        private final JLabel topRight;
        private final JLabel bottomLeft;
        private final JLabel bottomRight;
        private final JLabel errorLabel;
        private final Font font;

        public PreviewPanel() {
            if (WorldPreview.this == null) {
                throw new NullPointerException();
            }
            super(new GridBagLayout());
            this.topLeft = new JLabel();
            this.topRight = new JLabel();
            this.bottomLeft = new JLabel();
            this.bottomRight = new JLabel();
            this.errorLabel = new JLabel("<html>Invalid world dimensions. The origin (0, 0) must be inside the dimensions of the world.</html>");
            this.font = new Font(Fonts$.MODULE$.platformMonospacedFont(), 0, 10);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 18;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(10, 10, 10, 10);
            this.add((Component)this.topLeft, c);
            c.gridx = 1;
            c.anchor = 12;
            this.add((Component)this.topRight, c);
            c.gridx = 0;
            c.gridy = 1;
            c.anchor = 16;
            this.add((Component)this.bottomLeft, c);
            c.gridx = 1;
            c.anchor = 14;
            this.add((Component)this.bottomRight, c);
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            c.gridheight = 2;
            c.anchor = 10;
            c.fill = 1;
            this.add((Component)this.errorLabel, c);
            this.topLeft.setForeground(Color.WHITE);
            this.topRight.setForeground(Color.WHITE);
            this.bottomLeft.setForeground(Color.WHITE);
            this.bottomRight.setForeground(Color.WHITE);
            this.errorLabel.setForeground(Color.WHITE);
            this.topLeft.setFont(this.font);
            this.topRight.setFont(this.font);
            this.bottomLeft.setFont(this.font);
            this.bottomRight.setFont(this.font);
            this.errorLabel.setFont(this.font);
            Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(WorldPreview.this.org$nlogo$window$WorldPreview$$width, WorldPreview.this.org$nlogo$window$WorldPreview$$height);
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2d = Utils$.MODULE$.initGraphics2D(g);
            g2d.setColor(Color.BLACK);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.setColor(Color.WHITE);
            g2d.drawRect(5, 5, this.getWidth() - 11, this.getHeight() - 11);
            if (WorldPreview.this.org$nlogo$window$WorldPreview$$errors.nonEmpty()) {
                this.errorLabel.setVisible(true);
                this.topLeft.setVisible(false);
                this.topRight.setVisible(false);
                this.bottomLeft.setVisible(false);
                this.bottomRight.setVisible(false);
            } else {
                this.errorLabel.setVisible(false);
                int x = 10 + (int)((float)(this.getWidth() - 20) * -((float)WorldPreview.this.org$nlogo$window$WorldPreview$$minx) / (float)(WorldPreview.this.org$nlogo$window$WorldPreview$$maxx - WorldPreview.this.org$nlogo$window$WorldPreview$$minx));
                int y = 10 + (int)((float)(this.getHeight() - 20) * (float)WorldPreview.this.org$nlogo$window$WorldPreview$$maxy / (float)(WorldPreview.this.org$nlogo$window$WorldPreview$$maxy - WorldPreview.this.org$nlogo$window$WorldPreview$$miny));
                g2d.setColor(Color.RED);
                g2d.fillOval(x - 4, y - 4, 9, 9);
                g2d.setColor(Color.WHITE);
                g2d.drawLine(x - 5, y, x + 5, y);
                g2d.drawLine(x, y - 5, x, y + 5);
                g2d.setFont(this.font);
                FontMetrics metrics = g2d.getFontMetrics();
                int width = metrics.stringWidth("0, 0)");
                int height = metrics.getHeight();
                if (x + 8 + width > this.getWidth() - 20) {
                    g2d.drawString("(0, 0)", x - width - 8, y + height / 2);
                } else {
                    g2d.drawString("(0, 0)", x + 8, y + height / 2);
                }
                this.topLeft.setVisible(x > this.topLeft.getX() + this.topLeft.getWidth() + 8 || y > this.topLeft.getY() + this.topLeft.getHeight() + 8);
                this.topRight.setVisible(x < this.topRight.getX() - width - 8 || y > this.topRight.getY() + this.topRight.getHeight() + 8);
                this.bottomLeft.setVisible(x > this.bottomLeft.getX() + this.bottomLeft.getWidth() + 8 || y < this.bottomLeft.getY() - height - 8);
                this.bottomRight.setVisible(x < this.getWidth() - 10 - this.bottomRight.getWidth() - 8 || y < this.getHeight() - 10 - this.bottomRight.getHeight() - height - 8);
                this.topLeft.setText("(" + WorldPreview.this.org$nlogo$window$WorldPreview$$minx + ", " + WorldPreview.this.org$nlogo$window$WorldPreview$$maxy + ")");
                this.topRight.setText("(" + WorldPreview.this.org$nlogo$window$WorldPreview$$maxx + ", " + WorldPreview.this.org$nlogo$window$WorldPreview$$maxy + ")");
                this.bottomLeft.setText("(" + WorldPreview.this.org$nlogo$window$WorldPreview$$minx + ", " + WorldPreview.this.org$nlogo$window$WorldPreview$$miny + ")");
                this.bottomRight.setText("(" + WorldPreview.this.org$nlogo$window$WorldPreview$$maxx + ", " + WorldPreview.this.org$nlogo$window$WorldPreview$$miny + ")");
            }
            if (WorldPreview.this.org$nlogo$window$WorldPreview$$wrapX) {
                double chunkSize = (double)(this.getHeight() - 10) / 16.0;
                g2d.setColor(new Color(33, 204, 0));
                g2d.fillRect(1, 5, 3, this.getHeight() - 10);
                g2d.fillRect(this.getWidth() - 4, 5, 3, this.getHeight() - 10);
                g2d.setColor(Color.BLACK);
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 15).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    g2d.fillRect(1, 4 + (int)((double)i * chunkSize), 3, 2);
                    g2d.fillRect(this.getWidth() - 4, 4 + (int)((double)i * chunkSize), 3, 2);
                });
            } else {
                g2d.setColor(Color.RED);
                g2d.fillRect(1, 5, 3, this.getHeight() - 10);
                g2d.fillRect(this.getWidth() - 4, 5, 3, this.getHeight() - 10);
            }
            if (WorldPreview.this.org$nlogo$window$WorldPreview$$wrapY) {
                double chunkSize = (double)(this.getWidth() - 10) / 16.0;
                g2d.setColor(new Color(33, 204, 0));
                g2d.fillRect(5, 1, this.getWidth() - 10, 3);
                g2d.fillRect(5, this.getHeight() - 4, this.getWidth() - 10, 3);
                g2d.setColor(Color.BLACK);
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 15).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    g2d.fillRect(4 + (int)((double)i * chunkSize), 1, 2, 3);
                    g2d.fillRect(4 + (int)((double)i * chunkSize), this.getHeight() - 4, 2, 3);
                });
                return;
            }
            g2d.setColor(Color.RED);
            g2d.fillRect(5, 1, this.getWidth() - 10, 3);
            g2d.fillRect(5, this.getHeight() - 4, this.getWidth() - 10, 3);
        }

        public final /* synthetic */ WorldPreview org$nlogo$window$WorldPreview$PreviewPanel$$$outer() {
            return WorldPreview.this;
        }
    }
}

