/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.workspace;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import org.nlogo.api.ClassManager;
import org.nlogo.api.ExtensionManager$;
import org.nlogo.workspace.ExtendableWorkspace;
import org.nlogo.workspace.ExtensionManager;
import org.nlogo.workspace.ExtensionManager$ExtensionData$;
import org.nlogo.workspace.ExtensionManagerException;
import org.nlogo.workspace.ExtensionManagerException$ExtensionNotFound$;
import org.nlogo.workspace.ExtensionManagerException$InvalidClassManager$;
import org.nlogo.workspace.ExtensionManagerException$NoClassManager$;
import org.nlogo.workspace.ExtensionManagerException$NoExtensionName$;
import org.nlogo.workspace.ExtensionManagerException$NoManifest$;
import org.nlogo.workspace.ExtensionManagerException$NotFoundClassManager$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.util.Try$;

public class JarLoader
implements ExtensionManager.ExtensionLoader {
    private final ExtendableWorkspace workspace;

    public JarLoader(ExtendableWorkspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public Option<URL> locateExtension(String extensionName) {
        None$ none$;
        try {
            none$ = this.resolvePathAsURL(this.identifierToJar(extensionName));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof RuntimeException || throwable2 instanceof MalformedURLException) {
                Exception ex = (Exception)throwable2;
                none$ = None$.MODULE$;
            }
            throw throwable;
        }
        return none$;
    }

    @Override
    public ExtensionManager.ExtensionData extensionData(String extensionName, URL fileURL) {
        JarURLConnection connection = this.connectToJar(fileURL);
        return (ExtensionManager.ExtensionData)Option$.MODULE$.apply((Object)connection.getManifest()).map((Function1 & Serializable)manifest -> {
            Attributes attr = manifest.getMainAttributes();
            Option version = Option$.MODULE$.apply((Object)attr.getValue("NetLogo-Extension-API-Version"));
            String prefix = (String)Option$.MODULE$.apply((Object)attr.getValue("Extension-Name")).getOrElse(() -> JarLoader.$anonfun$1(extensionName));
            String classMangName = (String)Option$.MODULE$.apply((Object)attr.getValue("Class-Manager")).getOrElse(() -> JarLoader.$anonfun$2(extensionName));
            return ExtensionManager$ExtensionData$.MODULE$.apply(extensionName, fileURL, prefix, classMangName, (Option<String>)version, connection.getLastModified());
        }).getOrElse(() -> JarLoader.extensionData$$anonfun$2(extensionName));
    }

    @Override
    public ClassLoader extensionClassLoader(URL fileURL, ClassLoader parentLoader) {
        File folderContainingJar = new File(new File(fileURL.toURI()).getParent());
        Seq urls = (Seq)((SeqOps)this.getAdditionalJars(folderContainingJar).$plus$plus(this.getAdditionalJars(new File("extensions")))).$plus$colon((Object)fileURL);
        return URLClassLoader.newInstance((URL[])urls.toArray(ClassTag$.MODULE$.apply(URL.class)), parentLoader);
    }

    @Override
    public ClassManager extensionClassManager(ClassLoader classLoader, ExtensionManager.ExtensionData data) {
        ClassManager classManager;
        try {
            Object obj = classLoader.loadClass(data.classManagerName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(obj instanceof ClassManager)) {
                throw new ExtensionManagerException(ExtensionManagerException$InvalidClassManager$.MODULE$.apply(data.extensionName()));
            }
            ClassManager cm = (ClassManager)obj;
            classManager = cm;
        }
        catch (ClassNotFoundException ex) {
            throw new ExtensionManagerException(ExtensionManagerException$NotFoundClassManager$.MODULE$.apply(data.classManagerName()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InstantiationException || throwable2 instanceof IllegalAccessException) {
                ReflectiveOperationException ex = (ReflectiveOperationException)throwable2;
                throw new IllegalStateException(ex);
            }
            throw throwable;
        }
        return classManager;
    }

    private JarURLConnection connectToJar(URL fileURL) {
        JarURLConnection jarURLConnection;
        try {
            URL jarURL = new URL("jar", "", fileURL.toString() + "!/");
            jarURLConnection = (JarURLConnection)jarURL.openConnection();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof FileNotFoundException || throwable2 instanceof IOException) {
                throw new ExtensionManagerException(ExtensionManagerException$ExtensionNotFound$.MODULE$.apply(fileURL.toString()));
            }
            throw throwable;
        }
        return jarURLConnection;
    }

    private String identifierToJar(String id) {
        if (!id.endsWith(".jar")) {
            return id + File.separator + id + ".jar";
        }
        return id;
    }

    public Option<URL> resolvePathAsURL(String path) {
        return ((IterableOps)((IterableOps)((IterableOps)((SeqOps)new .colon.colon((Object)this.workspace.attachModelDir(path), (List)new .colon.colon((Object)(ExtensionManager$.MODULE$.extensionsPath() + File.separator + path), (List)new .colon.colon((Object)(ExtensionManager$.MODULE$.userExtensionsPath() + File.separator + path), (List)new .colon.colon((Object)(ExtensionManager$.MODULE$.extensionsPath() + File.separator + ".bundled" + File.separator + path), (List)Nil$.MODULE$))))).map((Function1 & Serializable)_$1 -> new File((String)_$1))).filter((Function1 & Serializable)_$2 -> _$2.exists())).map((Function1 & Serializable)_$3 -> _$3.toURI().toURL())).headOption();
    }

    private Seq<URL> getAdditionalJars(File folder) {
        if (folder.exists() && folder.isDirectory()) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])folder.listFiles());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)file -> file.isFile() && file.getName().toUpperCase().endsWith(".JAR")));
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)f -> (URL)Try$.MODULE$.apply(() -> JarLoader.getAdditionalJars$$anonfun$2$$anonfun$1(f)).recover((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    if (throwable instanceof MalformedURLException) {
                        MalformedURLException ex = (MalformedURLException)throwable;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    if (throwable instanceof MalformedURLException) {
                        MalformedURLException ex = (MalformedURLException)throwable;
                        throw new IllegalStateException(ex);
                    }
                    return function1.apply((Object)x);
                }
            }).get(), ClassTag$.MODULE$.apply(URL.class)));
            return ArrayOps$.MODULE$.toIndexedSeq$extension(object3);
        }
        return (Seq)((SeqOps)Nil$.MODULE$);
    }

    private static final String $anonfun$1(String extensionName$2) {
        throw new ExtensionManagerException(ExtensionManagerException$NoExtensionName$.MODULE$.apply(extensionName$2));
    }

    private static final String $anonfun$2(String extensionName$3) {
        throw new ExtensionManagerException(ExtensionManagerException$NoClassManager$.MODULE$.apply(extensionName$3));
    }

    private static final ExtensionManager.ExtensionData extensionData$$anonfun$2(String extensionName$4) {
        throw new ExtensionManagerException(ExtensionManagerException$NoManifest$.MODULE$.apply(extensionName$4));
    }

    private static final URL getAdditionalJars$$anonfun$2$$anonfun$1(File f$1) {
        return f$1.toURI().toURL();
    }
}

