/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeoutException;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.HttpIdleTimeoutException;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.BidiFlow;
import org.apache.pekko.stream.scaladsl.BidiFlow$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.util.ByteString;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.ModuleSerializationProxy;

@InternalApi
public final class HttpConnectionIdleTimeoutBidi$
implements Serializable {
    public static final HttpConnectionIdleTimeoutBidi$ MODULE$ = new HttpConnectionIdleTimeoutBidi$();

    private HttpConnectionIdleTimeoutBidi$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpConnectionIdleTimeoutBidi$.class);
    }

    public BidiFlow<ByteString, ByteString, ByteString, ByteString, NotUsed> apply(Duration idleTimeout, Option<InetSocketAddress> remoteAddress) {
        Duration duration = idleTimeout;
        if (duration instanceof FiniteDuration) {
            FiniteDuration f = (FiniteDuration)duration;
            return this.apply(f, remoteAddress);
        }
        return BidiFlow$.MODULE$.identity();
    }

    public BidiFlow<ByteString, ByteString, ByteString, ByteString, NotUsed> apply(FiniteDuration idleTimeout, Option<InetSocketAddress> remoteAddress) {
        String string;
        Option<InetSocketAddress> option = remoteAddress;
        if (option instanceof Some) {
            InetSocketAddress addr = (InetSocketAddress)((Some)option).value();
            string = new StringBuilder(20).append(" on connection to [").append(addr).append("]").toString();
        } else {
            string = "";
        }
        String connectionToString = string;
        HttpIdleTimeoutException ex = new HttpIdleTimeoutException(new StringBuilder(125).append("HTTP idle-timeout encountered").append(connectionToString).append(", ").append("no bytes passed in the last ").append(idleTimeout).append(". ").append("This is configurable by pekko.http.[server|client].idle-timeout.").toString(), idleTimeout);
        Flow mapError = (Flow)Flow$.MODULE$.apply().mapError((PartialFunction)new Serializable(ex){
            private final HttpIdleTimeoutException ex$1;
            {
                this.ex$1 = ex$2;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof TimeoutException) {
                    TimeoutException t = (TimeoutException)throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof TimeoutException) {
                    TimeoutException t = (TimeoutException)throwable;
                    return this.ex$1;
                }
                return function1.apply((Object)x);
            }
        });
        BidiFlow toNetTimeout = BidiFlow$.MODULE$.fromFlows((Graph)mapError, (Graph)Flow$.MODULE$.apply());
        BidiFlow fromNetTimeout = toNetTimeout.reversed();
        return fromNetTimeout.atop((Graph)BidiFlow$.MODULE$.bidirectionalIdleTimeout(idleTimeout)).atop((Graph)toNetTimeout);
    }
}

