/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.client.pool;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Set;
import java.util.TreeSet;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.client.PoolFlow;
import org.apache.pekko.http.impl.engine.client.PoolFlow$ResponseContext$;
import org.apache.pekko.http.impl.engine.client.pool.NewHostConnectionPool$;
import org.apache.pekko.http.impl.engine.client.pool.NewHostConnectionPool$HostConnectionPoolStage$;
import org.apache.pekko.http.impl.engine.client.pool.NewHostConnectionPool$HostConnectionPoolStage$$anon$1$Event$;
import org.apache.pekko.http.impl.util.StageLoggingWithOverride;
import org.apache.pekko.http.impl.util.package$RichHttpRequest$;
import org.apache.pekko.http.scaladsl.Http;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Default$;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.ResponseEntity;
import org.apache.pekko.http.scaladsl.model.headers.Connection;
import org.apache.pekko.http.scaladsl.settings.ConnectionPoolSettings;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.stage.AsyncCallback;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.ByteString;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.Vector;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@InternalApi
public final class NewHostConnectionPool {
    public static Flow<PoolFlow.RequestContext, PoolFlow.ResponseContext, NotUsed> apply(Flow<HttpRequest, HttpResponse, Future<Http.OutgoingConnection>> flow, ConnectionPoolSettings connectionPoolSettings, LoggingAdapter loggingAdapter) {
        return NewHostConnectionPool$.MODULE$.apply(flow, connectionPoolSettings, loggingAdapter);
    }

    public static final class HostConnectionPoolStage
    extends GraphStage<FlowShape<PoolFlow.RequestContext, PoolFlow.ResponseContext>> {
        public final Flow<HttpRequest, HttpResponse, Future<Http.OutgoingConnection>> org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$connectionFlow;
        public final ConnectionPoolSettings org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$_settings;
        public final LoggingAdapter org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$_log;
        private final Inlet requestsIn;
        private final Outlet responsesOut;
        private final FlowShape shape;

        public HostConnectionPoolStage(Flow<HttpRequest, HttpResponse, Future<Http.OutgoingConnection>> connectionFlow, ConnectionPoolSettings _settings, LoggingAdapter _log) {
            this.org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$connectionFlow = connectionFlow;
            this.org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$_settings = _settings;
            this.org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$_log = _log;
            this.requestsIn = Inlet$.MODULE$.apply("HostConnectionPoolStage.requestsIn");
            this.responsesOut = Outlet$.MODULE$.apply("HostConnectionPoolStage.responsesOut");
            this.shape = FlowShape$.MODULE$.apply(this.requestsIn(), this.responsesOut());
        }

        public Inlet<PoolFlow.RequestContext> requestsIn() {
            return this.requestsIn;
        }

        public Outlet<PoolFlow.ResponseContext> responsesOut() {
            return this.responsesOut;
        }

        public FlowShape<PoolFlow.RequestContext, PoolFlow.ResponseContext> shape() {
            return this.shape;
        }

        public GraphStageLogic createLogic(Attributes inheritedAttributes) {
            return (GraphStageLogic)new StageLoggingWithOverride(this){
                public static final long OFFSET$0;
                private LoggingAdapter org$apache$pekko$http$impl$util$StageLoggingWithOverride$$_log;
                private long lastTimeoutId;
                private final Vector slots;
                private final Deque slotsWaitingForDispatch;
                private final TreeSet idleSlots;
                private final Deque retryBuffer;
                private FiniteDuration _connectionEmbargo;
                private volatile Object Event$lzy1;
                public final AsyncCallback org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$safeCallback;
                private final /* synthetic */ HostConnectionPoolStage $outer;
                {
                    void var2_2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    StageLoggingWithOverride.$init$(this);
                    this.setHandlers($outer.requestsIn(), $outer.responsesOut(), this);
                    this.lastTimeoutId = 0L;
                    this.slots = (Vector)package$.MODULE$.Vector().tabulate($outer.org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$_settings.maxConnections(), (Function1 & Serializable)_$1 -> this.$init$$$anonfun$1(BoxesRunTime.unboxToInt((Object)_$1)));
                    this.slotsWaitingForDispatch = new ArrayDeque<E>();
                    TreeSet<E> res = new TreeSet<E>(NewHostConnectionPool$::org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$_$_$$anonfun$1);
                    res.addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.slots()).asJava());
                    this.idleSlots = var2_2;
                    this.retryBuffer = new ArrayDeque<E>();
                    this._connectionEmbargo = Duration$.MODULE$.Zero();
                    this.org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$safeCallback = this.getAsyncCallback((Function1)((JProcedure1 & Serializable)NewHostConnectionPool$::org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$_$$lessinit$greater$$anonfun$2));
                }

                static {
                    OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(HostConnectionPoolStage$$anon$1.class.getDeclaredField("Event$lzy1"));
                }

                public LoggingAdapter org$apache$pekko$http$impl$util$StageLoggingWithOverride$$_log() {
                    return this.org$apache$pekko$http$impl$util$StageLoggingWithOverride$$_log;
                }

                public void org$apache$pekko$http$impl$util$StageLoggingWithOverride$$_log_$eq(LoggingAdapter x$1) {
                    this.org$apache$pekko$http$impl$util$StageLoggingWithOverride$$_log = x$1;
                }

                public LoggingAdapter logOverride() {
                    return this.$outer.org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$_log;
                }

                public Vector slots() {
                    return this.slots;
                }

                public Deque slotsWaitingForDispatch() {
                    return this.slotsWaitingForDispatch;
                }

                public TreeSet idleSlots() {
                    return this.idleSlots;
                }

                public Deque retryBuffer() {
                    return this.retryBuffer;
                }

                public FiniteDuration _connectionEmbargo() {
                    return this._connectionEmbargo;
                }

                public void _connectionEmbargo_$eq(FiniteDuration x$1) {
                    this._connectionEmbargo = x$1;
                }

                public FiniteDuration baseEmbargo() {
                    return this.$outer.org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$_settings.baseConnectionBackoff();
                }

                public FiniteDuration maxBaseEmbargo() {
                    return this.$outer.org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$_settings.maxConnectionBackoff().$div(2L);
                }

                public void preStart() {
                    this.pull(this.$outer.requestsIn());
                    this.slots().foreach((Function1)((JProcedure1 & Serializable)NewHostConnectionPool$::org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$_$preStart$$anonfun$1));
                }

                public void onPush() {
                    PoolFlow.RequestContext nextRequest = (PoolFlow.RequestContext)this.grab(this.$outer.requestsIn());
                    if (this.hasIdleSlots()) {
                        this.dispatchRequest(nextRequest);
                        this.pullIfNeeded();
                        return;
                    }
                    this.retryBuffer().addFirst(nextRequest);
                }

                public void onPull() {
                    if (!this.slotsWaitingForDispatch().isEmpty()) {
                        ((HostConnectionPoolStage$$anon$1$Slot)this.slotsWaitingForDispatch().pollFirst()).onResponseDispatchable();
                        return;
                    }
                }

                public void pullIfNeeded() {
                    if (this.hasIdleSlots()) {
                        if (!this.retryBuffer().isEmpty()) {
                            this.log().debug("Dispatching request from retryBuffer");
                            this.dispatchRequest((PoolFlow.RequestContext)this.retryBuffer().pollFirst());
                            return;
                        }
                        if (!this.hasBeenPulled(this.$outer.requestsIn())) {
                            this.pull(this.$outer.requestsIn());
                            return;
                        }
                        return;
                    }
                }

                public boolean hasIdleSlots() {
                    if (this.log().isDebugEnabled()) {
                        scala.collection.immutable.Set idle = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaSetConverter((Set)this.idleSlots()).asScala()).map(NewHostConnectionPool$::org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$_$_$$anonfun$2)).toSet();
                        scala.collection.immutable.Set idleAll = ((IterableOnceOps)((StrictOptimizedIterableOps)this.slots().filter(NewHostConnectionPool$::org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$_$_$$anonfun$3)).map(NewHostConnectionPool$::org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$_$_$$anonfun$4)).toSet();
                        scala.collection.immutable.Set set = idle;
                        scala.collection.immutable.Set set2 = idleAll;
                        Predef$.MODULE$.require(!(set != null ? !set.equals(set2) : set2 != null), () -> NewHostConnectionPool$.org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$_$hasIdleSlots$$anonfun$1(idle, idleAll));
                    }
                    return !this.idleSlots().isEmpty();
                }

                public void dispatchResponseResult(PoolFlow.RequestContext req, Try result) {
                    if (result.isFailure() && req.canBeRetried()) {
                        this.log().debug("Request [{}] has {} retries left, retrying...", (Object)package$RichHttpRequest$.MODULE$.debugString$extension(org.apache.pekko.http.impl.util.package$.MODULE$.RichHttpRequest(req.request())), (Object)BoxesRunTime.boxToInteger((int)req.retriesLeft()));
                        int n = req.retriesLeft() - 1;
                        HttpRequest httpRequest = req.copy$default$1();
                        Promise<HttpResponse> promise = req.copy$default$2();
                        this.retryBuffer().addLast(req.copy(httpRequest, promise, n));
                        return;
                    }
                    this.push(this.$outer.responsesOut(), PoolFlow$ResponseContext$.MODULE$.apply(req, (Try<HttpResponse>)result));
                }

                public void dispatchRequest(PoolFlow.RequestContext req) {
                    HostConnectionPoolStage$$anon$1$Slot slot = (HostConnectionPoolStage$$anon$1$Slot)this.idleSlots().first();
                    this.idleSlots().remove(slot);
                    HostConnectionPoolStage$$anon$1$Slot LogHelperMacro_this = slot;
                    if (LogHelperMacro_this.isDebugEnabled()) {
                        LogHelperMacro_this.log().debug(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(22).append("Dispatching request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(org.apache.pekko.http.impl.util.package$.MODULE$.RichHttpRequest(req.request()))).append("]").toString()).toString());
                    }
                    slot.onNewRequest(req);
                }

                public int numConnectedSlots() {
                    return this.slots().count(NewHostConnectionPool$::org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$_$numConnectedSlots$$anonfun$1);
                }

                public void onConnectionAttemptFailed(FiniteDuration atPreviousEmbargoLevel) {
                    FiniteDuration oldValue = this._connectionEmbargo();
                    FiniteDuration finiteDuration = this._connectionEmbargo();
                    FiniteDuration finiteDuration2 = Duration$.MODULE$.Zero();
                    FiniteDuration finiteDuration3 = finiteDuration;
                    if (!(finiteDuration2 != null ? !finiteDuration2.equals(finiteDuration3) : finiteDuration3 != null)) {
                        this._connectionEmbargo_$eq(this.baseEmbargo());
                    } else {
                        FiniteDuration finiteDuration4 = atPreviousEmbargoLevel;
                        FiniteDuration finiteDuration5 = finiteDuration;
                        if (!(finiteDuration4 != null ? !finiteDuration4.equals(finiteDuration5) : finiteDuration5 != null)) {
                            this._connectionEmbargo_$eq(this._connectionEmbargo().$times(2L).min(this.maxBaseEmbargo()));
                        }
                    }
                    FiniteDuration finiteDuration6 = this._connectionEmbargo();
                    FiniteDuration finiteDuration7 = oldValue;
                    if (finiteDuration6 == null ? finiteDuration7 != null : !finiteDuration6.equals(finiteDuration7)) {
                        this.log().debug(new StringBuilder(77).append("Connection attempt failed. Backing off new connection attempts for at least ").append(this._connectionEmbargo()).append(".").toString());
                        this.slots().foreach((Function1)(JProcedure1 & Serializable)_$7 -> _$7.onNewConnectionEmbargo(this._connectionEmbargo()));
                        return;
                    }
                }

                public void onConnectionAttemptSucceeded() {
                    this._connectionEmbargo_$eq(Duration$.MODULE$.Zero());
                }

                public FiniteDuration currentEmbargo() {
                    return this._connectionEmbargo();
                }

                public final NewHostConnectionPool$HostConnectionPoolStage$$anon$1$Event$ Event() {
                    Object object = this.Event$lzy1;
                    if (object instanceof NewHostConnectionPool$HostConnectionPoolStage$$anon$1$Event$) {
                        return (NewHostConnectionPool$HostConnectionPoolStage$$anon$1$Event$)object;
                    }
                    if (object == LazyVals.NullValue$.MODULE$) {
                        return null;
                    }
                    return (NewHostConnectionPool$HostConnectionPoolStage$$anon$1$Event$)this.Event$lzyINIT1();
                }

                private Object Event$lzyINIT1() {
                    Object object;
                    block8: {
                        while (true) {
                            if ((object = this.Event$lzy1) == null) {
                                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                                Object object2 = null;
                                NewHostConnectionPool$HostConnectionPoolStage$$anon$1$Event$ newHostConnectionPool$HostConnectionPoolStage$$anon$1$Event$ = null;
                                try {
                                    newHostConnectionPool$HostConnectionPoolStage$$anon$1$Event$ = new NewHostConnectionPool$HostConnectionPoolStage$$anon$1$Event$(this);
                                    object2 = newHostConnectionPool$HostConnectionPoolStage$$anon$1$Event$ == null ? LazyVals.NullValue$.MODULE$ : newHostConnectionPool$HostConnectionPoolStage$$anon$1$Event$;
                                }
                                finally {
                                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.Event$lzy1;
                                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                        waiting.countDown();
                                    }
                                }
                                return newHostConnectionPool$HostConnectionPoolStage$$anon$1$Event$;
                            }
                            if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                            if (object == LazyVals.Evaluating$.MODULE$) {
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                                continue;
                            }
                            if (!(object instanceof LazyVals.Waiting)) break;
                            ((LazyVals.Waiting)object).await();
                        }
                        return null;
                    }
                    return object;
                }

                public boolean org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$hasNoEntityStream(HttpResponse response) {
                    ResponseEntity responseEntity = response.entity();
                    if (responseEntity instanceof HttpEntity.Strict) {
                        return true;
                    }
                    if (responseEntity instanceof HttpEntity.Default) {
                        Source<ByteString, Object> source;
                        Source<ByteString, Object> e;
                        HttpEntity.Default default_ = HttpEntity$Default$.MODULE$.unapply((HttpEntity.Default)responseEntity);
                        ContentType contentType = default_._1();
                        long l = default_._2();
                        Source<ByteString, Object> source2 = e = (source = default_._3());
                        Source source3 = Source$.MODULE$.empty();
                        return !(source2 != null ? !source2.equals((Object)source3) : source3 != null);
                    }
                    ResponseEntity e = responseEntity;
                    return e.isKnownEmpty();
                }

                public HostConnectionPoolStage$$anon$1$SlotConnection openConnection(HostConnectionPoolStage$$anon$1$Slot slot) {
                    FiniteDuration currentEmbargoLevel = this.currentEmbargo();
                    GraphStageLogic.SubSourceOutlet requestOut = new GraphStageLogic.SubSourceOutlet((GraphStageLogic)this, new StringBuilder(21).append("PoolSlot[").append(slot.slotId()).append("].requestOut").toString());
                    GraphStageLogic.SubSinkInlet responseIn = new GraphStageLogic.SubSinkInlet((GraphStageLogic)this, new StringBuilder(21).append("PoolSlot[").append(slot.slotId()).append("].responseIn").toString());
                    responseIn.pull();
                    HostConnectionPoolStage$$anon$1$Slot LogHelperMacro_this = slot;
                    if (LogHelperMacro_this.isDebugEnabled()) {
                        LogHelperMacro_this.log().debug(new StringBuilder(23).append(LogHelperMacro_this.prefixString()).append("Establishing connection").toString());
                    }
                    Future connection = (Future)Source$.MODULE$.fromGraph(requestOut.source()).viaMat(this.$outer.org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$connectionFlow, Keep$.MODULE$.right()).to(responseIn.sink()).run(this.subFusingMaterializer());
                    HostConnectionPoolStage$$anon$1$SlotConnection slotCon = new HostConnectionPoolStage$$anon$1$SlotConnection(this, slot, requestOut, responseIn);
                    requestOut.setHandler((OutHandler)slotCon);
                    responseIn.setHandler((InHandler)slotCon);
                    connection.onComplete(this.org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$safely((Function1)(JProcedure1 & Serializable)x$1 -> {
                        Try try_ = x$1;
                        if (try_ instanceof Success) {
                            Http.OutgoingConnection outgoingConnection = (Http.OutgoingConnection)((Success)try_).value();
                            slotCon.withSlot((Function1)(JProcedure1 & Serializable)sl -> {
                                slotCon.connectionEstablished_$eq(true);
                                HostConnectionPoolStage$$anon$1$Slot LogHelperMacro_this = slot;
                                if (LogHelperMacro_this.isDebugEnabled()) {
                                    LogHelperMacro_this.log().debug(new StringBuilder(28).append(LogHelperMacro_this.prefixString()).append("Connection attempt succeeded").toString());
                                }
                                this.onConnectionAttemptSucceeded();
                                sl.onConnectionAttemptSucceeded(outgoingConnection);
                            });
                            return;
                        }
                        if (try_ instanceof Failure) {
                            Throwable cause = ((Failure)try_).exception();
                            slotCon.withSlot((Function1)(JProcedure1 & Serializable)sl -> {
                                HostConnectionPoolStage$$anon$1$Slot LogHelperMacro_this = slot;
                                if (LogHelperMacro_this.isDebugEnabled()) {
                                    LogHelperMacro_this.log().debug(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(31).append("Connection attempt failed with ").append(cause.getMessage()).toString()).toString());
                                }
                                this.onConnectionAttemptFailed(currentEmbargoLevel);
                                sl.onConnectionAttemptFailed(cause);
                            });
                            return;
                        }
                        throw new MatchError((Object)try_);
                    }), ExecutionContexts$.MODULE$.parasitic());
                    return slotCon;
                }

                public void onUpstreamFinish() {
                    this.log().debug("Pool upstream was completed");
                    InHandler.onUpstreamFinish$((InHandler)this);
                }

                public void onUpstreamFailure(Throwable ex) {
                    this.log().debug("Pool upstream failed with {}", (Object)ex);
                    InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                }

                public void onDownstreamFinish(Throwable cause) {
                    this.log().debug("Pool downstream cancelled");
                    OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
                }

                public void postStop() {
                    this.slots().foreach((Function1)((JProcedure1 & Serializable)NewHostConnectionPool$::org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$_$postStop$$anonfun$1));
                    this.log().debug("Pool stopped");
                }

                public boolean org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$willClose(HttpResponse response) {
                    return response.header(ClassTag$.MODULE$.apply(Connection.class)).exists(NewHostConnectionPool$::org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$_$willClose$$anonfun$1);
                }

                public Function1 org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$safely(Function1 f) {
                    return (JProcedure1 & Serializable)t -> this.org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$safeCallback.invoke(() -> NewHostConnectionPool$.org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$_$safely$$anonfun$1$$anonfun$1(f, t));
                }

                public Runnable org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$safeRunnable(Function0 body) {
                    return new Runnable(body, this){
                        private final Function0 body$1;
                        private final /* synthetic */ HostConnectionPoolStage$$anon$1 $outer;
                        {
                            this.body$1 = body$2;
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public void run() {
                            this.$outer.org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$safeCallback.invoke((JFunction0.mcV.sp & Serializable)() -> this.body$1.apply$mcV$sp());
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{run$$anonfun$1()}, serializedLambda);
                        }
                    };
                }

                public long org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$createNewTimeoutId() {
                    ++this.lastTimeoutId;
                    return this.lastTimeoutId;
                }

                public Materializer protected$materializer() {
                    return this.materializer();
                }

                public Materializer protected$subFusingMaterializer() {
                    return this.subFusingMaterializer();
                }

                public final /* synthetic */ HostConnectionPoolStage org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$_$$anon$$$outer() {
                    return this.$outer;
                }

                private final /* synthetic */ HostConnectionPoolStage$$anon$1$Slot $init$$$anonfun$1(int _$1) {
                    return new HostConnectionPoolStage$$anon$1$Slot(this, _$1);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$init$$$anonfun$adapted$1(java.lang.Object ), org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$_$$lessinit$greater$$anonfun$2(scala.Function0 ), org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$_$preStart$$anonfun$1(org.apache.pekko.http.impl.engine.client.pool.NewHostConnectionPool$HostConnectionPoolStage$$anon$1$Slot ), org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$_$_$$anonfun$2(org.apache.pekko.http.impl.engine.client.pool.NewHostConnectionPool$HostConnectionPoolStage$$anon$1$Slot ), org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$_$_$$anonfun$3(org.apache.pekko.http.impl.engine.client.pool.NewHostConnectionPool$HostConnectionPoolStage$$anon$1$Slot ), org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$_$_$$anonfun$4(org.apache.pekko.http.impl.engine.client.pool.NewHostConnectionPool$HostConnectionPoolStage$$anon$1$Slot ), org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$_$hasIdleSlots$$anonfun$1(scala.collection.immutable.Set scala.collection.immutable.Set ), org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$_$numConnectedSlots$$anonfun$1(org.apache.pekko.http.impl.engine.client.pool.NewHostConnectionPool$HostConnectionPoolStage$$anon$1$Slot ), onConnectionAttemptFailed$$anonfun$1(org.apache.pekko.http.impl.engine.client.pool.NewHostConnectionPool$HostConnectionPoolStage$$anon$1$Slot ), openConnection$$anonfun$1(org.apache.pekko.http.impl.engine.client.pool.NewHostConnectionPool$HostConnectionPoolStage$$anon$1$SlotConnection org.apache.pekko.http.impl.engine.client.pool.NewHostConnectionPool$HostConnectionPoolStage$$anon$1$Slot scala.concurrent.duration.FiniteDuration scala.util.Try ), org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$_$postStop$$anonfun$1(org.apache.pekko.http.impl.engine.client.pool.NewHostConnectionPool$HostConnectionPoolStage$$anon$1$Slot ), org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$_$willClose$$anonfun$1(org.apache.pekko.http.scaladsl.model.headers.Connection ), safely$$anonfun$1(scala.Function1 java.lang.Object ), openConnection$$anonfun$1$$anonfun$1(org.apache.pekko.http.impl.engine.client.pool.NewHostConnectionPool$HostConnectionPoolStage$$anon$1$SlotConnection org.apache.pekko.http.impl.engine.client.pool.NewHostConnectionPool$HostConnectionPoolStage$$anon$1$Slot org.apache.pekko.http.scaladsl.Http$OutgoingConnection org.apache.pekko.http.impl.engine.client.pool.NewHostConnectionPool$HostConnectionPoolStage$$anon$1$Slot ), openConnection$$anonfun$1$$anonfun$2(org.apache.pekko.http.impl.engine.client.pool.NewHostConnectionPool$HostConnectionPoolStage$$anon$1$Slot java.lang.Throwable scala.concurrent.duration.FiniteDuration org.apache.pekko.http.impl.engine.client.pool.NewHostConnectionPool$HostConnectionPoolStage$$anon$1$Slot ), org$apache$pekko$http$impl$engine$client$pool$NewHostConnectionPool$HostConnectionPoolStage$$anon$1$$_$safely$$anonfun$1$$anonfun$1(scala.Function1 java.lang.Object )}, serializedLambda);
                }
            };
        }
    }
}

