/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.parsing;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import javax.net.ssl.SSLSession;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.parsing.HttpHeaderParser;
import org.apache.pekko.http.impl.engine.parsing.HttpMessageParser;
import org.apache.pekko.http.impl.engine.parsing.HttpMessageParser$;
import org.apache.pekko.http.impl.engine.parsing.NotEnoughDataException$;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput$NeedMoreData$;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput$RequestStart$;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput$StreamEnd$;
import org.apache.pekko.http.impl.engine.parsing.ParsingException;
import org.apache.pekko.http.impl.engine.parsing.package$;
import org.apache.pekko.http.impl.engine.server.HttpAttributes;
import org.apache.pekko.http.impl.engine.ws.Handshake$Server$;
import org.apache.pekko.http.impl.engine.ws.UpgradeToWebSocketLowLevel;
import org.apache.pekko.http.impl.model.parser.CharacterClasses$;
import org.apache.pekko.http.impl.model.parser.UriParser;
import org.apache.pekko.http.impl.model.parser.UriParser$;
import org.apache.pekko.http.impl.util.ByteStringParserInput;
import org.apache.pekko.http.scaladsl.model.AttributeKey;
import org.apache.pekko.http.scaladsl.model.AttributeKeys$;
import org.apache.pekko.http.scaladsl.model.ErrorInfo;
import org.apache.pekko.http.scaladsl.model.ErrorInfo$;
import org.apache.pekko.http.scaladsl.model.HttpCharsets$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpMethods$;
import org.apache.pekko.http.scaladsl.model.HttpProtocol;
import org.apache.pekko.http.scaladsl.model.HttpProtocols$;
import org.apache.pekko.http.scaladsl.model.IllegalUriException;
import org.apache.pekko.http.scaladsl.model.IllegalUriException$;
import org.apache.pekko.http.scaladsl.model.SslSessionInfo$;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusLength;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusLength$;
import org.apache.pekko.http.scaladsl.model.headers.Raw$minusRequest$minusURI;
import org.apache.pekko.http.scaladsl.model.headers.Raw$minusRequest$minusURI$;
import org.apache.pekko.http.scaladsl.model.headers.Tls$minusSession$minusInfo;
import org.apache.pekko.http.scaladsl.settings.ParserSettings;
import org.apache.pekko.http.scaladsl.settings.WebSocketSettings;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.TLSProtocol;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.parboiled2.ParserInput;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class HttpRequestParser
extends GraphStage<FlowShape<TLSProtocol.SessionBytes, ParserOutput.RequestOutput>> {
    public final ParserSettings org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$settings;
    public final WebSocketSettings org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$websocketSettings;
    public final boolean org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$rawRequestUriHeader;
    public final HttpHeaderParser org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$headerParser;
    private final Inlet in;
    private final Outlet out;
    private final FlowShape shape;

    public HttpRequestParser(ParserSettings settings, WebSocketSettings websocketSettings, boolean rawRequestUriHeader, HttpHeaderParser headerParser) {
        this.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$settings = settings;
        this.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$websocketSettings = websocketSettings;
        this.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$rawRequestUriHeader = rawRequestUriHeader;
        this.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$headerParser = headerParser;
        this.in = Inlet$.MODULE$.apply("HttpRequestParser.in");
        this.out = Outlet$.MODULE$.apply("HttpRequestParser.out");
        this.shape = FlowShape$.MODULE$.of(this.in(), this.out());
    }

    public Inlet<TLSProtocol.SessionBytes> in() {
        return this.in;
    }

    public Outlet<ParserOutput.RequestOutput> out() {
        return this.out;
    }

    public FlowShape<TLSProtocol.SessionBytes, ParserOutput.RequestOutput> shape() {
        return this.shape;
    }

    public Attributes initialAttributes() {
        return Attributes$.MODULE$.name("HttpRequestParser");
    }

    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new HttpMessageParser<ParserOutput.RequestOutput>(inheritedAttributes, this){
            private final Attributes inheritedAttributes$1;
            private Object org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result;
            private Function1 org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state;
            private HttpProtocol org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol;
            private Function0 completionHandling;
            private boolean terminated;
            private SSLSession org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession;
            private Tls$minusSession$minusInfo org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader;
            private final ParserSettings settings;
            private final HttpHeaderParser headerParser;
            private final boolean isResponseParser;
            private HttpMethod method;
            private Uri uri;
            private ByteString uriBytes;
            private final UriParser uriParser;
            private final /* synthetic */ HttpRequestParser $outer;
            {
                this.inheritedAttributes$1 = inheritedAttributes$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                HttpMessageParser.$init$(this);
                this.settings = $outer.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$settings;
                this.headerParser = $outer.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$headerParser.createShallowCopy();
                this.isResponseParser = false;
                this.setHandlers($outer.in(), $outer.out(), this);
                Uri.ParsingMode parsingMode = $outer.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$settings.uriParsingMode();
                Charset charset = UriParser$.MODULE$.$lessinit$greater$default$2();
                this.uriParser = new UriParser(null, charset, parsingMode);
            }

            public Object org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result() {
                return this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result;
            }

            public Function1 org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state() {
                return this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state;
            }

            public HttpProtocol org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol() {
                return this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol;
            }

            public Function0 completionHandling() {
                return this.completionHandling;
            }

            public boolean terminated() {
                return this.terminated;
            }

            public SSLSession org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession() {
                return this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession;
            }

            public Tls$minusSession$minusInfo org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader() {
                return this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader;
            }

            public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result_$eq(Object x$1) {
                this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result = x$1;
            }

            public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state_$eq(Function1 x$1) {
                this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state = x$1;
            }

            public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol_$eq(HttpProtocol x$1) {
                this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol = x$1;
            }

            public void completionHandling_$eq(Function0 x$1) {
                this.completionHandling = x$1;
            }

            public void terminated_$eq(boolean x$1) {
                this.terminated = x$1;
            }

            public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession_$eq(SSLSession x$1) {
                this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession = x$1;
            }

            public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader_$eq(Tls$minusSession$minusInfo x$1) {
                this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader = x$1;
            }

            public ParserSettings settings() {
                return this.settings;
            }

            public HttpHeaderParser headerParser() {
                return this.headerParser;
            }

            public boolean isResponseParser() {
                return this.isResponseParser;
            }

            public void onPush() {
                this.handleParserOutput((ParserOutput.RequestOutput)this.parseSessionBytes((TLSProtocol.SessionBytes)this.grab(this.$outer.in())));
            }

            public void onPull() {
                this.handleParserOutput((ParserOutput.RequestOutput)this.doPull());
            }

            public void onUpstreamFinish() {
                if (HttpMessageParser.shouldComplete$(this)) {
                    this.completeStage();
                    return;
                }
                if (this.isAvailable(this.$outer.out())) {
                    this.handleParserOutput((ParserOutput.RequestOutput)this.doPull());
                    return;
                }
            }

            private void handleParserOutput(ParserOutput.RequestOutput output) {
                ParserOutput.RequestOutput requestOutput = output;
                if (ParserOutput$StreamEnd$.MODULE$.equals(requestOutput)) {
                    this.completeStage();
                    return;
                }
                if (ParserOutput$NeedMoreData$.MODULE$.equals(requestOutput)) {
                    this.pull(this.$outer.in());
                    return;
                }
                ParserOutput.RequestOutput x = requestOutput;
                this.push(this.$outer.out(), x);
            }

            public HttpMessageParser.StateResult parseMessage(ByteString input2, int offset2) {
                if (offset2 < input2.length()) {
                    int cursor = this.parseMethod(input2, offset2);
                    cursor = this.parseRequestTarget(input2, cursor);
                    if (package$.MODULE$.byteChar(input2, cursor = this.parseProtocol(input2, cursor)) == '\r' && package$.MODULE$.byteChar(input2, cursor + 1) == '\n') {
                        return this.parseHeaderLines(input2, cursor + 2, this.parseHeaderLines$default$3(), this.parseHeaderLines$default$4(), this.parseHeaderLines$default$5(), this.parseHeaderLines$default$6(), this.parseHeaderLines$default$7(), this.parseHeaderLines$default$8(), this.parseHeaderLines$default$9(), this.parseHeaderLines$default$10());
                    }
                    if (package$.MODULE$.byteChar(input2, cursor) == '\n') {
                        return this.parseHeaderLines(input2, cursor + 1, this.parseHeaderLines$default$3(), this.parseHeaderLines$default$4(), this.parseHeaderLines$default$5(), this.parseHeaderLines$default$6(), this.parseHeaderLines$default$7(), this.parseHeaderLines$default$8(), this.parseHeaderLines$default$9(), this.parseHeaderLines$default$10());
                    }
                    throw this.onBadProtocol(input2.drop(cursor));
                }
                return this.continue((Function2 & Serializable)(input, offset) -> this.parseMessage$$anonfun$1((ByteString)input, BoxesRunTime.unboxToInt((Object)offset)));
            }

            public int parseMethod(ByteString input, int cursor) {
                char c = package$.MODULE$.byteChar(input, cursor);
                switch (c) {
                    case 'G': {
                        return this.parseMethod$1(input, cursor, HttpMethods$.MODULE$.GET(), HttpRequestParser.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$parseMethod$default$2$1());
                    }
                    case 'P': {
                        char c2 = package$.MODULE$.byteChar(input, cursor + 1);
                        switch (c2) {
                            case 'O': {
                                return this.parseMethod$1(input, cursor, HttpMethods$.MODULE$.POST(), 2);
                            }
                            case 'U': {
                                return this.parseMethod$1(input, cursor, HttpMethods$.MODULE$.PUT(), 2);
                            }
                            case 'A': {
                                return this.parseMethod$1(input, cursor, HttpMethods$.MODULE$.PATCH(), 2);
                            }
                        }
                        return this.parseCustomMethod$1(input, cursor, HttpRequestParser.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$parseCustomMethod$default$1$1(), HttpRequestParser.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$parseCustomMethod$default$2$1());
                    }
                    case 'D': {
                        return this.parseMethod$1(input, cursor, HttpMethods$.MODULE$.DELETE(), HttpRequestParser.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$parseMethod$default$2$1());
                    }
                    case 'H': {
                        return this.parseMethod$1(input, cursor, HttpMethods$.MODULE$.HEAD(), HttpRequestParser.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$parseMethod$default$2$1());
                    }
                    case 'O': {
                        return this.parseMethod$1(input, cursor, HttpMethods$.MODULE$.OPTIONS(), HttpRequestParser.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$parseMethod$default$2$1());
                    }
                    case 'T': {
                        return this.parseMethod$1(input, cursor, HttpMethods$.MODULE$.TRACE(), HttpRequestParser.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$parseMethod$default$2$1());
                    }
                    case 'C': {
                        return this.parseMethod$1(input, cursor, HttpMethods$.MODULE$.CONNECT(), HttpRequestParser.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$parseMethod$default$2$1());
                    }
                    case '\u0016': {
                        throw new ParsingException((StatusCode)StatusCodes$.MODULE$.BadRequest(), ErrorInfo$.MODULE$.apply("Unsupported HTTP method", new StringBuilder(128).append("The HTTP method started with 0x16 rather than any known HTTP method").append(this.remoteAddressStr()).append(". ").append("Perhaps this was an HTTPS request sent to an HTTP endpoint?").toString()));
                    }
                }
                return this.parseCustomMethod$1(input, cursor, HttpRequestParser.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$parseCustomMethod$default$1$1(), HttpRequestParser.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$parseCustomMethod$default$2$1());
            }

            public UriParser uriParser() {
                return this.uriParser;
            }

            public int parseRequestTarget(ByteString input, int cursor) {
                int uriStart = cursor;
                int uriEndLimit = cursor + this.$outer.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$settings.maxUriLength();
                int uriEnd = this.findUriEnd$1(input, uriEndLimit, HttpRequestParser.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$findUriEnd$default$1$1(cursor));
                try {
                    this.uriBytes = input.slice(uriStart, uriEnd);
                    this.uriParser().reset((ParserInput)new ByteStringParserInput(this.uriBytes));
                    this.uri = this.uriParser().parseHttpRequestTarget();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof IllegalUriException) {
                        ErrorInfo errorInfo;
                        IllegalUriException illegalUriException = IllegalUriException$.MODULE$.unapply((IllegalUriException)throwable2);
                        ErrorInfo info = errorInfo = illegalUriException._1();
                        throw new ParsingException((StatusCode)StatusCodes$.MODULE$.BadRequest(), info);
                    }
                    throw throwable;
                }
                return uriEnd + 1;
            }

            public Nothing$ onBadProtocol(ByteString input) {
                throw new ParsingException((StatusCode)StatusCodes$.MODULE$.HttpVersionNotSupported(), "");
            }

            public HttpMessageParser.StateResult parseEntity(List headers, HttpProtocol protocol, ByteString input, int bodyStart, Option clh, Option cth, boolean isChunked, boolean expect100continue, boolean hostHeaderPresent, boolean closeAfterResponseCompletion, SSLSession sslSession) {
                block14: {
                    block13: {
                        if (hostHeaderPresent) break block13;
                        HttpProtocol httpProtocol = protocol;
                        HttpProtocol httpProtocol2 = HttpProtocols$.MODULE$.HTTP$div1$u002E0();
                        if (httpProtocol != null ? !((Object)httpProtocol).equals(httpProtocol2) : httpProtocol2 != null) break block14;
                    }
                    if (!isChunked) {
                        long l;
                        Content$minusLength content$minusLength;
                        Option option = clh;
                        if (option instanceof Some && (content$minusLength = (Content$minusLength)((Some)option).value()) != null) {
                            long l2;
                            long len;
                            Content$minusLength content$minusLength2 = Content$minusLength$.MODULE$.unapply(content$minusLength);
                            l = len = (l2 = content$minusLength2._1());
                        } else if (None$.MODULE$.equals(option)) {
                            l = 0L;
                        } else {
                            throw new MatchError((Object)option);
                        }
                        long contentLength = l;
                        if (contentLength == 0L) {
                            this.emitRequestStart$1(sslSession, hostHeaderPresent, protocol, expect100continue, closeAfterResponseCompletion, this.emptyEntity(cth), HttpRequestParser.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$emitRequestStart$default$2$1(headers));
                            this.setCompletionHandling((Function0)HttpMessageParser$.MODULE$.CompletionOk());
                            return this.startNewMessage(input, bodyStart);
                        }
                        if (!this.method.isEntityAccepted()) {
                            return this.failMessageStart(StatusCodes$.MODULE$.UnprocessableContent(), new StringBuilder(33).append(this.method.name()).append(" requests must not have an entity").toString(), this.failMessageStart$default$3());
                        }
                        if (contentLength <= (long)(input.size() - bodyStart)) {
                            int cl = (int)contentLength;
                            this.emitRequestStart$1(sslSession, hostHeaderPresent, protocol, expect100continue, closeAfterResponseCompletion, this.strictEntity(cth, input, bodyStart, cl), HttpRequestParser.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$emitRequestStart$default$2$1(headers));
                            this.setCompletionHandling((Function0)HttpMessageParser$.MODULE$.CompletionOk());
                            return this.startNewMessage(input, bodyStart + cl);
                        }
                        this.emitRequestStart$1(sslSession, hostHeaderPresent, protocol, expect100continue, closeAfterResponseCompletion, this.defaultEntity(cth, contentLength), HttpRequestParser.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$emitRequestStart$default$2$1(headers));
                        return this.parseFixedLengthBody(contentLength, closeAfterResponseCompletion, input, bodyStart);
                    }
                    if (!this.method.isEntityAccepted()) {
                        return this.failMessageStart(StatusCodes$.MODULE$.UnprocessableContent(), new StringBuilder(33).append(this.method.name()).append(" requests must not have an entity").toString(), this.failMessageStart$default$3());
                    }
                    if (clh.isEmpty()) {
                        this.emitRequestStart$1(sslSession, hostHeaderPresent, protocol, expect100continue, closeAfterResponseCompletion, this.chunkedEntity(cth), headers);
                        return this.parseChunk(input, bodyStart, closeAfterResponseCompletion, 0L);
                    }
                    return this.failMessageStart("A chunked request must not contain a Content-Length header");
                }
                return this.failMessageStart("Request is missing required `Host` header");
            }

            private String remoteAddressStr() {
                Option option = this.inheritedAttributes$1.get(ClassTag$.MODULE$.apply(HttpAttributes.RemoteAddress.class)).map(HttpRequestParser::org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$remoteAddressStr$$anonfun$1);
                if (option instanceof Some) {
                    InetSocketAddress addr = (InetSocketAddress)((Some)option).value();
                    return new StringBuilder(7).append(" from ").append(addr.getHostString()).append(":").append(addr.getPort()).toString();
                }
                if (None$.MODULE$.equals(option)) {
                    return "";
                }
                throw new MatchError((Object)option);
            }

            private final /* synthetic */ HttpMessageParser.StateResult parseMessage$$anonfun$1(ByteString input, int offset) {
                return this.startNewMessage(input, offset);
            }

            private final int parseCustomMethod$1(ByteString input$1, int cursor$1, int ix, StringBuilder sb) {
                while (ix < this.$outer.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$settings.maxMethodLength()) {
                    char c = package$.MODULE$.byteChar(input$1, cursor$1 + ix);
                    if (' ' == c) {
                        Option option = (Option)this.$outer.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$settings.customMethods().apply((Object)sb.toString());
                        if (option instanceof Some) {
                            HttpMethod m;
                            this.method = m = (HttpMethod)((Some)option).value();
                            return cursor$1 + ix + 1;
                        }
                        if (None$.MODULE$.equals(option)) {
                            throw new ParsingException((StatusCode)StatusCodes$.MODULE$.NotImplemented(), ErrorInfo$.MODULE$.apply("Unsupported HTTP method", sb.toString()));
                        }
                        throw new MatchError((Object)option);
                    }
                    char c2 = c;
                    int n = ix + 1;
                    StringBuilder stringBuilder = sb.append(c2);
                    ix = n;
                    sb = stringBuilder;
                }
                throw new ParsingException((StatusCode)StatusCodes$.MODULE$.BadRequest(), ErrorInfo$.MODULE$.apply("Unsupported HTTP method", new StringBuilder(140).append("HTTP method too long (started with '").append(sb.toString()).append("')").append(this.remoteAddressStr()).append(". ").append("Increase `pekko.http.server.parsing.max-method-length` to support HTTP methods with more characters.").toString()));
            }

            private final int parseMethod$1(ByteString input$2, int cursor$2, HttpMethod meth, int ix) {
                while (true) {
                    if (ix == meth.value().length()) {
                        if (package$.MODULE$.byteChar(input$2, cursor$2 + ix) == ' ') {
                            this.method = meth;
                            return cursor$2 + ix + 1;
                        }
                        return this.parseCustomMethod$1(input$2, cursor$2, HttpRequestParser.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$parseCustomMethod$default$1$1(), HttpRequestParser.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$parseCustomMethod$default$2$1());
                    }
                    if (package$.MODULE$.byteChar(input$2, cursor$2 + ix) != meth.value().charAt(ix)) break;
                    ++ix;
                }
                return this.parseCustomMethod$1(input$2, cursor$2, HttpRequestParser.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$parseCustomMethod$default$1$1(), HttpRequestParser.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$parseCustomMethod$default$2$1());
            }

            private final int findUriEnd$1(ByteString input$3, int uriEndLimit$1, int ix) {
                while (true) {
                    if (ix == input$3.length()) {
                        throw NotEnoughDataException$.MODULE$;
                    }
                    if (CharacterClasses$.MODULE$.WSPCRLF().apply((char)input$3.apply(ix))) {
                        return ix;
                    }
                    if (ix >= uriEndLimit$1) break;
                    ++ix;
                }
                throw new ParsingException((StatusCode)StatusCodes$.MODULE$.UriTooLong(), new StringBuilder(54).append("URI length exceeds the configured limit of ").append(this.$outer.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$settings.maxUriLength()).append(" characters").append(this.remoteAddressStr()).toString());
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final void emitRequestStart$1(SSLSession sslSession$1, boolean hostHeaderPresent$1, HttpProtocol protocol$1, boolean expect100continue$1, boolean closeAfterResponseCompletion$1, ParserOutput.EntityCreator createEntity, List headers) {
                ParserOutput.RequestStart requestStart;
                Map map;
                List allHeaders0;
                List list;
                if (this.$outer.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$rawRequestUriHeader) {
                    Raw$minusRequest$minusURI raw$minusRequest$minusURI = Raw$minusRequest$minusURI$.MODULE$.apply(this.uriBytes.decodeString(HttpCharsets$.MODULE$.US$minusASCII().nioCharset()));
                    list = headers.$colon$colon((Object)raw$minusRequest$minusURI);
                } else {
                    list = allHeaders0 = headers;
                }
                if (this.settings().includeSslSessionAttribute()) {
                    Object[] objectArray = new Tuple2[1];
                    AttributeKey attributeKey = (AttributeKey)Predef$.MODULE$.ArrowAssoc(AttributeKeys$.MODULE$.sslSession());
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)attributeKey, (Object)SslSessionInfo$.MODULE$.apply(sslSession$1));
                    map = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                } else {
                    map = Predef$.MODULE$.Map().empty();
                }
                Map attributes = map;
                HttpMethod httpMethod = this.method;
                HttpMethod httpMethod2 = HttpMethods$.MODULE$.GET();
                if (!(httpMethod != null ? !((Object)httpMethod).equals(httpMethod2) : httpMethod2 != null)) {
                    UpgradeToWebSocketLowLevel upgradeToWebSocketLowLevel = Handshake$Server$.MODULE$.websocketUpgrade((List<HttpHeader>)headers, hostHeaderPresent$1, this.$outer.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$websocketSettings, this.headerParser().log());
                    UpgradeToWebSocketLowLevel upgradeToWebSocketLowLevel2 = (UpgradeToWebSocketLowLevel)OptionVal.Some$.MODULE$.unapply((Object)upgradeToWebSocketLowLevel);
                    if (!OptionVal$.MODULE$.isEmpty$extension((Object)upgradeToWebSocketLowLevel2)) {
                        UpgradeToWebSocketLowLevel upgradeToWebSocketLowLevel3;
                        UpgradeToWebSocketLowLevel upgrade = upgradeToWebSocketLowLevel3 = (UpgradeToWebSocketLowLevel)OptionVal$.MODULE$.get$extension((Object)upgradeToWebSocketLowLevel2);
                        requestStart = ParserOutput$RequestStart$.MODULE$.apply(this.method, this.uri, protocol$1, (Map)attributes.updated(AttributeKeys$.MODULE$.webSocketUpgrade(), (Object)upgrade), (List<HttpHeader>)allHeaders0.$colon$colon((Object)upgrade), createEntity, expect100continue$1, closeAfterResponseCompletion$1);
                    } else {
                        OptionVal$.MODULE$.None();
                        UpgradeToWebSocketLowLevel upgradeToWebSocketLowLevel4 = upgradeToWebSocketLowLevel;
                        if (null != null ? !((Object)null).equals(upgradeToWebSocketLowLevel4) : upgradeToWebSocketLowLevel4 != null) throw new MatchError((Object)new OptionVal((Object)upgradeToWebSocketLowLevel));
                        requestStart = ParserOutput$RequestStart$.MODULE$.apply(this.method, this.uri, protocol$1, attributes, (List<HttpHeader>)allHeaders0, createEntity, expect100continue$1, closeAfterResponseCompletion$1);
                    }
                } else {
                    requestStart = ParserOutput$RequestStart$.MODULE$.apply(this.method, this.uri, protocol$1, attributes, (List<HttpHeader>)allHeaders0, createEntity, expect100continue$1, closeAfterResponseCompletion$1);
                }
                ParserOutput.RequestStart requestStart2 = requestStart;
                this.emit(requestStart2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{parseMessage$$anonfun$adapted$1(java.lang.Object java.lang.Object ), org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$remoteAddressStr$$anonfun$1(org.apache.pekko.http.impl.engine.server.HttpAttributes$RemoteAddress )}, serializedLambda);
            }
        };
    }

    public String toString() {
        return "HttpRequestParser";
    }

    public static final int org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$parseCustomMethod$default$1$1() {
        return 0;
    }

    public static final StringBuilder org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$parseCustomMethod$default$2$1() {
        return new StringBuilder(16);
    }

    public static final int org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$parseMethod$default$2$1() {
        return 1;
    }

    public static final int org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$findUriEnd$default$1$1(int cursor$3) {
        return cursor$3;
    }

    public static final List org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$emitRequestStart$default$2$1(List headers$1) {
        return headers$1;
    }

    public static final /* synthetic */ InetSocketAddress org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$anon$1$$_$remoteAddressStr$$anonfun$1(HttpAttributes.RemoteAddress _$4) {
        return _$4.address();
    }
}

